/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SelectableSlotContainer;
import net.minecraft.world.level.block.SideChainPartBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.SideChainPart;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShelfBlock
extends BaseEntityBlock
implements SelectableSlotContainer,
SideChainPartBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<ShelfBlock> CODEC = ShelfBlock.simpleCodec(ShelfBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<SideChainPart> SIDE_CHAIN_PART = BlockStateProperties.SIDE_CHAIN_PART;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.rotateHorizontal(Shapes.or(Block.box(0.0, 12.0, 11.0, 16.0, 16.0, 13.0), Block.box(0.0, 0.0, 13.0, 16.0, 16.0, 16.0), Block.box(0.0, 0.0, 11.0, 16.0, 4.0, 13.0)));

    public MapCodec<ShelfBlock> codec() {
        return CODEC;
    }

    public ShelfBlock(BlockBehaviour.Properties $$0) {
        super($$0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(POWERED, false)).setValue(SIDE_CHAIN_PART, SideChainPart.UNCONNECTED)).setValue(WATERLOGGED, false));
    }

    @Override
    protected VoxelShape getShape(BlockState $$0, BlockGetter $$1, BlockPos $$2, CollisionContext $$3) {
        return SHAPES.get($$0.getValue(FACING));
    }

    @Override
    protected boolean useShapeForLightOcclusion(BlockState $$0) {
        return true;
    }

    @Override
    protected boolean isPathfindable(BlockState $$0, PathComputationType $$1) {
        return $$1 == PathComputationType.WATER && $$0.getFluidState().is(FluidTags.WATER);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos $$0, BlockState $$1) {
        return new ShelfBlockEntity($$0, $$1);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> $$0) {
        $$0.add(FACING, POWERED, SIDE_CHAIN_PART, WATERLOGGED);
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState $$0, ServerLevel $$1, BlockPos $$2, boolean $$3) {
        Containers.updateNeighboursAfterDestroy($$0, $$1, $$2);
        this.updateNeighborsAfterPoweringDown($$1, $$2, $$0);
    }

    @Override
    protected void neighborChanged(BlockState $$0, Level $$1, BlockPos $$2, Block $$3, @Nullable Orientation $$4, boolean $$5) {
        if ($$1.isClientSide()) {
            return;
        }
        boolean $$6 = $$1.hasNeighborSignal($$2);
        if ($$0.getValue(POWERED) != $$6) {
            BlockState $$7 = (BlockState)$$0.setValue(POWERED, $$6);
            if (!$$6) {
                $$7 = (BlockState)$$7.setValue(SIDE_CHAIN_PART, SideChainPart.UNCONNECTED);
            }
            $$1.setBlock($$2, $$7, 3);
            this.playSound($$1, $$2, $$6 ? SoundEvents.SHELF_ACTIVATE : SoundEvents.SHELF_DEACTIVATE);
            $$1.gameEvent($$6 ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE, $$2, GameEvent.Context.of($$7));
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext $$0) {
        FluidState $$1 = $$0.getLevel().getFluidState($$0.getClickedPos());
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, $$0.getHorizontalDirection().getOpposite())).setValue(POWERED, $$0.getLevel().hasNeighborSignal($$0.getClickedPos()))).setValue(WATERLOGGED, $$1.getType() == Fluids.WATER);
    }

    @Override
    public BlockState rotate(BlockState $$0, Rotation $$1) {
        return (BlockState)$$0.setValue(FACING, $$1.rotate($$0.getValue(FACING)));
    }

    @Override
    public BlockState mirror(BlockState $$0, Mirror $$1) {
        return $$0.rotate($$1.getRotation($$0.getValue(FACING)));
    }

    @Override
    public int getRows() {
        return 1;
    }

    @Override
    public int getColumns() {
        return 3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected InteractionResult useItemOn(ItemStack $$0, BlockState $$1, Level $$2, BlockPos $$3, Player $$4, InteractionHand $$5, BlockHitResult $$6) {
        block13: {
            block12: {
                BlockEntity blockEntity = $$2.getBlockEntity($$3);
                if (!(blockEntity instanceof ShelfBlockEntity)) break block12;
                ShelfBlockEntity $$7 = (ShelfBlockEntity)blockEntity;
                if (!$$5.equals((Object)InteractionHand.OFF_HAND)) break block13;
            }
            return InteractionResult.PASS;
        }
        OptionalInt $$9 = this.getHitSlot($$6, $$1.getValue(FACING));
        if ($$9.isEmpty()) {
            return InteractionResult.PASS;
        }
        if ($$2.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        Inventory $$10 = $$4.getInventory();
        if (!$$1.getValue(POWERED).booleanValue()) {
            void $$8;
            boolean $$11 = ShelfBlock.swapSingleItem($$0, $$4, (ShelfBlockEntity)$$8, $$9.getAsInt(), $$10);
            if ($$11) {
                this.playSound($$2, $$3, $$0.isEmpty() ? SoundEvents.SHELF_TAKE_ITEM : SoundEvents.SHELF_SINGLE_SWAP);
            } else if (!$$0.isEmpty()) {
                this.playSound($$2, $$3, SoundEvents.SHELF_PLACE_ITEM);
            } else {
                return InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS.heldItemTransformedTo($$0);
        }
        ItemStack $$12 = $$10.getSelectedItem();
        boolean $$13 = this.swapHotbar($$2, $$3, $$10);
        if (!$$13) {
            return InteractionResult.CONSUME;
        }
        this.playSound($$2, $$3, SoundEvents.SHELF_MULTI_SWAP);
        if ($$12 == $$10.getSelectedItem()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS.heldItemTransformedTo($$10.getSelectedItem());
    }

    private static boolean swapSingleItem(ItemStack $$0, Player $$1, ShelfBlockEntity $$2, int $$3, Inventory $$4) {
        ItemStack $$5 = $$2.swapItemNoUpdate($$3, $$0);
        ItemStack $$6 = $$1.hasInfiniteMaterials() && $$5.isEmpty() ? $$0.copy() : $$5;
        $$4.setItem($$4.getSelectedSlot(), $$6);
        $$4.setChanged();
        $$2.setChanged(GameEvent.ITEM_INTERACT_FINISH);
        return !$$5.isEmpty();
    }

    private boolean swapHotbar(Level $$0, BlockPos $$1, Inventory $$2) {
        List<BlockPos> $$3 = this.getAllBlocksConnectedTo($$0, $$1);
        if ($$3.isEmpty()) {
            return false;
        }
        boolean $$4 = false;
        for (int $$5 = 0; $$5 < $$3.size(); ++$$5) {
            ShelfBlockEntity $$6 = (ShelfBlockEntity)$$0.getBlockEntity($$3.get($$5));
            if ($$6 == null) continue;
            for (int $$7 = 0; $$7 < $$6.getContainerSize(); ++$$7) {
                int $$8 = 9 - ($$3.size() - $$5) * $$6.getContainerSize() + $$7;
                if ($$8 < 0 || $$8 > $$2.getContainerSize()) continue;
                ItemStack $$9 = $$2.removeItemNoUpdate($$8);
                ItemStack $$10 = $$6.swapItemNoUpdate($$7, $$9);
                if ($$9.isEmpty() && $$10.isEmpty()) continue;
                $$2.setItem($$8, $$10);
                $$4 = true;
            }
            $$2.setChanged();
            $$6.setChanged(GameEvent.ENTITY_INTERACT);
        }
        return $$4;
    }

    @Override
    public SideChainPart getSideChainPart(BlockState $$0) {
        return $$0.getValue(SIDE_CHAIN_PART);
    }

    @Override
    public BlockState setSideChainPart(BlockState $$0, SideChainPart $$1) {
        return (BlockState)$$0.setValue(SIDE_CHAIN_PART, $$1);
    }

    @Override
    public Direction getFacing(BlockState $$0) {
        return $$0.getValue(FACING);
    }

    @Override
    public boolean isConnectable(BlockState $$0) {
        return $$0.is(BlockTags.WOODEN_SHELVES) && $$0.hasProperty(POWERED) && $$0.getValue(POWERED) != false;
    }

    @Override
    public int getMaxChainLength() {
        return 3;
    }

    @Override
    protected void onPlace(BlockState $$0, Level $$1, BlockPos $$2, BlockState $$3, boolean $$4) {
        if ($$0.getValue(POWERED).booleanValue()) {
            this.updateSelfAndNeighborsOnPoweringUp($$1, $$2, $$0, $$3);
        } else {
            this.updateNeighborsAfterPoweringDown($$1, $$2, $$0);
        }
    }

    private void playSound(LevelAccessor $$0, BlockPos $$1, SoundEvent $$2) {
        $$0.playSound(null, $$1, $$2, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    protected FluidState getFluidState(BlockState $$0) {
        if ($$0.getValue(WATERLOGGED).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState($$0);
    }

    @Override
    protected BlockState updateShape(BlockState $$0, LevelReader $$1, ScheduledTickAccess $$2, BlockPos $$3, Direction $$4, BlockPos $$5, BlockState $$6, RandomSource $$7) {
        if ($$0.getValue(WATERLOGGED).booleanValue()) {
            $$2.scheduleTick($$3, Fluids.WATER, Fluids.WATER.getTickDelay($$1));
        }
        return super.updateShape($$0, $$1, $$2, $$3, $$4, $$5, $$6, $$7);
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState $$0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState $$0, Level $$1, BlockPos $$2, Direction $$3) {
        if ($$1.isClientSide()) {
            return 0;
        }
        if ($$3 != $$0.getValue(FACING).getOpposite()) {
            return 0;
        }
        BlockEntity blockEntity = $$1.getBlockEntity($$2);
        if (blockEntity instanceof ShelfBlockEntity) {
            ShelfBlockEntity $$4 = (ShelfBlockEntity)blockEntity;
            int $$5 = $$4.getItem(0).isEmpty() ? 0 : 1;
            int $$6 = $$4.getItem(1).isEmpty() ? 0 : 1;
            int $$7 = $$4.getItem(2).isEmpty() ? 0 : 1;
            return $$5 | $$6 << 1 | $$7 << 2;
        }
        return 0;
    }
}

