/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components.toasts;

import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.NowPlayingToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ForgeEventFactoryClient;
import org.apache.commons.lang3.mutable.MutableBoolean;

@OnlyIn(value=Dist.CLIENT)
public class ToastManager {
    private static final int SLOT_COUNT = 5;
    private static final int ALL_SLOTS_OCCUPIED = -1;
    final Minecraft minecraft;
    private final List<ToastInstance<?>> visibleToasts = new ArrayList();
    private final BitSet occupiedSlots = new BitSet(5);
    private final Deque<Toast> queued = Queues.newArrayDeque();
    private final Set<SoundEvent> playedToastSounds = new HashSet<SoundEvent>();
    @Nullable
    private ToastInstance<NowPlayingToast> nowPlayingToast;

    public ToastManager(Minecraft p_363951_, Options p_407989_) {
        this.minecraft = p_363951_;
        if (((Boolean)p_407989_.showNowPlayingToast().get()).booleanValue()) {
            this.createNowPlayingToast();
        }
    }

    public void update() {
        MutableBoolean mutableboolean = new MutableBoolean(false);
        this.visibleToasts.removeIf(p_389308_ -> {
            Toast.Visibility toast$visibility = p_389308_.visibility;
            p_389308_.update();
            if (p_389308_.visibility != toast$visibility && mutableboolean.isFalse()) {
                mutableboolean.setTrue();
                p_389308_.visibility.playSound(this.minecraft.getSoundManager());
            }
            if (p_389308_.hasFinishedRendering()) {
                this.occupiedSlots.clear(p_389308_.firstSlotIndex, p_389308_.firstSlotIndex + p_389308_.occupiedSlotCount);
                return true;
            }
            return false;
        });
        if (!this.queued.isEmpty() && this.freeSlotCount() > 0) {
            this.queued.removeIf(p_389309_ -> {
                int i = p_389309_.occcupiedSlotCount();
                int j = this.findFreeSlotsIndex(i);
                if (j == -1) {
                    return false;
                }
                this.visibleToasts.add(new ToastInstance(this, p_389309_, j, i));
                this.occupiedSlots.set(j, j + i);
                SoundEvent soundevent = p_389309_.getSoundEvent();
                if (soundevent != null && this.playedToastSounds.add(soundevent)) {
                    this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)soundevent, (float)1.0f, (float)1.0f));
                }
                return true;
            });
        }
        this.playedToastSounds.clear();
        if (this.nowPlayingToast != null) {
            this.nowPlayingToast.update();
        }
    }

    public void render(GuiGraphics p_366590_) {
        if (!this.minecraft.options.hideGui) {
            int i = p_366590_.guiWidth();
            if (!this.visibleToasts.isEmpty()) {
                p_366590_.nextStratum();
            }
            for (ToastInstance<?> toastinstance : this.visibleToasts) {
                toastinstance.render(p_366590_, i);
            }
            if (((Boolean)this.minecraft.options.showNowPlayingToast().get()).booleanValue() && this.nowPlayingToast != null && (this.minecraft.screen == null || !(this.minecraft.screen instanceof PauseScreen))) {
                this.nowPlayingToast.render(p_366590_, i);
            }
        }
    }

    private int findFreeSlotsIndex(int p_366194_) {
        if (this.freeSlotCount() >= p_366194_) {
            int i = 0;
            for (int j = 0; j < 5; ++j) {
                if (this.occupiedSlots.get(j)) {
                    i = 0;
                    continue;
                }
                if (++i != p_366194_) continue;
                return j + 1 - i;
            }
        }
        return -1;
    }

    private int freeSlotCount() {
        return 5 - this.occupiedSlots.cardinality();
    }

    @Nullable
    public <T extends Toast> T getToast(Class<? extends T> p_368822_, Object p_361635_) {
        for (ToastInstance<?> toastinstance : this.visibleToasts) {
            if (toastinstance == null || !p_368822_.isAssignableFrom(toastinstance.getToast().getClass()) || !toastinstance.getToast().getToken().equals(p_361635_)) continue;
            return (T)toastinstance.getToast();
        }
        for (Toast toast : this.queued) {
            if (!p_368822_.isAssignableFrom(toast.getClass()) || !toast.getToken().equals(p_361635_)) continue;
            return (T)toast;
        }
        return null;
    }

    public void clear() {
        this.occupiedSlots.clear();
        this.visibleToasts.clear();
        this.queued.clear();
    }

    public void addToast(Toast p_360768_) {
        if (ForgeEventFactoryClient.onToastAdd((Toast)p_360768_)) {
            return;
        }
        this.queued.add(p_360768_);
    }

    public void showNowPlayingToast() {
        if (this.nowPlayingToast != null) {
            this.nowPlayingToast.resetToast();
            this.nowPlayingToast.getToast().showToast(this.minecraft.options);
        }
    }

    public void hideNowPlayingToast() {
        if (this.nowPlayingToast != null) {
            this.nowPlayingToast.getToast().setWantedVisibility(Toast.Visibility.HIDE);
        }
    }

    public void createNowPlayingToast() {
        this.nowPlayingToast = new ToastInstance(this, (Toast)new NowPlayingToast(), 0, 0);
    }

    public void removeNowPlayingToast() {
        this.nowPlayingToast = null;
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    public double getNotificationDisplayTimeMultiplier() {
        return (Double)this.minecraft.options.notificationDisplayTime().get();
    }

    @OnlyIn(value=Dist.CLIENT)
    class ToastInstance<T extends Toast> {
        private static final long SLIDE_ANIMATION_DURATION_MS = 600L;
        private final T toast;
        final int firstSlotIndex;
        final int occupiedSlotCount;
        private long animationStartTime;
        private long becameFullyVisibleAt;
        Toast.Visibility visibility;
        private long fullyVisibleFor;
        private float visiblePortion;
        protected boolean hasFinishedRendering;
        final /* synthetic */ ToastManager this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        ToastInstance(T p_369780_, int p_370007_, int p_366058_) {
            this.this$0 = (ToastManager)this$0;
            this.toast = p_369780_;
            this.firstSlotIndex = p_370007_;
            this.occupiedSlotCount = p_366058_;
            this.resetToast();
        }

        public T getToast() {
            return this.toast;
        }

        public void resetToast() {
            this.animationStartTime = -1L;
            this.becameFullyVisibleAt = -1L;
            this.visibility = Toast.Visibility.HIDE;
            this.fullyVisibleFor = 0L;
            this.visiblePortion = 0.0f;
            this.hasFinishedRendering = false;
        }

        public boolean hasFinishedRendering() {
            return this.hasFinishedRendering;
        }

        private void calculateVisiblePortion(long p_367026_) {
            float f = Mth.clamp((float)(p_367026_ - this.animationStartTime) / 600.0f, 0.0f, 1.0f);
            f *= f;
            this.visiblePortion = this.visibility == Toast.Visibility.HIDE ? 1.0f - f : f;
        }

        public void update() {
            long i = Util.getMillis();
            if (this.animationStartTime == -1L) {
                this.animationStartTime = i;
                this.visibility = Toast.Visibility.SHOW;
            }
            if (this.visibility == Toast.Visibility.SHOW && i - this.animationStartTime <= 600L) {
                this.becameFullyVisibleAt = i;
            }
            this.fullyVisibleFor = i - this.becameFullyVisibleAt;
            this.calculateVisiblePortion(i);
            this.toast.update(this.this$0, this.fullyVisibleFor);
            Toast.Visibility toast$visibility = this.toast.getWantedVisibility();
            if (toast$visibility != this.visibility) {
                this.animationStartTime = i - (long)((int)((1.0f - this.visiblePortion) * 600.0f));
                this.visibility = toast$visibility;
            }
            boolean flag = this.hasFinishedRendering;
            boolean bl = this.hasFinishedRendering = this.visibility == Toast.Visibility.HIDE && i - this.animationStartTime > 600L;
            if (this.hasFinishedRendering && !flag) {
                this.toast.onFinishedRendering();
            }
        }

        public void render(GuiGraphics p_369740_, int p_366638_) {
            if (!this.hasFinishedRendering) {
                p_369740_.pose().pushMatrix();
                p_369740_.pose().translate(this.toast.xPos(p_366638_, this.visiblePortion), this.toast.yPos(this.firstSlotIndex));
                this.toast.render(p_369740_, this.this$0.minecraft.font, this.fullyVisibleFor);
                p_369740_.pose().popMatrix();
            }
        }
    }
}

