// Code generated by mdatagen. DO NOT EDIT.

package metadata

import (
	"errors"
	"sync"

	"go.opentelemetry.io/otel/metric"
	"go.opentelemetry.io/otel/trace"

	"go.opentelemetry.io/collector/component"
)

func Meter(settings component.TelemetrySettings) metric.Meter {
	return settings.MeterProvider.Meter("github.com/open-telemetry/opentelemetry-collector-contrib/processor/k8sattributesprocessor")
}

func Tracer(settings component.TelemetrySettings) trace.Tracer {
	return settings.TracerProvider.Tracer("github.com/open-telemetry/opentelemetry-collector-contrib/processor/k8sattributesprocessor")
}

// TelemetryBuilder provides an interface for components to report telemetry
// as defined in metadata and user config.
type TelemetryBuilder struct {
	meter                        metric.Meter
	mu                           sync.Mutex
	registrations                []metric.Registration
	OtelsvcK8sDaemonsetAdded     metric.Int64Counter
	OtelsvcK8sDaemonsetDeleted   metric.Int64Counter
	OtelsvcK8sDaemonsetUpdated   metric.Int64Counter
	OtelsvcK8sDeploymentAdded    metric.Int64Counter
	OtelsvcK8sDeploymentDeleted  metric.Int64Counter
	OtelsvcK8sDeploymentUpdated  metric.Int64Counter
	OtelsvcK8sIPLookupMiss       metric.Int64Counter
	OtelsvcK8sJobAdded           metric.Int64Counter
	OtelsvcK8sJobDeleted         metric.Int64Counter
	OtelsvcK8sJobUpdated         metric.Int64Counter
	OtelsvcK8sNamespaceAdded     metric.Int64Counter
	OtelsvcK8sNamespaceDeleted   metric.Int64Counter
	OtelsvcK8sNamespaceUpdated   metric.Int64Counter
	OtelsvcK8sNodeAdded          metric.Int64Counter
	OtelsvcK8sNodeDeleted        metric.Int64Counter
	OtelsvcK8sNodeUpdated        metric.Int64Counter
	OtelsvcK8sPodAdded           metric.Int64Counter
	OtelsvcK8sPodDeleted         metric.Int64Counter
	OtelsvcK8sPodTableSize       metric.Int64Gauge
	OtelsvcK8sPodUpdated         metric.Int64Counter
	OtelsvcK8sReplicasetAdded    metric.Int64Counter
	OtelsvcK8sReplicasetDeleted  metric.Int64Counter
	OtelsvcK8sReplicasetUpdated  metric.Int64Counter
	OtelsvcK8sStatefulsetAdded   metric.Int64Counter
	OtelsvcK8sStatefulsetDeleted metric.Int64Counter
	OtelsvcK8sStatefulsetUpdated metric.Int64Counter
}

// TelemetryBuilderOption applies changes to default builder.
type TelemetryBuilderOption interface {
	apply(*TelemetryBuilder)
}

type telemetryBuilderOptionFunc func(mb *TelemetryBuilder)

func (tbof telemetryBuilderOptionFunc) apply(mb *TelemetryBuilder) {
	tbof(mb)
}

// Shutdown unregister all registered callbacks for async instruments.
func (builder *TelemetryBuilder) Shutdown() {
	builder.mu.Lock()
	defer builder.mu.Unlock()
	for _, reg := range builder.registrations {
		reg.Unregister()
	}
}

// NewTelemetryBuilder provides a struct with methods to update all internal telemetry
// for a component
func NewTelemetryBuilder(settings component.TelemetrySettings, options ...TelemetryBuilderOption) (*TelemetryBuilder, error) {
	builder := TelemetryBuilder{}
	for _, op := range options {
		op.apply(&builder)
	}
	builder.meter = Meter(settings)
	var err, errs error
	builder.OtelsvcK8sDaemonsetAdded, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_daemonset_added",
		metric.WithDescription("Number of daemonset add events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sDaemonsetDeleted, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_daemonset_deleted",
		metric.WithDescription("Number of daemonset delete events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sDaemonsetUpdated, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_daemonset_updated",
		metric.WithDescription("Number of daemonset update events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sDeploymentAdded, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_deployment_added",
		metric.WithDescription("Number of deployment add events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sDeploymentDeleted, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_deployment_deleted",
		metric.WithDescription("Number of deployment delete events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sDeploymentUpdated, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_deployment_updated",
		metric.WithDescription("Number of deployment update events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sIPLookupMiss, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_ip_lookup_miss",
		metric.WithDescription("Number of times pod by IP lookup failed. [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sJobAdded, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_job_added",
		metric.WithDescription("Number of job add events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sJobDeleted, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_job_deleted",
		metric.WithDescription("Number of job delete events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sJobUpdated, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_job_updated",
		metric.WithDescription("Number of job update events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sNamespaceAdded, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_namespace_added",
		metric.WithDescription("Number of namespace add events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sNamespaceDeleted, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_namespace_deleted",
		metric.WithDescription("Number of namespace delete events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sNamespaceUpdated, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_namespace_updated",
		metric.WithDescription("Number of namespace update events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sNodeAdded, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_node_added",
		metric.WithDescription("Number of node add events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sNodeDeleted, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_node_deleted",
		metric.WithDescription("Number of node delete events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sNodeUpdated, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_node_updated",
		metric.WithDescription("Number of node update events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sPodAdded, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_pod_added",
		metric.WithDescription("Number of pod add events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sPodDeleted, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_pod_deleted",
		metric.WithDescription("Number of pod delete events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sPodTableSize, err = builder.meter.Int64Gauge(
		"otelcol_otelsvc_k8s_pod_table_size",
		metric.WithDescription("Size of table containing pod info [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sPodUpdated, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_pod_updated",
		metric.WithDescription("Number of pod update events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sReplicasetAdded, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_replicaset_added",
		metric.WithDescription("Number of ReplicaSet add events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sReplicasetDeleted, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_replicaset_deleted",
		metric.WithDescription("Number of ReplicaSet delete events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sReplicasetUpdated, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_replicaset_updated",
		metric.WithDescription("Number of ReplicaSet update events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sStatefulsetAdded, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_statefulset_added",
		metric.WithDescription("Number of statefulset add events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sStatefulsetDeleted, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_statefulset_deleted",
		metric.WithDescription("Number of statefulset delete events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.OtelsvcK8sStatefulsetUpdated, err = builder.meter.Int64Counter(
		"otelcol_otelsvc_k8s_statefulset_updated",
		metric.WithDescription("Number of statefulset update events received [Development]"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	return &builder, errs
}
