/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.weupnp;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.bitlet.weupnp.GatewayDeviceHandler;
import org.bitlet.weupnp.NameValueHandler;
import org.bitlet.weupnp.PortMappingEntry;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatewayDevice {
    private static final int DEFAULT_HTTP_RECEIVE_TIMEOUT = 7000;
    private String st;
    private String location;
    private String serviceType;
    private String serviceTypeCIF;
    private String urlBase;
    private String controlURL;
    private String controlURLCIF;
    private String eventSubURL;
    private String eventSubURLCIF;
    private String sCPDURL;
    private String sCPDURLCIF;
    private String deviceType;
    private String deviceTypeCIF;
    private String friendlyName;
    private String manufacturer;
    private String modelDescription;
    private String presentationURL;
    private InetAddress localAddress;
    private String modelNumber;
    private String modelName;
    private static int httpReadTimeout = 7000;

    public void loadDescription() throws SAXException, IOException {
        URLConnection urlConn = new URL(this.getLocation()).openConnection();
        urlConn.setReadTimeout(httpReadTimeout);
        XMLReader parser = XMLReaderFactory.createXMLReader();
        parser.setContentHandler(new GatewayDeviceHandler(this));
        parser.parse(new InputSource(urlConn.getInputStream()));
        String ipConDescURL = this.urlBase != null && this.urlBase.trim().length() > 0 ? this.urlBase : this.location;
        int lastSlashIndex = ipConDescURL.indexOf(47, 7);
        if (lastSlashIndex > 0) {
            ipConDescURL = ipConDescURL.substring(0, lastSlashIndex);
        }
        this.sCPDURL = this.copyOrCatUrl(ipConDescURL, this.sCPDURL);
        this.controlURL = this.copyOrCatUrl(ipConDescURL, this.controlURL);
        this.controlURLCIF = this.copyOrCatUrl(ipConDescURL, this.controlURLCIF);
        this.presentationURL = this.copyOrCatUrl(ipConDescURL, this.presentationURL);
    }

    public static Map<String, String> simpleUPnPcommand(String url, String service, String action, Map<String, String> args) throws IOException, SAXException {
        String soapAction = "\"" + service + "#" + action + "\"";
        StringBuilder soapBody = new StringBuilder();
        soapBody.append("<?xml version=\"1.0\"?>\r\n<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><SOAP-ENV:Body><m:" + action + " xmlns:m=\"" + service + "\">");
        if (args != null && args.size() > 0) {
            Set<Map.Entry<String, String>> entrySet = args.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                soapBody.append("<" + entry.getKey() + ">" + entry.getValue() + "</" + entry.getKey() + ">");
            }
        }
        soapBody.append("</m:" + action + ">");
        soapBody.append("</SOAP-ENV:Body></SOAP-ENV:Envelope>");
        URL postUrl = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)postUrl.openConnection();
        conn.setRequestMethod("POST");
        conn.setConnectTimeout(httpReadTimeout);
        conn.setReadTimeout(httpReadTimeout);
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "text/xml");
        conn.setRequestProperty("SOAPAction", soapAction);
        conn.setRequestProperty("Connection", "Close");
        byte[] soapBodyBytes = soapBody.toString().getBytes();
        conn.setRequestProperty("Content-Length", String.valueOf(soapBodyBytes.length));
        conn.getOutputStream().write(soapBodyBytes);
        HashMap<String, String> nameValue = new HashMap<String, String>();
        XMLReader parser = XMLReaderFactory.createXMLReader();
        parser.setContentHandler(new NameValueHandler(nameValue));
        if (conn.getResponseCode() == 500) {
            try {
                parser.parse(new InputSource(conn.getErrorStream()));
            }
            catch (SAXException e) {
                // empty catch block
            }
            conn.disconnect();
            return nameValue;
        }
        parser.parse(new InputSource(conn.getInputStream()));
        conn.disconnect();
        return nameValue;
    }

    public boolean isConnected() throws IOException, SAXException {
        Map<String, String> nameValue = GatewayDevice.simpleUPnPcommand(this.controlURL, this.serviceType, "GetStatusInfo", null);
        String connectionStatus = nameValue.get("NewConnectionStatus");
        return connectionStatus != null && connectionStatus.equalsIgnoreCase("Connected");
    }

    public String getExternalIPAddress() throws IOException, SAXException {
        Map<String, String> nameValue = GatewayDevice.simpleUPnPcommand(this.controlURL, this.serviceType, "GetExternalIPAddress", null);
        return nameValue.get("NewExternalIPAddress");
    }

    public boolean addPortMapping(int externalPort, int internalPort, String internalClient, String protocol, String description) throws IOException, SAXException {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("NewRemoteHost", "");
        args.put("NewExternalPort", Integer.toString(externalPort));
        args.put("NewProtocol", protocol);
        args.put("NewInternalPort", Integer.toString(internalPort));
        args.put("NewInternalClient", internalClient);
        args.put("NewEnabled", Integer.toString(1));
        args.put("NewPortMappingDescription", description);
        args.put("NewLeaseDuration", Integer.toString(0));
        Map<String, String> nameValue = GatewayDevice.simpleUPnPcommand(this.controlURL, this.serviceType, "AddPortMapping", args);
        return nameValue.get("errorCode") == null;
    }

    public boolean getSpecificPortMappingEntry(int externalPort, String protocol, PortMappingEntry portMappingEntry) throws IOException, SAXException {
        portMappingEntry.setExternalPort(externalPort);
        portMappingEntry.setProtocol(protocol);
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("NewRemoteHost", "");
        args.put("NewExternalPort", Integer.toString(externalPort));
        args.put("NewProtocol", protocol);
        Map<String, String> nameValue = GatewayDevice.simpleUPnPcommand(this.controlURL, this.serviceType, "GetSpecificPortMappingEntry", args);
        if (nameValue.isEmpty() || nameValue.containsKey("errorCode")) {
            return false;
        }
        if (!nameValue.containsKey("NewInternalClient") || !nameValue.containsKey("NewInternalPort")) {
            return false;
        }
        portMappingEntry.setProtocol(protocol);
        portMappingEntry.setEnabled(nameValue.get("NewEnabled"));
        portMappingEntry.setInternalClient(nameValue.get("NewInternalClient"));
        portMappingEntry.setExternalPort(externalPort);
        portMappingEntry.setPortMappingDescription(nameValue.get("NewPortMappingDescription"));
        portMappingEntry.setRemoteHost(nameValue.get("NewRemoteHost"));
        try {
            portMappingEntry.setInternalPort(Integer.parseInt(nameValue.get("NewInternalPort")));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return true;
    }

    public boolean getGenericPortMappingEntry(int index, PortMappingEntry portMappingEntry) throws IOException, SAXException {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("NewPortMappingIndex", Integer.toString(index));
        Map<String, String> nameValue = GatewayDevice.simpleUPnPcommand(this.controlURL, this.serviceType, "GetGenericPortMappingEntry", args);
        if (nameValue.isEmpty() || nameValue.containsKey("errorCode")) {
            return false;
        }
        portMappingEntry.setRemoteHost(nameValue.get("NewRemoteHost"));
        portMappingEntry.setInternalClient(nameValue.get("NewInternalClient"));
        portMappingEntry.setProtocol(nameValue.get("NewProtocol"));
        portMappingEntry.setEnabled(nameValue.get("NewEnabled"));
        portMappingEntry.setPortMappingDescription(nameValue.get("NewPortMappingDescription"));
        try {
            portMappingEntry.setInternalPort(Integer.parseInt(nameValue.get("NewInternalPort")));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            portMappingEntry.setExternalPort(Integer.parseInt(nameValue.get("NewExternalPort")));
        }
        catch (Exception e) {
            // empty catch block
        }
        return true;
    }

    public Integer getPortMappingNumberOfEntries() throws IOException, SAXException {
        Map<String, String> nameValue = GatewayDevice.simpleUPnPcommand(this.controlURL, this.serviceType, "GetPortMappingNumberOfEntries", null);
        Integer portMappingNumber = null;
        try {
            portMappingNumber = Integer.valueOf(nameValue.get("NewPortMappingNumberOfEntries"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return portMappingNumber;
    }

    public boolean deletePortMapping(int externalPort, String protocol) throws IOException, SAXException {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("NewRemoteHost", "");
        args.put("NewExternalPort", Integer.toString(externalPort));
        args.put("NewProtocol", protocol);
        Map<String, String> nameValue = GatewayDevice.simpleUPnPcommand(this.controlURL, this.serviceType, "DeletePortMapping", args);
        return true;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(InetAddress localAddress) {
        this.localAddress = localAddress;
    }

    public String getSt() {
        return this.st;
    }

    public void setSt(String st) {
        this.st = st;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getServiceTypeCIF() {
        return this.serviceTypeCIF;
    }

    public void setServiceTypeCIF(String serviceTypeCIF) {
        this.serviceTypeCIF = serviceTypeCIF;
    }

    public String getControlURL() {
        return this.controlURL;
    }

    public void setControlURL(String controlURL) {
        this.controlURL = controlURL;
    }

    public String getControlURLCIF() {
        return this.controlURLCIF;
    }

    public void setControlURLCIF(String controlURLCIF) {
        this.controlURLCIF = controlURLCIF;
    }

    public String getEventSubURL() {
        return this.eventSubURL;
    }

    public void setEventSubURL(String eventSubURL) {
        this.eventSubURL = eventSubURL;
    }

    public String getEventSubURLCIF() {
        return this.eventSubURLCIF;
    }

    public void setEventSubURLCIF(String eventSubURLCIF) {
        this.eventSubURLCIF = eventSubURLCIF;
    }

    public String getSCPDURL() {
        return this.sCPDURL;
    }

    public void setSCPDURL(String sCPDURL) {
        this.sCPDURL = sCPDURL;
    }

    public String getSCPDURLCIF() {
        return this.sCPDURLCIF;
    }

    public void setSCPDURLCIF(String sCPDURLCIF) {
        this.sCPDURLCIF = sCPDURLCIF;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getDeviceTypeCIF() {
        return this.deviceTypeCIF;
    }

    public void setDeviceTypeCIF(String deviceTypeCIF) {
        this.deviceTypeCIF = deviceTypeCIF;
    }

    public String getURLBase() {
        return this.urlBase;
    }

    public void setURLBase(String uRLBase) {
        this.urlBase = uRLBase;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getModelDescription() {
        return this.modelDescription;
    }

    public void setModelDescription(String modelDescription) {
        this.modelDescription = modelDescription;
    }

    public String getPresentationURL() {
        return this.presentationURL;
    }

    public void setPresentationURL(String presentationURL) {
        this.presentationURL = presentationURL;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelNumber() {
        return this.modelNumber;
    }

    public void setModelNumber(String modelNumber) {
        this.modelNumber = modelNumber;
    }

    public static int getHttpReadTimeout() {
        return httpReadTimeout;
    }

    public static void setHttpReadTimeout(int milliseconds) {
        httpReadTimeout = milliseconds;
    }

    private String copyOrCatUrl(String dst, String src) {
        if (src != null) {
            if (src.startsWith("http://")) {
                dst = src;
            } else {
                if (!src.startsWith("/")) {
                    dst = dst + "/";
                }
                dst = dst + src;
            }
        }
        return dst;
    }
}

