/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.stack;

import java.io.IOException;
import org.ice4j.StunException;
import org.ice4j.TransportAddress;
import org.ice4j.message.Response;
import org.ice4j.stack.StunStack;
import org.ice4j.stack.TransactionID;

public class StunServerTransaction {
    static final long LIFETIME = 16000L;
    private final StunStack stackCallback;
    private TransportAddress responseDestination = null;
    private final TransportAddress requestSource;
    private Response response = null;
    private final TransportAddress localListeningAddress;
    private TransportAddress localSendingAddress = null;
    private final TransactionID transactionID;
    private long expirationTime = -1L;
    private boolean expired = true;
    private boolean isRetransmitting = false;

    public StunServerTransaction(StunStack stackCallback, TransactionID tranID, TransportAddress localListeningAddress, TransportAddress requestSource) {
        this.stackCallback = stackCallback;
        this.transactionID = tranID;
        this.localListeningAddress = localListeningAddress;
        this.requestSource = requestSource;
    }

    public synchronized void start() {
        if (this.expirationTime != -1L) {
            throw new IllegalStateException("StunServerTransaction " + String.valueOf(this.getTransactionID()) + " has already been started!");
        }
        this.expired = false;
        this.expirationTime = 16000L + System.currentTimeMillis();
    }

    public void sendResponse(Response response, TransportAddress sendThrough, TransportAddress sendTo) throws StunException, IOException, IllegalArgumentException {
        if (!this.isRetransmitting) {
            this.response = response;
            response.setTransactionID(this.transactionID.getBytes());
            this.localSendingAddress = sendThrough;
            this.responseDestination = sendTo;
        }
        this.isRetransmitting = true;
        this.retransmitResponse();
    }

    protected void retransmitResponse() throws StunException, IOException, IllegalArgumentException {
        if (this.isExpired() || !this.isRetransmitting) {
            return;
        }
        this.stackCallback.getNetAccessManager().sendMessage(this.response, this.localSendingAddress, this.responseDestination);
    }

    public synchronized void expire() {
        this.expired = true;
    }

    public boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    public synchronized boolean isExpired(long now) {
        if (this.expirationTime == -1L) {
            return false;
        }
        if (this.expirationTime < now) {
            return true;
        }
        return this.expired;
    }

    public TransactionID getTransactionID() {
        return this.transactionID;
    }

    public boolean isRetransmitting() {
        return this.isRetransmitting;
    }

    public TransportAddress getSendingAddress() {
        return this.localSendingAddress;
    }

    public TransportAddress getResponseDestinationAddress() {
        return this.responseDestination;
    }

    public TransportAddress getLocalListeningAddress() {
        return this.localListeningAddress;
    }

    public TransportAddress getRequestSourceAddress() {
        return this.requestSource;
    }

    protected Response getResponse() {
        return this.response;
    }
}

