/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.connector.TvShowNfoParser;
import org.tinymediamanager.core.tvshow.connector.TvShowSeasonNfoParser;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowReadNfoAction
extends TmmAction {
    public TvShowReadNfoAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.readnfo"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.readnfo.desc"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        final List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShowsRecursive();
        if (selectedTvShows.isEmpty()) {
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(TmmResourceBundle.getString("tvshow.readnfo"), selectedTvShows.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                int i = 0;
                for (TvShow tvShow : selectedTvShows) {
                    boolean dirty = this.processTvShow(tvShow);
                    for (TvShowSeason season : tvShow.getSeasons()) {
                        dirty |= this.processSeason(season);
                    }
                    if (dirty) {
                        tvShow.saveToDb();
                    }
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    break;
                }
            }

            private boolean processTvShow(TvShow tvShow) {
                Path nfo;
                TvShow tempTvShow = null;
                for (MediaFile mf : tvShow.getMediaFiles(MediaFileType.NFO)) {
                    if (tempTvShow == null) {
                        try {
                            tempTvShow = TvShowNfoParser.parseNfo(mf.getFileAsPath()).toTvShow();
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    try {
                        tempTvShow.merge(TvShowNfoParser.parseNfo(mf.getFileAsPath()).toTvShow());
                    }
                    catch (Exception exception) {}
                }
                if (tempTvShow == null && Files.exists(nfo = tvShow.getPathNIO().resolve("tvshow.nfo"), new LinkOption[0])) {
                    tvShow.addToMediaFiles(new MediaFile(nfo));
                    try {
                        tempTvShow = TvShowNfoParser.parseNfo(nfo).toTvShow();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (tempTvShow != null) {
                    tvShow.forceMerge(tempTvShow);
                    return true;
                }
                return false;
            }

            private boolean processSeason(TvShowSeason season) {
                TvShowSeason tempSeason = null;
                for (MediaFile mf : season.getMediaFiles(MediaFileType.NFO)) {
                    if (tempSeason == null) {
                        try {
                            tempSeason = TvShowSeasonNfoParser.parseNfo(mf.getFileAsPath()).toTvShowSeason();
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    try {
                        tempSeason.merge(TvShowSeasonNfoParser.parseNfo(mf.getFileAsPath()).toTvShowSeason());
                    }
                    catch (Exception exception) {}
                }
                if (tempSeason != null) {
                    season.forceMerge(tempSeason);
                    return true;
                }
                return false;
            }
        });
    }
}

