/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.validators;

import java.util.Collections;
import java.util.List;
import org.verapdf.model.baselayer.Object;
import org.verapdf.pdfa.validation.profiles.Rule;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.pdfa.validation.validators.BaseValidator;
import org.verapdf.pdfa.validation.validators.FlavourValidator;

class FastFailValidator
extends BaseValidator {
    private final int maxFailedTests;
    protected int failureCount = 0;

    protected FastFailValidator(ValidationProfile profile, boolean logPassedChecks) {
        this(profile, logPassedChecks, 0, false, false, 0);
    }

    protected FastFailValidator(ValidationProfile profile, boolean logPassedChecks, int maxFailedTests, boolean showErrorMessages, boolean showProgress, int maxNumberOfDisplayedFailedChecks) {
        this(Collections.singletonList(profile), logPassedChecks, maxFailedTests, showErrorMessages, showProgress, maxNumberOfDisplayedFailedChecks);
    }

    protected FastFailValidator(List<ValidationProfile> profiles, boolean logPassedChecks, int maxFailedTests, boolean showErrorMessages, boolean showProgress, int maxNumberOfDisplayedFailedChecks) {
        super(profiles, maxNumberOfDisplayedFailedChecks, logPassedChecks, showErrorMessages, showProgress);
        this.maxFailedTests = maxFailedTests;
    }

    @Override
    protected void processAssertionResult(FlavourValidator flavourValidator, boolean assertionResult, String locationContext, Rule rule, Object obj) {
        super.processAssertionResult(flavourValidator, assertionResult, locationContext, rule, obj);
        if (!assertionResult) {
            ++this.failureCount;
            if (this.maxFailedTests > 0 && this.failureCount >= this.maxFailedTests) {
                this.abortProcessing = true;
            }
        }
    }
}

