/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.MapMaker;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class ResourceKey<T> {
    private static final ConcurrentMap<InternKey, ResourceKey<?>> VALUES = new MapMaker().weakValues().makeMap();
    private final ResourceLocation registryName;
    private final ResourceLocation location;

    public static <T> Codec<ResourceKey<T>> codec(ResourceKey<? extends Registry<T>> $$0) {
        return ResourceLocation.CODEC.xmap($$1 -> ResourceKey.create($$0, $$1), ResourceKey::location);
    }

    public static <T> StreamCodec<ByteBuf, ResourceKey<T>> streamCodec(ResourceKey<? extends Registry<T>> $$0) {
        return ResourceLocation.STREAM_CODEC.map($$1 -> ResourceKey.create($$0, $$1), ResourceKey::location);
    }

    public static <T> ResourceKey<T> create(ResourceKey<? extends Registry<T>> $$0, ResourceLocation $$1) {
        return ResourceKey.create($$0.location, $$1);
    }

    public static <T> ResourceKey<Registry<T>> createRegistryKey(ResourceLocation $$0) {
        return ResourceKey.create(Registries.ROOT_REGISTRY_NAME, $$0);
    }

    private static <T> ResourceKey<T> create(ResourceLocation $$02, ResourceLocation $$1) {
        return VALUES.computeIfAbsent(new InternKey($$02, $$1), $$0 -> new ResourceKey($$0.registry, $$0.location));
    }

    private ResourceKey(ResourceLocation $$0, ResourceLocation $$1) {
        this.registryName = $$0;
        this.location = $$1;
    }

    public String toString() {
        return "ResourceKey[" + String.valueOf(this.registryName) + " / " + String.valueOf(this.location) + "]";
    }

    public boolean isFor(ResourceKey<? extends Registry<?>> $$0) {
        return this.registryName.equals($$0.location());
    }

    public <E> Optional<ResourceKey<E>> cast(ResourceKey<? extends Registry<E>> $$0) {
        return this.isFor($$0) ? Optional.of(this) : Optional.empty();
    }

    public ResourceLocation location() {
        return this.location;
    }

    public ResourceLocation registry() {
        return this.registryName;
    }

    public ResourceKey<Registry<T>> registryKey() {
        return ResourceKey.createRegistryKey(this.registryName);
    }

    record InternKey(ResourceLocation registry, ResourceLocation location) {
    }
}

