//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmonitor

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// MetricDefinitionsClient contains the methods for the MetricDefinitions group.
// Don't use this type directly, use NewMetricDefinitionsClient() instead.
type MetricDefinitionsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewMetricDefinitionsClient creates a new instance of MetricDefinitionsClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewMetricDefinitionsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*MetricDefinitionsClient, error) {
	cl, err := arm.NewClient(moduleName+".MetricDefinitionsClient", moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &MetricDefinitionsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// NewListPager - Lists the metric definitions for the resource.
//
// Generated from API version 2021-05-01
//   - resourceURI - The identifier of the resource.
//   - options - MetricDefinitionsClientListOptions contains the optional parameters for the MetricDefinitionsClient.NewListPager
//     method.
func (client *MetricDefinitionsClient) NewListPager(resourceURI string, options *MetricDefinitionsClientListOptions) *runtime.Pager[MetricDefinitionsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[MetricDefinitionsClientListResponse]{
		More: func(page MetricDefinitionsClientListResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *MetricDefinitionsClientListResponse) (MetricDefinitionsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "MetricDefinitionsClient.NewListPager")
			req, err := client.listCreateRequest(ctx, resourceURI, options)
			if err != nil {
				return MetricDefinitionsClientListResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return MetricDefinitionsClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return MetricDefinitionsClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *MetricDefinitionsClient) listCreateRequest(ctx context.Context, resourceURI string, options *MetricDefinitionsClientListOptions) (*policy.Request, error) {
	urlPath := "/{resourceUri}/providers/Microsoft.Insights/metricDefinitions"
	urlPath = strings.ReplaceAll(urlPath, "{resourceUri}", resourceURI)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-05-01")
	if options != nil && options.Metricnamespace != nil {
		reqQP.Set("metricnamespace", *options.Metricnamespace)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *MetricDefinitionsClient) listHandleResponse(resp *http.Response) (MetricDefinitionsClientListResponse, error) {
	result := MetricDefinitionsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MetricDefinitionCollection); err != nil {
		return MetricDefinitionsClientListResponse{}, err
	}
	return result, nil
}

// NewListAtSubscriptionScopePager - Lists the metric definitions for the subscription.
//
// Generated from API version 2021-05-01
//   - region - The region where the metrics you want reside.
//   - options - MetricDefinitionsClientListAtSubscriptionScopeOptions contains the optional parameters for the MetricDefinitionsClient.NewListAtSubscriptionScopePager
//     method.
func (client *MetricDefinitionsClient) NewListAtSubscriptionScopePager(region string, options *MetricDefinitionsClientListAtSubscriptionScopeOptions) *runtime.Pager[MetricDefinitionsClientListAtSubscriptionScopeResponse] {
	return runtime.NewPager(runtime.PagingHandler[MetricDefinitionsClientListAtSubscriptionScopeResponse]{
		More: func(page MetricDefinitionsClientListAtSubscriptionScopeResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *MetricDefinitionsClientListAtSubscriptionScopeResponse) (MetricDefinitionsClientListAtSubscriptionScopeResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "MetricDefinitionsClient.NewListAtSubscriptionScopePager")
			req, err := client.listAtSubscriptionScopeCreateRequest(ctx, region, options)
			if err != nil {
				return MetricDefinitionsClientListAtSubscriptionScopeResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return MetricDefinitionsClientListAtSubscriptionScopeResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return MetricDefinitionsClientListAtSubscriptionScopeResponse{}, runtime.NewResponseError(resp)
			}
			return client.listAtSubscriptionScopeHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listAtSubscriptionScopeCreateRequest creates the ListAtSubscriptionScope request.
func (client *MetricDefinitionsClient) listAtSubscriptionScopeCreateRequest(ctx context.Context, region string, options *MetricDefinitionsClientListAtSubscriptionScopeOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Insights/metricDefinitions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-05-01")
	reqQP.Set("region", region)
	if options != nil && options.Metricnamespace != nil {
		reqQP.Set("metricnamespace", *options.Metricnamespace)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAtSubscriptionScopeHandleResponse handles the ListAtSubscriptionScope response.
func (client *MetricDefinitionsClient) listAtSubscriptionScopeHandleResponse(resp *http.Response) (MetricDefinitionsClientListAtSubscriptionScopeResponse, error) {
	result := MetricDefinitionsClientListAtSubscriptionScopeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SubscriptionScopeMetricDefinitionCollection); err != nil {
		return MetricDefinitionsClientListAtSubscriptionScopeResponse{}, err
	}
	return result, nil
}
