/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.rating.RatingProvider;

public class TvShowFetchRatingsTask
extends TmmTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowFetchRatingsTask.class);
    private final List<TvShow> tvShows;
    private final List<TvShowEpisode> episodes;
    private final List<RatingProvider.RatingSource> sources;

    public TvShowFetchRatingsTask(Collection<TvShow> tvShows, Collection<TvShowEpisode> episodes, Collection<RatingProvider.RatingSource> sources) {
        super(TmmResourceBundle.getString("tvshow.fetchratings"), tvShows.size() + episodes.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.tvShows = new ArrayList<TvShow>(tvShows);
        this.episodes = new ArrayList<TvShowEpisode>(episodes);
        this.sources = new ArrayList<RatingProvider.RatingSource>(sources);
    }

    @Override
    protected void doInBackground() {
        List<MediaRating> ratings;
        HashMap<String, Object> ids;
        LOGGER.debug("fetching ratings...");
        int i = 0;
        for (TvShow tvShow : this.tvShows) {
            ids = new HashMap<String, Object>(tvShow.getIds());
            ids.put("tvShowIds", tvShow.getIds());
            ratings = RatingProvider.getRatings(ids, this.sources, MediaType.TV_SHOW);
            ratings.forEach(tvShow::setRating);
            if (!ratings.isEmpty()) {
                tvShow.saveToDb();
                tvShow.writeNFO();
            }
            this.publishState(++i);
            if (!this.cancel) continue;
            break;
        }
        for (TvShowEpisode episode : this.episodes) {
            ids = new HashMap<String, Object>(episode.getIds());
            ids.put("tvShowIds", episode.getTvShow().getIds());
            ids.put("seasonNr", episode.getSeason());
            ids.put("episodeNr", episode.getEpisode());
            ratings = RatingProvider.getRatings(ids, this.sources, MediaType.TV_EPISODE);
            ratings.forEach(episode::setRating);
            if (!ratings.isEmpty()) {
                episode.saveToDb();
                episode.writeNFO();
            }
            this.publishState(++i);
            if (!this.cancel) continue;
            break;
        }
    }
}

