/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.playlist;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.tinymediamanager.library.bluray.playlist.MetadataBlockData;
import org.tinymediamanager.library.bluray.playlist.MetadataBlockHeader;

@XmlType(propOrder={"metadataBlockHeader", "paddingX", "metadataBlockData", "data"})
public class ExtDataBlock {
    private BlockType type;
    private long size;
    private MetadataBlockHeader[] metadataBlockHeader;
    private int paddingX;
    private MetadataBlockData[] metadataBlockData;
    private byte[] data;

    public ExtDataBlock() {
    }

    public ExtDataBlock(BlockType blockType, long l) {
        this.setType(blockType);
        this.size = l;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        if (this.type == BlockType.pip_metadata) {
            this.readPIPMetadata(dataInputStream);
        } else {
            this.readUnknownExtData(dataInputStream);
        }
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        if (this.type == BlockType.pip_metadata) {
            this.writePIPMetadata(dataOutputStream);
        } else {
            this.writeUnknownExtData(dataOutputStream);
        }
    }

    @XmlAttribute
    public BlockType getType() {
        return this.type;
    }

    public void setType(BlockType blockType) {
        this.type = blockType;
    }

    private void readPIPMetadata(DataInputStream dataInputStream) throws IOException {
        dataInputStream.skipBytes(4);
        int n = dataInputStream.readUnsignedShort();
        MetadataBlockHeader[] metadataBlockHeaderArray = new MetadataBlockHeader[n];
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            metadataBlockHeaderArray[i] = new MetadataBlockHeader();
            metadataBlockHeaderArray[i].readObject(dataInputStream);
            nArray[i] = dataInputStream.readInt();
        }
        this.setMetadataBlockHeader(metadataBlockHeaderArray);
        long l = nArray[0];
        int n2 = 0;
        if (l > 0L) {
            n2 = (int)((l - (long)(6 + n * 14)) / 2L);
            for (int i = 0; i < n2; ++i) {
                dataInputStream.readShort();
            }
        }
        this.setPaddingX(n2);
        MetadataBlockData[] metadataBlockDataArray = new MetadataBlockData[n];
        for (int i = 0; i < n; ++i) {
            long l2 = 0L;
            if (i < n - 1) {
                l2 = nArray[i + 1] - nArray[i];
            }
            metadataBlockDataArray[i] = new MetadataBlockData(l2);
            metadataBlockDataArray[i].readObject(dataInputStream);
        }
        this.setMetadataBlockData(metadataBlockDataArray);
    }

    private void writePIPMetadata(DataOutputStream dataOutputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        MetadataBlockData[] metadataBlockDataArray = this.getMetadataBlockData();
        int[] nArray = new int[metadataBlockDataArray.length];
        int n2 = 6 + 14 * metadataBlockDataArray.length + 2 * this.getPaddingX();
        int n3 = 0;
        for (int i = 0; i < metadataBlockDataArray.length; ++i) {
            nArray[i] = n3 + n2;
            metadataBlockDataArray[i].writeObject(dataOutputStream2);
            dataOutputStream2.flush();
            n3 = byteArrayOutputStream.size();
        }
        dataOutputStream2.flush();
        dataOutputStream2.close();
        MetadataBlockHeader[] metadataBlockHeaderArray = this.getMetadataBlockHeader();
        dataOutputStream.writeInt(2 + 14 * metadataBlockHeaderArray.length + 2 * this.getPaddingX() + n3);
        dataOutputStream.writeShort(metadataBlockHeaderArray.length);
        for (n = 0; n < metadataBlockHeaderArray.length; ++n) {
            metadataBlockHeaderArray[n].writeObject(dataOutputStream);
            dataOutputStream.writeInt(nArray[n]);
        }
        for (n = 0; n < this.getPaddingX(); ++n) {
            dataOutputStream.writeShort(0);
        }
        dataOutputStream.write(byteArrayOutputStream.toByteArray());
    }

    public MetadataBlockHeader[] getMetadataBlockHeader() {
        return this.metadataBlockHeader;
    }

    public void setMetadataBlockHeader(MetadataBlockHeader[] metadataBlockHeaderArray) {
        this.metadataBlockHeader = metadataBlockHeaderArray;
    }

    public int getPaddingX() {
        return this.paddingX;
    }

    public void setPaddingX(int n) {
        this.paddingX = n;
    }

    public MetadataBlockData[] getMetadataBlockData() {
        return this.metadataBlockData;
    }

    public void setMetadataBlockData(MetadataBlockData[] metadataBlockDataArray) {
        this.metadataBlockData = metadataBlockDataArray;
    }

    private void readUnknownExtData(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[(int)this.size];
        dataInputStream.readFully(byArray);
        this.setData(byArray);
    }

    private void writeUnknownExtData(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(this.getData());
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public static enum BlockType {
        pip_metadata,
        unknown;

    }
}

