/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.rating.RatingProvider;
import org.tinymediamanager.ui.components.button.DocsButton;
import org.tinymediamanager.ui.components.button.JHintCheckBox;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;
import org.tinymediamanager.ui.tvshows.panels.TvShowScraperMetadataPanel;

class TvShowScraperOptionsSettingsPanel
extends JPanel {
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private JComboBox<MediaLanguages> cbScraperLanguage;
    private JComboBox<CountryCode> cbCertificationCountry;
    private JComboBox<CountryItem> cbReleaseCountry;
    private JCheckBox chckbxCapitalizeWords;
    private JCheckBox chckbxDoNotOverwrite;
    private JCheckBox chckbxFetchAllRatings;
    private JCheckBox chckbxRatingImdb;
    private JCheckBox chckbxRatingTmdb;
    private JCheckBox chckbxRatingMcUserscore;
    private JCheckBox chckbxRatingMyAnimeList;
    private JCheckBox chckbxRatingRogerEbert;
    private JCheckBox chckbxRatingTraktTv;
    private JCheckBox chckbxRatingLetterboxd;

    TvShowScraperOptionsSettingsPanel() {
        ItemListener checkBoxListener = e -> this.checkChanges();
        this.initComponents();
        this.initDataBindings();
        for (String country : Locale.getISOCountries()) {
            CountryItem item = new CountryItem(new Locale("", country));
            this.cbReleaseCountry.addItem(item);
            if (!item.locale.getCountry().equalsIgnoreCase(this.settings.getReleaseDateCountry())) continue;
            this.cbReleaseCountry.setSelectedItem(item);
        }
        this.cbReleaseCountry.addItemListener(l -> this.settings.setReleaseDateCountry(((CountryItem)this.cbReleaseCountry.getSelectedItem()).locale.getCountry()));
        this.chckbxRatingImdb.addItemListener(checkBoxListener);
        this.chckbxRatingTmdb.addItemListener(checkBoxListener);
        this.chckbxRatingMcUserscore.addItemListener(checkBoxListener);
        this.chckbxRatingTraktTv.addItemListener(checkBoxListener);
        this.chckbxRatingLetterboxd.addItemListener(checkBoxListener);
        this.chckbxRatingMyAnimeList.addItemListener(checkBoxListener);
        this.chckbxRatingRogerEbert.addItemListener(checkBoxListener);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[][]15lp![][15lp!][][15lp!][]"));
        JPanel panelOptions = new JPanel();
        panelOptions.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][10lp!][][][][10lp!][]"));
        TmmLabel lblOptions = new TmmLabel(TmmResourceBundle.getString("Settings.advancedoptions"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelOptions, lblOptions, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#advanced-options"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        JLabel lblScraperLanguage = new JLabel(TmmResourceBundle.getString("Settings.preferredLanguage"));
        panelOptions.add((Component)lblScraperLanguage, "cell 1 0 2 1");
        this.cbScraperLanguage = new JComboBox<MediaLanguages>(MediaLanguages.valuesSorted());
        panelOptions.add(this.cbScraperLanguage, "cell 1 0 2 1");
        JLabel lblCountry = new JLabel(TmmResourceBundle.getString("Settings.certificationCountry"));
        panelOptions.add((Component)lblCountry, "cell 1 1 2 1");
        this.cbCertificationCountry = new JComboBox<CountryCode>(CountryCode.values());
        panelOptions.add(this.cbCertificationCountry, "cell 1 1 2 1");
        JLabel label = new JLabel(TmmResourceBundle.getString("Settings.releaseDateCountry"));
        panelOptions.add((Component)label, "flowx,cell 1 2 2 1");
        this.cbReleaseCountry = new JComboBox();
        panelOptions.add(this.cbReleaseCountry, "cell 1 2 2 1");
        this.chckbxFetchAllRatings = new JHintCheckBox(TmmResourceBundle.getString("Settings.fetchallratings"));
        this.chckbxFetchAllRatings.setToolTipText(TmmResourceBundle.getString("Settings.fetchallratings.desc"));
        panelOptions.add((Component)this.chckbxFetchAllRatings, "cell 1 4 2 1");
        this.chckbxRatingImdb = new JCheckBox("IMDb");
        panelOptions.add((Component)this.chckbxRatingImdb, "flowx,cell 2 5");
        this.chckbxRatingTmdb = new JCheckBox("TMDB");
        panelOptions.add((Component)this.chckbxRatingTmdb, "cell 2 5");
        this.chckbxRatingMcUserscore = new JCheckBox("Metacritic Userscore");
        panelOptions.add((Component)this.chckbxRatingMcUserscore, "cell 2 5");
        this.chckbxRatingMyAnimeList = new JCheckBox("MyAnimeList");
        panelOptions.add((Component)this.chckbxRatingMyAnimeList, "cell 2 6");
        this.chckbxRatingRogerEbert = new JCheckBox("RogerEbert.com");
        panelOptions.add((Component)this.chckbxRatingRogerEbert, "cell 2 6");
        this.chckbxRatingTraktTv = new JCheckBox("Trakt.tv");
        panelOptions.add((Component)this.chckbxRatingTraktTv, "cell 2 5");
        this.chckbxRatingLetterboxd = new JCheckBox("Letterboxd");
        panelOptions.add((Component)this.chckbxRatingLetterboxd, "cell 2 5");
        this.chckbxCapitalizeWords = new JCheckBox(TmmResourceBundle.getString("Settings.scraper.capitalizeWords"));
        panelOptions.add((Component)this.chckbxCapitalizeWords, "cell 1 8");
        JPanel panelDefaults = new JPanel();
        panelDefaults.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][]"));
        TmmLabel lblDefaultsT = new TmmLabel(TmmResourceBundle.getString("scraper.metadata.defaults"), 1.16667);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelDefaults, lblDefaultsT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#metadata-scrape-defaults"));
        this.add((Component)collapsiblePanel, "cell 0 2,growx, wmin 0");
        TvShowScraperMetadataPanel scraperMetadataPanel = new TvShowScraperMetadataPanel();
        panelDefaults.add((Component)scraperMetadataPanel, "cell 1 0 2 1");
        this.chckbxDoNotOverwrite = new JCheckBox(TmmResourceBundle.getString("message.scrape.donotoverwrite"));
        this.chckbxDoNotOverwrite.setToolTipText(TmmResourceBundle.getString("message.scrape.donotoverwrite.desc"));
        panelDefaults.add((Component)this.chckbxDoNotOverwrite, "cell 1 1 2 1");
    }

    private void checkChanges() {
        ArrayList<RatingProvider.RatingSource> fetchRatingSources = new ArrayList<RatingProvider.RatingSource>();
        if (this.chckbxRatingImdb.isSelected()) {
            fetchRatingSources.add(RatingProvider.RatingSource.IMDB);
        }
        if (this.chckbxRatingTmdb.isSelected()) {
            fetchRatingSources.add(RatingProvider.RatingSource.TMDB);
        }
        if (this.chckbxRatingMcUserscore.isSelected()) {
            fetchRatingSources.add(RatingProvider.RatingSource.METACRITIC_USER);
        }
        if (this.chckbxRatingMyAnimeList.isSelected()) {
            fetchRatingSources.add(RatingProvider.RatingSource.MAL);
        }
        if (this.chckbxRatingRogerEbert.isSelected()) {
            fetchRatingSources.add(RatingProvider.RatingSource.ROGER_EBERT);
        }
        if (this.chckbxRatingTraktTv.isSelected()) {
            fetchRatingSources.add(RatingProvider.RatingSource.TRAKT_TV);
        }
        if (this.chckbxRatingLetterboxd.isSelected()) {
            fetchRatingSources.add(RatingProvider.RatingSource.LETTERBOXD);
        }
        this.settings.setFetchRatingSources(fetchRatingSources);
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_8 = BeanProperty.create((String)"scraperLanguage");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_8, this.cbScraperLanguage, (Property)jComboBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty settingsBeanProperty_9 = BeanProperty.create((String)"certificationCountry");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_9, this.cbCertificationCountry, (Property)jComboBoxBeanProperty);
        autoBinding_8.bind();
        BeanProperty settingsBeanProperty_10 = BeanProperty.create((String)"capitalWordsInTitles");
        BeanProperty jCheckBoxBeanProperty_1 = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_10, (Object)this.chckbxCapitalizeWords, (Property)jCheckBoxBeanProperty_1);
        autoBinding_9.bind();
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"doNotOverwriteExistingData");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (Object)this.chckbxDoNotOverwrite, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowSettingsBeanProperty_1 = BeanProperty.create((String)"fetchAllRatings");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_1, (Object)this.chckbxFetchAllRatings, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty jCheckBoxBeanProperty_2 = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxFetchAllRatings, (Property)jCheckBoxBeanProperty_1, (Object)this.chckbxRatingImdb, (Property)jCheckBoxBeanProperty_2);
        autoBinding.bind();
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxFetchAllRatings, (Property)jCheckBoxBeanProperty_1, (Object)this.chckbxRatingTmdb, (Property)jCheckBoxBeanProperty_2);
        autoBinding_3.bind();
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxFetchAllRatings, (Property)jCheckBoxBeanProperty_1, (Object)this.chckbxRatingMcUserscore, (Property)jCheckBoxBeanProperty_2);
        autoBinding_4.bind();
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxFetchAllRatings, (Property)jCheckBoxBeanProperty_1, (Object)this.chckbxRatingMyAnimeList, (Property)jCheckBoxBeanProperty_2);
        autoBinding_5.bind();
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxFetchAllRatings, (Property)jCheckBoxBeanProperty_1, (Object)this.chckbxRatingRogerEbert, (Property)jCheckBoxBeanProperty_2);
        autoBinding_6.bind();
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxFetchAllRatings, (Property)jCheckBoxBeanProperty_1, (Object)this.chckbxRatingTraktTv, (Property)jCheckBoxBeanProperty_2);
        autoBinding_10.bind();
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxFetchAllRatings, (Property)jCheckBoxBeanProperty_1, (Object)this.chckbxRatingLetterboxd, (Property)jCheckBoxBeanProperty_2);
        autoBinding_11.bind();
    }

    private static class CountryItem {
        private final Locale locale;

        public CountryItem(Locale locale) {
            this.locale = locale;
        }

        public String toString() {
            return this.locale.getCountry() + " - " + this.locale.getDisplayCountry();
        }
    }
}

