/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.ui.ScraperInTable;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.components.button.DocsButton;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextPane;
import org.tinymediamanager.ui.panels.MediaScraperConfigurationPanel;
import org.tinymediamanager.ui.panels.ScrollablePanel;

public class TvShowTrailerSettingsPanel
extends JPanel {
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private final List<ScraperInTable> scrapers = ObservableCollections.observableList(new ArrayList());
    private TmmTable tableTrailerScraper;
    private JTextPane tpScraperDescription;
    private JPanel panelScraperOptions;

    TvShowTrailerSettingsPanel() {
        List<String> enabledTrailerProviders = this.settings.getTrailerScrapers();
        int selectedIndex = -1;
        int counter = 0;
        for (MediaScraper scraper : TvShowModuleManager.getInstance().getTvShowList().getAvailableTrailerScrapers()) {
            ScraperInTable trailerScraper = new ScraperInTable(scraper);
            if (enabledTrailerProviders.contains(trailerScraper.getScraperId())) {
                trailerScraper.setActive(true);
                if (selectedIndex < 0) {
                    selectedIndex = counter;
                }
            }
            this.scrapers.add(trailerScraper);
            ++counter;
        }
        this.initComponents();
        this.initDataBindings();
        TableColumnResizer.setMaxWidthForColumn(this.tableTrailerScraper, 0, 2);
        TableColumnResizer.setMaxWidthForColumn(this.tableTrailerScraper, 1, 10);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableTrailerScraper, 5);
        this.tableTrailerScraper.getModel().addTableModelListener(arg0 -> {
            if (arg0.getColumn() == 0) {
                int row = arg0.getFirstRow();
                ScraperInTable changedScraper = this.scrapers.get(row);
                if (changedScraper.getActive().booleanValue()) {
                    this.settings.addTvShowTrailerScraper(changedScraper.getScraperId());
                } else {
                    this.settings.removeTvShowTrailerScraper(changedScraper.getScraperId());
                }
            }
        });
        this.tableTrailerScraper.getSelectionModel().addListSelectionListener(e -> {
            int index = this.tableTrailerScraper.convertRowIndexToModel(this.tableTrailerScraper.getSelectedRow());
            if (index > -1) {
                this.panelScraperOptions.removeAll();
                if (this.scrapers.get(index).getMediaProvider().getProviderInfo().getConfig().hasConfig()) {
                    this.panelScraperOptions.add(new MediaScraperConfigurationPanel(this.scrapers.get(index).getMediaProvider()));
                }
                this.panelScraperOptions.revalidate();
            }
        });
        Font font = UIManager.getFont("Label.font");
        Color color = UIManager.getColor("Label.foreground");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; color: rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "); }";
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        ((HTMLDocument)this.tpScraperDescription.getDocument()).getStyleSheet().addRule(bodyRule);
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        if (counter > 0) {
            this.tableTrailerScraper.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 0", "[60lp,grow]", "[]"));
        JPanel panelScraper = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][grow]", "[][shrink 0][]"));
        TmmLabel lblScraper = new TmmLabel(TmmResourceBundle.getString("scraper.trailer"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelScraper, lblScraper, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#trailer"));
        this.add((Component)collapsiblePanel, "cell 0 0,wmin 0,grow");
        this.tableTrailerScraper = new TmmTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                ScraperInTable scraper = TvShowTrailerSettingsPanel.this.scrapers.get(row);
                comp.setEnabled(scraper.isEnabled());
                return comp;
            }
        };
        this.tableTrailerScraper.setRowHeight(29);
        this.tableTrailerScraper.setShowGrid(true);
        panelScraper.add((Component)this.tableTrailerScraper, "cell 1 0,grow");
        JSeparator separator = new JSeparator();
        panelScraper.add((Component)separator, "cell 1 1,growx");
        ScrollablePanel panelScraperDetails = new ScrollablePanel();
        panelScraper.add((Component)panelScraperDetails, "cell 1 2,grow");
        panelScraperDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[grow]", "[][grow]"));
        this.tpScraperDescription = new ReadOnlyTextPane();
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        panelScraperDetails.add((Component)this.tpScraperDescription, "cell 0 0,grow");
        this.panelScraperOptions = new ScrollablePanel();
        this.panelScraperOptions.setLayout(new FlowLayout(0));
        panelScraperDetails.add((Component)this.panelScraperOptions, "cell 0 1,grow");
    }

    protected void initDataBindings() {
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.scrapers, (JTable)this.tableTrailerScraper);
        BeanProperty trailerScraperBeanProperty = BeanProperty.create((String)"active");
        jTableBinding.addColumnBinding((Property)trailerScraperBeanProperty).setColumnName("Aktiv").setColumnClass(Boolean.class);
        BeanProperty trailerScraperBeanProperty_1 = BeanProperty.create((String)"scraperLogo");
        jTableBinding.addColumnBinding((Property)trailerScraperBeanProperty_1).setColumnName("Logo").setEditable(false).setColumnClass(ImageIcon.class);
        BeanProperty trailerScraperBeanProperty_2 = BeanProperty.create((String)"scraperName");
        jTableBinding.addColumnBinding((Property)trailerScraperBeanProperty_2).setColumnName("Name").setEditable(false).setColumnClass(String.class);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.scraperDescription");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableTrailerScraper, (Property)jTableBeanProperty, (Object)this.tpScraperDescription, (Property)jTextPaneBeanProperty);
        autoBinding.bind();
    }
}

