/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.nat;

import com.ubnt.data.Site;
import com.ubnt.model.api.nat.BatchNatRuleUpdatePartDto;
import com.ubnt.model.api.nat.NatRuleDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.nat.A.oOoO;
import com.ubnt.service.nat.NatRuleDocument;
import com.ubnt.service.nat.null;
import com.ubnt.service.nat.o0OO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@V2RestController
@Validated
@Tag(name="NAT Rules")
public class NatRuleController {
    private final o0OO o00000;

    public NatRuleController(o0OO o0OO2) {
        this.o00000 = o0OO2;
    }

    @GetMapping(value={"/api/site/{siteName}/nat"})
    @Operation(summary="Get all NAT rules")
    public List<NatRuleDto> getNatRules(@PathVariable(value="siteName") Site site) {
        return this.o00000.\u00d4O0000(site.getId());
    }

    @GetMapping(value={"/api/site/{siteName}/nat/{id}"})
    @Operation(summary="Get a single NAT rule")
    public NatRuleDto getNatRule(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string) {
        Optional<NatRuleDocument> optional = this.o00000.\u00f800000(string);
        return optional.map(NatRuleDto::ofDocument).orElseThrow(oOoO::new);
    }

    @PostMapping(value={"/api/site/{siteName}/nat"})
    @Operation(summary="Create a NAT rule")
    @ResponseStatus(value=HttpStatus.CREATED)
    public NatRuleDto createNatRule(@PathVariable(value="siteName") Site site, @RequestBody @Valid NatRuleDto natRuleDto) {
        NatRuleDocument natRuleDocument = natRuleDto.toDocument(site.getId());
        return NatRuleDto.ofDocument(this.o00000.\u00d2O0000(natRuleDocument));
    }

    @PutMapping(value={"/api/site/{siteName}/nat/{id}"})
    @Operation(summary="Update a NAT rule")
    public NatRuleDto updateNatRule(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string, @RequestBody @Valid NatRuleDto natRuleDto) {
        NatRuleDocument natRuleDocument = natRuleDto.toDocument(string, site.getId());
        return NatRuleDto.ofDocument(this.o00000.\u00d600000(site.getId(), string, natRuleDocument));
    }

    @PutMapping(value={"/api/site/{siteName}/nat"})
    @Operation(summary="Batch update NAT rules")
    public List<NatRuleDto> batchUpdateNatRules(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotEmpty List<BatchNatRuleUpdatePartDto> list) {
        List<null> list2 = list.stream().map(BatchNatRuleUpdatePartDto::toBatchUpdatePart).toList();
        return this.o00000.OO0000(site.getId(), list2).stream().map(NatRuleDto::ofDocument).toList();
    }

    @DeleteMapping(value={"/api/site/{siteName}/nat/{id}"})
    @Operation(summary="Delete a NAT rule")
    public void deleteNatRule(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string) {
        this.o00000.\u00d200000(site.getId(), string);
    }
}

