/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.nbt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;

public class ContextNbtProvider
implements NbtProvider {
    private static final ExtraCodecs.LateBoundIdMapper<String, Source<?>> SOURCES = new ExtraCodecs.LateBoundIdMapper();
    private static final Codec<Source<?>> GETTER_CODEC;
    public static final MapCodec<ContextNbtProvider> MAP_CODEC;
    public static final Codec<ContextNbtProvider> INLINE_CODEC;
    private final Source<?> source;

    private ContextNbtProvider(Source<?> $$0) {
        this.source = $$0;
    }

    @Override
    public LootNbtProviderType getType() {
        return NbtProviders.CONTEXT;
    }

    @Override
    @Nullable
    public Tag get(LootContext $$0) {
        return this.source.get($$0);
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(this.source.contextParam());
    }

    public static NbtProvider forContextEntity(LootContext.EntityTarget $$0) {
        return new ContextNbtProvider(new EntitySource($$0.getParam()));
    }

    static {
        for (LootContext.EntityTarget entityTarget : LootContext.EntityTarget.values()) {
            SOURCES.put(entityTarget.getSerializedName(), new EntitySource(entityTarget.getParam()));
        }
        for (Enum enum_ : LootContext.BlockEntityTarget.values()) {
            SOURCES.put(((LootContext.BlockEntityTarget)enum_).getSerializedName(), new BlockEntitySource(((LootContext.BlockEntityTarget)enum_).getParam()));
        }
        GETTER_CODEC = SOURCES.codec((Codec<String>)Codec.STRING);
        MAP_CODEC = RecordCodecBuilder.mapCodec($$02 -> $$02.group((App)GETTER_CODEC.fieldOf("target").forGetter($$0 -> $$0.source)).apply((Applicative)$$02, ContextNbtProvider::new));
        INLINE_CODEC = GETTER_CODEC.xmap(ContextNbtProvider::new, $$0 -> $$0.source);
    }

    static interface Source<T> {
        public ContextKey<? extends T> contextParam();

        @Nullable
        public Tag get(T var1);

        @Nullable
        default public Tag get(LootContext $$0) {
            T $$1 = $$0.getOptionalParameter(this.contextParam());
            return $$1 != null ? this.get($$1) : null;
        }
    }

    record EntitySource(ContextKey<? extends Entity> contextParam) implements Source<Entity>
    {
        @Override
        public Tag get(Entity $$0) {
            return NbtPredicate.getEntityTagToCompare($$0);
        }
    }

    record BlockEntitySource(ContextKey<? extends BlockEntity> contextParam) implements Source<BlockEntity>
    {
        @Override
        public Tag get(BlockEntity $$0) {
            return $$0.saveWithFullMetadata($$0.getLevel().registryAccess());
        }
    }
}

