/*
 * Decompiled with CFR 0.152.
 */
package com.electronwill.nightconfig.core.file;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.core.utils.CommentedConfigWrapper;
import java.io.File;
import java.nio.file.Path;
import java.util.function.Function;

final class AutoreloadFileConfig<C extends CommentedFileConfig>
extends CommentedConfigWrapper<C>
implements CommentedFileConfig {
    private final FileWatcher watcher;
    private final Runnable autoListener;

    AutoreloadFileConfig(C config, FileWatcher watcher, Runnable autoreloadListener) {
        super(config);
        this.watcher = watcher;
        this.autoListener = autoreloadListener;
        watcher.addWatch(config.getNioPath(), this::autoReload);
    }

    private void autoReload() {
        this.load();
        this.autoListener.run();
    }

    @Override
    public File getFile() {
        return ((CommentedFileConfig)this.config).getFile();
    }

    @Override
    public Path getNioPath() {
        return ((CommentedFileConfig)this.config).getNioPath();
    }

    @Override
    public void save() {
        ((CommentedFileConfig)this.config).save();
    }

    @Override
    public void load() {
        ((CommentedFileConfig)this.config).load();
    }

    @Override
    public void close() {
        try {
            this.watcher.removeWatch(((CommentedFileConfig)this.config).getNioPath());
        }
        finally {
            ((CommentedFileConfig)this.config).close();
        }
    }

    @Override
    public <R> R bulkCommentedUpdate(Function<? super CommentedConfig, R> action) {
        return ((CommentedFileConfig)this.config).bulkCommentedUpdate(action);
    }

    @Override
    public <R> R bulkUpdate(Function<? super Config, R> action) {
        return ((CommentedFileConfig)this.config).bulkUpdate(action);
    }
}

