/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ToolAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IForgeItemStack {
    private ItemStack self() {
        return (ItemStack)this;
    }

    default public ItemStack getCraftingRemainder() {
        return this.self().getItem().getCraftingRemainder(this.self());
    }

    default public int getBurnTime(@Nullable RecipeType<?> recipeType) {
        return this.self().getItem().getBurnTime(this.self(), recipeType);
    }

    default public InteractionResult onItemUseFirst(UseOnContext context) {
        boolean adventure;
        Player entityplayer = context.getPlayer();
        BlockPos blockpos = context.getClickedPos();
        BlockInWorld blockworldstate = new BlockInWorld((LevelReader)context.getLevel(), blockpos, false);
        boolean bl = adventure = this.self().canBreakBlockInAdventureMode(blockworldstate) || this.self().canPlaceOnBlockInAdventureMode(blockworldstate);
        if (entityplayer != null && !entityplayer.getAbilities().mayBuild && !adventure) {
            return InteractionResult.PASS;
        }
        Item item = this.self().getItem();
        InteractionResult enumactionresult = item.onItemUseFirst(this.self(), context);
        if (entityplayer != null && enumactionresult == InteractionResult.SUCCESS) {
            entityplayer.awardStat(Stats.ITEM_USED.get((Object)item));
        }
        return enumactionresult;
    }

    default public boolean canPerformAction(ToolAction toolAction) {
        return this.self().getItem().canPerformAction(this.self(), toolAction);
    }

    default public boolean onBlockStartBreak(BlockPos pos, Player player) {
        return !this.self().isEmpty() && this.self().getItem().onBlockStartBreak(this.self(), pos, player);
    }

    default public boolean shouldCauseBlockBreakReset(ItemStack newStack) {
        return this.self().getItem().shouldCauseBlockBreakReset(this.self(), newStack);
    }

    @Deprecated(forRemoval=true, since="1.21.3")
    default public boolean canApplyAtEnchantingTable(Enchantment enchantment) {
        return this.self().getItem().canApplyAtEnchantingTable(this.self(), enchantment);
    }

    default public boolean canApplyAtEnchantingTable(Holder<Enchantment> enchantment) {
        return this.self().getItem().canApplyAtEnchantingTable(this.self(), enchantment);
    }

    @Nullable
    default public EquipmentSlot getEquipmentSlot() {
        return this.self().getItem().getEquipmentSlot(this.self());
    }

    default public boolean canDisableShield(ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return this.self().getItem().canDisableShield(this.self(), shield, entity, attacker);
    }

    default public boolean onEntitySwing(LivingEntity entity) {
        return this.self().getItem().onEntitySwing(this.self(), entity);
    }

    default public void onStopUsing(LivingEntity entity, int count) {
        this.self().getItem().onStopUsing(this.self(), entity, count);
    }

    default public int getEntityLifespan(Level level) {
        return this.self().getItem().getEntityLifespan(this.self(), level);
    }

    default public boolean onEntityItemUpdate(ItemEntity entity) {
        return this.self().getItem().onEntityItemUpdate(this.self(), entity);
    }

    default public void inventoryTick(Level level, Entity entity, @Nullable EquipmentSlot slot, int slotIndex) {
        this.self().getItem().inventoryTick(this.self(), level, entity, slot, slotIndex);
    }

    default public void onHorseArmorTick(Level level, Mob horse) {
        this.self().getItem().onHorseArmorTick(this.self(), level, horse);
    }

    default public boolean canEquip(EquipmentSlot armorType, Entity entity) {
        return this.self().getItem().canEquip(this.self(), armorType, entity);
    }

    default public boolean isBookEnchantable(ItemStack book) {
        return this.self().getItem().isBookEnchantable(this.self(), book);
    }

    default public boolean onDroppedByPlayer(Player player) {
        return this.self().getItem().onDroppedByPlayer(this.self(), player);
    }

    default public Component getHighlightTip(Component displayName) {
        return this.self().getItem().getHighlightTip(this.self(), displayName);
    }

    default public boolean doesSneakBypassUse(LevelReader level, BlockPos pos, Player player) {
        return this.self().isEmpty() || this.self().getItem().doesSneakBypassUse(this.self(), level, pos, player);
    }

    default public boolean isPiglinCurrency() {
        return this.self().getItem().isPiglinCurrency(this.self());
    }

    default public boolean makesPiglinsNeutral(LivingEntity wearer) {
        return this.self().getItem().makesPiglinsNeutral(this.self(), wearer);
    }

    default public boolean isMonsterDisguise(Player player, Monster monster) {
        return this.self().getItem().isMonsterDisguise(this.self(), player, monster);
    }

    default public boolean canElytraFly(LivingEntity entity) {
        return this.self().getItem().canElytraFly(this.self(), entity);
    }

    default public boolean elytraFlightTick(LivingEntity entity, int flightTicks) {
        return this.self().getItem().elytraFlightTick(this.self(), entity, flightTicks);
    }

    default public boolean canWalkOnPowderedSnow(LivingEntity wearer) {
        return this.self().getItem().canWalkOnPowderedSnow(this.self(), wearer);
    }

    @NotNull
    default public AABB getSweepHitBox(@NotNull Player player, @NotNull Entity target) {
        return this.self().getItem().getSweepHitBox(this.self(), player, target);
    }

    default public int damageItem(int damage, ServerLevel level, @Nullable ServerPlayer player, boolean canBreak, Consumer<Item> onBroken) {
        return this.self().getItem().damageItem(this.self(), damage, level, player, canBreak, onBroken);
    }

    default public void onDestroyed(ItemEntity itemEntity, DamageSource damageSource) {
        this.self().getItem().onDestroyed(itemEntity, damageSource);
    }

    default public boolean isNotReplaceableByPickAction(Player player, int inventorySlot) {
        return this.self().getItem().isNotReplaceableByPickAction(this.self(), player, inventorySlot);
    }

    default public boolean canGrindstoneRepair() {
        return this.self().getItem().canGrindstoneRepair(this.self());
    }
}

