// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV2

import (
	"fmt"

	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// ObservabilityPipelineSocketSourceFramingChunkedGelfMethod Byte frames which are chunked GELF messages.
type ObservabilityPipelineSocketSourceFramingChunkedGelfMethod string

// List of ObservabilityPipelineSocketSourceFramingChunkedGelfMethod.
const (
	OBSERVABILITYPIPELINESOCKETSOURCEFRAMINGCHUNKEDGELFMETHOD_CHUNKED_GELF ObservabilityPipelineSocketSourceFramingChunkedGelfMethod = "chunked_gelf"
)

var allowedObservabilityPipelineSocketSourceFramingChunkedGelfMethodEnumValues = []ObservabilityPipelineSocketSourceFramingChunkedGelfMethod{
	OBSERVABILITYPIPELINESOCKETSOURCEFRAMINGCHUNKEDGELFMETHOD_CHUNKED_GELF,
}

// GetAllowedValues reeturns the list of possible values.
func (v *ObservabilityPipelineSocketSourceFramingChunkedGelfMethod) GetAllowedValues() []ObservabilityPipelineSocketSourceFramingChunkedGelfMethod {
	return allowedObservabilityPipelineSocketSourceFramingChunkedGelfMethodEnumValues
}

// UnmarshalJSON deserializes the given payload.
func (v *ObservabilityPipelineSocketSourceFramingChunkedGelfMethod) UnmarshalJSON(src []byte) error {
	var value string
	err := datadog.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	*v = ObservabilityPipelineSocketSourceFramingChunkedGelfMethod(value)
	return nil
}

// NewObservabilityPipelineSocketSourceFramingChunkedGelfMethodFromValue returns a pointer to a valid ObservabilityPipelineSocketSourceFramingChunkedGelfMethod
// for the value passed as argument, or an error if the value passed is not allowed by the enum.
func NewObservabilityPipelineSocketSourceFramingChunkedGelfMethodFromValue(v string) (*ObservabilityPipelineSocketSourceFramingChunkedGelfMethod, error) {
	ev := ObservabilityPipelineSocketSourceFramingChunkedGelfMethod(v)
	if ev.IsValid() {
		return &ev, nil
	}
	return nil, fmt.Errorf("invalid value '%v' for ObservabilityPipelineSocketSourceFramingChunkedGelfMethod: valid values are %v", v, allowedObservabilityPipelineSocketSourceFramingChunkedGelfMethodEnumValues)
}

// IsValid return true if the value is valid for the enum, false otherwise.
func (v ObservabilityPipelineSocketSourceFramingChunkedGelfMethod) IsValid() bool {
	for _, existing := range allowedObservabilityPipelineSocketSourceFramingChunkedGelfMethodEnumValues {
		if existing == v {
			return true
		}
	}
	return false
}

// Ptr returns reference to ObservabilityPipelineSocketSourceFramingChunkedGelfMethod value.
func (v ObservabilityPipelineSocketSourceFramingChunkedGelfMethod) Ptr() *ObservabilityPipelineSocketSourceFramingChunkedGelfMethod {
	return &v
}
