// Code generated by bpf2go; DO NOT EDIT.
//go:build 386 || amd64

package gotracer

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"
	"structs"

	"github.com/cilium/ebpf"
)

type BpfConnectionInfoT struct {
	_      structs.HostLayout
	S_addr [16]uint8
	D_addr [16]uint8
	S_port uint16
	D_port uint16
}

type BpfEgressKeyT struct {
	_      structs.HostLayout
	S_port uint16
	D_port uint16
}

type BpfGoAddrKeyT struct {
	_    structs.HostLayout
	Pid  uint64
	Addr uint64
}

type BpfGoroutineMetadata struct {
	_         structs.HostLayout
	Parent    BpfGoAddrKeyT
	Timestamp uint64
}

type BpfGrpcClientFuncInvocationT struct {
	_               structs.HostLayout
	StartMonotimeNs uint64
	Cc              uint64
	Method          uint64
	MethodLen       uint64
	Tp              BpfTpInfoT
	Flags           uint64
}

type BpfGrpcSrvFuncInvocationT struct {
	_               structs.HostLayout
	StartMonotimeNs uint64
	Stream          uint64
	St              uint64
	Tp              BpfTpInfoT
}

type BpfGrpcTransportsT struct {
	_    structs.HostLayout
	Conn BpfConnectionInfoT
	Type uint8
	Pad  [3]uint8
	Tp   BpfTpInfoT
}

type BpfHttpClientDataT struct {
	_             structs.HostLayout
	ContentLength int64
	Pid           struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Path   [100]uint8
	Host   [100]uint8
	Scheme [10]uint8
	Method [7]uint8
	Pad    [3]uint8
}

type BpfHttpFuncInvocationT struct {
	_               structs.HostLayout
	StartMonotimeNs uint64
	Tp              BpfTpInfoT
}

type BpfKafkaClientReqT struct {
	_               structs.HostLayout
	Type            uint8
	Pad             [7]uint8
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	Buf             [256]uint8
	Conn            BpfConnectionInfoT
	Pid             struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
}

type BpfKafkaGoReqT struct {
	_    structs.HostLayout
	Type uint8
	Op   uint8
	Pad0 [2]uint8
	Pid  struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Conn            BpfConnectionInfoT
	Pad1            [4]uint8
	Tp              BpfTpInfoT
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	Topic           [64]uint8
}

type BpfMongoGoClientReqT struct {
	_               structs.HostLayout
	Type            uint8
	Err             uint8
	Pad             [6]uint8
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	Pid             struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Op   [32]uint8
	Db   [32]uint8
	Coll [32]uint8
	Conn BpfConnectionInfoT
	Tp   BpfTpInfoT
}

type BpfNewFuncInvocationT struct {
	_      structs.HostLayout
	Parent uint64
}

type BpfOffTableT struct {
	_     structs.HostLayout
	Table [64]uint64
}

type BpfOtelSpanT struct {
	_         structs.HostLayout
	Type      uint8
	Pad       [7]uint8
	StartTime uint64
	EndTime   uint64
	ParentGo  uint64
	Tp        BpfTpInfoT
	PrevTp    BpfTpInfoT
	Status    uint32
	SpanName  struct {
		_   structs.HostLayout
		Buf [64]uint8
	}
	SpanDescription struct {
		_   structs.HostLayout
		Buf [64]uint8
	}
	Pid struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	SpanAttrs struct {
		_     structs.HostLayout
		Attrs [16]struct {
			_         structs.HostLayout
			ValLength uint16
			Vtype     uint8
			Reserved  uint8
			Key       [32]uint8
			Value     [128]uint8
		}
		ValidAttrs uint8
		Apad       uint8
	}
	Epad [6]uint8
}

type BpfProduceReqT struct {
	_               structs.HostLayout
	MsgPtr          uint64
	ConnPtr         uint64
	StartMonotimeNs uint64
}

type BpfRedisClientReqT struct {
	_               structs.HostLayout
	Type            uint8
	Err             uint8
	Pad             [6]uint8
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	Pid             struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Buf  [256]uint8
	Conn BpfConnectionInfoT
	Tp   BpfTpInfoT
}

type BpfServerHttpFuncInvocationT struct {
	_               structs.HostLayout
	StartMonotimeNs uint64
	ContentLength   uint64
	ResponseLength  uint64
	Status          uint64
	RpcRequestAddr  uint64
	Tp              BpfTpInfoT
	Method          [7]uint8
	Path            [100]uint8
	Pad             [5]uint8
}

type BpfSpanInfoT struct {
	_    structs.HostLayout
	Name struct {
		_   structs.HostLayout
		Buf [64]uint8
	}
	OptsPtr uint64
	OptsLen uint64
}

type BpfSqlFuncInvocationT struct {
	_               structs.HostLayout
	StartMonotimeNs uint64
	SqlParam        uint64
	QueryLen        uint64
	Tp              BpfTpInfoT
	Conn            BpfConnectionInfoT
	Pad             [4]uint8
}

type BpfStreamKeyT struct {
	_        structs.HostLayout
	ConnPtr  uint64
	StreamId uint32
	Pad      uint32
}

type BpfTopicT struct {
	_    structs.HostLayout
	Name [64]int8
	Tp   BpfTpInfoT
}

type BpfTpInfoPidT struct {
	_       structs.HostLayout
	Tp      BpfTpInfoT
	Pid     uint32
	Valid   uint8
	Written uint8
	ReqType uint8
	Pad     [1]uint8
}

type BpfTpInfoT struct {
	_        structs.HostLayout
	TraceId  [16]uint8
	SpanId   [8]uint8
	ParentId [8]uint8
	Ts       uint64
	Flags    uint8
	Pad      [7]uint8
}

type BpfTraceMapKeyT struct {
	_    structs.HostLayout
	Conn BpfConnectionInfoT
	Type uint32
}

type BpfTransportNewClientInvocationT struct {
	_     structs.HostLayout
	Inv   BpfGrpcClientFuncInvocationT
	S_key BpfStreamKeyT
}

// LoadBpf returns the embedded CollectionSpec for Bpf.
func LoadBpf() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_BpfBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load Bpf: %w", err)
	}

	return spec, err
}

// LoadBpfObjects loads Bpf and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*BpfObjects
//	*BpfPrograms
//	*BpfMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func LoadBpfObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := LoadBpf()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// BpfSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfSpecs struct {
	BpfProgramSpecs
	BpfMapSpecs
	BpfVariableSpecs
}

// BpfProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfProgramSpecs struct {
	ObiUprobeClientConnClose                      *ebpf.ProgramSpec `ebpf:"obi_uprobe_ClientConn_Close"`
	ObiUprobeClientConnInvoke                     *ebpf.ProgramSpec `ebpf:"obi_uprobe_ClientConn_Invoke"`
	ObiUprobeClientConnInvokeReturn               *ebpf.ProgramSpec `ebpf:"obi_uprobe_ClientConn_Invoke_return"`
	ObiUprobeClientConnNewStream                  *ebpf.ProgramSpec `ebpf:"obi_uprobe_ClientConn_NewStream"`
	ObiUprobeClientConnNewStreamReturn            *ebpf.ProgramSpec `ebpf:"obi_uprobe_ClientConn_NewStream_return"`
	ObiUprobeRecordError                          *ebpf.ProgramSpec `ebpf:"obi_uprobe_RecordError"`
	ObiUprobeServeHTTP                            *ebpf.ProgramSpec `ebpf:"obi_uprobe_ServeHTTP"`
	ObiUprobeServeHTTPReturns                     *ebpf.ProgramSpec `ebpf:"obi_uprobe_ServeHTTPReturns"`
	ObiUprobeSetAttributes                        *ebpf.ProgramSpec `ebpf:"obi_uprobe_SetAttributes"`
	ObiUprobeSetName                              *ebpf.ProgramSpec `ebpf:"obi_uprobe_SetName"`
	ObiUprobeSetStatus                            *ebpf.ProgramSpec `ebpf:"obi_uprobe_SetStatus"`
	ObiUprobeClientStreamRecvMsgReturn            *ebpf.ProgramSpec `ebpf:"obi_uprobe_clientStream_RecvMsg_return"`
	ObiUprobeClientRoundTrip                      *ebpf.ProgramSpec `ebpf:"obi_uprobe_client_roundTrip"`
	ObiUprobeConnServe                            *ebpf.ProgramSpec `ebpf:"obi_uprobe_connServe"`
	ObiUprobeConnServeRet                         *ebpf.ProgramSpec `ebpf:"obi_uprobe_connServeRet"`
	ObiUprobeExecDC                               *ebpf.ProgramSpec `ebpf:"obi_uprobe_execDC"`
	ObiUprobeGrpcFramerWriteHeaders               *ebpf.ProgramSpec `ebpf:"obi_uprobe_grpcFramerWriteHeaders"`
	ObiUprobeGrpcFramerWriteHeadersReturns        *ebpf.ProgramSpec `ebpf:"obi_uprobe_grpcFramerWriteHeaders_returns"`
	ObiUprobeHttp2FramerWriteHeaders              *ebpf.ProgramSpec `ebpf:"obi_uprobe_http2FramerWriteHeaders"`
	ObiUprobeHttp2FramerWriteHeadersReturns       *ebpf.ProgramSpec `ebpf:"obi_uprobe_http2FramerWriteHeaders_returns"`
	ObiUprobeHttp2ResponseWriterStateWriteHeader  *ebpf.ProgramSpec `ebpf:"obi_uprobe_http2ResponseWriterStateWriteHeader"`
	ObiUprobeHttp2RoundTrip                       *ebpf.ProgramSpec `ebpf:"obi_uprobe_http2RoundTrip"`
	ObiUprobeHttp2ServerOperateHeaders            *ebpf.ProgramSpec `ebpf:"obi_uprobe_http2Server_operateHeaders"`
	ObiUprobeHttp2ServerProcessHeaders            *ebpf.ProgramSpec `ebpf:"obi_uprobe_http2Server_processHeaders"`
	ObiUprobeHttp2WriteHeaders                    *ebpf.ProgramSpec `ebpf:"obi_uprobe_http2WriteHeaders"`
	ObiUprobeHttp2WriteHeadersVendored            *ebpf.ProgramSpec `ebpf:"obi_uprobe_http2WriteHeaders_vendored"`
	ObiUprobeHttp2serverConnRunHandler            *ebpf.ProgramSpec `ebpf:"obi_uprobe_http2serverConn_runHandler"`
	ObiUprobeJsonrpcReadRequestHeader             *ebpf.ProgramSpec `ebpf:"obi_uprobe_jsonrpcReadRequestHeader"`
	ObiUprobeJsonrpcReadRequestHeaderReturns      *ebpf.ProgramSpec `ebpf:"obi_uprobe_jsonrpcReadRequestHeaderReturns"`
	ObiUprobeMongoOpAggregate                     *ebpf.ProgramSpec `ebpf:"obi_uprobe_mongo_op_aggregate"`
	ObiUprobeMongoOpCountDocuments                *ebpf.ProgramSpec `ebpf:"obi_uprobe_mongo_op_countDocuments"`
	ObiUprobeMongoOpDelete                        *ebpf.ProgramSpec `ebpf:"obi_uprobe_mongo_op_delete"`
	ObiUprobeMongoOpDistinct                      *ebpf.ProgramSpec `ebpf:"obi_uprobe_mongo_op_distinct"`
	ObiUprobeMongoOpDrop                          *ebpf.ProgramSpec `ebpf:"obi_uprobe_mongo_op_drop"`
	ObiUprobeMongoOpEstimatedDocumentCount        *ebpf.ProgramSpec `ebpf:"obi_uprobe_mongo_op_estimatedDocumentCount"`
	ObiUprobeMongoOpExecute                       *ebpf.ProgramSpec `ebpf:"obi_uprobe_mongo_op_execute"`
	ObiUprobeMongoOpExecuteRet                    *ebpf.ProgramSpec `ebpf:"obi_uprobe_mongo_op_execute_ret"`
	ObiUprobeMongoOpFind                          *ebpf.ProgramSpec `ebpf:"obi_uprobe_mongo_op_find"`
	ObiUprobeMongoOpFindAndModify                 *ebpf.ProgramSpec `ebpf:"obi_uprobe_mongo_op_findAndModify"`
	ObiUprobeMongoOpInsert                        *ebpf.ProgramSpec `ebpf:"obi_uprobe_mongo_op_insert"`
	ObiUprobeMongoOpUpdateOrReplace               *ebpf.ProgramSpec `ebpf:"obi_uprobe_mongo_op_updateOrReplace"`
	ObiUprobeNetFdRead                            *ebpf.ProgramSpec `ebpf:"obi_uprobe_netFdRead"`
	ObiUprobeNonRecordingSpanEnd                  *ebpf.ProgramSpec `ebpf:"obi_uprobe_nonRecordingSpan_End"`
	ObiUprobePersistConnRoundTrip                 *ebpf.ProgramSpec `ebpf:"obi_uprobe_persistConnRoundTrip"`
	ObiUprobeProcGoexit1                          *ebpf.ProgramSpec `ebpf:"obi_uprobe_proc_goexit1"`
	ObiUprobeProcNewproc1                         *ebpf.ProgramSpec `ebpf:"obi_uprobe_proc_newproc1"`
	ObiUprobeProcNewproc1Ret                      *ebpf.ProgramSpec `ebpf:"obi_uprobe_proc_newproc1_ret"`
	ObiUprobeProtocolRoundtrip                    *ebpf.ProgramSpec `ebpf:"obi_uprobe_protocol_roundtrip"`
	ObiUprobeProtocolRoundtripRet                 *ebpf.ProgramSpec `ebpf:"obi_uprobe_protocol_roundtrip_ret"`
	ObiUprobeQueryDC                              *ebpf.ProgramSpec `ebpf:"obi_uprobe_queryDC"`
	ObiUprobeQueryReturn                          *ebpf.ProgramSpec `ebpf:"obi_uprobe_queryReturn"`
	ObiUprobeReadContinuedLineSliceReturns        *ebpf.ProgramSpec `ebpf:"obi_uprobe_readContinuedLineSliceReturns"`
	ObiUprobeReadRequestReturns                   *ebpf.ProgramSpec `ebpf:"obi_uprobe_readRequestReturns"`
	ObiUprobeReadRequestStart                     *ebpf.ProgramSpec `ebpf:"obi_uprobe_readRequestStart"`
	ObiUprobeReaderRead                           *ebpf.ProgramSpec `ebpf:"obi_uprobe_reader_read"`
	ObiUprobeReaderReadRet                        *ebpf.ProgramSpec `ebpf:"obi_uprobe_reader_read_ret"`
	ObiUprobeReaderSendMessage                    *ebpf.ProgramSpec `ebpf:"obi_uprobe_reader_send_message"`
	ObiUprobeRedisProcess                         *ebpf.ProgramSpec `ebpf:"obi_uprobe_redis_process"`
	ObiUprobeRedisProcessRet                      *ebpf.ProgramSpec `ebpf:"obi_uprobe_redis_process_ret"`
	ObiUprobeRedisWithWriter                      *ebpf.ProgramSpec `ebpf:"obi_uprobe_redis_with_writer"`
	ObiUprobeRedisWithWriterRet                   *ebpf.ProgramSpec `ebpf:"obi_uprobe_redis_with_writer_ret"`
	ObiUprobeRoundTrip                            *ebpf.ProgramSpec `ebpf:"obi_uprobe_roundTrip"`
	ObiUprobeRoundTripReturn                      *ebpf.ProgramSpec `ebpf:"obi_uprobe_roundTripReturn"`
	ObiUprobeSaramaBrokerWrite                    *ebpf.ProgramSpec `ebpf:"obi_uprobe_sarama_broker_write"`
	ObiUprobeSaramaResponsePromiseHandle          *ebpf.ProgramSpec `ebpf:"obi_uprobe_sarama_response_promise_handle"`
	ObiUprobeSaramaSendInternal                   *ebpf.ProgramSpec `ebpf:"obi_uprobe_sarama_sendInternal"`
	ObiUprobeServerHandleStream                   *ebpf.ProgramSpec `ebpf:"obi_uprobe_server_handleStream"`
	ObiUprobeServerHandleStreamReturn             *ebpf.ProgramSpec `ebpf:"obi_uprobe_server_handleStream_return"`
	ObiUprobeServerHandlerTransportHandleStreams  *ebpf.ProgramSpec `ebpf:"obi_uprobe_server_handler_transport_handle_streams"`
	ObiUprobeTracerStart                          *ebpf.ProgramSpec `ebpf:"obi_uprobe_tracer_Start"`
	ObiUprobeTracerStartReturns                   *ebpf.ProgramSpec `ebpf:"obi_uprobe_tracer_Start_Returns"`
	ObiUprobeTracerStartGlobal                    *ebpf.ProgramSpec `ebpf:"obi_uprobe_tracer_Start_global"`
	ObiUprobeTransportHttp2ClientNewStream        *ebpf.ProgramSpec `ebpf:"obi_uprobe_transport_http2Client_NewStream"`
	ObiUprobeTransportHttp2ClientNewStreamReturns *ebpf.ProgramSpec `ebpf:"obi_uprobe_transport_http2Client_NewStream_Returns"`
	ObiUprobeTransportWriteStatus                 *ebpf.ProgramSpec `ebpf:"obi_uprobe_transport_writeStatus"`
	ObiUprobeWriteSubset                          *ebpf.ProgramSpec `ebpf:"obi_uprobe_writeSubset"`
	ObiUprobeWriterProduce                        *ebpf.ProgramSpec `ebpf:"obi_uprobe_writer_produce"`
	ObiUprobeWriterWriteMessages                  *ebpf.ProgramSpec `ebpf:"obi_uprobe_writer_write_messages"`
}

// BpfMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfMapSpecs struct {
	ActiveSpans                   *ebpf.MapSpec `ebpf:"active_spans"`
	Events                        *ebpf.MapSpec `ebpf:"events"`
	FetchRequests                 *ebpf.MapSpec `ebpf:"fetch_requests"`
	GoOffsetsMap                  *ebpf.MapSpec `ebpf:"go_offsets_map"`
	GoOngoingHttp                 *ebpf.MapSpec `ebpf:"go_ongoing_http"`
	GoOngoingHttpClientRequests   *ebpf.MapSpec `ebpf:"go_ongoing_http_client_requests"`
	GoTraceMap                    *ebpf.MapSpec `ebpf:"go_trace_map"`
	Http2ServerRequestsTp         *ebpf.MapSpec `ebpf:"http2_server_requests_tp"`
	IncomingTraceMap              *ebpf.MapSpec `ebpf:"incoming_trace_map"`
	KafkaRequests                 *ebpf.MapSpec `ebpf:"kafka_requests"`
	Newproc1                      *ebpf.MapSpec `ebpf:"newproc1"`
	OngoingClientConnections      *ebpf.MapSpec `ebpf:"ongoing_client_connections"`
	OngoingGoroutines             *ebpf.MapSpec `ebpf:"ongoing_goroutines"`
	OngoingGrpcClientRequests     *ebpf.MapSpec `ebpf:"ongoing_grpc_client_requests"`
	OngoingGrpcHeaderWrites       *ebpf.MapSpec `ebpf:"ongoing_grpc_header_writes"`
	OngoingGrpcOperateHeaders     *ebpf.MapSpec `ebpf:"ongoing_grpc_operate_headers"`
	OngoingGrpcRequestStatus      *ebpf.MapSpec `ebpf:"ongoing_grpc_request_status"`
	OngoingGrpcServerRequests     *ebpf.MapSpec `ebpf:"ongoing_grpc_server_requests"`
	OngoingGrpcTransports         *ebpf.MapSpec `ebpf:"ongoing_grpc_transports"`
	OngoingHttpClientRequestsData *ebpf.MapSpec `ebpf:"ongoing_http_client_requests_data"`
	OngoingHttpServerRequests     *ebpf.MapSpec `ebpf:"ongoing_http_server_requests"`
	OngoingKafkaRequests          *ebpf.MapSpec `ebpf:"ongoing_kafka_requests"`
	OngoingMongoRequests          *ebpf.MapSpec `ebpf:"ongoing_mongo_requests"`
	OngoingProduceMessages        *ebpf.MapSpec `ebpf:"ongoing_produce_messages"`
	OngoingProduceTopics          *ebpf.MapSpec `ebpf:"ongoing_produce_topics"`
	OngoingRedisRequests          *ebpf.MapSpec `ebpf:"ongoing_redis_requests"`
	OngoingServerConnections      *ebpf.MapSpec `ebpf:"ongoing_server_connections"`
	OngoingSqlQueries             *ebpf.MapSpec `ebpf:"ongoing_sql_queries"`
	OngoingStreams                *ebpf.MapSpec `ebpf:"ongoing_streams"`
	OutgoingTraceMap              *ebpf.MapSpec `ebpf:"outgoing_trace_map"`
	ProduceRequests               *ebpf.MapSpec `ebpf:"produce_requests"`
	ProduceTraceparents           *ebpf.MapSpec `ebpf:"produce_traceparents"`
	RedisWrites                   *ebpf.MapSpec `ebpf:"redis_writes"`
	SpanMem                       *ebpf.MapSpec `ebpf:"span_mem"`
	SpanNames                     *ebpf.MapSpec `ebpf:"span_names"`
	TempHeaderMemStore            *ebpf.MapSpec `ebpf:"temp_header_mem_store"`
	TraceMap                      *ebpf.MapSpec `ebpf:"trace_map"`
	TransportNewClientInvocations *ebpf.MapSpec `ebpf:"transport_new_client_invocations"`
}

// BpfVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfVariableSpecs struct {
	ERROR_KEY            *ebpf.VariableSpec `ebpf:"ERROR_KEY"`
	ERROR_KEY_SIZE       *ebpf.VariableSpec `ebpf:"ERROR_KEY_SIZE"`
	AttrTypeBool         *ebpf.VariableSpec `ebpf:"attr_type_bool"`
	AttrTypeBoolslice    *ebpf.VariableSpec `ebpf:"attr_type_boolslice"`
	AttrTypeFloat64      *ebpf.VariableSpec `ebpf:"attr_type_float64"`
	AttrTypeFloat64slice *ebpf.VariableSpec `ebpf:"attr_type_float64slice"`
	AttrTypeInt64        *ebpf.VariableSpec `ebpf:"attr_type_int64"`
	AttrTypeInt64slice   *ebpf.VariableSpec `ebpf:"attr_type_int64slice"`
	AttrTypeInvalid      *ebpf.VariableSpec `ebpf:"attr_type_invalid"`
	AttrTypeString       *ebpf.VariableSpec `ebpf:"attr_type_string"`
	AttrTypeStringslice  *ebpf.VariableSpec `ebpf:"attr_type_stringslice"`
	DisableBlackBoxCp    *ebpf.VariableSpec `ebpf:"disable_black_box_cp"`
	HuffmanCodeLen       *ebpf.VariableSpec `ebpf:"huffman_code_len"`
	HuffmanCodes         *ebpf.VariableSpec `ebpf:"huffman_codes"`
	Ip4ip6Prefix         *ebpf.VariableSpec `ebpf:"ip4ip6_prefix"`
	Unused               *ebpf.VariableSpec `ebpf:"unused"`
	UnusedHttp2          *ebpf.VariableSpec `ebpf:"unused_http2"`
	WakeupDataBytes      *ebpf.VariableSpec `ebpf:"wakeup_data_bytes"`
}

// BpfObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to LoadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfObjects struct {
	BpfPrograms
	BpfMaps
	BpfVariables
}

func (o *BpfObjects) Close() error {
	return _BpfClose(
		&o.BpfPrograms,
		&o.BpfMaps,
	)
}

// BpfMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to LoadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfMaps struct {
	ActiveSpans                   *ebpf.Map `ebpf:"active_spans"`
	Events                        *ebpf.Map `ebpf:"events"`
	FetchRequests                 *ebpf.Map `ebpf:"fetch_requests"`
	GoOffsetsMap                  *ebpf.Map `ebpf:"go_offsets_map"`
	GoOngoingHttp                 *ebpf.Map `ebpf:"go_ongoing_http"`
	GoOngoingHttpClientRequests   *ebpf.Map `ebpf:"go_ongoing_http_client_requests"`
	GoTraceMap                    *ebpf.Map `ebpf:"go_trace_map"`
	Http2ServerRequestsTp         *ebpf.Map `ebpf:"http2_server_requests_tp"`
	IncomingTraceMap              *ebpf.Map `ebpf:"incoming_trace_map"`
	KafkaRequests                 *ebpf.Map `ebpf:"kafka_requests"`
	Newproc1                      *ebpf.Map `ebpf:"newproc1"`
	OngoingClientConnections      *ebpf.Map `ebpf:"ongoing_client_connections"`
	OngoingGoroutines             *ebpf.Map `ebpf:"ongoing_goroutines"`
	OngoingGrpcClientRequests     *ebpf.Map `ebpf:"ongoing_grpc_client_requests"`
	OngoingGrpcHeaderWrites       *ebpf.Map `ebpf:"ongoing_grpc_header_writes"`
	OngoingGrpcOperateHeaders     *ebpf.Map `ebpf:"ongoing_grpc_operate_headers"`
	OngoingGrpcRequestStatus      *ebpf.Map `ebpf:"ongoing_grpc_request_status"`
	OngoingGrpcServerRequests     *ebpf.Map `ebpf:"ongoing_grpc_server_requests"`
	OngoingGrpcTransports         *ebpf.Map `ebpf:"ongoing_grpc_transports"`
	OngoingHttpClientRequestsData *ebpf.Map `ebpf:"ongoing_http_client_requests_data"`
	OngoingHttpServerRequests     *ebpf.Map `ebpf:"ongoing_http_server_requests"`
	OngoingKafkaRequests          *ebpf.Map `ebpf:"ongoing_kafka_requests"`
	OngoingMongoRequests          *ebpf.Map `ebpf:"ongoing_mongo_requests"`
	OngoingProduceMessages        *ebpf.Map `ebpf:"ongoing_produce_messages"`
	OngoingProduceTopics          *ebpf.Map `ebpf:"ongoing_produce_topics"`
	OngoingRedisRequests          *ebpf.Map `ebpf:"ongoing_redis_requests"`
	OngoingServerConnections      *ebpf.Map `ebpf:"ongoing_server_connections"`
	OngoingSqlQueries             *ebpf.Map `ebpf:"ongoing_sql_queries"`
	OngoingStreams                *ebpf.Map `ebpf:"ongoing_streams"`
	OutgoingTraceMap              *ebpf.Map `ebpf:"outgoing_trace_map"`
	ProduceRequests               *ebpf.Map `ebpf:"produce_requests"`
	ProduceTraceparents           *ebpf.Map `ebpf:"produce_traceparents"`
	RedisWrites                   *ebpf.Map `ebpf:"redis_writes"`
	SpanMem                       *ebpf.Map `ebpf:"span_mem"`
	SpanNames                     *ebpf.Map `ebpf:"span_names"`
	TempHeaderMemStore            *ebpf.Map `ebpf:"temp_header_mem_store"`
	TraceMap                      *ebpf.Map `ebpf:"trace_map"`
	TransportNewClientInvocations *ebpf.Map `ebpf:"transport_new_client_invocations"`
}

func (m *BpfMaps) Close() error {
	return _BpfClose(
		m.ActiveSpans,
		m.Events,
		m.FetchRequests,
		m.GoOffsetsMap,
		m.GoOngoingHttp,
		m.GoOngoingHttpClientRequests,
		m.GoTraceMap,
		m.Http2ServerRequestsTp,
		m.IncomingTraceMap,
		m.KafkaRequests,
		m.Newproc1,
		m.OngoingClientConnections,
		m.OngoingGoroutines,
		m.OngoingGrpcClientRequests,
		m.OngoingGrpcHeaderWrites,
		m.OngoingGrpcOperateHeaders,
		m.OngoingGrpcRequestStatus,
		m.OngoingGrpcServerRequests,
		m.OngoingGrpcTransports,
		m.OngoingHttpClientRequestsData,
		m.OngoingHttpServerRequests,
		m.OngoingKafkaRequests,
		m.OngoingMongoRequests,
		m.OngoingProduceMessages,
		m.OngoingProduceTopics,
		m.OngoingRedisRequests,
		m.OngoingServerConnections,
		m.OngoingSqlQueries,
		m.OngoingStreams,
		m.OutgoingTraceMap,
		m.ProduceRequests,
		m.ProduceTraceparents,
		m.RedisWrites,
		m.SpanMem,
		m.SpanNames,
		m.TempHeaderMemStore,
		m.TraceMap,
		m.TransportNewClientInvocations,
	)
}

// BpfVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to LoadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfVariables struct {
	ERROR_KEY            *ebpf.Variable `ebpf:"ERROR_KEY"`
	ERROR_KEY_SIZE       *ebpf.Variable `ebpf:"ERROR_KEY_SIZE"`
	AttrTypeBool         *ebpf.Variable `ebpf:"attr_type_bool"`
	AttrTypeBoolslice    *ebpf.Variable `ebpf:"attr_type_boolslice"`
	AttrTypeFloat64      *ebpf.Variable `ebpf:"attr_type_float64"`
	AttrTypeFloat64slice *ebpf.Variable `ebpf:"attr_type_float64slice"`
	AttrTypeInt64        *ebpf.Variable `ebpf:"attr_type_int64"`
	AttrTypeInt64slice   *ebpf.Variable `ebpf:"attr_type_int64slice"`
	AttrTypeInvalid      *ebpf.Variable `ebpf:"attr_type_invalid"`
	AttrTypeString       *ebpf.Variable `ebpf:"attr_type_string"`
	AttrTypeStringslice  *ebpf.Variable `ebpf:"attr_type_stringslice"`
	DisableBlackBoxCp    *ebpf.Variable `ebpf:"disable_black_box_cp"`
	HuffmanCodeLen       *ebpf.Variable `ebpf:"huffman_code_len"`
	HuffmanCodes         *ebpf.Variable `ebpf:"huffman_codes"`
	Ip4ip6Prefix         *ebpf.Variable `ebpf:"ip4ip6_prefix"`
	Unused               *ebpf.Variable `ebpf:"unused"`
	UnusedHttp2          *ebpf.Variable `ebpf:"unused_http2"`
	WakeupDataBytes      *ebpf.Variable `ebpf:"wakeup_data_bytes"`
}

// BpfPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to LoadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfPrograms struct {
	ObiUprobeClientConnClose                      *ebpf.Program `ebpf:"obi_uprobe_ClientConn_Close"`
	ObiUprobeClientConnInvoke                     *ebpf.Program `ebpf:"obi_uprobe_ClientConn_Invoke"`
	ObiUprobeClientConnInvokeReturn               *ebpf.Program `ebpf:"obi_uprobe_ClientConn_Invoke_return"`
	ObiUprobeClientConnNewStream                  *ebpf.Program `ebpf:"obi_uprobe_ClientConn_NewStream"`
	ObiUprobeClientConnNewStreamReturn            *ebpf.Program `ebpf:"obi_uprobe_ClientConn_NewStream_return"`
	ObiUprobeRecordError                          *ebpf.Program `ebpf:"obi_uprobe_RecordError"`
	ObiUprobeServeHTTP                            *ebpf.Program `ebpf:"obi_uprobe_ServeHTTP"`
	ObiUprobeServeHTTPReturns                     *ebpf.Program `ebpf:"obi_uprobe_ServeHTTPReturns"`
	ObiUprobeSetAttributes                        *ebpf.Program `ebpf:"obi_uprobe_SetAttributes"`
	ObiUprobeSetName                              *ebpf.Program `ebpf:"obi_uprobe_SetName"`
	ObiUprobeSetStatus                            *ebpf.Program `ebpf:"obi_uprobe_SetStatus"`
	ObiUprobeClientStreamRecvMsgReturn            *ebpf.Program `ebpf:"obi_uprobe_clientStream_RecvMsg_return"`
	ObiUprobeClientRoundTrip                      *ebpf.Program `ebpf:"obi_uprobe_client_roundTrip"`
	ObiUprobeConnServe                            *ebpf.Program `ebpf:"obi_uprobe_connServe"`
	ObiUprobeConnServeRet                         *ebpf.Program `ebpf:"obi_uprobe_connServeRet"`
	ObiUprobeExecDC                               *ebpf.Program `ebpf:"obi_uprobe_execDC"`
	ObiUprobeGrpcFramerWriteHeaders               *ebpf.Program `ebpf:"obi_uprobe_grpcFramerWriteHeaders"`
	ObiUprobeGrpcFramerWriteHeadersReturns        *ebpf.Program `ebpf:"obi_uprobe_grpcFramerWriteHeaders_returns"`
	ObiUprobeHttp2FramerWriteHeaders              *ebpf.Program `ebpf:"obi_uprobe_http2FramerWriteHeaders"`
	ObiUprobeHttp2FramerWriteHeadersReturns       *ebpf.Program `ebpf:"obi_uprobe_http2FramerWriteHeaders_returns"`
	ObiUprobeHttp2ResponseWriterStateWriteHeader  *ebpf.Program `ebpf:"obi_uprobe_http2ResponseWriterStateWriteHeader"`
	ObiUprobeHttp2RoundTrip                       *ebpf.Program `ebpf:"obi_uprobe_http2RoundTrip"`
	ObiUprobeHttp2ServerOperateHeaders            *ebpf.Program `ebpf:"obi_uprobe_http2Server_operateHeaders"`
	ObiUprobeHttp2ServerProcessHeaders            *ebpf.Program `ebpf:"obi_uprobe_http2Server_processHeaders"`
	ObiUprobeHttp2WriteHeaders                    *ebpf.Program `ebpf:"obi_uprobe_http2WriteHeaders"`
	ObiUprobeHttp2WriteHeadersVendored            *ebpf.Program `ebpf:"obi_uprobe_http2WriteHeaders_vendored"`
	ObiUprobeHttp2serverConnRunHandler            *ebpf.Program `ebpf:"obi_uprobe_http2serverConn_runHandler"`
	ObiUprobeJsonrpcReadRequestHeader             *ebpf.Program `ebpf:"obi_uprobe_jsonrpcReadRequestHeader"`
	ObiUprobeJsonrpcReadRequestHeaderReturns      *ebpf.Program `ebpf:"obi_uprobe_jsonrpcReadRequestHeaderReturns"`
	ObiUprobeMongoOpAggregate                     *ebpf.Program `ebpf:"obi_uprobe_mongo_op_aggregate"`
	ObiUprobeMongoOpCountDocuments                *ebpf.Program `ebpf:"obi_uprobe_mongo_op_countDocuments"`
	ObiUprobeMongoOpDelete                        *ebpf.Program `ebpf:"obi_uprobe_mongo_op_delete"`
	ObiUprobeMongoOpDistinct                      *ebpf.Program `ebpf:"obi_uprobe_mongo_op_distinct"`
	ObiUprobeMongoOpDrop                          *ebpf.Program `ebpf:"obi_uprobe_mongo_op_drop"`
	ObiUprobeMongoOpEstimatedDocumentCount        *ebpf.Program `ebpf:"obi_uprobe_mongo_op_estimatedDocumentCount"`
	ObiUprobeMongoOpExecute                       *ebpf.Program `ebpf:"obi_uprobe_mongo_op_execute"`
	ObiUprobeMongoOpExecuteRet                    *ebpf.Program `ebpf:"obi_uprobe_mongo_op_execute_ret"`
	ObiUprobeMongoOpFind                          *ebpf.Program `ebpf:"obi_uprobe_mongo_op_find"`
	ObiUprobeMongoOpFindAndModify                 *ebpf.Program `ebpf:"obi_uprobe_mongo_op_findAndModify"`
	ObiUprobeMongoOpInsert                        *ebpf.Program `ebpf:"obi_uprobe_mongo_op_insert"`
	ObiUprobeMongoOpUpdateOrReplace               *ebpf.Program `ebpf:"obi_uprobe_mongo_op_updateOrReplace"`
	ObiUprobeNetFdRead                            *ebpf.Program `ebpf:"obi_uprobe_netFdRead"`
	ObiUprobeNonRecordingSpanEnd                  *ebpf.Program `ebpf:"obi_uprobe_nonRecordingSpan_End"`
	ObiUprobePersistConnRoundTrip                 *ebpf.Program `ebpf:"obi_uprobe_persistConnRoundTrip"`
	ObiUprobeProcGoexit1                          *ebpf.Program `ebpf:"obi_uprobe_proc_goexit1"`
	ObiUprobeProcNewproc1                         *ebpf.Program `ebpf:"obi_uprobe_proc_newproc1"`
	ObiUprobeProcNewproc1Ret                      *ebpf.Program `ebpf:"obi_uprobe_proc_newproc1_ret"`
	ObiUprobeProtocolRoundtrip                    *ebpf.Program `ebpf:"obi_uprobe_protocol_roundtrip"`
	ObiUprobeProtocolRoundtripRet                 *ebpf.Program `ebpf:"obi_uprobe_protocol_roundtrip_ret"`
	ObiUprobeQueryDC                              *ebpf.Program `ebpf:"obi_uprobe_queryDC"`
	ObiUprobeQueryReturn                          *ebpf.Program `ebpf:"obi_uprobe_queryReturn"`
	ObiUprobeReadContinuedLineSliceReturns        *ebpf.Program `ebpf:"obi_uprobe_readContinuedLineSliceReturns"`
	ObiUprobeReadRequestReturns                   *ebpf.Program `ebpf:"obi_uprobe_readRequestReturns"`
	ObiUprobeReadRequestStart                     *ebpf.Program `ebpf:"obi_uprobe_readRequestStart"`
	ObiUprobeReaderRead                           *ebpf.Program `ebpf:"obi_uprobe_reader_read"`
	ObiUprobeReaderReadRet                        *ebpf.Program `ebpf:"obi_uprobe_reader_read_ret"`
	ObiUprobeReaderSendMessage                    *ebpf.Program `ebpf:"obi_uprobe_reader_send_message"`
	ObiUprobeRedisProcess                         *ebpf.Program `ebpf:"obi_uprobe_redis_process"`
	ObiUprobeRedisProcessRet                      *ebpf.Program `ebpf:"obi_uprobe_redis_process_ret"`
	ObiUprobeRedisWithWriter                      *ebpf.Program `ebpf:"obi_uprobe_redis_with_writer"`
	ObiUprobeRedisWithWriterRet                   *ebpf.Program `ebpf:"obi_uprobe_redis_with_writer_ret"`
	ObiUprobeRoundTrip                            *ebpf.Program `ebpf:"obi_uprobe_roundTrip"`
	ObiUprobeRoundTripReturn                      *ebpf.Program `ebpf:"obi_uprobe_roundTripReturn"`
	ObiUprobeSaramaBrokerWrite                    *ebpf.Program `ebpf:"obi_uprobe_sarama_broker_write"`
	ObiUprobeSaramaResponsePromiseHandle          *ebpf.Program `ebpf:"obi_uprobe_sarama_response_promise_handle"`
	ObiUprobeSaramaSendInternal                   *ebpf.Program `ebpf:"obi_uprobe_sarama_sendInternal"`
	ObiUprobeServerHandleStream                   *ebpf.Program `ebpf:"obi_uprobe_server_handleStream"`
	ObiUprobeServerHandleStreamReturn             *ebpf.Program `ebpf:"obi_uprobe_server_handleStream_return"`
	ObiUprobeServerHandlerTransportHandleStreams  *ebpf.Program `ebpf:"obi_uprobe_server_handler_transport_handle_streams"`
	ObiUprobeTracerStart                          *ebpf.Program `ebpf:"obi_uprobe_tracer_Start"`
	ObiUprobeTracerStartReturns                   *ebpf.Program `ebpf:"obi_uprobe_tracer_Start_Returns"`
	ObiUprobeTracerStartGlobal                    *ebpf.Program `ebpf:"obi_uprobe_tracer_Start_global"`
	ObiUprobeTransportHttp2ClientNewStream        *ebpf.Program `ebpf:"obi_uprobe_transport_http2Client_NewStream"`
	ObiUprobeTransportHttp2ClientNewStreamReturns *ebpf.Program `ebpf:"obi_uprobe_transport_http2Client_NewStream_Returns"`
	ObiUprobeTransportWriteStatus                 *ebpf.Program `ebpf:"obi_uprobe_transport_writeStatus"`
	ObiUprobeWriteSubset                          *ebpf.Program `ebpf:"obi_uprobe_writeSubset"`
	ObiUprobeWriterProduce                        *ebpf.Program `ebpf:"obi_uprobe_writer_produce"`
	ObiUprobeWriterWriteMessages                  *ebpf.Program `ebpf:"obi_uprobe_writer_write_messages"`
}

func (p *BpfPrograms) Close() error {
	return _BpfClose(
		p.ObiUprobeClientConnClose,
		p.ObiUprobeClientConnInvoke,
		p.ObiUprobeClientConnInvokeReturn,
		p.ObiUprobeClientConnNewStream,
		p.ObiUprobeClientConnNewStreamReturn,
		p.ObiUprobeRecordError,
		p.ObiUprobeServeHTTP,
		p.ObiUprobeServeHTTPReturns,
		p.ObiUprobeSetAttributes,
		p.ObiUprobeSetName,
		p.ObiUprobeSetStatus,
		p.ObiUprobeClientStreamRecvMsgReturn,
		p.ObiUprobeClientRoundTrip,
		p.ObiUprobeConnServe,
		p.ObiUprobeConnServeRet,
		p.ObiUprobeExecDC,
		p.ObiUprobeGrpcFramerWriteHeaders,
		p.ObiUprobeGrpcFramerWriteHeadersReturns,
		p.ObiUprobeHttp2FramerWriteHeaders,
		p.ObiUprobeHttp2FramerWriteHeadersReturns,
		p.ObiUprobeHttp2ResponseWriterStateWriteHeader,
		p.ObiUprobeHttp2RoundTrip,
		p.ObiUprobeHttp2ServerOperateHeaders,
		p.ObiUprobeHttp2ServerProcessHeaders,
		p.ObiUprobeHttp2WriteHeaders,
		p.ObiUprobeHttp2WriteHeadersVendored,
		p.ObiUprobeHttp2serverConnRunHandler,
		p.ObiUprobeJsonrpcReadRequestHeader,
		p.ObiUprobeJsonrpcReadRequestHeaderReturns,
		p.ObiUprobeMongoOpAggregate,
		p.ObiUprobeMongoOpCountDocuments,
		p.ObiUprobeMongoOpDelete,
		p.ObiUprobeMongoOpDistinct,
		p.ObiUprobeMongoOpDrop,
		p.ObiUprobeMongoOpEstimatedDocumentCount,
		p.ObiUprobeMongoOpExecute,
		p.ObiUprobeMongoOpExecuteRet,
		p.ObiUprobeMongoOpFind,
		p.ObiUprobeMongoOpFindAndModify,
		p.ObiUprobeMongoOpInsert,
		p.ObiUprobeMongoOpUpdateOrReplace,
		p.ObiUprobeNetFdRead,
		p.ObiUprobeNonRecordingSpanEnd,
		p.ObiUprobePersistConnRoundTrip,
		p.ObiUprobeProcGoexit1,
		p.ObiUprobeProcNewproc1,
		p.ObiUprobeProcNewproc1Ret,
		p.ObiUprobeProtocolRoundtrip,
		p.ObiUprobeProtocolRoundtripRet,
		p.ObiUprobeQueryDC,
		p.ObiUprobeQueryReturn,
		p.ObiUprobeReadContinuedLineSliceReturns,
		p.ObiUprobeReadRequestReturns,
		p.ObiUprobeReadRequestStart,
		p.ObiUprobeReaderRead,
		p.ObiUprobeReaderReadRet,
		p.ObiUprobeReaderSendMessage,
		p.ObiUprobeRedisProcess,
		p.ObiUprobeRedisProcessRet,
		p.ObiUprobeRedisWithWriter,
		p.ObiUprobeRedisWithWriterRet,
		p.ObiUprobeRoundTrip,
		p.ObiUprobeRoundTripReturn,
		p.ObiUprobeSaramaBrokerWrite,
		p.ObiUprobeSaramaResponsePromiseHandle,
		p.ObiUprobeSaramaSendInternal,
		p.ObiUprobeServerHandleStream,
		p.ObiUprobeServerHandleStreamReturn,
		p.ObiUprobeServerHandlerTransportHandleStreams,
		p.ObiUprobeTracerStart,
		p.ObiUprobeTracerStartReturns,
		p.ObiUprobeTracerStartGlobal,
		p.ObiUprobeTransportHttp2ClientNewStream,
		p.ObiUprobeTransportHttp2ClientNewStreamReturns,
		p.ObiUprobeTransportWriteStatus,
		p.ObiUprobeWriteSubset,
		p.ObiUprobeWriterProduce,
		p.ObiUprobeWriterWriteMessages,
	)
}

func _BpfClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed bpf_x86_bpfel.o
var _BpfBytes []byte
