/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri2.json;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.colibri.json.JSONSerializer;
import org.jitsi.xmpp.extensions.colibri2.AbstractConferenceEntity;
import org.jitsi.xmpp.extensions.colibri2.AbstractConferenceModificationIQ;
import org.jitsi.xmpp.extensions.colibri2.Capability;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Endpoint;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Relay;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifiedIQ;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifyIQ;
import org.jitsi.xmpp.extensions.colibri2.Connect;
import org.jitsi.xmpp.extensions.colibri2.Connects;
import org.jitsi.xmpp.extensions.colibri2.Endpoints;
import org.jitsi.xmpp.extensions.colibri2.ForceMute;
import org.jitsi.xmpp.extensions.colibri2.InitialLastN;
import org.jitsi.xmpp.extensions.colibri2.Media;
import org.jitsi.xmpp.extensions.colibri2.MediaSource;
import org.jitsi.xmpp.extensions.colibri2.Sctp;
import org.jitsi.xmpp.extensions.colibri2.Sources;
import org.jitsi.xmpp.extensions.colibri2.Transport;
import org.jitsi.xmpp.extensions.jingle.ExtmapAllowMixedPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.jivesoftware.smackx.muc.MUCRole;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u00020\r2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020$H\u0002J\u0016\u0010%\u001a\u00020\u00142\f\u0010&\u001a\b\u0012\u0004\u0012\u00020$0\u0016H\u0002J\u0010\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020\r2\u0006\u00101\u001a\u000202H\u0002J\u0016\u00103\u001a\u00020\u00142\f\u00104\u001a\b\u0012\u0004\u0012\u00020/0\u0016H\u0002J\u0010\u00105\u001a\u00020\r2\u0006\u00106\u001a\u000207H\u0002J\u0016\u00108\u001a\u00020\u00142\f\u00109\u001a\b\u0012\u0004\u0012\u0002070\u0016H\u0002J\u0010\u0010:\u001a\u00020\r2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u00020\u00142\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u00020\r2\u0006\u0010A\u001a\u00020BH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/jitsi/xmpp/extensions/colibri2/json/Colibri2JSONSerializer;", "", "()V", "CAPABILITIES_LIST", "", "ENDPOINTS", "MEDIA_LIST", "PAYLOAD_TYPES", "RELAYS", "RTP_HEADER_EXTS", "SOURCES", "SOURCE_GROUPS", "serializeAbstractConferenceEntity", "Lorg/json/simple/JSONObject;", "entity", "Lorg/jitsi/xmpp/extensions/colibri2/AbstractConferenceEntity;", "serializeAbstractConferenceModificationIQ", "iq", "Lorg/jitsi/xmpp/extensions/colibri2/AbstractConferenceModificationIQ;", "serializeCapabilities", "Lorg/json/simple/JSONArray;", "capabilities", "", "Lorg/jitsi/xmpp/extensions/colibri2/Capability;", "serializeConferenceModified", "Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifiedIQ;", "serializeConferenceModify", "Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifyIQ;", "serializeConnect", "connect", "Lorg/jitsi/xmpp/extensions/colibri2/Connect;", "serializeConnects", "connects", "Lorg/jitsi/xmpp/extensions/colibri2/Connects;", "serializeEndpoint", "endpoint", "Lorg/jitsi/xmpp/extensions/colibri2/Colibri2Endpoint;", "serializeEndpoints", "endpoints", "serializeForceMute", "forceMute", "Lorg/jitsi/xmpp/extensions/colibri2/ForceMute;", "serializeInitialLastN", "initialLastN", "Lorg/jitsi/xmpp/extensions/colibri2/InitialLastN;", "serializeMedia", "media", "Lorg/jitsi/xmpp/extensions/colibri2/Media;", "serializeMediaSource", "source", "Lorg/jitsi/xmpp/extensions/colibri2/MediaSource;", "serializeMedias", "medias", "serializeRelay", "relay", "Lorg/jitsi/xmpp/extensions/colibri2/Colibri2Relay;", "serializeRelays", "relays", "serializeSctp", "sctp", "Lorg/jitsi/xmpp/extensions/colibri2/Sctp;", "serializeSources", "sources", "Lorg/jitsi/xmpp/extensions/colibri2/Sources;", "serializeTransport", "transport", "Lorg/jitsi/xmpp/extensions/colibri2/Transport;", "jitsi-xmpp-extensions"})
@SourceDebugExtension(value={"SMAP\nColibri2JSONSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Colibri2JSONSerializer.kt\norg/jitsi/xmpp/extensions/colibri2/json/Colibri2JSONSerializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,290:1\n1#2:291\n1855#3,2:292\n1855#3,2:294\n1855#3,2:296\n1855#3,2:298\n1855#3,2:300\n1855#3,2:302\n1855#3,2:304\n*S KotlinDebug\n*F\n+ 1 Colibri2JSONSerializer.kt\norg/jitsi/xmpp/extensions/colibri2/json/Colibri2JSONSerializer\n*L\n145#1:292,2\n151#1:294,2\n190#1:296,2\n215#1:298,2\n221#1:300,2\n247#1:302,2\n255#1:304,2\n*E\n"})
public final class Colibri2JSONSerializer {
    @NotNull
    public static final Colibri2JSONSerializer INSTANCE = new Colibri2JSONSerializer();
    @NotNull
    public static final String ENDPOINTS = "endpoints";
    @NotNull
    public static final String RELAYS = "relays";
    @NotNull
    public static final String MEDIA_LIST = "medias";
    @NotNull
    public static final String CAPABILITIES_LIST = "capabilities";
    @NotNull
    public static final String PAYLOAD_TYPES = "payload-types";
    @NotNull
    public static final String RTP_HEADER_EXTS = "rtp-hdrexts";
    @NotNull
    public static final String SOURCE_GROUPS = "ssrc-groups";
    @NotNull
    public static final String SOURCES = "sources";

    private Colibri2JSONSerializer() {
    }

    private final JSONObject serializeMedia(Media media) {
        JSONObject jSONObject;
        block2: {
            JSONObject $this$serializeMedia_u24lambda_u241 = jSONObject = new JSONObject();
            boolean bl = false;
            $this$serializeMedia_u24lambda_u241.put((Object)"type", (Object)media.getType().toString());
            List<PayloadTypePacketExtension> list = media.getPayloadTypes();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getPayloadTypes(...)");
            if (!((Collection)list).isEmpty()) {
                $this$serializeMedia_u24lambda_u241.put((Object)PAYLOAD_TYPES, (Object)JSONSerializer.serializePayloadTypes((Collection<PayloadTypePacketExtension>)media.getPayloadTypes()));
            }
            List<RTPHdrExtPacketExtension> list2 = media.getRtpHdrExts();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getRtpHdrExts(...)");
            if (!((Collection)list2).isEmpty()) {
                $this$serializeMedia_u24lambda_u241.put((Object)RTP_HEADER_EXTS, (Object)JSONSerializer.serializeRtpHdrExts((Collection<RTPHdrExtPacketExtension>)media.getRtpHdrExts()));
            }
            ExtmapAllowMixedPacketExtension extmapAllowMixedPacketExtension = media.getExtmapAllowMixed();
            if (extmapAllowMixedPacketExtension == null) break block2;
            ExtmapAllowMixedPacketExtension it = extmapAllowMixedPacketExtension;
            boolean bl2 = false;
            $this$serializeMedia_u24lambda_u241.put((Object)"extmap-allow-mixed", (Object)true);
        }
        return jSONObject;
    }

    private final JSONObject serializeSctp(Sctp sctp) {
        JSONObject jSONObject;
        block1: {
            Object it;
            JSONObject $this$serializeSctp_u24lambda_u244 = jSONObject = new JSONObject();
            boolean bl = false;
            Integer n = sctp.getPort();
            if (n != null) {
                it = n;
                boolean bl2 = false;
                $this$serializeSctp_u24lambda_u244.put((Object)"port", it);
            }
            Sctp.Role role = sctp.getRole();
            if (role == null) break block1;
            it = role;
            boolean bl3 = false;
            $this$serializeSctp_u24lambda_u244.put((Object)"role", it);
        }
        return jSONObject;
    }

    private final JSONObject serializeTransport(Transport transport) {
        JSONObject jSONObject;
        block3: {
            AbstractPacketExtension it;
            JSONObject $this$serializeTransport_u24lambda_u247 = jSONObject = new JSONObject();
            boolean bl = false;
            if (transport.getIceControlling()) {
                $this$serializeTransport_u24lambda_u247.put((Object)"ice-controlling", (Object)transport.getIceControlling());
            }
            if (transport.getUseUniquePort()) {
                $this$serializeTransport_u24lambda_u247.put((Object)"use-unique-port", (Object)transport.getUseUniquePort());
            }
            IceUdpTransportPacketExtension iceUdpTransportPacketExtension = transport.getIceUdpTransport();
            if (iceUdpTransportPacketExtension != null) {
                it = iceUdpTransportPacketExtension;
                boolean bl2 = false;
                $this$serializeTransport_u24lambda_u247.put((Object)"transport", (Object)JSONSerializer.serializeTransport(it));
            }
            Sctp sctp = transport.getSctp();
            if (sctp == null) break block3;
            it = sctp;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it);
            $this$serializeTransport_u24lambda_u247.put((Object)"sctp", (Object)INSTANCE.serializeSctp((Sctp)it));
        }
        return jSONObject;
    }

    private final JSONObject serializeMediaSource(MediaSource source) {
        JSONObject jSONObject;
        JSONObject $this$serializeMediaSource_u24lambda_u248 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$serializeMediaSource_u24lambda_u248.put((Object)"type", (Object)source.getType().toString());
        $this$serializeMediaSource_u24lambda_u248.put((Object)"id", (Object)source.getId());
        List<SourcePacketExtension> list = source.getSources();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSources(...)");
        if (!((Collection)list).isEmpty()) {
            $this$serializeMediaSource_u24lambda_u248.put((Object)SOURCES, (Object)JSONSerializer.serializeSources((Collection<SourcePacketExtension>)source.getSources()));
        }
        List<SourceGroupPacketExtension> list2 = source.getSsrcGroups();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getSsrcGroups(...)");
        if (!((Collection)list2).isEmpty()) {
            $this$serializeMediaSource_u24lambda_u248.put((Object)SOURCE_GROUPS, (Object)JSONSerializer.serializeSourceGroups((Collection<SourceGroupPacketExtension>)source.getSsrcGroups()));
        }
        return jSONObject;
    }

    private final JSONArray serializeMedias(Collection<? extends Media> medias) {
        JSONArray jSONArray;
        JSONArray $this$serializeMedias_u24lambda_u2410 = jSONArray = new JSONArray();
        boolean bl = false;
        Iterable $this$forEach$iv = medias;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Media it = (Media)element$iv;
            boolean bl2 = false;
            $this$serializeMedias_u24lambda_u2410.add((Object)INSTANCE.serializeMedia(it));
        }
        return jSONArray;
    }

    private final JSONArray serializeSources(Sources sources) {
        JSONArray jSONArray;
        JSONArray $this$serializeSources_u24lambda_u2412 = jSONArray = new JSONArray();
        boolean bl = false;
        List<MediaSource> list = sources.getMediaSources();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getMediaSources(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MediaSource it = (MediaSource)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            $this$serializeSources_u24lambda_u2412.add((Object)INSTANCE.serializeMediaSource(it));
        }
        return jSONArray;
    }

    private final JSONObject serializeAbstractConferenceEntity(AbstractConferenceEntity entity) {
        JSONObject jSONObject;
        block4: {
            AbstractPacketExtension it;
            JSONObject $this$serializeAbstractConferenceEntity_u24lambda_u2415 = jSONObject = new JSONObject();
            boolean bl = false;
            $this$serializeAbstractConferenceEntity_u24lambda_u2415.put((Object)"id", (Object)entity.getId());
            if (entity.getCreate()) {
                $this$serializeAbstractConferenceEntity_u24lambda_u2415.put((Object)"create", (Object)entity.getCreate());
            }
            if (entity.getExpire()) {
                $this$serializeAbstractConferenceEntity_u24lambda_u2415.put((Object)"expire", (Object)entity.getExpire());
            }
            List<Media> list = entity.getMedia();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getMedia(...)");
            if (!((Collection)list).isEmpty()) {
                List<Media> list2 = entity.getMedia();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getMedia(...)");
                $this$serializeAbstractConferenceEntity_u24lambda_u2415.put((Object)MEDIA_LIST, (Object)INSTANCE.serializeMedias((Collection<? extends Media>)list2));
            }
            Transport transport = entity.getTransport();
            if (transport != null) {
                it = transport;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                $this$serializeAbstractConferenceEntity_u24lambda_u2415.put((Object)"transport", (Object)INSTANCE.serializeTransport((Transport)it));
            }
            Sources sources = entity.getSources();
            if (sources == null) break block4;
            it = sources;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it);
            $this$serializeAbstractConferenceEntity_u24lambda_u2415.put((Object)SOURCES, (Object)INSTANCE.serializeSources((Sources)it));
        }
        return jSONObject;
    }

    private final JSONObject serializeForceMute(ForceMute forceMute) {
        JSONObject jSONObject;
        JSONObject $this$serializeForceMute_u24lambda_u2416 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$serializeForceMute_u24lambda_u2416.put((Object)"audio", (Object)forceMute.getAudio());
        $this$serializeForceMute_u24lambda_u2416.put((Object)"video", (Object)forceMute.getVideo());
        return jSONObject;
    }

    private final JSONObject serializeInitialLastN(InitialLastN initialLastN) {
        JSONObject jSONObject;
        JSONObject $this$serializeInitialLastN_u24lambda_u2417 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$serializeInitialLastN_u24lambda_u2417.put((Object)"value", (Object)initialLastN.getValue());
        return jSONObject;
    }

    private final JSONArray serializeCapabilities(Collection<? extends Capability> capabilities) {
        JSONArray jSONArray;
        JSONArray $this$serializeCapabilities_u24lambda_u2419 = jSONArray = new JSONArray();
        boolean bl = false;
        Iterable $this$forEach$iv = capabilities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Capability it = (Capability)element$iv;
            boolean bl2 = false;
            $this$serializeCapabilities_u24lambda_u2419.add((Object)it.getName());
        }
        return jSONArray;
    }

    private final JSONObject serializeEndpoint(Colibri2Endpoint endpoint) {
        Object object;
        JSONObject jSONObject;
        JSONObject $this$serializeEndpoint_u24lambda_u2424 = jSONObject = this.serializeAbstractConferenceEntity(endpoint);
        boolean bl = false;
        String string = endpoint.getStatsId();
        if (string != null) {
            object = string;
            String $this$serializeEndpoint_u24lambda_u2424_u24lambda_u2420 = object;
            boolean bl2 = false;
            $this$serializeEndpoint_u24lambda_u2424.put((Object)"stats-id", (Object)$this$serializeEndpoint_u24lambda_u2424_u24lambda_u2420);
        }
        MUCRole mUCRole = endpoint.getMucRole();
        if (mUCRole != null) {
            object = mUCRole;
            String $this$serializeEndpoint_u24lambda_u2424_u24lambda_u2421 = object;
            boolean bl3 = false;
            $this$serializeEndpoint_u24lambda_u2424.put((Object)"muc-role", (Object)$this$serializeEndpoint_u24lambda_u2424_u24lambda_u2421.toString());
        }
        ForceMute forceMute = endpoint.getForceMute();
        if (forceMute != null) {
            Object $this$serializeEndpoint_u24lambda_u2424_u24lambda_u2422 = object = forceMute;
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)$this$serializeEndpoint_u24lambda_u2424_u24lambda_u2422);
            $this$serializeEndpoint_u24lambda_u2424.put((Object)"force-mute", (Object)INSTANCE.serializeForceMute((ForceMute)$this$serializeEndpoint_u24lambda_u2424_u24lambda_u2422));
        }
        InitialLastN initialLastN = endpoint.getInitialLastN();
        if (initialLastN != null) {
            Object $this$serializeEndpoint_u24lambda_u2424_u24lambda_u2423 = object = initialLastN;
            boolean bl5 = false;
            Intrinsics.checkNotNull((Object)$this$serializeEndpoint_u24lambda_u2424_u24lambda_u2423);
            $this$serializeEndpoint_u24lambda_u2424.put((Object)"initial-last-n", (Object)INSTANCE.serializeInitialLastN((InitialLastN)$this$serializeEndpoint_u24lambda_u2424_u24lambda_u2423));
        }
        List<Capability> list = endpoint.getCapabilities();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getCapabilities(...)");
        if (!((Collection)list).isEmpty()) {
            List<Capability> list2 = endpoint.getCapabilities();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getCapabilities(...)");
            $this$serializeEndpoint_u24lambda_u2424.put((Object)CAPABILITIES_LIST, (Object)INSTANCE.serializeCapabilities((Collection<? extends Capability>)list2));
        }
        return jSONObject;
    }

    private final JSONObject serializeRelay(Colibri2Relay relay) {
        JSONObject jSONObject;
        block1: {
            JSONObject $this$serializeRelay_u24lambda_u2427 = jSONObject = this.serializeAbstractConferenceEntity(relay);
            boolean bl = false;
            String string = relay.getMeshId();
            if (string != null) {
                String string2;
                String $this$serializeRelay_u24lambda_u2427_u24lambda_u2425 = string2 = string;
                boolean bl2 = false;
                $this$serializeRelay_u24lambda_u2427.put((Object)"mesh-id", (Object)$this$serializeRelay_u24lambda_u2427_u24lambda_u2425);
            }
            Endpoints endpoints = relay.getEndpoints();
            if (endpoints == null) break block1;
            Endpoints it = endpoints;
            boolean bl3 = false;
            List<Colibri2Endpoint> list = it.getEndpoints();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getEndpoints(...)");
            $this$serializeRelay_u24lambda_u2427.put((Object)ENDPOINTS, (Object)INSTANCE.serializeEndpoints((Collection<? extends Colibri2Endpoint>)list));
        }
        return jSONObject;
    }

    private final JSONArray serializeEndpoints(Collection<? extends Colibri2Endpoint> endpoints) {
        JSONArray jSONArray;
        JSONArray $this$serializeEndpoints_u24lambda_u2429 = jSONArray = new JSONArray();
        boolean bl = false;
        Iterable $this$forEach$iv = endpoints;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Colibri2Endpoint it = (Colibri2Endpoint)element$iv;
            boolean bl2 = false;
            $this$serializeEndpoints_u24lambda_u2429.add((Object)INSTANCE.serializeEndpoint(it));
        }
        return jSONArray;
    }

    private final JSONArray serializeRelays(Collection<? extends Colibri2Relay> relays) {
        JSONArray jSONArray;
        JSONArray $this$serializeRelays_u24lambda_u2431 = jSONArray = new JSONArray();
        boolean bl = false;
        Iterable $this$forEach$iv = relays;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Colibri2Relay it = (Colibri2Relay)element$iv;
            boolean bl2 = false;
            $this$serializeRelays_u24lambda_u2431.add((Object)INSTANCE.serializeRelay(it));
        }
        return jSONArray;
    }

    private final JSONObject serializeAbstractConferenceModificationIQ(AbstractConferenceModificationIQ<?> iq) {
        JSONObject jSONObject;
        JSONObject $this$serializeAbstractConferenceModificationIQ_u24lambda_u2432 = jSONObject = new JSONObject();
        boolean bl = false;
        List<Colibri2Endpoint> list = iq.getEndpoints();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getEndpoints(...)");
        if (!((Collection)list).isEmpty()) {
            List<Colibri2Endpoint> list2 = iq.getEndpoints();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getEndpoints(...)");
            $this$serializeAbstractConferenceModificationIQ_u24lambda_u2432.put((Object)ENDPOINTS, (Object)INSTANCE.serializeEndpoints((Collection<? extends Colibri2Endpoint>)list2));
        }
        List<Colibri2Relay> list3 = iq.getRelays();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getRelays(...)");
        if (!((Collection)list3).isEmpty()) {
            List<Colibri2Relay> list4 = iq.getRelays();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"getRelays(...)");
            $this$serializeAbstractConferenceModificationIQ_u24lambda_u2432.put((Object)RELAYS, (Object)INSTANCE.serializeRelays((Collection<? extends Colibri2Relay>)list4));
        }
        return jSONObject;
    }

    private final JSONObject serializeConnect(Connect connect) {
        List<Connect.HttpHeader> headers;
        JSONObject jSONObject;
        JSONObject $this$serializeConnect_u24lambda_u2434 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$serializeConnect_u24lambda_u2434.put((Object)"url", (Object)connect.getUrl().toString());
        String string = connect.getProtocol().toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        $this$serializeConnect_u24lambda_u2434.put((Object)"protocol", (Object)string);
        String string2 = connect.getType().toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        $this$serializeConnect_u24lambda_u2434.put((Object)"type", (Object)string2);
        if (connect.getAudio()) {
            $this$serializeConnect_u24lambda_u2434.put((Object)"audio", (Object)true);
        }
        if (connect.getVideo()) {
            $this$serializeConnect_u24lambda_u2434.put((Object)"video", (Object)true);
        }
        if (!((Collection)(headers = connect.getHttpHeaders())).isEmpty()) {
            JSONObject headersObj = new JSONObject();
            Iterable $this$forEach$iv = headers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Connect.HttpHeader header = (Connect.HttpHeader)element$iv;
                boolean bl2 = false;
                ((Map)headersObj).put(header.getName(), header.getValue());
            }
            $this$serializeConnect_u24lambda_u2434.put((Object)"headers", (Object)headersObj);
        }
        return jSONObject;
    }

    private final JSONArray serializeConnects(Connects connects) {
        JSONArray jSONArray;
        JSONArray $this$serializeConnects_u24lambda_u2436 = jSONArray = new JSONArray();
        boolean bl = false;
        Iterable $this$forEach$iv = connects.getConnects();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Connect it = (Connect)element$iv;
            boolean bl2 = false;
            $this$serializeConnects_u24lambda_u2436.add((Object)INSTANCE.serializeConnect(it));
        }
        return jSONArray;
    }

    @JvmStatic
    @NotNull
    public static final JSONObject serializeConferenceModify(@NotNull ConferenceModifyIQ iq) {
        JSONObject jSONObject;
        block4: {
            Object it;
            Intrinsics.checkNotNullParameter((Object)((Object)iq), (String)"iq");
            JSONObject $this$serializeConferenceModify_u24lambda_u2439 = jSONObject = INSTANCE.serializeAbstractConferenceModificationIQ(iq);
            boolean bl = false;
            if (iq.getCreate()) {
                $this$serializeConferenceModify_u24lambda_u2439.put((Object)"create", (Object)iq.getCreate());
            }
            if (iq.getExpire()) {
                $this$serializeConferenceModify_u24lambda_u2439.put((Object)"expire", (Object)iq.getExpire());
            }
            if (!iq.isRtcstatsEnabled()) {
                $this$serializeConferenceModify_u24lambda_u2439.put((Object)"rtcstats-enabled", (Object)iq.isRtcstatsEnabled());
            }
            Connects connects = iq.getConnects();
            if (connects != null) {
                it = connects;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                $this$serializeConferenceModify_u24lambda_u2439.put((Object)"connects", (Object)INSTANCE.serializeConnects((Connects)it));
            }
            $this$serializeConferenceModify_u24lambda_u2439.put((Object)"meeting-id", (Object)iq.getMeetingId());
            String string = iq.getConferenceName();
            if (string == null) break block4;
            it = string;
            boolean bl3 = false;
            $this$serializeConferenceModify_u24lambda_u2439.put((Object)"name", it);
        }
        return jSONObject;
    }

    @JvmStatic
    @NotNull
    public static final JSONObject serializeConferenceModified(@NotNull ConferenceModifiedIQ iq) {
        JSONObject jSONObject;
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)iq), (String)"iq");
            JSONObject $this$serializeConferenceModified_u24lambda_u2441 = jSONObject = INSTANCE.serializeAbstractConferenceModificationIQ(iq);
            boolean bl = false;
            Sources sources = iq.getSources();
            if (sources == null) break block0;
            Sources it = sources;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            $this$serializeConferenceModified_u24lambda_u2441.put((Object)SOURCES, (Object)INSTANCE.serializeSources(it));
        }
        return jSONObject;
    }
}

