/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.math.BigInteger;
import java.nio.ByteOrder;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.util.ByteArrays;

public final class RadiotapDataTsft
implements RadiotapPacket.RadiotapData {
    private static final long serialVersionUID = -6492811566937170319L;
    private static final int LENGTH = 8;
    private final BigInteger macTimestamp;

    public static RadiotapDataTsft newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new RadiotapDataTsft(rawData, offset, length);
    }

    private RadiotapDataTsft(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 8) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a RadiotapTsft (").append(8).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.macTimestamp = new BigInteger(new byte[]{0, rawData[offset + 7], rawData[offset + 6], rawData[offset + 5], rawData[offset + 4], rawData[offset + 3], rawData[offset + 2], rawData[offset + 1], rawData[offset + 0]});
    }

    private RadiotapDataTsft(Builder builder) {
        if (builder == null || builder.macTimestamp == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.macTimestamp: ").append(builder.macTimestamp);
            throw new NullPointerException(sb.toString());
        }
        if (builder.macTimestamp.signum() == -1) {
            throw new IllegalArgumentException("macTimestamp must be positive.");
        }
        if (builder.macTimestamp.bitLength() > 64) {
            throw new IllegalArgumentException("macTimestamp must be less than 18446744073709551616.");
        }
        this.macTimestamp = builder.macTimestamp;
    }

    public BigInteger getMacTimestamp() {
        return this.macTimestamp;
    }

    @Override
    public int length() {
        return 8;
    }

    @Override
    public byte[] getRawData() {
        return ByteArrays.toByteArray(this.macTimestamp.longValue(), ByteOrder.LITTLE_ENDIAN);
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("TSFT: ").append(ls).append(indent).append("  MAC timestamp: ").append(this.macTimestamp).append(" microseconds").append(ls);
        return sb.toString();
    }

    public int hashCode() {
        return this.macTimestamp.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        RadiotapDataTsft other = (RadiotapDataTsft)obj;
        return this.macTimestamp.equals(other.macTimestamp);
    }

    public static final class Builder {
        private BigInteger macTimestamp;

        public Builder() {
        }

        private Builder(RadiotapDataTsft obj) {
            this.macTimestamp = obj.macTimestamp;
        }

        public Builder macTimestamp(BigInteger macTimestamp) {
            this.macTimestamp = macTimestamp;
            return this;
        }

        public RadiotapDataTsft build() {
            return new RadiotapDataTsft(this);
        }
    }
}

