/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.SocketException;
import org.ice4j.TransportAddress;
import org.ice4j.ice.CandidateExtendedType;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.harvest.TurnCandidateHarvest;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.IceUdpSocketWrapper;
import org.ice4j.socket.MultiplexingDatagramSocket;
import org.ice4j.socket.RelayedCandidateDatagramSocket;

public class RelayedCandidate
extends LocalCandidate {
    private RelayedCandidateDatagramSocket relayedCandidateDatagramSocket;
    private IceSocketWrapper socket;
    private final TurnCandidateHarvest turnCandidateHarvest;

    public RelayedCandidate(TransportAddress transportAddress, TurnCandidateHarvest turnCandidateHarvest, TransportAddress mappedAddress) {
        super(transportAddress, turnCandidateHarvest.hostCandidate.getParentComponent(), CandidateType.RELAYED_CANDIDATE, CandidateExtendedType.TURN_RELAYED_CANDIDATE, turnCandidateHarvest.hostCandidate.getParentComponent().findLocalCandidate(mappedAddress));
        this.turnCandidateHarvest = turnCandidateHarvest;
        this.setBase(this);
        this.setRelayServerAddress(turnCandidateHarvest.harvester.stunServer);
        this.setMappedAddress(mappedAddress);
    }

    private synchronized RelayedCandidateDatagramSocket getRelayedCandidateDatagramSocket() {
        if (this.relayedCandidateDatagramSocket == null) {
            try {
                this.relayedCandidateDatagramSocket = new RelayedCandidateDatagramSocket(this, this.turnCandidateHarvest);
            }
            catch (SocketException sex) {
                throw new UndeclaredThrowableException(sex);
            }
        }
        return this.relayedCandidateDatagramSocket;
    }

    @Override
    public synchronized IceSocketWrapper getCandidateIceSocketWrapper() {
        if (this.socket == null) {
            try {
                this.socket = new IceUdpSocketWrapper(new MultiplexingDatagramSocket(this.getRelayedCandidateDatagramSocket()));
            }
            catch (SocketException sex) {
                throw new UndeclaredThrowableException(sex);
            }
        }
        return this.socket;
    }
}

