/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.mediajson.TranscriptionResultEvent;
import org.jitsi.nlj.DebugStateMode;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.VideoType;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.rtcp.rtcpfb.RtcpFbPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbFirPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbPliPacket;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.dsi.SpeakerRanking;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.LogContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.utils.queue.PacketQueue;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.AbstractEndpointMessageTransport;
import org.jitsi.videobridge.AudioSubscriptionManager;
import org.jitsi.videobridge.ColibriQueue;
import org.jitsi.videobridge.ConferenceSpeechActivity;
import org.jitsi.videobridge.EncodingsManager;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.EndpointConnectionStatusMonitor;
import org.jitsi.videobridge.LoudestConfig;
import org.jitsi.videobridge.PotentialPacketHandler;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.VideobridgeConfig;
import org.jitsi.videobridge.colibri2.Colibri2ConferenceHandler;
import org.jitsi.videobridge.export.ExporterWrapper;
import org.jitsi.videobridge.message.BridgeChannelMessage;
import org.jitsi.videobridge.message.DominantSpeakerMessage;
import org.jitsi.videobridge.message.EndpointMessage;
import org.jitsi.videobridge.message.ReceiverAudioSubscriptionMessage;
import org.jitsi.videobridge.metrics.VideobridgeMetrics;
import org.jitsi.videobridge.relay.AudioSourceDesc;
import org.jitsi.videobridge.relay.Relay;
import org.jitsi.videobridge.relay.RelayedEndpoint;
import org.jitsi.videobridge.util.ByteBufferPool;
import org.jitsi.videobridge.util.TaskPools;
import org.jitsi.videobridge.xmpp.XmppConnection;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifyIQ;
import org.jitsi.xmpp.extensions.colibri2.Connect;
import org.jitsi.xmpp.util.ErrorUtilKt;
import org.jitsi.xmpp.util.RedactColibriIp;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.json.simple.JSONObject;
import org.jxmpp.jid.EntityBareJid;

public class Conference
implements AbstractEndpointMessageTransport.EndpointMessageTransportEventHandler {
    private final ConcurrentHashMap<String, AbstractEndpoint> endpointsById = new ConcurrentHashMap();
    private final boolean isRtcStatsEnabled;
    private List<Endpoint> endpointsCache = Collections.emptyList();
    private final Object endpointsCacheLock = new Object();
    private final ConcurrentHashMap<Long, AbstractEndpoint> endpointsBySsrc = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Relay> relaysById = new ConcurrentHashMap();
    private final AtomicBoolean expired = new AtomicBoolean(false);
    private final long localAudioSsrc = Videobridge.RANDOM.nextLong() & 0xFFFFFFFFL;
    private final long localVideoSsrc = Videobridge.RANDOM.nextLong() & 0xFFFFFFFFL;
    private final String id;
    @Nullable
    private final EntityBareJid conferenceName;
    private final ConferenceSpeechActivity speechActivity;
    private final Videobridge videobridge;
    private final Logger logger;
    private final long creationTime = System.currentTimeMillis();
    @NotNull
    private final Colibri2ConferenceHandler colibri2Handler;
    @NotNull
    private final PacketQueue<XmppConnection.ColibriRequest> colibriQueue;
    @NotNull
    private final EncodingsManager encodingsManager = new EncodingsManager();
    private final boolean routeLoudestOnly = LoudestConfig.getRouteLoudestOnly();
    @NotNull
    private final AudioSubscriptionManager audioSubscriptionManager = new AudioSubscriptionManager();
    private ScheduledFuture<?> updateLastNEndpointsFuture;
    @NotNull
    private final EndpointConnectionStatusMonitor epConnectionStatusMonitor;
    @Nullable
    private final String meetingId;
    @NotNull
    private final ExporterWrapper exporter;
    private static final Pattern uuidTrimmer = Pattern.compile("(\\p{XDigit}{8})[\\p{XDigit}-]*");

    public boolean isRtcStatsEnabled() {
        return this.isRtcStatsEnabled;
    }

    public long getLocalAudioSsrc() {
        return this.localAudioSsrc;
    }

    public long getLocalVideoSsrc() {
        return this.localVideoSsrc;
    }

    public Conference(Videobridge videobridge, String id, @Nullable EntityBareJid conferenceName, @Nullable String meetingId, boolean isRtcStatsEnabled) {
        this.meetingId = meetingId;
        this.videobridge = Objects.requireNonNull(videobridge, "videobridge");
        this.isRtcStatsEnabled = isRtcStatsEnabled;
        HashMap<String, String> context = new HashMap<String, String>(Map.of("confId", id));
        if (conferenceName != null) {
            context.put("conf_name", conferenceName.toString());
        }
        if (meetingId != null) {
            context.put("meeting_id", uuidTrimmer.matcher(meetingId).replaceAll("$1"));
        }
        this.logger = new LoggerImpl(Conference.class.getName(), new LogContext(context));
        this.exporter = new ExporterWrapper(this.logger, (Function1<? super TranscriptionResultEvent, Unit>)((Function1)j -> {
            this.handleTranscriptionMessage((TranscriptionResultEvent)j);
            return Unit.INSTANCE;
        }));
        this.id = Objects.requireNonNull(id, "id");
        this.conferenceName = conferenceName;
        this.colibri2Handler = new Colibri2ConferenceHandler(this, this.logger);
        this.colibriQueue = new ColibriQueue(request -> {
            try {
                this.logger.info(() -> {
                    String reqStr = request.getRequest().toXML().toString();
                    if (VideobridgeConfig.getRedactRemoteAddresses()) {
                        reqStr = RedactColibriIp.Companion.redact(reqStr);
                    }
                    return "RECV colibri2 request: " + reqStr;
                });
                long start2 = System.currentTimeMillis();
                Pair<IQ, Boolean> p = this.colibri2Handler.handleConferenceModifyIQ(request.getRequest());
                IQ response = (IQ)p.getFirst();
                boolean expire = (Boolean)p.getSecond();
                long end = System.currentTimeMillis();
                long processingDelay = end - start2;
                long totalDelay = end - request.getReceiveTime();
                request.getProcessingDelayStats().addDelay(processingDelay);
                request.getTotalDelayStats().addDelay(totalDelay);
                if (processingDelay > 100L) {
                    String reqStr = request.getRequest().toXML().toString();
                    if (VideobridgeConfig.getRedactRemoteAddresses()) {
                        reqStr = RedactColibriIp.Companion.redact(reqStr);
                    }
                    this.logger.warn((Object)("Took " + processingDelay + " ms to process an IQ (total delay " + totalDelay + " ms): " + reqStr));
                }
                this.logger.info((Object)("SENT colibri2 response: " + String.valueOf(response.toXML())));
                request.getCallback().invoke((Object)response);
                if (expire) {
                    videobridge.expireConference(this);
                }
            }
            catch (Throwable e) {
                this.logger.warn((Object)"Failed to handle colibri request: ", e);
                request.getCallback().invoke((Object)ErrorUtilKt.createError((IQ)request.getRequest(), (StanzaError.Condition)StanzaError.Condition.internal_server_error, (String)e.getMessage()));
            }
            return true;
        }){};
        this.speechActivity = new ConferenceSpeechActivity(new SpeechActivityListener());
        this.updateLastNEndpointsFuture = TaskPools.SCHEDULED_POOL.scheduleAtFixedRate(() -> {
            try {
                if (this.speechActivity.updateLastNEndpoints()) {
                    this.lastNEndpointsChangedAsync();
                }
            }
            catch (Exception e) {
                this.logger.warn((Object)"Failed to update lastN endpoints:", (Throwable)e);
            }
        }, 3L, 3L, TimeUnit.SECONDS);
        VideobridgeMetrics.conferencesCreated.inc();
        this.epConnectionStatusMonitor = new EndpointConnectionStatusMonitor(this, TaskPools.SCHEDULED_POOL, this.logger);
        this.epConnectionStatusMonitor.start();
    }

    public void enqueueColibriRequest(XmppConnection.ColibriRequest request) {
        this.colibriQueue.add((Object)request);
    }

    public DiagnosticContext newDiagnosticContext() {
        if (this.conferenceName != null) {
            DiagnosticContext diagnosticContext = new DiagnosticContext();
            diagnosticContext.put((Object)"conf_name", (Object)this.conferenceName.toString());
            diagnosticContext.put((Object)"conf_creation_time_ms", (Object)this.creationTime);
            return diagnosticContext;
        }
        return new NoOpDiagnosticContext();
    }

    public void sendMessage(BridgeChannelMessage msg, List<Endpoint> endpoints, boolean sendToRelays) {
        for (Endpoint endpoint : endpoints) {
            endpoint.sendMessage(msg);
        }
        if (sendToRelays) {
            for (Relay relay : this.relaysById.values()) {
                relay.sendMessage(msg);
            }
        }
    }

    public void sendMessageFromRelay(BridgeChannelMessage msg, boolean sendToEndpoints, @Nullable String meshId) {
        if (sendToEndpoints) {
            for (Endpoint endpoint : this.getLocalEndpoints()) {
                endpoint.sendMessage(msg);
            }
        }
        for (Relay relay : this.relaysById.values()) {
            if (Objects.equals(meshId, relay.getMeshId())) continue;
            relay.sendMessage(msg);
        }
    }

    public void broadcastMessage(BridgeChannelMessage msg, boolean sendToRelays) {
        this.sendMessage(msg, this.getLocalEndpoints(), sendToRelays);
    }

    public void broadcastMessage(BridgeChannelMessage msg) {
        this.broadcastMessage(msg, false);
    }

    public void requestKeyframe(String requesterID, String endpointID, long mediaSsrc) {
        AbstractEndpoint remoteEndpoint = this.getEndpoint(endpointID);
        if (remoteEndpoint != null) {
            remoteEndpoint.requestKeyframe(requesterID, mediaSsrc);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Cannot request keyframe because the endpoint was not found.");
        }
    }

    IQ handleConferenceModifyIQ(ConferenceModifyIQ conferenceModifyIQ) {
        Pair<IQ, Boolean> p = this.colibri2Handler.handleConferenceModifyIQ(conferenceModifyIQ);
        if (((Boolean)p.getSecond()).booleanValue()) {
            this.videobridge.expireConference(this);
        }
        return (IQ)p.getFirst();
    }

    private void lastNEndpointsChangedAsync() {
        TaskPools.IO_POOL.execute(() -> {
            try {
                this.lastNEndpointsChanged();
            }
            catch (Exception e) {
                this.logger.warn((Object)"Failed to handle change in last N endpoints: ", (Throwable)e);
            }
        });
    }

    private void lastNEndpointsChanged() {
        this.endpointsCache.forEach(Endpoint::lastNEndpointsChanged);
    }

    private void recentSpeakersChanged(List<AbstractEndpoint> recentSpeakers, boolean dominantSpeakerChanged, boolean silence) {
        if (!recentSpeakers.isEmpty()) {
            List<String> recentSpeakersIds = recentSpeakers.stream().map(AbstractEndpoint::getId).collect(Collectors.toList());
            this.logger.info((Object)("Recent speakers changed: " + String.valueOf(recentSpeakersIds) + ", dominant speaker changed: " + dominantSpeakerChanged + " silence:" + silence));
            this.broadcastMessage(new DominantSpeakerMessage(recentSpeakersIds, silence));
            if (dominantSpeakerChanged && !silence) {
                VideobridgeMetrics.dominantSpeakerChanges.inc();
                if (this.getEndpointCount() > 2) {
                    this.maybeSendKeyframeRequest(recentSpeakers.get(0));
                }
            }
        }
    }

    private void maybeSendKeyframeRequest(AbstractEndpoint dominantSpeaker) {
        if (dominantSpeaker == null) {
            return;
        }
        boolean anyEndpointInStageView = false;
        HashSet<String> allOnStageSourceNames = new HashSet<String>();
        for (Endpoint otherEndpoint : this.getLocalEndpoints()) {
            if (otherEndpoint == dominantSpeaker) continue;
            allOnStageSourceNames.addAll(otherEndpoint.getOnStageSources());
        }
        for (String onStageSourceName : allOnStageSourceNames) {
            MediaSourceDesc onStageSource;
            AbstractEndpoint owner = this.findSourceOwner(onStageSourceName);
            if (owner == null || (onStageSource = owner.findMediaSourceDesc(onStageSourceName)) == null || onStageSource.getVideoType() != VideoType.CAMERA) continue;
            anyEndpointInStageView = true;
            break;
        }
        if (!anyEndpointInStageView) {
            VideobridgeMetrics.preemptiveKeyframeRequestsSuppressed.inc();
            return;
        }
        VideobridgeMetrics.preemptiveKeyframeRequestsSent.inc();
        double senderRtt = this.getRtt(dominantSpeaker);
        double maxReceiveRtt = this.getMaxReceiverRtt(dominantSpeaker.getId());
        double keyframeDelay = maxReceiveRtt - senderRtt + 10.0;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Scheduling keyframe request from " + dominantSpeaker.getId() + " after a delay of " + keyframeDelay + "ms"));
        }
        TaskPools.SCHEDULED_POOL.schedule(dominantSpeaker::requestKeyframe, (long)keyframeDelay, TimeUnit.MILLISECONDS);
    }

    private double getRtt(AbstractEndpoint endpoint) {
        if (endpoint instanceof Endpoint) {
            Endpoint localDominantSpeaker = (Endpoint)endpoint;
            return localDominantSpeaker.getRtt();
        }
        return 100.0;
    }

    private double getMaxReceiverRtt(String excludedEndpointId) {
        return this.endpointsCache.stream().filter(ep -> !ep.getId().equalsIgnoreCase(excludedEndpointId)).map(Endpoint::getRtt).mapToDouble(Double::valueOf).max().orElse(0.0);
    }

    void expire() {
        if (!this.expired.compareAndSet(false, true)) {
            return;
        }
        this.logger.info((Object)"Expiring.");
        this.colibriQueue.close();
        this.epConnectionStatusMonitor.stop();
        if (this.updateLastNEndpointsFuture != null) {
            this.updateLastNEndpointsFuture.cancel(true);
            this.updateLastNEndpointsFuture = null;
        }
        this.logger.debug(() -> "Expiring endpoints.");
        this.getEndpoints().forEach(AbstractEndpoint::expire);
        this.getRelays().forEach(Relay::expire);
        this.exporter.stop();
        this.speechActivity.expire();
        this.updateStatisticsOnExpire();
    }

    private void updateStatisticsOnExpire() {
        long durationSeconds = Math.round((double)(System.currentTimeMillis() - this.creationTime) / 1000.0);
        VideobridgeMetrics.conferencesCompleted.inc();
        VideobridgeMetrics.totalConferenceSeconds.add(durationSeconds);
        this.logger.info((Object)("expire_conf,duration=" + durationSeconds));
    }

    AbstractEndpoint findEndpointByReceiveSSRC(long receiveSSRC) {
        return this.getEndpoints().stream().filter(ep -> ep.receivesSsrc(receiveSSRC)).findFirst().orElse(null);
    }

    @Nullable
    public AbstractEndpoint getEndpoint(@NotNull String id) {
        return this.endpointsById.get(Objects.requireNonNull(id, "id must be non null"));
    }

    @Nullable
    public Relay getRelay(@NotNull String id) {
        return this.relaysById.get(id);
    }

    @Nullable
    public AbstractEndpoint findSourceOwner(@NotNull String sourceName) {
        for (AbstractEndpoint e : this.endpointsById.values()) {
            if (e.findMediaSourceDesc(sourceName) == null) continue;
            return e;
        }
        return null;
    }

    @NotNull
    public Endpoint createLocalEndpoint(String id, boolean iceControlling, boolean doSsrcRewriting, boolean visitor, boolean privateAddresses) {
        AbstractEndpoint existingEndpoint = this.getEndpoint(id);
        if (existingEndpoint != null) {
            throw new IllegalArgumentException("Local endpoint with ID = " + id + "already created");
        }
        Endpoint endpoint = new Endpoint(id, this, this.logger, iceControlling, doSsrcRewriting, visitor, privateAddresses);
        this.videobridge.localEndpointCreated(visitor);
        endpoint.addEventHandler(() -> this.endpointSourcesChanged(endpoint));
        this.addEndpoints(Collections.singleton(endpoint));
        return endpoint;
    }

    @NotNull
    public Relay createRelay(String id, @Nullable String meshId, boolean iceControlling, boolean useUniquePort) {
        Relay existingRelay = this.getRelay(id);
        if (existingRelay != null) {
            throw new IllegalArgumentException("Relay with ID = " + id + "already created");
        }
        Relay relay = new Relay(id, this, this.logger, meshId, iceControlling, useUniquePort);
        this.relaysById.put(id, relay);
        return relay;
    }

    private void endpointsChanged(boolean includesNonVisitors) {
        if (includesNonVisitors) {
            this.speechActivity.endpointsChanged(this.getNonVisitorEndpoints());
        }
    }

    private void endpointSourcesChanged(@NotNull Endpoint endpoint) {
        this.lastNEndpointsChangedAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEndpointsCache() {
        Object object = this.endpointsCacheLock;
        synchronized (object) {
            ArrayList endpointsList = new ArrayList(this.endpointsById.size());
            this.endpointsById.values().forEach(e -> {
                if (e instanceof Endpoint) {
                    endpointsList.add((Endpoint)e);
                }
            });
            this.endpointsCache = Collections.unmodifiableList(endpointsList);
        }
    }

    public int getEndpointCount() {
        return this.endpointsById.size();
    }

    public int getRelayCount() {
        return this.relaysById.size();
    }

    public int getLocalEndpointCount() {
        return this.getLocalEndpoints().size();
    }

    public List<AbstractEndpoint> getEndpoints() {
        return new ArrayList<AbstractEndpoint>(this.endpointsById.values());
    }

    public List<AbstractEndpoint> getNonVisitorEndpoints() {
        return this.endpointsById.values().stream().filter(ep -> !ep.getVisitor()).collect(Collectors.toList());
    }

    List<AbstractEndpoint> getOrderedEndpoints() {
        return this.speechActivity.getOrderedEndpoints();
    }

    public List<Endpoint> getLocalEndpoints() {
        return this.endpointsCache;
    }

    public List<Relay> getRelays() {
        return new ArrayList<Relay>(this.relaysById.values());
    }

    public final String getID() {
        return this.id;
    }

    @Nullable
    public final String getMeetingId() {
        return this.meetingId;
    }

    @Nullable
    public Endpoint getLocalEndpoint(String id) {
        AbstractEndpoint endpoint = this.getEndpoint(id);
        if (endpoint instanceof Endpoint) {
            return (Endpoint)endpoint;
        }
        return null;
    }

    public ConferenceSpeechActivity getSpeechActivity() {
        return this.speechActivity;
    }

    public final Videobridge getVideobridge() {
        return this.videobridge;
    }

    public boolean isExpired() {
        return this.expired.get();
    }

    public void endpointExpired(AbstractEndpoint endpoint) {
        String id = endpoint.getId();
        AbstractEndpoint removedEndpoint = this.endpointsById.remove(id);
        if (removedEndpoint == null) {
            this.logger.warn((Object)("No endpoint found, id=" + id));
            return;
        }
        if (removedEndpoint instanceof Endpoint) {
            this.updateEndpointsCache();
            this.endpointsById.values().forEach(e -> e.otherEndpointExpired(removedEndpoint));
            this.videobridge.localEndpointExpired(removedEndpoint.getVisitor());
        }
        this.relaysById.forEach((i, relay) -> relay.endpointExpired(id));
        endpoint.getSsrcs().forEach(ssrc -> this.endpointsBySsrc.remove(ssrc, endpoint));
        this.audioSubscriptionManager.removeEndpoint(endpoint.getId());
        this.audioSubscriptionManager.removeSources(new HashSet<AudioSourceDesc>(endpoint.getAudioSources()));
        this.endpointsChanged(removedEndpoint.getVisitor());
    }

    public void relayExpired(Relay relay) {
        String id = relay.getId();
        this.relaysById.remove(id);
        this.getLocalEndpoints().forEach(senderEndpoint -> senderEndpoint.removeReceiver(id));
    }

    public void addEndpoints(Set<AbstractEndpoint> endpoints) {
        endpoints.forEach(endpoint -> {
            if (endpoint.getConference() != this) {
                throw new IllegalArgumentException("Endpoint belong to other conference = " + String.valueOf(endpoint.getConference()));
            }
            AbstractEndpoint replacedEndpoint = this.endpointsById.put(endpoint.getId(), (AbstractEndpoint)endpoint);
            if (replacedEndpoint != null) {
                this.logger.info((Object)("Endpoint with id " + endpoint.getId() + ": " + String.valueOf(replacedEndpoint) + " has been replaced by new endpoint with same id: " + String.valueOf(endpoint)));
            }
        });
        this.updateEndpointsCache();
        boolean hasNonVisitor = endpoints.stream().anyMatch(endpoint -> !endpoint.getVisitor());
        this.endpointsChanged(hasNonVisitor);
    }

    @Override
    public void endpointMessageTransportConnected(@NotNull AbstractEndpoint abstractEndpoint) {
        List<String> recentSpeakers;
        Endpoint endpoint = (Endpoint)abstractEndpoint;
        this.epConnectionStatusMonitor.endpointConnected(endpoint.getId());
        if (!this.isExpired() && !(recentSpeakers = this.speechActivity.getRecentSpeakers()).isEmpty()) {
            endpoint.sendMessage(new DominantSpeakerMessage(recentSpeakers, this.speechActivity.isInSilence()));
        }
    }

    public AbstractEndpoint getEndpointBySsrc(long ssrc) {
        return this.endpointsBySsrc.get(ssrc);
    }

    public void addEndpointSsrc(@NotNull AbstractEndpoint endpoint, long ssrc) {
        AbstractEndpoint oldEndpoint = this.endpointsBySsrc.put(ssrc, endpoint);
        if (oldEndpoint != null && oldEndpoint != endpoint) {
            this.logger.warn((Object)("SSRC " + ssrc + " moved from ep " + oldEndpoint.getId() + " to ep " + endpoint.getId()));
        }
    }

    public List<AudioSourceDesc> getAudioSourceDescs() {
        ArrayList<AudioSourceDesc> descs = new ArrayList<AudioSourceDesc>();
        for (Endpoint endpoint : this.getLocalEndpoints()) {
            descs.addAll(endpoint.getAudioSources());
        }
        return descs;
    }

    @Nullable
    public EntityBareJid getName() {
        return this.conferenceName;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void addAudioSources(Set<AudioSourceDesc> audioSources) {
        this.audioSubscriptionManager.onSourcesAdded(audioSources);
    }

    public void removeAudioSources(Set<AudioSourceDesc> audioSources) {
        this.audioSubscriptionManager.removeSources(audioSources);
    }

    public void setEndpointAudioSubscription(String endpointId, ReceiverAudioSubscriptionMessage subscription) {
        this.audioSubscriptionManager.setEndpointAudioSubscription(endpointId, subscription, this.getAudioSourceDescs());
    }

    public boolean isEndpointAudioWanted(String endpointId, long ssrc) {
        return this.audioSubscriptionManager.isEndpointAudioWanted(endpointId, ssrc);
    }

    private boolean inMultipleMeshes() {
        return this.relaysById.values().stream().map(Relay::getMeshId).collect(Collectors.toSet()).size() > 1;
    }

    public boolean shouldExpire() {
        return this.getEndpointCount() == 0 && !this.inMultipleMeshes() && System.currentTimeMillis() - this.creationTime > 20000L;
    }

    public boolean isRankedSpeaker(AbstractEndpoint ep) {
        if (!LoudestConfig.Companion.getRouteLoudestOnly()) {
            return true;
        }
        return this.speechActivity.isAmongLoudest(ep.getId());
    }

    private void sendOut(PacketInfo packetInfo) {
        String sourceEndpointId = packetInfo.getEndpointId();
        PotentialPacketHandler prevHandler = null;
        for (Endpoint endpoint : this.endpointsCache) {
            if (endpoint.getId().equals(sourceEndpointId) || !endpoint.wants(packetInfo)) continue;
            if (prevHandler != null) {
                prevHandler.send(packetInfo.clone());
            }
            prevHandler = endpoint;
        }
        for (Relay relay : this.relaysById.values()) {
            if (!relay.wants(packetInfo)) continue;
            if (prevHandler != null) {
                prevHandler.send(packetInfo.clone());
            }
            prevHandler = relay;
        }
        if (this.exporter.wants(packetInfo)) {
            if (prevHandler != null) {
                prevHandler.send(packetInfo.clone());
            }
            prevHandler = this.exporter;
        }
        if (prevHandler != null) {
            prevHandler.send(packetInfo);
        } else {
            ByteBufferPool.returnBuffer(packetInfo.getPacket().getBuffer());
        }
    }

    public void setConnects(List<Connect> exports) {
        this.exporter.setConnects(exports);
    }

    public boolean hasRelays() {
        return !this.relaysById.isEmpty();
    }

    public void handleIncomingPacket(PacketInfo packetInfo) {
        Packet packet = packetInfo.getPacket();
        if (packet instanceof RtpPacket) {
            this.sendOut(packetInfo);
        } else if (packet instanceof RtcpFbPliPacket || packet instanceof RtcpFbFirPacket) {
            AbstractEndpoint ep;
            AbstractEndpoint targetEndpoint = null;
            boolean rewriter = false;
            long mediaSsrc = packet instanceof RtcpFbPliPacket ? ((RtcpFbPliPacket)packet).getMediaSourceSsrc() : ((RtcpFbFirPacket)packet).getMediaSenderSsrc();
            String endpointId = packetInfo.getEndpointId();
            if (endpointId != null && (ep = this.getEndpoint(endpointId)) instanceof Endpoint && ((Endpoint)ep).doesSsrcRewriting()) {
                rewriter = true;
                String owner = ((Endpoint)ep).unmapRtcpFbSsrc((RtcpFbPacket)packet);
                if (owner != null) {
                    targetEndpoint = this.getEndpoint(owner);
                }
            }
            if (!rewriter) {
                targetEndpoint = this.findEndpointByReceiveSSRC(mediaSsrc);
            }
            EncodingsManager.EncodingsUpdateListener pph = null;
            if (targetEndpoint instanceof Endpoint) {
                pph = (Endpoint)targetEndpoint;
            } else if (targetEndpoint instanceof RelayedEndpoint) {
                pph = ((RelayedEndpoint)targetEndpoint).getRelay();
            }
            if (pph == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Dropping FIR/PLI for media ssrc " + mediaSsrc));
                }
            } else if (pph.wants(packetInfo)) {
                pph.send(packetInfo);
            }
        } else {
            this.sendOut(packetInfo);
        }
    }

    public boolean levelChanged(@NotNull AbstractEndpoint endpoint, long level) {
        AudioSourceDesc source;
        SpeakerRanking ranking = this.speechActivity.levelChanged(endpoint, level);
        if (ranking == null || !this.routeLoudestOnly) {
            return false;
        }
        if (ranking.isDominant && LoudestConfig.Companion.getAlwaysRouteDominant()) {
            return false;
        }
        if (ranking.energyRanking < LoudestConfig.Companion.getNumLoudest()) {
            return false;
        }
        List<AudioSourceDesc> sources = endpoint.getAudioSources();
        if (!sources.isEmpty() && this.audioSubscriptionManager.isExplicitlySubscribed((source = sources.get(0)).getSourceName())) {
            return false;
        }
        VideobridgeMetrics.tossedPacketsEnergy.getHistogram().observe((double)ranking.energyScore);
        return true;
    }

    public JSONObject getDebugState(@NotNull DebugStateMode mode, @Nullable String endpointId) {
        if (mode == DebugStateMode.STATS && !this.isRtcStatsEnabled) {
            return new JSONObject();
        }
        JSONObject debugState = new JSONObject();
        debugState.put((Object)"id", (Object)this.id);
        debugState.put((Object)"rtcstatsEnabled", (Object)this.isRtcStatsEnabled);
        if (this.conferenceName != null) {
            debugState.put((Object)"name", (Object)this.conferenceName.toString());
        }
        if (this.meetingId != null) {
            debugState.put((Object)"meeting_id", (Object)this.meetingId);
        }
        if (mode == DebugStateMode.FULL) {
            debugState.put((Object)"expired", (Object)this.expired.get());
            debugState.put((Object)"creation_time", (Object)this.creationTime);
        }
        if (mode == DebugStateMode.FULL || mode == DebugStateMode.STATS) {
            debugState.put((Object)"speech_activity", (Object)this.speechActivity.getDebugState(mode));
        }
        JSONObject endpoints = new JSONObject();
        debugState.put((Object)"endpoints", (Object)endpoints);
        for (Endpoint e : this.endpointsCache) {
            if (endpointId != null && !endpointId.equals(e.getId())) continue;
            if (mode == DebugStateMode.SHORT) {
                endpoints.put((Object)e.getId(), (Object)e.getStatsId());
                continue;
            }
            endpoints.put((Object)e.getId(), (Object)e.debugState(mode));
        }
        JSONObject relays = new JSONObject();
        debugState.put((Object)"relays", (Object)relays);
        for (Relay r : this.relaysById.values()) {
            if (mode == DebugStateMode.SHORT) {
                relays.put((Object)r.getId(), (Object)r.getId());
                continue;
            }
            relays.put((Object)r.getId(), (Object)r.debugState(mode));
        }
        if (mode != DebugStateMode.SHORT) {
            debugState.put((Object)"exporter", (Object)this.exporter.debugState());
        }
        return debugState;
    }

    public boolean isP2p() {
        return this.isInactive() && this.getEndpointCount() == 2;
    }

    public boolean isInactive() {
        return this.getEndpoints().stream().noneMatch(e -> e.isSendingAudio() || e.isSendingVideo());
    }

    @NotNull
    public EncodingsManager getEncodingsManager() {
        return this.encodingsManager;
    }

    private void handleTranscriptionMessage(TranscriptionResultEvent transcriptionMessage) {
        try {
            EndpointMessage endpointMessage = new EndpointMessage("");
            endpointMessage.put("msgPayload", transcriptionMessage);
            endpointMessage.put("from", "transcriber");
            this.broadcastMessage(endpointMessage, true);
        }
        catch (Exception e) {
            this.logger.warn((Object)"Failed to broadcast transcription message", (Throwable)e);
        }
    }

    private class SpeechActivityListener
    implements ConferenceSpeechActivity.Listener {
        private SpeechActivityListener() {
        }

        @Override
        public void recentSpeakersChanged(List<AbstractEndpoint> recentSpeakers, boolean dominantSpeakerChanged, boolean silence) {
            Conference.this.recentSpeakersChanged(recentSpeakers, dominantSpeakerChanged, silence);
        }

        @Override
        public void lastNEndpointsChanged() {
            Conference.this.lastNEndpointsChanged();
        }
    }

    static class NoOpTimeSeriesPoint
    extends DiagnosticContext.TimeSeriesPoint {
        public NoOpTimeSeriesPoint() {
            this(Collections.emptyMap());
        }

        public NoOpTimeSeriesPoint(Map<String, Object> m) {
            super(m);
        }

        public Object put(String key, Object value) {
            return null;
        }
    }

    static class NoOpDiagnosticContext
    extends DiagnosticContext {
        NoOpDiagnosticContext() {
        }

        public DiagnosticContext.TimeSeriesPoint makeTimeSeriesPoint(String timeSeriesName, long tsMs) {
            return new NoOpTimeSeriesPoint();
        }

        public Object put(@NotNull String key, @NotNull Object value) {
            return null;
        }
    }
}

