/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.load_management;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.metrics.DoubleGaugeMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.videobridge.load_management.CpuMeasurement;
import org.jitsi.videobridge.load_management.TotalAndSteal;
import org.jitsi.videobridge.metrics.VideobridgeMetricsContainer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\n\u0010\n\u001a\u0004\u0018\u00010\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jitsi/videobridge/load_management/StealDetection;", "", "file", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "previous", "Lorg/jitsi/videobridge/load_management/TotalAndSteal;", "update", "Lorg/jitsi/videobridge/load_management/CpuMeasurement;", "readFromFile", "Companion", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nStealDetection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StealDetection.kt\norg/jitsi/videobridge/load_management/StealDetection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n295#2,2:80\n1617#2,9:82\n1869#2:91\n1870#2:93\n1626#2:94\n1#3:92\n*S KotlinDebug\n*F\n+ 1 StealDetection.kt\norg/jitsi/videobridge/load_management/StealDetection\n*L\n54#1:80,2\n57#1:82,9\n57#1:91\n57#1:93\n57#1:94\n57#1:92\n*E\n"})
public final class StealDetection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;
    @NotNull
    private TotalAndSteal previous;
    @NotNull
    private static final Lazy<DoubleGaugeMetric> stealMetric$delegate = LazyKt.lazy(StealDetection::stealMetric_delegate$lambda$0);
    private static final boolean linux;
    @Nullable
    private static final StealDetection instance;

    public StealDetection(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.previous = new TotalAndSteal(0L, 0L);
    }

    @NotNull
    public final CpuMeasurement update() {
        TotalAndSteal totalAndSteal;
        try {
            TotalAndSteal totalAndSteal2 = this.readFromFile();
            if (totalAndSteal2 == null) {
                return new CpuMeasurement(0.0);
            }
            totalAndSteal = totalAndSteal2;
        }
        catch (Exception e) {
            return new CpuMeasurement(0.0);
        }
        TotalAndSteal current = totalAndSteal;
        if (this.previous.getSteal() == 0L && this.previous.getTotal() == 0L) {
            this.previous = current;
            return new CpuMeasurement(0.0);
        }
        long totalDelta = current.getTotal() - this.previous.getTotal();
        long stealDelta = current.getSteal() - this.previous.getSteal();
        double currentSteal = totalDelta > 0L && stealDelta > 0L ? (double)stealDelta / (double)totalDelta : 0.0;
        this.previous = current;
        DoubleGaugeMetric.set$default((DoubleGaugeMetric)StealDetection.Companion.getStealMetric(), (double)currentSteal, null, (int)2, null);
        return new CpuMeasurement(currentSteal);
    }

    /*
     * WARNING - void declaration
     */
    private final TotalAndSteal readFromFile() {
        Collection destination$iv$iv;
        int element$iv2;
        Object object;
        List list;
        Object v0;
        Regex regex;
        block5: {
            Iterable $this$firstOrNull$iv = FilesKt.readLines$default((File)this.file, null, (int)1, null);
            boolean $i$f$firstOrNull = false;
            regex = $this$firstOrNull$iv.iterator();
            while (regex.hasNext()) {
                Object element$iv2 = regex.next();
                String it = (String)element$iv2;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)"cpu ", (boolean)false, (int)2, null)) continue;
                v0 = element$iv2;
                break block5;
            }
            v0 = null;
        }
        String string = v0;
        if (string != null && (list = (regex = new Regex("\\s+")).split((CharSequence)(object = (CharSequence)string), element$iv2 = 0)) != null && (object = CollectionsKt.drop((Iterable)list, (int)1)) != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable element$iv2 = (Iterable)object;
            boolean $i$f$mapNotNull = false;
            void bl = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Long it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                if (StringsKt.toLongOrNull((String)it) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
        } else {
            return null;
        }
        List cpuLine = (List)destination$iv$iv;
        if (cpuLine.size() < 8) {
            return null;
        }
        return new TotalAndSteal(CollectionsKt.sumOfLong((Iterable)cpuLine), ((Number)cpuLine.get(7)).longValue());
    }

    private static final DoubleGaugeMetric stealMetric_delegate$lambda$0() {
        return MetricsContainer.registerDoubleGauge$default((MetricsContainer)VideobridgeMetricsContainer.Companion.getInstance(), (String)"cpu_steal", (String)"CPU steal fraction (from 0 to 1)", (double)0.0, null, (int)12, null);
    }

    static {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        linux = StringsKt.contains$default((CharSequence)string2, (CharSequence)"linux", (boolean)false, (int)2, null);
        instance = linux ? new StealDetection(new File("/proc/stat")) : null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jitsi/videobridge/load_management/StealDetection$Companion;", "", "<init>", "()V", "stealMetric", "Lorg/jitsi/metrics/DoubleGaugeMetric;", "getStealMetric", "()Lorg/jitsi/metrics/DoubleGaugeMetric;", "stealMetric$delegate", "Lkotlin/Lazy;", "linux", "", "instance", "Lorg/jitsi/videobridge/load_management/StealDetection;", "getInstance", "()Lorg/jitsi/videobridge/load_management/StealDetection;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        private final DoubleGaugeMetric getStealMetric() {
            Lazy lazy = stealMetric$delegate;
            return (DoubleGaugeMetric)lazy.getValue();
        }

        @Nullable
        public final StealDetection getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

