/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tasks;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.tasks.DownloadTask;
import org.tinymediamanager.scraper.imdb.ImdbMovieTrailerProvider;

public abstract class TrailerDownloadTask
extends DownloadTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrailerDownloadTask.class);
    private final MediaTrailer mediaTrailer;

    protected TrailerDownloadTask(MediaTrailer trailer) {
        super(TmmResourceBundle.getString("trailer.download") + " - " + trailer.getName(), trailer.getUrl());
        this.mediaTrailer = trailer;
        this.setTaskDescription(trailer.getName());
    }

    @Override
    protected void doInBackground() {
        if (!this.isFeatureEnabled()) {
            return;
        }
        String url = this.mediaTrailer.getUrl();
        if (url.contains("trailers.apple.com")) {
            LOGGER.warn("Could not download trailer: Apple Trailers has been shut down on 01.09.2023");
            return;
        }
        if (!url.startsWith("http")) {
            String id = this.mediaTrailer.getId();
            if (!id.matches("vi\\d+")) {
                LOGGER.debug("Could not download trailer: id not known {}", (Object)this.mediaTrailer);
                return;
            }
            ImdbMovieTrailerProvider tp = new ImdbMovieTrailerProvider();
            url = tp.getUrlForId(this.mediaTrailer);
            if (url.isEmpty()) {
                LOGGER.debug("Could not download trailer: could not construct url from id {}", (Object)this.mediaTrailer);
                return;
            }
            this.mediaTrailer.setUrl(url);
        }
        super.doInBackground();
    }

    @Override
    protected String getSpecialUserAgent() {
        if ("apple".equalsIgnoreCase(this.mediaTrailer.getProvider())) {
            return "QuickTime";
        }
        return null;
    }

    @Override
    protected void checkDownloadedFile() throws IOException {
        super.checkDownloadedFile();
        BasicFileAttributes view = Files.readAttributes(this.tempFile, BasicFileAttributes.class, new LinkOption[0]);
        if (view.size() < 1000000L) {
            this.cancel = true;
        }
    }
}

