/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.RenamerPreviewContainer;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;

public class TvShowRenamerPreview {
    private final TvShow tvShow;
    private final TvShow clone;
    private final RenamerPreviewContainer container;

    public TvShowRenamerPreview(TvShow tvShow) {
        this.tvShow = tvShow;
        this.clone = new TvShow();
        this.clone.merge(tvShow);
        this.clone.setDataSource(tvShow.getDataSource());
        this.container = new RenamerPreviewContainer(tvShow);
    }

    public RenamerPreviewContainer generatePreview() {
        this.container.newPath = Paths.get(TvShowRenamer.getTvShowFoldername(TvShowModuleManager.getInstance().getSettings().getRenamerTvShowFoldername(), this.tvShow), new String[0]);
        this.clone.setPath(this.container.newPath.toString());
        this.processTvShow();
        this.processSeasons();
        this.processEpisodes();
        HashMap<String, RenamerPreviewContainer.MediaFileTypeContainer> duplicates = new HashMap<String, RenamerPreviewContainer.MediaFileTypeContainer>();
        for (RenamerPreviewContainer.MediaFileTypeContainer files : this.container.getFiles()) {
            for (String rel : files.newFiles) {
                if (duplicates.containsKey(rel)) {
                    files.duped = true;
                    RenamerPreviewContainer.MediaFileTypeContainer other = (RenamerPreviewContainer.MediaFileTypeContainer)duplicates.get(rel);
                    other.duped = true;
                    this.container.renamerProblems = true;
                    continue;
                }
                duplicates.put(rel, files);
            }
        }
        duplicates.clear();
        return this.container;
    }

    private void processTvShow() {
        for (MediaFileType type : MediaFileType.values()) {
            RenamerPreviewContainer.MediaFileTypeContainer c = new RenamerPreviewContainer.MediaFileTypeContainer();
            for (MediaFile typeMf : this.tvShow.getMediaFiles(type)) {
                c.oldFiles.add(this.container.getOldPath().relativize(typeMf.getFileAsPath()).toString());
                MediaFile mediaFileClone = new MediaFile(typeMf);
                mediaFileClone.setPath(typeMf.getPath().replace(this.container.getOldPath().toString(), this.container.getNewPath().toString()));
                List<MediaFile> mfs = TvShowRenamer.generateFilename(this.clone, mediaFileClone);
                for (MediaFile mf : mfs) {
                    c.newFiles.add(this.container.getNewPath().relativize(mf.getFileAsPath()).toString());
                }
            }
            if (c.oldFiles.isEmpty()) continue;
            this.container.addFile(c);
        }
    }

    private void processSeasons() {
        for (TvShowSeason season : this.tvShow.getSeasons()) {
            for (MediaFileType type : MediaFileType.values()) {
                RenamerPreviewContainer.MediaFileTypeContainer c = new RenamerPreviewContainer.MediaFileTypeContainer();
                for (MediaFile typeMf : season.getMediaFiles(type)) {
                    c.oldFiles.add(this.container.getOldPath().relativize(typeMf.getFileAsPath()).toString());
                    List<MediaFile> mfs = TvShowRenamer.generateSeasonFilenames(this.clone, season, new MediaFile(typeMf));
                    for (MediaFile mf : mfs) {
                        c.newFiles.add(this.container.getNewPath().relativize(mf.getFileAsPath()).toString());
                    }
                }
                if (c.oldFiles.isEmpty()) continue;
                this.container.addFile(c);
            }
        }
    }

    private void processEpisodes() {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>(this.tvShow.getEpisodes());
        Collections.sort(episodes);
        ArrayList<Path> multiCache = new ArrayList<Path>();
        for (TvShowEpisode episode : episodes) {
            Path main = episode.getMainFile().getFileAsPath();
            if (multiCache.contains(main)) continue;
            multiCache.add(main);
            String oldVideoBasename = episode.getVideoBasenameWithoutStacking();
            RenamerPreviewContainer.MediaFileTypeContainer c = new RenamerPreviewContainer.MediaFileTypeContainer();
            for (MediaFile typeMf : episode.getMediaFiles()) {
                c.oldFiles.add(this.container.getOldPath().relativize(typeMf.getFileAsPath()).toString());
                List<MediaFile> mfs = TvShowRenamer.generateEpisodeFilenames(this.clone, new MediaFile(typeMf), oldVideoBasename);
                for (MediaFile mf : mfs) {
                    c.newFiles.add(this.container.getNewPath().relativize(mf.getFileAsPath()).toString());
                }
            }
            if (c.oldFiles.isEmpty()) continue;
            this.container.addFile(c);
        }
    }
}

