/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Version {
    private final String hash;
    private final Date date;
    private final Branch branch;
    private final Type type;
    private static Version VERSION;

    public static Version get() {
        if (VERSION == null) {
            VERSION = new Version("72a7730", "2016-02-21 16:48:48 -0700", Branch.JARVIS, Type.RELEASE);
        }
        return VERSION;
    }

    private Version(String string, String string2, Branch branch, Type type) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.US);
        this.hash = string;
        try {
            this.date = simpleDateFormat.parse(string2);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Date must be in the form: yyyy-MM-dd HH:mm:ss Z (like: 2012-11-10 09:33:15 +0100).");
        }
        this.branch = branch;
        this.type = type;
    }

    public String getHash() {
        return this.hash;
    }

    public Date getDate() {
        return this.date;
    }

    public Branch getBranch() {
        return this.branch;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.hash + " (" + this.branch.toString().toLowerCase(Locale.US) + ")";
    }

    public static enum Branch {
        EDEN,
        FRODO,
        GOTHAM,
        HELIX,
        ISENGARD,
        JARVIS,
        KRYPTON,
        LEIA,
        MATRIX,
        NEXUS,
        MASTER,
        UNKNOWN;

    }

    public static enum Type {
        SNAPSHOT,
        NIGHTLY,
        RELEASE,
        BETA,
        RC,
        UNKNOWN;

    }
}

