/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import ca.odell.glazedlists.EventList;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.dialogs.TextDialog;
import org.tinymediamanager.ui.renderer.RightAlignTableCellRenderer;

public class MediaFilesPanel
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaFilesPanel.class);
    private TmmTable tableFiles;
    private final EventList<MediaFile> mediaFileEventList;

    public MediaFilesPanel(EventList<MediaFile> mediaFiles) {
        this.mediaFileEventList = mediaFiles;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("insets 0", "[200lp:450lp,grow]", "[100lp:300lp,grow]"));
        TmmTableModel<MediaFile> tableModel = new TmmTableModel<MediaFile>(this.mediaFileEventList, new MediaTableFormat());
        this.tableFiles = new TmmTable((TableModel)((Object)tableModel));
        this.tableFiles.setAutoResizeMode(0);
        LinkListener linkListener = new LinkListener();
        this.tableFiles.addMouseListener(linkListener);
        this.tableFiles.addMouseMotionListener(linkListener);
        JScrollPane scrollPaneFiles = new JScrollPane();
        this.tableFiles.configureScrollPane(scrollPaneFiles);
        this.add((Component)scrollPaneFiles, "cell 0 0,grow");
        scrollPaneFiles.setViewportView(this.tableFiles);
    }

    public void installTmmUILayoutStore(String parentId) {
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            this.tableFiles.setName(parentId + ".mediaFilesTable");
            TmmUILayoutStore.getInstance().install(this.tableFiles);
        }
    }

    public void adjustColumns() {
        this.tableFiles.adjustColumnPreferredWidths(6);
    }

    private static class MediaTableFormat
    extends TmmTableFormat<MediaFile> {
        MediaTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, "", "open", mediaFile -> {
                if (mediaFile.isVideo()) {
                    return IconManager.PLAY;
                }
                if (mediaFile.isGraphic()) {
                    return IconManager.SEARCH;
                }
                if (mediaFile.isMusicTheme()) {
                    return IconManager.MUSIC;
                }
                if (mediaFile.isTextual()) {
                    return IconManager.NFO_BLUE;
                }
                return null;
            }, ImageIcon.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.filename"), "filename", MediaFile::getFilename, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.mediafiletype"), "filetype", mediaFile -> this.getMediaFileTypeLocalized(mediaFile.getType()), String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.size"), "filesize", mediaFile -> Utils.formatFileSizeForDisplay(mediaFile.getFilesize()), String.class);
            col.setCellRenderer(new RightAlignTableCellRenderer());
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.title"), "title", MediaFile::getTitle, String.class);
            col.setDefaultHidden(true);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.videocodec"), "videocodec", MediaFile::getVideoCodec, String.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.audiocodec"), "audiocodec", MediaFile::getAudioCodecListAsAstring, String.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.resolution"), "resolution", MediaFile::getVideoResolution, String.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.runtime"), "runtime", MediaFile::getDurationHMS, String.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.subtitle"), "subtitle", MediaFile::getSubtitlesAsString, String.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.filecreationdate"), "filecreationdate", mediaFile -> this.formatDate(mediaFile.getDateCreated()), String.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.filelastmodifieddate"), "filelastmodifieddate", mediaFile -> this.formatDate(mediaFile.getDateLastModified()), String.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
        }

        private String getMediaFileTypeLocalized(MediaFileType type) {
            String prop = "mediafiletype." + type.name().toLowerCase(Locale.ROOT);
            return TmmResourceBundle.getString(prop);
        }

        private String formatDate(Date date) {
            if (date == null) {
                return "";
            }
            return TmmDateFormat.MEDIUM_DATE_SHORT_TIME_FORMAT.format(date);
        }
    }

    private class LinkListener
    implements MouseListener,
    MouseMotionListener {
        private LinkListener() {
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            int col = MediaFilesPanel.this.tableFiles.columnAtPoint(arg0.getPoint());
            if (col == 0) {
                int row = MediaFilesPanel.this.tableFiles.rowAtPoint(arg0.getPoint());
                MediaFile mf = (MediaFile)MediaFilesPanel.this.mediaFileEventList.get(row = MediaFilesPanel.this.tableFiles.convertRowIndexToModel(row));
                if (mf.isVideo()) {
                    try {
                        TmmUIHelper.openFile(MediaFileHelper.getMainVideoFile(mf));
                    }
                    catch (Exception ex) {
                        LOGGER.error("Could not open file manager - '{}'", (Object)ex.getMessage());
                        MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf, "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
                    }
                } else if (mf.isMusicTheme()) {
                    try {
                        TmmUIHelper.openFile(mf.getFileAsPath());
                    }
                    catch (Exception ex) {
                        LOGGER.error("Could not open file manager - '{}'", (Object)ex.getMessage());
                        MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf, "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
                    }
                } else if (mf.isGraphic()) {
                    MainWindow.getInstance().createLightbox(mf.getFileAsPath().toString(), "");
                } else if (mf.isTextual()) {
                    String text;
                    try {
                        text = Utils.readFileToString(mf.getFileAsPath());
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingfound"));
                        return;
                    }
                    TextDialog textDialog = new TextDialog(mf.getFilename(), text);
                    textDialog.setLocationRelativeTo(MainWindow.getInstance());
                    ((Dialog)textDialog).setVisible(true);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col == 0) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0) {
                table.setCursor(new Cursor(0));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0 && table.getCursor().getType() == 12) {
                table.setCursor(new Cursor(0));
            }
            if (col == 0 && table.getCursor().getType() == 0) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
        }
    }
}

