/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractFileVisitor;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaSource;
import org.tinymediamanager.core.movie.MovieArtworkHelper;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieMediaFileComparator;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.connector.MovieNfoParser;
import org.tinymediamanager.core.movie.connector.MovieSetNfoParser;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.tasks.MediaFileInformationFetcherTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.thirdparty.VSMeta;
import org.tinymediamanager.thirdparty.trakttv.MovieSyncTraktTvTask;

public class MovieUpdateDatasourceTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieUpdateDatasourceTask.class);
    private static long preDir = 0L;
    private static long postDir = 0L;
    private static long visFile = 0L;
    private static long preDirAll = 0L;
    private static long postDirAll = 0L;
    private static long visFileAll = 0L;
    private static final List<String> SKIP_FOLDERS = Arrays.asList(".", "..", "CERTIFICATE", "$RECYCLE.BIN", "RECYCLER", "SYSTEM VOLUME INFORMATION", "@EADIR", "ADV_OBJ", "PLEX VERSIONS", "LOST.DIR");
    private static final String SKIP_REGEX = "(?i)^[.@](?!45|buelos)[\\w@]+.*";
    public static final String FOLDER_STRUCTURE = "(?i)^(\\w|\\d{4}|\\d{4}s|\\d{4}\\-\\d{4})$";
    private static final Pattern VIDEO_3D_PATTERN = Pattern.compile("(?i)[ .,_\\(\\[-]3D[ .,_\\)\\]-]?");
    private final List<String> dataSources;
    private final List<Pattern> skipFolders = new ArrayList<Pattern>();
    private final List<Movie> moviesToUpdate = new ArrayList<Movie>();
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();
    private final Set<Path> filesFound = new HashSet<Path>();
    private final ReentrantReadWriteLock fileLock = new ReentrantReadWriteLock();
    private final List<Runnable> miTasks = Collections.synchronizedList(new ArrayList());
    private final List<Path> existingMovies = new ArrayList<Path>();
    private final List<MediaFile> imageFiles = new ArrayList<MediaFile>();
    private final ConcurrentMap<Path, BasicFileAttributes> fsAttrCache = new ConcurrentHashMap<Path, BasicFileAttributes>();

    public MovieUpdateDatasourceTask() {
        this((Collection<String>)MovieModuleManager.getInstance().getSettings().getMovieDataSource());
    }

    public MovieUpdateDatasourceTask(Collection<String> datasources) {
        super(TmmResourceBundle.getString("update.datasource"));
        this.dataSources = new ArrayList<String>(datasources);
        this.init();
    }

    public MovieUpdateDatasourceTask(String datasource) {
        super(TmmResourceBundle.getString("update.datasource") + " (" + datasource + ")");
        this.dataSources = new ArrayList<String>(1);
        this.dataSources.add(datasource);
        this.init();
    }

    public MovieUpdateDatasourceTask(List<Movie> movies) {
        super(TmmResourceBundle.getString("update.datasource"));
        this.dataSources = new ArrayList<String>(0);
        this.moviesToUpdate.addAll(movies);
        this.init();
    }

    private void init() {
        for (String skipFolder : MovieModuleManager.getInstance().getSettings().getSkipFolder()) {
            try {
                Pattern pattern = Pattern.compile(skipFolder);
                this.skipFolders.add(pattern);
            }
            catch (Exception e) {
                try {
                    LOGGER.debug("no valid skip pattern - '{}'", (Object)skipFolder);
                    Pattern pattern = Pattern.compile(Pattern.quote(skipFolder));
                    this.skipFolders.add(pattern);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void doInBackground() {
        Utils.removeEmptyStringsFromList(this.dataSources);
        if (this.dataSources.isEmpty() && this.moviesToUpdate.isEmpty()) {
            LOGGER.info("no datasource to update");
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, "update.datasource", "update.datasource.nonespecified"));
            return;
        }
        preDir = 0L;
        postDir = 0L;
        visFile = 0L;
        preDirAll = 0L;
        postDirAll = 0L;
        visFileAll = 0L;
        for (Movie movie : this.movieList.getMovies()) {
            this.existingMovies.add(movie.getPathNIO());
        }
        try {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            this.updateMovieSets();
            if (this.moviesToUpdate.isEmpty()) {
                this.updateDatasource();
            } else {
                this.updateMovies();
            }
            if (!this.imageFiles.isEmpty()) {
                this.imageFiles.forEach(ImageCache::cacheImageAsync);
            }
            if (MovieModuleManager.getInstance().getSettings().getSyncTrakt()) {
                MovieSyncTraktTvTask task = new MovieSyncTraktTvTask(MovieModuleManager.getInstance().getMovieList().getMovies());
                task.setSyncCollection(MovieModuleManager.getInstance().getSettings().getSyncTraktCollection());
                task.setSyncWatched(MovieModuleManager.getInstance().getSettings().getSyncTraktWatched());
                task.setSyncRating(MovieModuleManager.getInstance().getSettings().getSyncTraktRating());
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            this.movieList.reevaluateMMD();
            stopWatch.stop();
            LOGGER.info("Finished updating data sources :) - took {} ms", (Object)stopWatch);
        }
        catch (Exception e) {
            LOGGER.error("Could not update movie data data sources - '{}'", (Object)e.getMessage());
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, "update.datasource", "message.update.threadcrashed"));
        }
        finally {
            this.fsAttrCache.clear();
        }
    }

    private void updateDatasource() {
        if (MovieModuleManager.getInstance().getSettings().isResetNewFlagOnUds()) {
            this.movieList.getMovies().forEach(movie -> movie.setNewlyAdded(false));
        }
        for (String ds : this.dataSources) {
            this.fsAttrCache.clear();
            Path dsAsPath = Paths.get(ds, new String[0]);
            if (this.isInSkipFolder(dsAsPath)) {
                LOGGER.warn("Datasource '{}' is also a skip folder - skipping", (Object)ds);
                continue;
            }
            LOGGER.info("Starting \"update data sources\" on datasource: {}", (Object)ds);
            this.miTasks.clear();
            this.initThreadPool(3, "update");
            this.setTaskName(TmmResourceBundle.getString("update.datasource") + " '" + ds + "'");
            this.publishState();
            if (!Files.exists(dsAsPath, new LinkOption[0])) {
                LOGGER.warn("Data source '{}' is not available - skipping", (Object)dsAsPath);
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                continue;
            }
            this.publishState();
            ArrayList<Path> newMovieDirs = new ArrayList<Path>();
            ArrayList<Path> existingMovieDirs = new ArrayList<Path>();
            List<Path> rootList = this.listFilesAndDirs(dsAsPath);
            LOGGER.debug("Found '{}' files/folders in the data source", (Object)rootList.size());
            if (rootList.isEmpty() && !SystemUtils.IS_OS_WINDOWS) {
                boolean isEmpty = true;
                try {
                    isEmpty = Utils.isFolderEmpty(dsAsPath);
                }
                catch (Exception e) {
                    LOGGER.warn("Could not check folder '{}' for emptiness - '{}'", (Object)dsAsPath, (Object)e.getMessage());
                }
                if (isEmpty) {
                    MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                    continue;
                }
            }
            TreeSet<Path> rootFiles = new TreeSet<Path>();
            for (Path path : rootList) {
                boolean isDir;
                BasicFileAttributes attr = (BasicFileAttributes)this.fsAttrCache.get(path);
                boolean bl = isDir = attr != null ? attr.isDirectory() : Files.isDirectory(path, new LinkOption[0]);
                if (isDir) {
                    String name = path.getFileName().toString();
                    if (name.equalsIgnoreCase("BDMV") || name.equalsIgnoreCase("VIDEO_TS") || name.equalsIgnoreCase("HVDVD_TS")) {
                        MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.discfolderinroot", new String[]{path.toString()}));
                        continue;
                    }
                    if (this.existingMovies.contains(path)) {
                        existingMovieDirs.add(path);
                        continue;
                    }
                    newMovieDirs.add(path);
                    continue;
                }
                rootFiles.add(path);
            }
            rootList.clear();
            this.publishState();
            LOGGER.debug("Processing '{}' existing, '{}' new movies and '{}' root files", new Object[]{existingMovieDirs.size(), newMovieDirs.size(), rootFiles.size()});
            for (Path path : newMovieDirs) {
                this.searchAndParse(dsAsPath.toAbsolutePath(), path, Integer.MAX_VALUE);
            }
            for (Path path : existingMovieDirs) {
                this.searchAndParse(dsAsPath.toAbsolutePath(), path, Integer.MAX_VALUE);
            }
            if (!rootFiles.isEmpty()) {
                this.submitTask(new ParseMultiMovieDirTask(dsAsPath.toAbsolutePath(), dsAsPath.toAbsolutePath(), new ArrayList<Path>(rootFiles)));
            }
            this.waitForCompletionOrCancel();
            LOGGER.info("Files found: {}", (Object)this.filesFound.size());
            LOGGER.info("Movies found: {}", (Object)this.movieList.getMovieCount());
            LOGGER.debug("PreDir: {}", (Object)preDir);
            LOGGER.debug("PostDir: {}", (Object)postDir);
            LOGGER.debug("VisFile: {}", (Object)visFile);
            LOGGER.debug("PreDirAll: {}", (Object)preDirAll);
            LOGGER.debug("PostDirAll: {}", (Object)postDirAll);
            LOGGER.debug("VisFileAll: {}", (Object)visFileAll);
            newMovieDirs.clear();
            existingMovieDirs.clear();
            rootFiles.clear();
            if (this.cancel) break;
            this.cleanup(ds);
            if (StringUtils.isNotBlank((CharSequence)Settings.getInstance().getKodiHost())) {
                TmmTaskManager.getInstance().addUnnamedTask(() -> KodiRPC.getInstance().updateMovieMappings());
            }
            this.gatherMediainfo(ds);
            if (this.cancel) break;
            if (!Settings.getInstance().isImageCache() || !MovieModuleManager.getInstance().getSettings().isBuildImageCacheOnImport()) continue;
            for (Movie movie2 : this.movieList.getMovies()) {
                if (!dsAsPath.equals(Paths.get(movie2.getDataSource(), new String[0]))) continue;
                for (MediaFile imageFile : movie2.getImagesToCache()) {
                    if (ImageCache.isImageCached(imageFile.getFileAsPath())) continue;
                    this.imageFiles.add(imageFile);
                }
            }
        }
    }

    private void updateMovieSets() {
        if (StringUtils.isBlank((CharSequence)MovieModuleManager.getInstance().getSettings().getMovieSetDataFolder())) {
            return;
        }
        LOGGER.info("Start \"update data sources\" for movie sets");
        Set<Path> movieSetFiles = this.getAllFilesRecursiveButNoDiscFiles(Paths.get(MovieModuleManager.getInstance().getSettings().getMovieSetDataFolder(), new String[0]));
        for (Path path : movieSetFiles) {
            if (!FilenameUtils.isExtension((String)path.getFileName().toString(), (String)"nfo")) continue;
            try {
                MediaFile mf;
                MovieSet movieSetInDb;
                MovieSetNfoParser nfoParser = MovieSetNfoParser.parseNfo(path);
                MovieSet movieSet = nfoParser.toMovieSet();
                if (StringUtils.isBlank((CharSequence)movieSet.getTitle())) {
                    movieSet.setTitle(FilenameUtils.getBaseName((String)path.getFileName().toString()));
                }
                if ((movieSetInDb = this.matchMovieSetInDb(path, movieSet)) != null) {
                    if (movieSetInDb.isLocked()) continue;
                    mf = new MediaFile(path);
                    movieSetInDb.addToMediaFiles(mf);
                    this.miTasks.add(new MovieMediaFileInformationFetcherTask(mf, movieSetInDb, true));
                    continue;
                }
                mf = new MediaFile(path);
                movieSet.addToMediaFiles(mf);
                this.miTasks.add(new MovieMediaFileInformationFetcherTask(mf, movieSet, true));
                MovieModuleManager.getInstance().getMovieList().addMovieSet(movieSet);
            }
            catch (Exception e) {
                LOGGER.debug("Could not parse movie set NFO '{}' - '{}'", (Object)path.getFileName(), (Object)e.getMessage());
            }
        }
    }

    private MovieSet matchMovieSetInDb(Path nfoFile, MovieSet movieSetFromNfo) {
        List<MovieSet> existingMovieSets = MovieModuleManager.getInstance().getMovieList().getMovieSetList();
        MediaFile foundNfo = new MediaFile(nfoFile);
        for (MovieSet movieSetInDb : existingMovieSets) {
            List<MediaFile> nfos = movieSetInDb.getMediaFiles(MediaFileType.NFO);
            if (!nfos.contains(foundNfo)) continue;
            return movieSetInDb;
        }
        int tmdbId = movieSetFromNfo.getTmdbId();
        if (tmdbId > 0) {
            for (MovieSet movieSetInDb : existingMovieSets) {
                int id = movieSetInDb.getTmdbId();
                if (id != tmdbId) continue;
                return movieSetInDb;
            }
        }
        for (MovieSet movieSetInDb : existingMovieSets) {
            if (!movieSetFromNfo.getTitle().equals(movieSetInDb.getTitle())) continue;
            return movieSetInDb;
        }
        return null;
    }

    private void updateMovies() {
        LOGGER.info("Start \"update data sources\" for selected movies");
        this.fsAttrCache.clear();
        this.initThreadPool(3, "update");
        this.setTaskName(TmmResourceBundle.getString("update.datasource"));
        this.publishState();
        HashSet movieDatasources = new HashSet();
        this.moviesToUpdate.stream().filter(movie -> !movie.isLocked()).forEach(movie -> movieDatasources.add(movie.getDataSource()));
        ArrayList<Movie> moviesToCleanup = new ArrayList<Movie>();
        for (String ds : movieDatasources) {
            Path dsAsPath = Paths.get(ds, new String[0]);
            if (!Files.exists(dsAsPath, new LinkOption[0])) {
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                continue;
            }
            List<Path> rootList = this.listFilesAndDirs(dsAsPath);
            if (rootList.isEmpty() && !SystemUtils.IS_OS_WINDOWS) {
                boolean isEmpty = true;
                try {
                    isEmpty = Utils.isFolderEmpty(dsAsPath);
                }
                catch (Exception e) {
                    LOGGER.warn("Could not check folder '{}' for emptiness - '{}'", (Object)dsAsPath, (Object)e.getMessage());
                }
                if (isEmpty) {
                    MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                    continue;
                }
            }
            LinkedHashSet<Path> movieDirs = new LinkedHashSet<Path>();
            for (Movie movie2 : this.moviesToUpdate) {
                if (!movie2.getDataSource().equals(ds)) continue;
                movieDirs.add(movie2.getPathNIO());
                moviesToCleanup.add(movie2);
                if (!MovieModuleManager.getInstance().getSettings().isResetNewFlagOnUds()) continue;
                movie2.setNewlyAdded(false);
            }
            for (Path path : movieDirs) {
                this.submitTask(new FindMovieTask(path, Paths.get(ds, new String[0])));
            }
        }
        this.waitForCompletionOrCancel();
        LOGGER.info("Files found: {}", (Object)this.filesFound.size());
        LOGGER.info("Movies found: {}", (Object)this.movieList.getMovieCount());
        LOGGER.debug("PreDir: {}", (Object)preDir);
        LOGGER.debug("PostDir: {}", (Object)postDir);
        LOGGER.debug("VisFile: {}", (Object)visFile);
        LOGGER.debug("PreDirAll: {}", (Object)preDirAll);
        LOGGER.debug("PostDirAll: {}", (Object)postDirAll);
        LOGGER.debug("VisFileAll: {}", (Object)visFileAll);
        this.cleanup(moviesToCleanup);
        this.gatherMediainfo(moviesToCleanup);
    }

    private void parseMovieDirectory(Path movieDir, Path dataSource) {
        LOGGER.trace("Parsing '{}'", (Object)movieDir);
        this.publishState(movieDir.toString());
        List<Path> movieDirList = this.listFilesAndDirs(movieDir);
        ArrayList<Path> files = new ArrayList<Path>();
        HashSet<String> normalizedVideoFiles = new HashSet<String>();
        boolean isDiscFolder = false;
        boolean isMultiMovieDir = false;
        boolean videoFileFound = false;
        Path movieRoot = movieDir;
        for (Path path : movieDirList) {
            LOGGER.trace("found file {}", (Object)path);
            if (Utils.isRegularFile(path)) {
                files.add(path.toAbsolutePath());
                MediaFile mf = new MediaFile();
                mf.setPath(path.getParent().toString());
                mf.setFilename(path.getFileName().toString());
                mf.setType(MediaFileHelper.parseMediaFileType(path, movieDir));
                LOGGER.trace("identified as {}", (Object)mf.getType());
                if (mf.getType() != MediaFileType.VIDEO) continue;
                videoFileFound = true;
                if (mf.isDiscFile()) {
                    isDiscFolder = true;
                    break;
                }
                String basename = FilenameUtils.getBaseName((String)mf.getFilename());
                String stack = Utils.getStackingMarker(mf.getFilename());
                if (!stack.isEmpty() && basename.endsWith(stack)) {
                    LOGGER.trace("Found stacking marker {} inf file {} - removing", (Object)stack, (Object)mf.getFilename());
                    basename = FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(mf.getFilename()));
                }
                if (basename.isEmpty()) {
                    basename = "empty";
                }
                normalizedVideoFiles.add(basename);
                continue;
            }
            String name = path.getFileName().toString();
            if (!name.equalsIgnoreCase("BDMV") && !name.equalsIgnoreCase("VIDEO_TS") && !name.equalsIgnoreCase("HVDVD_TS")) continue;
            videoFileFound = true;
            isDiscFolder = true;
        }
        if (!videoFileFound) {
            LOGGER.trace("hmm - we found no video file in this folder: '{}'", (Object)movieDir);
            return;
        }
        if (isDiscFolder) {
            Path relative = dataSource.relativize(movieDir);
            String folder = relative.toString().toUpperCase(Locale.ROOT);
            while (relative.getNameCount() > 1 && (folder.contains("VIDEO_TS") || folder.contains("BDMV") || folder.contains("HVDVD_TS"))) {
                movieDir = movieDir.getParent();
                relative = dataSource.relativize(movieDir);
                folder = relative.toString().toUpperCase(Locale.ROOT);
            }
            movieRoot = movieDir;
        } else {
            if (normalizedVideoFiles.isEmpty()) {
                return;
            }
            if (normalizedVideoFiles.size() > 1 || movieDir.equals(dataSource)) {
                isMultiMovieDir = true;
            }
        }
        if (this.cancel) {
            return;
        }
        if (isMultiMovieDir) {
            this.createMultiMovieFromDir(dataSource, movieRoot, files);
        } else {
            this.createSingleMovieFromDir(dataSource, movieRoot, isDiscFolder);
        }
    }

    public static Movie parseNFOs(List<MediaFile> mfs) {
        Movie movie = null;
        for (MediaFile mf : mfs) {
            if (mf.getType() != MediaFileType.NFO) continue;
            LOGGER.trace("| parsing NFO {}", (Object)mf.getFileAsPath());
            Movie nfo = null;
            try {
                MovieNfoParser movieNfoParser = MovieNfoParser.parseNfo(mf.getFileAsPath());
                nfo = movieNfoParser.toMovie();
            }
            catch (Exception e) {
                LOGGER.debug("problem parsing NFO: {}", (Object)e.getMessage());
            }
            if (movie == null) {
                movie = nfo == null ? new Movie() : nfo;
            } else {
                movie.merge(nfo);
            }
            if (!movie.getImdbId().isEmpty() && movie.getTmdbId() != 0) continue;
            try {
                String content = Utils.readFileToString(mf.getFileAsPath());
                String imdb = ParserUtils.detectImdbId(content);
                if (movie.getImdbId().isEmpty() && !imdb.isEmpty()) {
                    LOGGER.debug("| Found IMDB id: {}", (Object)imdb);
                    movie.setImdbId(imdb);
                }
                String tmdb = StrgUtils.substr(content, "themoviedb\\.org\\/movie\\/(\\d+)");
                if (movie.getTmdbId() != 0 || tmdb.isEmpty()) continue;
                LOGGER.debug("| Found TMDB id: {}", (Object)tmdb);
                movie.setTmdbId(MetadataUtil.parseInt(tmdb, 0));
            }
            catch (IOException e) {
                LOGGER.debug("| couldn't read NFO {}", (Object)mf);
            }
        }
        for (MediaFile mf : mfs) {
            if (mf.getType() != MediaFileType.VSMETA) continue;
            if (movie == null) {
                movie = new Movie();
            }
            VSMeta vsmeta = new VSMeta(mf.getFileAsPath());
            vsmeta.parseFile();
            movie.merge(vsmeta.getMovie());
        }
        if (movie == null) {
            for (MediaFile mf : mfs) {
                if (!"xml".equalsIgnoreCase(mf.getExtension())) continue;
                try {
                    MovieNfoParser movieNfoParser = MovieNfoParser.parseNfo(mf.getFileAsPath());
                    if (!StringUtils.isNotBlank((CharSequence)movieNfoParser.title)) continue;
                    movie = movieNfoParser.toMovie();
                }
                catch (Exception exception) {}
            }
        }
        return movie;
    }

    private void createSingleMovieFromDir(Path dataSource, Path movieDir, boolean isDiscFolder) {
        boolean bl;
        List<MediaFile> vid;
        Movie movie;
        LOGGER.debug("Parsing single movie directory: {}, (are we a disc folder? {})", (Object)movieDir, (Object)isDiscFolder);
        Path relative = dataSource.relativize(movieDir);
        if (!Utils.getFolderStackingMarker(relative.toString()).isEmpty() && Utils.getFolderStackingMarker(relative.toString()).equals(movieDir.getFileName().toString())) {
            movieDir = movieDir.getParent();
        }
        if ((movie = this.movieList.findFirstByPath(movieDir)) != null && movie.isLocked()) {
            LOGGER.warn("Movie '{}' found in \"update data source\", but is locked", (Object)movie.getPath());
            return;
        }
        Set<Path> allFiles = this.getAllFilesRecursiveButNoDiscFiles(movieDir);
        this.fileLock.writeLock().lock();
        this.filesFound.add(movieDir.toAbsolutePath());
        this.filesFound.addAll(allFiles);
        this.fileLock.writeLock().unlock();
        ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
        for (Path file : allFiles) {
            mfs.add(new MediaFile(file));
        }
        if (movie == null) {
            LOGGER.debug("| movie not found; looking for NFOs");
            movie = MovieUpdateDatasourceTask.parseNFOs(mfs);
            if (movie == null) {
                movie = new Movie();
            }
            movie.setNewlyAdded(true);
        }
        movie.setDisc(isDiscFolder);
        String bdinfoTitle = "";
        String bdmtTitle = "";
        String videoName = "";
        for (MediaFile mediaFile : mfs) {
            if (mediaFile.getType() == MediaFileType.TEXT) {
                try {
                    String txtFile = Utils.readFileToString(mediaFile.getFileAsPath());
                    String bdinfo = StrgUtils.substr(txtFile, ".*Disc Title:\\s+(.*?)[\\n\\r]");
                    if (!bdinfo.isEmpty()) {
                        LOGGER.debug("| Found Disc Title in BDInfo.txt: {}", (Object)bdinfo);
                        bdinfoTitle = StrgUtils.capitalize(bdinfo);
                    }
                    String imdb = ParserUtils.detectImdbId(txtFile);
                    if (!movie.getImdbId().isEmpty() || imdb.isEmpty()) continue;
                    LOGGER.debug("| Found IMDB id: {}", (Object)imdb);
                    movie.setImdbId(imdb);
                }
                catch (Exception e) {
                    LOGGER.debug("| couldn't read TXT {}", (Object)mediaFile.getFilename());
                }
                continue;
            }
            if (mediaFile.getType() != MediaFileType.VIDEO) continue;
            videoName = mediaFile.getBasename();
        }
        if (isDiscFolder) {
            Path bdmt = movieDir.resolve("BDMV/META/DL/bdmt_eng.xml");
            if (Files.exists(bdmt, new LinkOption[0])) {
                try {
                    String string = Utils.readFileToString(bdmt);
                    String name = StrgUtils.substr(string, "di:name\\>(.*?)\\<");
                    if (!name.isEmpty()) {
                        LOGGER.debug("| Found Disc Title in Bluray META folder: {}", (Object)name);
                        bdmtTitle = name;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            videoName = movieDir.getFileName().toString();
        }
        if (movie.getTitle().isEmpty()) {
            Object video = null;
            if (movieDir.getFileName().toString().matches(FOLDER_STRUCTURE) || MediaGenres.containsGenre(movieDir.getFileName().toString())) {
                this.createMultiMovieFromDir(dataSource, movieDir, new ArrayList<Path>(allFiles));
                return;
            }
            video = ParserUtils.detectCleanTitleAndYear(movieDir.getFileName().toString(), MovieModuleManager.getInstance().getSettings().getBadWord());
            movie.setTitle(StrgUtils.replaceUnicodeCharactersInverse(Utils.removeSortableName(video[0])));
            if (!video[1].isEmpty()) {
                try {
                    movie.setYear(Integer.parseInt(video[1]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (StringUtils.isNotBlank((CharSequence)bdmtTitle)) {
                video = ParserUtils.detectCleanTitleAndYear(bdmtTitle, MovieModuleManager.getInstance().getSettings().getBadWord());
                if (!((String)video[0]).isEmpty()) {
                    movie.setTitle(StrgUtils.replaceUnicodeCharactersInverse(Utils.removeSortableName((String)video[0])));
                }
                if (!((String)video[1]).isEmpty()) {
                    try {
                        movie.setYear(Integer.parseInt((String)video[1]));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        allFiles.clear();
        if (StringUtils.isBlank((CharSequence)movie.getTitle()) && StringUtils.isNotBlank((CharSequence)bdinfoTitle)) {
            movie.setTitle(bdinfoTitle);
        } else if (StringUtils.isBlank((CharSequence)movie.getTitle())) {
            movie.setTitle(StrgUtils.replaceUnicodeCharactersInverse(Utils.removeSortableName(videoName)));
        }
        movie.setPath(movieDir.toAbsolutePath().toString());
        movie.setDataSource(dataSource.toString());
        if (!MediaIdUtil.isValidImdbId(movie.getImdbId())) {
            movie.setId("imdb", ParserUtils.detectImdbId(movieDir.getFileName().toString()));
        }
        if (movie.getTmdbId() == 0) {
            movie.setId("tmdb", ParserUtils.detectTmdbId(movieDir.getFileName().toString()));
        }
        if (movie.getIdAsInt("tvdb") == 0) {
            movie.setId("tvdb", ParserUtils.detectTvdbId(movieDir.getFileName().toString()));
        }
        for (MediaFile mediaFile : this.getMediaFiles(mfs, MediaFileType.UNKNOWN)) {
            for (MediaFile vid2 : this.getMediaFiles(mfs, MediaFileType.VIDEO)) {
                if (!mediaFile.getFilename().startsWith(vid2.getFilename())) continue;
                mediaFile.setType(MediaFileType.DOUBLE_EXT);
            }
        }
        this.addMediafilesToMovie(movie, mfs);
        for (MediaFile mediaFile : mfs) {
            String vfilename;
            if (mediaFile.getType() != MediaFileType.GRAPHIC) continue;
            LOGGER.debug("| parsing unknown graphic: {}", (Object)mediaFile.getFilename());
            vid = movie.getMediaFiles(MediaFileType.VIDEO);
            if (vid == null || vid.isEmpty() || !FilenameUtils.getBaseName((String)(vfilename = vid.get(0).getFilename())).equals(FilenameUtils.getBaseName((String)mediaFile.getFilename())) && !FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(vfilename)).strip().equals(FilenameUtils.getBaseName((String)mediaFile.getFilename())) && !movie.getTitle().equals(FilenameUtils.getBaseName((String)mediaFile.getFilename()))) continue;
            mediaFile.setType(MediaFileType.POSTER);
            movie.addToMediaFiles(mediaFile);
        }
        boolean videoRemoved = false;
        for (MediaFile mediaFile : movie.getMediaFiles()) {
            Path mfPath = mediaFile.getFile();
            BasicFileAttributes cached = (BasicFileAttributes)this.fsAttrCache.get(mfPath);
            boolean exists = cached != null || Files.exists(mfPath, LinkOption.NOFOLLOW_LINKS);
            if (exists) continue;
            if (mediaFile.getType() == MediaFileType.VIDEO) {
                videoRemoved = true;
            }
            movie.removeFromMediaFiles(mediaFile);
        }
        if (videoRemoved && !movie.getMediaFiles(MediaFileType.VIDEO).isEmpty()) {
            movie.setNewlyAdded(true);
            movie.setOriginalFilename(movie.getMainFile().getFilename());
        }
        if (movie.isNewlyAdded()) {
            Matcher matcher = VIDEO_3D_PATTERN.matcher(movieDir.getFileName().toString());
            if (matcher.find()) {
                movie.setVideoIn3D(true);
            }
            if ((vid = this.getMediaFile(mfs, MediaFileType.VIDEO)) != null) {
                Object newSource;
                Matcher matcher2 = VIDEO_3D_PATTERN.matcher(((MediaFile)((Object)vid)).getFilename());
                if (matcher2.find()) {
                    movie.setVideoIn3D(true);
                }
                if (StringUtils.isBlank((CharSequence)movie.getOriginalFilename())) {
                    movie.setOriginalFilename(((MediaFile)((Object)vid)).getFilename());
                }
                if (movie.getMediaSource() == MediaSource.UNKNOWN && (newSource = MediaSource.parseMediaSource(Utils.relPath(movie.getDataSource(), ((MediaFile)((Object)vid)).getFileAsPath().toString()))) != MediaSource.UNKNOWN) {
                    movie.setMediaSource((MediaSource)newSource);
                }
            }
            if (movie.getEdition() == MovieEdition.NONE) {
                movie.setEdition(MovieEdition.getMovieEditionFromString(movieDir.getFileName().toString()));
            }
        }
        boolean bl2 = false;
        boolean videoAvailable = false;
        for (MediaFile mf : movie.getMediaFiles(MediaFileType.VIDEO)) {
            videoAvailable = true;
            if (!"disc".equalsIgnoreCase(mf.getExtension())) continue;
            bl = true;
        }
        if (!videoAvailable) {
            LOGGER.warn("Could not add '{}' because no VIDEO file found", (Object)movieDir);
            return;
        }
        LOGGER.debug("| store movie into DB as: {}", (Object)movie.getTitle());
        this.movieList.addMovie(movie);
        movie.setOffline(bl);
        movie.reEvaluateDiscfolder();
        movie.reEvaluateStacking();
        movie.saveToDb();
        if (MovieModuleManager.getInstance().getSettings().isExtractArtworkFromVsmeta()) {
            List<MediaFile> vsmetas = movie.getMediaFiles(MediaFileType.VSMETA);
            if (movie.getMediaFiles(MediaFileType.POSTER).isEmpty() && !vsmetas.isEmpty() && !MovieModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty()) {
                LOGGER.debug("extracting POSTERs from VSMETA for {}", (Object)movie.getMainFile().getFileAsPath());
                MovieArtworkHelper.extractArtworkFromVsmeta(movie, vsmetas.get(0), MediaArtwork.MediaArtworkType.POSTER);
            }
            if (movie.getMediaFiles(MediaFileType.FANART).isEmpty() && !vsmetas.isEmpty() && !MovieModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty()) {
                LOGGER.debug("extracting FANARTs from VSMETA for {}", (Object)movie.getMainFile().getFileAsPath());
                MovieArtworkHelper.extractArtworkFromVsmeta(movie, vsmetas.get(0), MediaArtwork.MediaArtworkType.BACKGROUND);
            }
            if (movie.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
                MovieArtworkHelper.extractBlurayPosters(movie);
            }
        }
        if (movie.getMovieSet() != null) {
            LOGGER.debug("| movie is part of a movieset");
            movie.getMovieSet().insertMovie(movie);
            movie.getMovieSet().saveToDb();
        }
    }

    private void createMultiMovieFromDir(Path dataSource, Path movieDir, List<Path> allFiles) {
        LOGGER.debug("Parsing multi  movie directory: {}", (Object)movieDir);
        this.publishState(movieDir.toString());
        ArrayList<Movie> movies = new ArrayList<Movie>(this.movieList.findByPath(movieDir));
        this.fileLock.writeLock().lock();
        this.filesFound.add(movieDir);
        this.filesFound.addAll(allFiles);
        this.fileLock.writeLock().unlock();
        ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
        for (Path file : allFiles) {
            mfs.add(new MediaFile(file));
        }
        mfs.sort((file1, file2) -> file2.getFileAsPath().getFileName().toString().length() - file1.getFileAsPath().getFileName().toString().length());
        for (MediaFile mf : this.getMediaFiles(mfs, MediaFileType.VIDEO)) {
            MediaEntity movie = null;
            String basename = FilenameUtils.getBaseName((String)mf.getFilename());
            String stack = Utils.getStackingMarker(mf.getFilename());
            if (!stack.isEmpty()) {
                LOGGER.trace("Found stacking marker {} inf file {} - removing", (Object)stack, (Object)mf.getFilename());
                if (basename.endsWith(stack)) {
                    basename = FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(mf.getFilename()));
                }
            }
            ArrayList<MediaFile> sameName = new ArrayList<MediaFile>();
            LOGGER.trace("UDS: basename: {}", (Object)basename);
            for (MediaFile mediaFile : mfs) {
                Iterator<MediaFile> smBasename = FilenameUtils.getBaseName((String)mediaFile.getFilename());
                String smNameRegexp = Pattern.quote(basename) + "[\\s.,_-].*";
                if (!((String)((Object)smBasename)).equals(basename) && !((String)((Object)smBasename)).matches(smNameRegexp)) continue;
                if (mediaFile.getType() == MediaFileType.GRAPHIC) {
                    mediaFile.setType(MediaFileType.POSTER);
                }
                sameName.add(mediaFile);
                LOGGER.trace("UDS: found matching MF: {}", (Object)mediaFile);
            }
            for (Movie movie2 : movies) {
                for (MediaFile mfile : movie2.getMediaFiles(MediaFileType.VIDEO)) {
                    if (!mfile.equals(mf) && !mfile.getBasename().equalsIgnoreCase(mf.getBasename())) continue;
                    LOGGER.debug("| found movie '{}' from MediaFile {}", (Object)movie2.getTitle(), (Object)mf);
                    movie = movie2;
                }
            }
            if (movie != null && movie.isLocked()) {
                LOGGER.info("Movie '{}' found in \"update data source\", but is locked", (Object)movie.getPath());
                continue;
            }
            if (movie == null) {
                movie = MovieUpdateDatasourceTask.parseNFOs(sameName);
                if (movie == null) {
                    LOGGER.debug("| Create new movie from file: {}", (Object)mf);
                    movie = new Movie();
                    String[] ty = ParserUtils.detectCleanTitleAndYear(basename, MovieModuleManager.getInstance().getSettings().getBadWord());
                    ((Movie)movie).setTitle(ty[0]);
                    if (!ty[1].isEmpty()) {
                        try {
                            ((Movie)movie).setYear(Integer.parseInt((String)ty[1]));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ((Movie)movie).setEdition(MovieEdition.getMovieEditionFromString(basename));
                    Matcher matcher = VIDEO_3D_PATTERN.matcher(basename);
                    if (matcher.find()) {
                        ((Movie)movie).setVideoIn3D(true);
                    }
                }
                movie.setDataSource(dataSource.toString());
                movie.setNewlyAdded(true);
                ((Movie)movie).setPath(mf.getPath());
                if (StringUtils.isBlank((CharSequence)movie.getOriginalFilename())) {
                    movie.setOriginalFilename(mf.getFilename());
                }
                movies.add((Movie)movie);
            }
            if (!MediaIdUtil.isValidImdbId(((Movie)movie).getImdbId())) {
                ((Movie)movie).setImdbId(ParserUtils.detectImdbId(mf.getFileAsPath().toString()));
            }
            if (((Movie)movie).getTmdbId() == 0) {
                ((Movie)movie).setTmdbId(ParserUtils.detectTmdbId(mf.getFileAsPath().toString()));
            }
            if (((Movie)movie).getMediaSource() == MediaSource.UNKNOWN) {
                ((Movie)movie).setMediaSource(MediaSource.parseMediaSource(Utils.relPath(movie.getDataSource(), mf.getFileAsPath().toString())));
            }
            LOGGER.debug("| parsing video file {}", (Object)mf.getFilename());
            ((Movie)movie).setMultiMovieDir(true);
            for (MediaFile mediaFile : this.getMediaFiles(sameName, MediaFileType.UNKNOWN)) {
                for (MediaFile vid : this.getMediaFiles(mfs, MediaFileType.VIDEO)) {
                    if (!mediaFile.getFilename().startsWith(vid.getFilename())) continue;
                    mediaFile.setType(MediaFileType.DOUBLE_EXT);
                }
            }
            this.addMediafilesToMovie((Movie)movie, sameName);
            mfs.removeAll(sameName);
            for (MediaFile mediaFile : movie.getMediaFiles()) {
                Path mfPath = mediaFile.getFile();
                BasicFileAttributes cached = (BasicFileAttributes)this.fsAttrCache.get(mfPath);
                boolean exists = cached != null || Files.exists(mfPath, new LinkOption[0]);
                if (exists) continue;
                ((Movie)movie).removeFromMediaFiles(mediaFile);
            }
            boolean isOffline = false;
            for (MediaFile mediaFiles : movie.getMediaFiles(MediaFileType.VIDEO)) {
                if (!"disc".equalsIgnoreCase(mediaFiles.getExtension())) continue;
                isOffline = true;
            }
            ((Movie)movie).setOffline(isOffline);
            if (((Movie)movie).getMovieSet() != null) {
                LOGGER.debug("| movie is part of a movieset");
                ((Movie)movie).getMovieSet().insertMovie((Movie)movie);
                ((Movie)movie).getMovieSet().saveToDb();
            }
            if (MovieModuleManager.getInstance().getSettings().isExtractArtworkFromVsmeta()) {
                List<MediaFile> list = movie.getMediaFiles(MediaFileType.VSMETA);
                if (movie.getMediaFiles(MediaFileType.POSTER).isEmpty() && !list.isEmpty() && !MovieModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty()) {
                    LOGGER.debug("extracting POSTERs from VSMETA for {}", (Object)((Movie)movie).getMainFile().getFileAsPath());
                    MovieArtworkHelper.extractArtworkFromVsmeta((Movie)movie, list.get(0), MediaArtwork.MediaArtworkType.POSTER);
                }
                if (movie.getMediaFiles(MediaFileType.FANART).isEmpty() && !list.isEmpty() && !MovieModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty()) {
                    LOGGER.debug("extracting FANARTs from VSMETA for {}", (Object)((Movie)movie).getMainFile().getFileAsPath());
                    MovieArtworkHelper.extractArtworkFromVsmeta((Movie)movie, list.get(0), MediaArtwork.MediaArtworkType.BACKGROUND);
                }
            }
            this.movieList.addMovie((Movie)movie);
            ((Movie)movie).saveToDb();
        }
        for (Movie m : this.movieList.findByPath(movieDir)) {
            m.reEvaluateDiscfolder();
            m.reEvaluateStacking();
            m.saveToDb();
        }
    }

    private void addMediafilesToMovie(Movie movie, List<MediaFile> mediaFiles) {
        ArrayList<MediaFile> current = new ArrayList<MediaFile>(movie.getMediaFiles());
        mediaFiles.sort(new MovieMediaFileComparator());
        MediaFile mainVideoFile = null;
        if (!movie.getMediaFiles(MediaFileType.VIDEO).isEmpty()) {
            mainVideoFile = movie.getMainVideoFile();
        }
        block9: for (MediaFile mf : mediaFiles) {
            if (current.contains(mf)) continue;
            if ((mf.getPath().toUpperCase(Locale.ROOT).contains("BDMV") || mf.getPath().toUpperCase(Locale.ROOT).contains("VIDEO_TS") || mf.getPath().toUpperCase(Locale.ROOT).contains("HVDVD_TS") || mf.isDiscFile()) && movie.getMediaSource() == MediaSource.UNKNOWN) {
                String folderNameComplete = Paths.get(movie.getPath(), new String[0]).relativize(mf.getFileAsPath()).toString();
                movie.setMediaSource(MediaSource.parseMediaSource(folderNameComplete));
            }
            if (!MediaIdUtil.isValidImdbId(movie.getImdbId())) {
                movie.setImdbId(ParserUtils.detectImdbId(mf.getFilename()));
            }
            if (movie.getTmdbId() == 0) {
                movie.setTmdbId(ParserUtils.detectTmdbId(mf.getFilename()));
            }
            LOGGER.debug("| parsing {} {}", (Object)mf.getType().name(), (Object)mf.getFileAsPath());
            switch (mf.getType()) {
                case VIDEO: {
                    if (mainVideoFile == null) {
                        mainVideoFile = mf;
                    }
                    movie.addToMediaFiles(mf);
                    break;
                }
                case SUBTITLE: {
                    if (mf.isPacked()) break;
                    movie.addToMediaFiles(mf);
                    break;
                }
                case FANART: {
                    if (mf.getPath().toLowerCase(Locale.ROOT).contains("extrafanart")) {
                        LOGGER.debug("problem: detected media file type FANART in extrafanart folder: {}", (Object)mf.getPath());
                        continue block9;
                    }
                    if (this.hasInvalidBasename(mainVideoFile, mf, "fanart")) {
                        mf.setType(MediaFileType.GRAPHIC);
                    }
                    movie.addToMediaFiles(mf);
                    break;
                }
                case THUMB: {
                    if (mf.getPath().toLowerCase(Locale.ROOT).contains("extrathumbs")) {
                        LOGGER.debug("| problem: detected media file type THUMB in extrathumbs folder: {}", (Object)mf.getPath());
                        continue block9;
                    }
                    if (this.hasInvalidBasename(mainVideoFile, mf, "thumb")) {
                        mf.setType(MediaFileType.GRAPHIC);
                    }
                    movie.addToMediaFiles(mf);
                    break;
                }
                case POSTER: 
                case BANNER: 
                case CLEARLOGO: 
                case LOGO: 
                case CLEARART: 
                case KEYART: {
                    if (this.hasInvalidBasename(mainVideoFile, mf, mf.getType().name().toLowerCase(Locale.ROOT))) {
                        mf.setType(MediaFileType.GRAPHIC);
                    }
                    movie.addToMediaFiles(mf);
                    break;
                }
                case DISC: {
                    if (this.hasInvalidBasename(mainVideoFile, mf, "disc") || this.hasInvalidBasename(mainVideoFile, mf, "discart")) {
                        mf.setType(MediaFileType.GRAPHIC);
                    }
                    movie.addToMediaFiles(mf);
                    break;
                }
                case TRAILER: 
                case EXTRA: 
                case SAMPLE: 
                case NFO: 
                case TEXT: 
                case EXTRAFANART: 
                case EXTRATHUMB: 
                case AUDIO: 
                case MEDIAINFO: 
                case VSMETA: 
                case THEME: 
                case CHARACTERART: 
                case DOUBLE_EXT: {
                    movie.addToMediaFiles(mf);
                    break;
                }
                default: {
                    LOGGER.debug("| NOT adding unknown media file type: {}", (Object)mf.getFileAsPath());
                    continue block9;
                }
            }
            if (mf.getType() == MediaFileType.GRAPHIC || mf.getType() == MediaFileType.UNKNOWN || mf.getType() == MediaFileType.NFO || movie.getMediaFiles().contains(mf)) continue;
            LOGGER.debug("| Movie not added mf: {}", (Object)mf.getFileAsPath());
        }
        block10: for (MediaFileType type : Arrays.asList(MediaFileType.FANART, MediaFileType.POSTER, MediaFileType.BANNER, MediaFileType.CLEARLOGO, MediaFileType.LOGO, MediaFileType.CLEARART, MediaFileType.KEYART, MediaFileType.DISC)) {
            if (!movie.getMediaFiles(type).isEmpty()) continue;
            for (MediaFile mf : movie.getMediaFiles(MediaFileType.GRAPHIC)) {
                MediaFileType parsedType = MediaFileHelper.parseImageType(mf.getFile());
                if (parsedType != type) continue;
                mf.setType(type);
                continue block10;
            }
        }
    }

    private boolean hasInvalidBasename(MediaFile mainVideoFile, MediaFile toCheck, String suffix) {
        String mainVideoFileBasename;
        if (mainVideoFile == null) {
            return false;
        }
        String toCheckBasename = FilenameUtils.getBaseName((String)toCheck.getFilename());
        if (!toCheckBasename.endsWith("-" + suffix)) {
            return false;
        }
        return !(toCheckBasename = toCheckBasename.replaceAll("-" + suffix + "$", "")).equals(mainVideoFileBasename = FilenameUtils.getBaseName((String)mainVideoFile.getFilename()));
    }

    private void cleanup(String datasource) {
        ArrayList<Movie> moviesToclean = new ArrayList<Movie>();
        for (Movie movie : this.movieList.getMovies()) {
            if (!Paths.get(datasource, new String[0]).equals(Paths.get(movie.getDataSource(), new String[0]))) continue;
            moviesToclean.add(movie);
        }
        this.cleanup(moviesToclean);
    }

    private void cleanup(List<Movie> movies) {
        boolean dirty;
        this.setTaskName(TmmResourceBundle.getString("update.cleanup"));
        this.setTaskDescription(null);
        this.setProgressDone(0);
        this.setWorkUnits(0);
        this.publishState();
        LOGGER.info("Removing orphaned movies/files...");
        ArrayList<Movie> moviesToRemove = new ArrayList<Movie>();
        for (int i = movies.size() - 1; i >= 0 && !this.cancel; --i) {
            Movie movie = movies.get(i);
            if (movie.isLocked()) continue;
            dirty = false;
            Path movieDir = movie.getPathNIO();
            boolean dirFound = this.filesFound.contains(movieDir);
            if (!dirFound) {
                if (!Files.exists(movieDir, new LinkOption[0])) {
                    LOGGER.debug("movie directory '{}' not found, removing from DB...", (Object)movieDir);
                    moviesToRemove.add(movie);
                } else {
                    LOGGER.debug("dir {} not in hashset, but on hdd!", (Object)movieDir);
                }
            }
            if (!movie.isNewlyAdded()) {
                ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>(movie.getMediaFiles());
                for (MediaFile mf : mediaFiles) {
                    boolean fileFound = this.filesFound.contains(mf.getFileAsPath());
                    if (fileFound) continue;
                    LOGGER.debug("removing orphaned file from DB: {}", (Object)mf.getFileAsPath());
                    movie.removeFromMediaFiles(mf);
                    if (mf.isGraphic()) {
                        ImageCache.invalidateCachedImage(mf);
                    }
                    dirty = true;
                }
                if (dirty && !movie.getMediaFiles(MediaFileType.VIDEO).isEmpty()) {
                    movie.saveToDb();
                }
            }
            if (!movie.getMediaFiles(MediaFileType.VIDEO).isEmpty()) continue;
            LOGGER.debug("Movie ({}) without VIDEO files detected, removing from DB...", (Object)movie.getTitle());
            moviesToRemove.add(movie);
        }
        this.movieList.removeMovies(moviesToRemove);
        moviesToRemove.clear();
        for (Movie movie : movies) {
            dirty = false;
            if (!movie.isDisc() || movie.getDataSource().equals(movie.getPath())) continue;
            for (MediaFile mf : movie.getMediaFiles(MediaFileType.VIDEO)) {
                if (mf.getFilename().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$") || mf.isDiscFile()) continue;
                LOGGER.debug("DISC folder detected - remove VIDEO {}", (Object)mf.getFileAsPath());
                movie.removeFromMediaFiles(mf);
                dirty = true;
            }
            for (Movie sub : this.movieList.getMovies()) {
                if (movie.equals(sub) || !sub.getPathNIO().startsWith(movie.getPathNIO())) continue;
                LOGGER.debug("Movie {} inside DISC folder of {} - removing", (Object)sub.getMainFile().getFileAsPath(), (Object)movie.getPath());
                moviesToRemove.add(sub);
            }
            if (!dirty || movie.getMediaFiles(MediaFileType.VIDEO).isEmpty()) continue;
            movie.saveToDb();
        }
        this.movieList.removeMovies(moviesToRemove);
    }

    private void gatherMediainfo(String datasource) {
        this.setTaskName(TmmResourceBundle.getString("update.mediainfo"));
        this.publishState();
        this.initThreadPool(1, "mediainfo");
        LOGGER.info("Getting Mediainfo...");
        for (Runnable task : this.miTasks) {
            this.submitTask(task);
        }
        for (Movie movie : this.movieList.getMovies()) {
            if (this.cancel) break;
            if (!Paths.get(datasource, new String[0]).equals(Paths.get(movie.getDataSource(), new String[0])) || movie.isLocked()) continue;
            for (MediaFile mf : new ArrayList<MediaFile>(movie.getMediaFiles())) {
                if (StringUtils.isBlank((CharSequence)mf.getContainerFormat())) {
                    this.submitTask(new MovieMediaFileInformationFetcherTask(mf, movie, false));
                    continue;
                }
                BasicFileAttributes cached = (BasicFileAttributes)this.fsAttrCache.get(mf.getFileAsPath());
                if (!MediaFileHelper.gatherBasicFileInformation(mf, cached)) continue;
                this.submitTask(new MovieMediaFileInformationFetcherTask(mf, movie, true));
            }
        }
        this.waitForCompletionOrCancel();
    }

    private void gatherMediainfo(List<Movie> movies) {
        this.setTaskName(TmmResourceBundle.getString("update.mediainfo"));
        this.publishState();
        this.initThreadPool(1, "mediainfo");
        LOGGER.info("Getting Mediainfo...");
        for (Movie movie : movies) {
            if (this.cancel) break;
            if (movie.isLocked()) continue;
            for (MediaFile mf : new ArrayList<MediaFile>(movie.getMediaFiles())) {
                if (StringUtils.isBlank((CharSequence)mf.getContainerFormat())) {
                    this.submitTask(new MovieMediaFileInformationFetcherTask(mf, movie, false));
                    continue;
                }
                BasicFileAttributes cached = (BasicFileAttributes)this.fsAttrCache.get(mf.getFileAsPath());
                if (!MediaFileHelper.gatherBasicFileInformation(mf, cached)) continue;
                if (mf.getType() == MediaFileType.VIDEO) {
                    movie.getMediaFiles(MediaFileType.MEDIAINFO).forEach(mediaFile -> {
                        Utils.deleteFileSafely(mediaFile.getFileAsPath());
                        movie.removeFromMediaFiles((MediaFile)mediaFile);
                    });
                }
                this.submitTask(new MovieMediaFileInformationFetcherTask(mf, movie, true));
            }
            if (movie.getMediaSource() != MediaSource.BLURAY || !movie.getMainVideoFile().getVideoDefinitionCategory().equals("UHD")) continue;
            movie.setMediaSource(MediaSource.UHD_BLURAY);
            movie.saveToDb();
        }
        this.waitForCompletionOrCancel();
    }

    private MediaFile getMediaFile(List<MediaFile> mfs, MediaFileType ... types) {
        MediaFile mf = null;
        for (MediaFile mediaFile : mfs) {
            boolean match = false;
            for (MediaFileType type : types) {
                if (!mediaFile.getType().equals((Object)type)) continue;
                match = true;
            }
            if (!match) continue;
            mf = new MediaFile(mediaFile);
        }
        return mf;
    }

    private List<MediaFile> getMediaFiles(List<MediaFile> mfs, MediaFileType ... types) {
        List<MediaFileType> mediaFileTypes = Arrays.asList(types);
        return mfs.stream().filter(mf -> mediaFileTypes.contains((Object)mf.getType())).toList();
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private List<Path> listFilesAndDirs(Path directory) {
        ArrayList<Path> fileNames = new ArrayList();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            for (Path path : directoryStream) {
                if (this.isInSkipFolder(path)) {
                    LOGGER.debug("Skipping: {}", (Object)path);
                    continue;
                }
                if (fileNames.contains(path.toAbsolutePath())) {
                    throw new IOException("duplicate found: '" + path.getFileName() + "' - fall back to the alternate method");
                }
                fileNames.add(path.toAbsolutePath());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while getting a file listing of '{}' - '{}'", (Object)directory, (Object)e.getMessage());
            LOGGER.debug("could not list files in normal way", (Throwable)e);
            fileNames = this.listFilesAndDirs2(directory);
        }
        if (fileNames.isEmpty()) {
            LOGGER.debug("Tried to list '{}', but it was empty?!", (Object)directory);
        }
        Collections.sort(fileNames);
        return fileNames;
    }

    private List<Path> listFilesAndDirs2(Path directory) {
        ArrayList<Path> fileNames = new ArrayList<Path>();
        try (Stream<Path> directoryStream = Files.walk(directory, 1, FileVisitOption.FOLLOW_LINKS);){
            List<Path> allElements = directoryStream.toList();
            for (Path path : allElements) {
                if (directory.toAbsolutePath().equals(path.toAbsolutePath())) continue;
                if (this.isInSkipFolder(path)) {
                    LOGGER.debug("Skipping: {}", (Object)path);
                    continue;
                }
                fileNames.add(path.toAbsolutePath());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while getting a file listing of '{}' (alternate way) - '{}'", (Object)directory, (Object)e.getMessage());
            LOGGER.debug("could not list files in alternate way", (Throwable)e);
        }
        Collections.sort(fileNames);
        return fileNames;
    }

    private Set<Path> getAllFilesRecursiveButNoDiscFiles(Path folder) {
        folder = folder.toAbsolutePath();
        AllFilesRecursive visitor = new AllFilesRecursive();
        try {
            Files.walkFileTree(folder, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, visitor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return visitor.fFound;
    }

    public void searchAndParse(Path datasource, Path folder, int deep) {
        folder = folder.toAbsolutePath();
        SearchAndParseVisitor visitor = new SearchAndParseVisitor(datasource);
        try {
            Files.walkFileTree(folder, EnumSet.of(FileVisitOption.FOLLOW_LINKS), deep, visitor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean isInSkipFolder(Path dir) {
        if (dir == null || dir.getFileName() == null) {
            return false;
        }
        String dirName = dir.getFileName().toString();
        String dirNameUppercase = dirName.toUpperCase(Locale.ROOT);
        String fullPath = dir.toAbsolutePath().toString();
        if (SKIP_FOLDERS.contains(dirNameUppercase) || dirName.matches(SKIP_REGEX)) {
            return true;
        }
        for (Pattern pattern : this.skipFolders) {
            Matcher matcher = pattern.matcher(dirName);
            if (matcher.matches()) {
                return true;
            }
            if (!pattern.toString().replace("\\Q", "").replace("\\E", "").equals(fullPath)) continue;
            return true;
        }
        return false;
    }

    private static synchronized void incVisFile() {
        ++visFile;
        ++visFileAll;
    }

    private static synchronized void incPreDir() {
        ++preDir;
        ++preDirAll;
    }

    private static synchronized void incPostDir() {
        ++postDir;
        ++postDirAll;
    }

    private boolean cachedExists(Path path) {
        if (path == null) {
            return false;
        }
        if (this.fsAttrCache.containsKey(path.toAbsolutePath())) {
            return true;
        }
        try {
            return Files.exists(path, new LinkOption[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean cachedIsDirectory(Path path) {
        if (path == null) {
            return false;
        }
        BasicFileAttributes attr = (BasicFileAttributes)this.fsAttrCache.get(path.toAbsolutePath());
        if (attr != null) {
            return attr.isDirectory();
        }
        try {
            return Files.isDirectory(path, new LinkOption[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    private class ParseMultiMovieDirTask
    implements Callable<Object> {
        private final Path movieDir;
        private final Path datasource;
        private final List<Path> allFiles;

        public ParseMultiMovieDirTask(Path dataSource, Path movieDir, List<Path> allFiles) {
            this.datasource = dataSource;
            this.movieDir = movieDir;
            this.allFiles = allFiles;
        }

        @Override
        public String call() {
            MovieUpdateDatasourceTask.this.createMultiMovieFromDir(this.datasource, this.movieDir, this.allFiles);
            return this.movieDir.toString();
        }
    }

    private class MovieMediaFileInformationFetcherTask
    extends MediaFileInformationFetcherTask {
        public MovieMediaFileInformationFetcherTask(MediaFile mediaFile, MediaEntity mediaEntity, boolean forceUpdate) {
            super(mediaFile, mediaEntity, forceUpdate);
        }

        @Override
        public void run() {
            MovieUpdateDatasourceTask.this.publishState(this.mediaEntity.getTitle() + " - " + this.mediaFile.getFilename());
            super.run();
        }
    }

    private class FindMovieTask
    implements Callable<Object> {
        private final Path subdir;
        private final Path datasource;
        private final long uniqueId;

        public FindMovieTask(Path subdir, Path datasource) {
            this.subdir = subdir;
            this.datasource = datasource;
            this.uniqueId = TmmTaskManager.getInstance().GLOB_THRD_CNT.incrementAndGet();
        }

        @Override
        public String call() {
            Object name = Thread.currentThread().getName();
            if (!((String)name).contains("-G")) {
                name = (String)name + "-G0";
            }
            name = ((String)name).replaceAll("\\-G\\d+", "-G" + this.uniqueId);
            Thread.currentThread().setName((String)name);
            MovieUpdateDatasourceTask.this.parseMovieDirectory(this.subdir, this.datasource);
            return this.subdir.toString();
        }
    }

    private class AllFilesRecursive
    extends AbstractFileVisitor {
        private final Set<Path> fFound = new HashSet<Path>();
        private final boolean skipFoldersWithNomedia = MovieModuleManager.getInstance().getSettings().isSkipFoldersWithNomedia();
        private int deep = 0;

        @Override
        @NotNull
        public FileVisitResult visitFile(Path file, @NotNull BasicFileAttributes attr) {
            if (MovieUpdateDatasourceTask.this.cancel) {
                return FileVisitResult.TERMINATE;
            }
            MovieUpdateDatasourceTask.incVisFile();
            if (file.getFileName() == null) {
                return FileVisitResult.CONTINUE;
            }
            try {
                MovieUpdateDatasourceTask.this.fsAttrCache.putIfAbsent(file.toAbsolutePath(), attr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (file.getParent() != null && Utils.containsSkipFile(file.getParent(), this.skipFoldersWithNomedia, MovieUpdateDatasourceTask.this.fsAttrCache)) {
                return FileVisitResult.CONTINUE;
            }
            try {
                String filename = file.getFileName().toString();
                String path = "";
                if (file.getParent() != null && file.getParent().getFileName() != null) {
                    path = file.getParent().getFileName().toString();
                }
                if (Utils.isRegularFile(attr) && path.matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                    if (FilenameUtils.getExtension((String)filename).equalsIgnoreCase("nfo") || FilenameUtils.getBaseName((String)filename).endsWith("trailer")) {
                        this.fFound.add(file.toAbsolutePath());
                    }
                    return FileVisitResult.CONTINUE;
                }
                if (MediaFileHelper.isMainDiscIdentifierFile(filename)) {
                    this.fFound.add(file.toAbsolutePath());
                    return FileVisitResult.CONTINUE;
                }
                if (Utils.isRegularFile(attr) && !filename.matches(MovieUpdateDatasourceTask.SKIP_REGEX)) {
                    this.fFound.add(file.toAbsolutePath());
                    return FileVisitResult.CONTINUE;
                }
            }
            catch (Exception e) {
                LOGGER.debug("could not analyze file '{}' - '{}'", (Object)file.toAbsolutePath(), (Object)e.getMessage());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        @NotNull
        public FileVisitResult preVisitDirectory(Path dir, @NotNull BasicFileAttributes attrs) {
            if (MovieUpdateDatasourceTask.this.cancel) {
                return FileVisitResult.TERMINATE;
            }
            MovieUpdateDatasourceTask.incPreDir();
            ++this.deep;
            try {
                MovieUpdateDatasourceTask.this.fsAttrCache.putIfAbsent(dir.toAbsolutePath(), attrs);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (dir.getFileName() != null && MovieUpdateDatasourceTask.this.isInSkipFolder(dir)) {
                    LOGGER.debug("Skipping dir: {}", (Object)dir);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (dir.getFileName() != null && dir.getFileName().toString().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                    this.fFound.add(dir.toAbsolutePath());
                    return FileVisitResult.CONTINUE;
                }
                if (this.deep > 1 && dir.getParent() != null && dir.getParent().getFileName() != null && dir.getParent().getFileName().toString().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
            }
            catch (Exception e) {
                LOGGER.debug("could not analyze folder '{}' - '{}'", (Object)dir.toAbsolutePath(), (Object)e.getMessage());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        @NotNull
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            if (MovieUpdateDatasourceTask.this.cancel) {
                return FileVisitResult.TERMINATE;
            }
            MovieUpdateDatasourceTask.incPostDir();
            --this.deep;
            return FileVisitResult.CONTINUE;
        }
    }

    private class SearchAndParseVisitor
    extends AbstractFileVisitor {
        private final Path datasource;
        private final List<String> unstackedRoot;
        private final Set<Path> videofolders;
        private final Set<Path> visited;
        private final boolean skipFoldersWithNomedia;

        SearchAndParseVisitor(Path datasource) {
            this.datasource = datasource;
            this.unstackedRoot = new ArrayList<String>();
            this.videofolders = new HashSet<Path>();
            this.visited = new HashSet<Path>();
            this.skipFoldersWithNomedia = MovieModuleManager.getInstance().getSettings().isSkipFoldersWithNomedia();
        }

        @Override
        @NotNull
        public FileVisitResult visitFile(Path file, @NotNull BasicFileAttributes attr) {
            if (MovieUpdateDatasourceTask.this.cancel) {
                return FileVisitResult.TERMINATE;
            }
            if (this.visited.contains(file)) {
                LOGGER.debug("visiting already visited file '{}'", (Object)file.toAbsolutePath());
                return FileVisitResult.SKIP_SIBLINGS;
            }
            MovieUpdateDatasourceTask.incVisFile();
            this.visited.add(file);
            try {
                MovieUpdateDatasourceTask.this.fsAttrCache.putIfAbsent(file.toAbsolutePath(), attr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (file.getParent() != null && Utils.containsSkipFile(file.getParent(), this.skipFoldersWithNomedia, MovieUpdateDatasourceTask.this.fsAttrCache)) {
                return FileVisitResult.CONTINUE;
            }
            try {
                if (Utils.isRegularFile(attr) && !file.getFileName().toString().matches(MovieUpdateDatasourceTask.SKIP_REGEX) && Settings.getInstance().getVideoFileType().contains("." + FilenameUtils.getExtension((String)file.toString()).toLowerCase(Locale.ROOT))) {
                    MediaFile mf = new MediaFile(file);
                    if (mf.getType() == MediaFileType.VIDEO) {
                        this.videofolders.add(file.getParent());
                    } else {
                        LOGGER.debug("no VIDEO (is {}) - do not parse {}", (Object)mf.getType(), (Object)file);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.debug("could not analyze file '{}' - '{}'", (Object)file.toAbsolutePath(), (Object)e.getMessage());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        @NotNull
        public FileVisitResult preVisitDirectory(Path dir, @NotNull BasicFileAttributes attrs) {
            if (MovieUpdateDatasourceTask.this.cancel) {
                return FileVisitResult.TERMINATE;
            }
            if (this.visited.contains(dir)) {
                LOGGER.debug("visiting already visited folder '{}'", (Object)dir.toAbsolutePath());
                return FileVisitResult.SKIP_SUBTREE;
            }
            MovieUpdateDatasourceTask.incPreDir();
            String parent = "";
            if (!dir.equals(this.datasource) && !dir.getParent().equals(this.datasource)) {
                parent = dir.getParent().getFileName().toString().toUpperCase(Locale.ROOT);
            }
            this.visited.add(dir);
            try {
                MovieUpdateDatasourceTask.this.fsAttrCache.putIfAbsent(dir.toAbsolutePath(), attrs);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (dir.getFileName() != null && (MovieUpdateDatasourceTask.this.isInSkipFolder(dir) || parent.matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$"))) {
                    LOGGER.debug("Skipping dir: {}", (Object)dir);
                    return FileVisitResult.SKIP_SUBTREE;
                }
            }
            catch (Exception e) {
                LOGGER.debug("could not analyze folder '{}' - '{}'", (Object)dir.toAbsolutePath(), (Object)e.getMessage());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        @NotNull
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            if (MovieUpdateDatasourceTask.this.cancel) {
                return FileVisitResult.TERMINATE;
            }
            MovieUpdateDatasourceTask.incPostDir();
            if (this.videofolders.contains(dir)) {
                boolean update = true;
                Path relative = this.datasource.relativize(dir);
                if (!Utils.getFolderStackingMarker(relative.toString()).isEmpty() && Utils.getFolderStackingMarker(relative.toString()).equals(dir.getFileName().toString())) {
                    if (this.unstackedRoot.contains(dir.getParent().toString())) {
                        update = false;
                    } else {
                        this.unstackedRoot.add(dir.getParent().toString());
                    }
                }
                if (update) {
                    for (Path sub : this.videofolders) {
                        if (sub.equals(dir) || !sub.startsWith(dir)) continue;
                        List<Path> rootFiles = this.listFilesOnly(dir);
                        MovieUpdateDatasourceTask.this.submitTask(new ParseMultiMovieDirTask(this.datasource.toAbsolutePath(), dir, rootFiles));
                        MovieUpdateDatasourceTask.this.publishState();
                        return FileVisitResult.CONTINUE;
                    }
                    MovieUpdateDatasourceTask.this.submitTask(new FindMovieTask(dir, this.datasource));
                }
            } else {
                LOGGER.trace("not containing any video files - '{}'", (Object)dir);
            }
            return FileVisitResult.CONTINUE;
        }

        private List<Path> listFilesOnly(Path directory) {
            ArrayList<Path> fileNames = new ArrayList<Path>();
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
                for (Path path : directoryStream) {
                    if (!Utils.isRegularFile(path) && !path.getFileName().toString().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) continue;
                    if (MovieUpdateDatasourceTask.this.isInSkipFolder(path)) {
                        LOGGER.debug("Skipping: {}", (Object)path);
                        continue;
                    }
                    fileNames.add(path.toAbsolutePath());
                }
            }
            catch (IOException e) {
                LOGGER.error("Error while getting a file listing of '{}' - '{}'", (Object)directory, (Object)e.getMessage());
            }
            Collections.sort(fileNames);
            return fileNames;
        }
    }
}

