/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna;

import java.util.EnumMap;
import java.util.Map;
import org.jupnp.support.model.Protocol;
import org.jupnp.support.model.ProtocolInfo;
import org.jupnp.support.model.dlna.DLNAAttribute;
import org.jupnp.support.model.dlna.DLNAProfileAttribute;
import org.jupnp.support.model.dlna.DLNAProfiles;
import org.jupnp.util.MimeType;

public class DLNAProtocolInfo
extends ProtocolInfo {
    protected final Map<DLNAAttribute.Type, DLNAAttribute<?>> attributes = new EnumMap(DLNAAttribute.Type.class);

    public DLNAProtocolInfo(String s) {
        super(s);
        this.parseAdditionalInfo();
    }

    public DLNAProtocolInfo(MimeType contentFormatMimeType) {
        super(contentFormatMimeType);
    }

    public DLNAProtocolInfo(DLNAProfiles profile) {
        super(MimeType.valueOf((String)profile.getContentFormat()));
        this.attributes.put(DLNAAttribute.Type.DLNA_ORG_PN, new DLNAProfileAttribute(profile));
        this.additionalInfo = this.getAttributesString();
    }

    public DLNAProtocolInfo(DLNAProfiles profile, Map<DLNAAttribute.Type, DLNAAttribute<?>> attributes) {
        super(MimeType.valueOf((String)profile.getContentFormat()));
        this.attributes.putAll(attributes);
        this.attributes.put(DLNAAttribute.Type.DLNA_ORG_PN, new DLNAProfileAttribute(profile));
        this.additionalInfo = this.getAttributesString();
    }

    public DLNAProtocolInfo(Protocol protocol, String network, String contentFormat, String additionalInfo) {
        super(protocol, network, contentFormat, additionalInfo);
        this.parseAdditionalInfo();
    }

    public DLNAProtocolInfo(Protocol protocol, String network, String contentFormat, Map<DLNAAttribute.Type, DLNAAttribute<?>> attributes) {
        super(protocol, network, contentFormat, "");
        this.attributes.putAll(attributes);
        this.additionalInfo = this.getAttributesString();
    }

    public DLNAProtocolInfo(ProtocolInfo template) {
        this(template.getProtocol(), template.getNetwork(), template.getContentFormat(), template.getAdditionalInfo());
    }

    public boolean contains(DLNAAttribute.Type type) {
        return this.attributes.containsKey((Object)type);
    }

    public DLNAAttribute<?> getAttribute(DLNAAttribute.Type type) {
        return this.attributes.get((Object)type);
    }

    public Map<DLNAAttribute.Type, DLNAAttribute<?>> getAttributes() {
        return this.attributes;
    }

    protected String getAttributesString() {
        StringBuilder sb = new StringBuilder();
        for (DLNAAttribute.Type type : DLNAAttribute.Type.values()) {
            String value;
            String string = value = this.attributes.containsKey((Object)type) ? this.attributes.get((Object)type).getString() : null;
            if (value == null || value.isEmpty()) continue;
            sb.append(sb.length() == 0 ? "" : ";");
            sb.append(type.getAttributeName());
            sb.append("=");
            sb.append(value);
        }
        return sb.toString();
    }

    protected void parseAdditionalInfo() {
        if (this.additionalInfo != null) {
            String[] atts;
            for (String att : atts = this.additionalInfo.split(";")) {
                DLNAAttribute.Type type;
                String[] attNameValue = att.split("=");
                if (attNameValue.length != 2 || (type = DLNAAttribute.Type.valueOfAttributeName(attNameValue[0])) == null) continue;
                DLNAAttribute<?> dlnaAttrinute = DLNAAttribute.newInstance(type, attNameValue[1], this.getContentFormat());
                this.attributes.put(type, dlnaAttrinute);
            }
        }
    }
}

