/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.groups;

import com.ubnt.data.Site;
import com.ubnt.model.api.groups.NetworkMembersGroupDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.groups.exception.NetworkMembersGroupNotFound;
import com.ubnt.net.v2.groups.exception.UnexpectedNetworkMembersGroupId;
import com.ubnt.repository.while;
import com.ubnt.service.groups.A;
import com.ubnt.service.groups.NetworkMembersGroupDocument;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Validated
@V2RestController
@Tag(name="NetworkMembersGroup")
public class NetworkMembersGroupController {
    private final A o00000;

    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create a new network members group")
    @PostMapping(value={"/api/site/{siteName}/network-members-group"}, consumes={"application/json"})
    public NetworkMembersGroupDto createNetworkMembersGroup(@PathVariable(value="siteName") Site site, @RequestBody @Valid NetworkMembersGroupDto networkMembersGroupDto) {
        NetworkMembersGroupDocument networkMembersGroupDocument = this.o00000.O\u00f6\u00f6000(this.\u00d200000(site.getId(), networkMembersGroupDto));
        return this.\u00d400000(networkMembersGroupDocument);
    }

    @Operation(summary="Update the existing network members group")
    @PutMapping(value={"/api/site/{siteName}/network-members-group/{id}"}, consumes={"application/json"})
    public NetworkMembersGroupDto updateNetworkMembersGroup(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string, @RequestBody @Valid NetworkMembersGroupDto networkMembersGroupDto) {
        if (!Objects.equals(networkMembersGroupDto.id(), string)) {
            throw new UnexpectedNetworkMembersGroupId();
        }
        while<NetworkMembersGroupDocument> while_ = this.o00000.\u00d5\u00f6\u00f6000(networkMembersGroupDto.id(), networkMembersGroupDocument -> NetworkMembersGroupDocument.builder().\u00d600000(networkMembersGroupDocument.getId()).o00000(networkMembersGroupDocument.siteId()).\u00d400000(networkMembersGroupDto.type()).Object(networkMembersGroupDto.name()).\u00d500000(networkMembersGroupDto.members()).\u00d200000());
        return this.\u00d400000(while_.o00000());
    }

    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Delete the network members group")
    @DeleteMapping(value={"/api/site/{siteName}/network-members-group/{id}"})
    public void deleteNetworkMembersGroup(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string) {
        NetworkMembersGroupDocument networkMembersGroupDocument = this.o00000.whileforclass(site.getId(), string).orElseThrow(() -> new NetworkMembersGroupNotFound(string));
        this.o00000.\u00f5\u00f5\u00f6000(networkMembersGroupDocument);
    }

    @Operation(summary="Get all network members groups")
    @GetMapping(value={"/api/site/{siteName}/network-members-groups"})
    public List<NetworkMembersGroupDto> getNetworkMembersGroups(@PathVariable(value="siteName") Site site) {
        return this.o00000.thisdoclass(site.getId()).stream().map(this::\u00d400000).toList();
    }

    @Operation(summary="Get a network members group by the id")
    @GetMapping(value={"/api/site/{siteName}/network-members-group/{id}"})
    public NetworkMembersGroupDto getNetworkMembersGroup(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string) {
        return this.o00000.whileforclass(site.getId(), string).map(this::\u00d400000).orElseThrow(() -> new NetworkMembersGroupNotFound(string));
    }

    private NetworkMembersGroupDocument \u00d200000(String string, NetworkMembersGroupDto networkMembersGroupDto) {
        return NetworkMembersGroupDocument.builder().\u00d600000(networkMembersGroupDto.id()).o00000(string).\u00d400000(networkMembersGroupDto.type()).Object(networkMembersGroupDto.name()).\u00d500000(networkMembersGroupDto.members()).\u00d200000();
    }

    private NetworkMembersGroupDto \u00d400000(NetworkMembersGroupDocument networkMembersGroupDocument) {
        return NetworkMembersGroupDto.builder().id(networkMembersGroupDocument.id()).type(networkMembersGroupDocument.type()).name(networkMembersGroupDocument.name()).members(networkMembersGroupDocument.members()).build();
    }

    @ConstructorProperties(value={"networkMembersGroupService"})
    @Generated
    public NetworkMembersGroupController(A a2) {
        this.o00000 = a2;
    }
}

