/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cli;

public final class CliConstants {
    public static final String APP_NAME = "veraPDF";
    public static final String EXCEP_PROCESSOR_CLOSE = "IOException raised when closing ItemProcessor";
    public static final String EXCEP_REPORT_MARSHAL = "JAXBException raised when marshalling report.";
    public static final String EXCEP_REPORT_CLOSE = "Cannot close the report file.";
    public static final String EXCEP_TEMP_MRR_CREATE = "Failed to create temporary MRR file";
    public static final String EXCEP_TEMP_MRR_CLOSE = "Exception raised closing MRR temp file.";
    public static final String EXCEP_REPORT_OVERWRITE = "Cannot delete existing report file : %s.";
    public static final String EXCEP_VERA_BATCH = "VeraPDFException raised while processing batch";
    public static final String MESS_PDF_ENCRYPTED = "%s is an encrypted PDF document.";
    public static final String MESS_PDF_NOT_VALID = "%s is not a valid PDF document.";
    public static final String NAME_STDIN = "STDIN";

    private CliConstants() {
        throw new AssertionError((Object)"Should never be here.");
    }

    public static enum ExitCodes {
        VALID(0, "All files validated."),
        INVALID(1, "Invalid PDF/A file(s) found."),
        BAD_PARAMS(2, "Invalid command line parameters."),
        OOM(3, "Out of Java heap space (memory)."),
        NO_FILES(4, "No files to process."),
        IO_EXCEPTION(6, "I/O Exception while processing."),
        FAILED_PARSING(7, "Failed to parse one or more files."),
        ENCRYPTED_FILES(8, "Some PDFs encrypted."),
        VERAPDF_EXCEPTION(9, "VeraPDF exception while processing."),
        JAXB_EXCEPTION(10, "Java XML marshalling exception while processing result."),
        FAILED_MULTIPROCESS_START(11, "Failed to start multiprocess"),
        INTERRUPTED_EXCEPTION(12, "Interrupted exception while processing");

        public final int value;
        public final String message;

        private ExitCodes(int exitCode, String message) {
            this.value = exitCode;
            this.message = message;
        }

        public static ExitCodes fromValue(int code) {
            for (ExitCodes exitCode : ExitCodes.values()) {
                if (code != exitCode.value) continue;
                return exitCode;
            }
            return null;
        }
    }
}

