/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.core.utils;

public class ValidationProgress {
    private static final int UPPER_LIMIT_POWER_OF_TEN = 6;
    private static final int UPPER_POWER_OF_TEN_STEP = 5;
    private static final double UPPER_LIMIT = Math.pow(10.0, 6.0);
    private static final double UPPER_LIMIT_STEP = Math.pow(10.0, 5.0);
    private final boolean showProgress;
    private double currentStep = 1.0;
    private int currentPowerOfTenStep = 0;
    private int numberOfChecks;
    private int numberOfFailedChecks;
    private int numberOfProcessedObjects;
    private int numberOfObjectsToBeProcessed;
    private int lengthOfPrevProgressString = 1;

    public ValidationProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public void updateVariables() {
        if (this.showProgress) {
            System.out.println();
        }
        this.numberOfChecks = 0;
        this.numberOfFailedChecks = 0;
        this.numberOfProcessedObjects = 0;
        this.numberOfObjectsToBeProcessed = 1;
    }

    public void incrementNumberOfChecks() {
        ++this.numberOfChecks;
        if (this.showProgress && this.checkCurrentNumberOfChecks()) {
            this.showProgressDuringValidation();
            this.checkAndChangeCurrentStep();
        }
    }

    public void showProgressAfterValidation() {
        if (this.showProgress) {
            System.err.printf("%-" + this.lengthOfPrevProgressString + "s%n", this.getCurrentValidationJobProgress());
        }
    }

    public void updateNumberOfFailedChecks(int numberOfFailedChecks) {
        this.numberOfFailedChecks = numberOfFailedChecks;
    }

    public void incrementNumberOfProcessedObjects() {
        ++this.numberOfProcessedObjects;
    }

    public void updateNumberOfObjectsToBeProcessed(int numberOfObjectsToBeProcessed) {
        this.numberOfObjectsToBeProcessed = numberOfObjectsToBeProcessed;
    }

    public String getCurrentValidationJobProgressWithCommas() {
        return "Progress: " + this.numberOfChecks + " checks, " + this.numberOfFailedChecks + " failed, " + this.numberOfProcessedObjects + " processed objects, " + this.numberOfObjectsToBeProcessed + " in stack.";
    }

    private String getCurrentValidationJobProgress() {
        return "Progress: " + this.numberOfChecks + " checks / " + this.numberOfFailedChecks + " failed / " + this.numberOfProcessedObjects + " processed objects / " + this.numberOfObjectsToBeProcessed + " in stack.";
    }

    private boolean checkCurrentNumberOfChecks() {
        return (double)this.numberOfChecks % this.currentStep == 0.0;
    }

    private void checkAndChangeCurrentStep() {
        if ((double)this.numberOfChecks > UPPER_LIMIT) {
            return;
        }
        if ((double)this.numberOfChecks == Math.pow(10.0, (double)this.currentPowerOfTenStep + 1.0)) {
            ++this.currentPowerOfTenStep;
            this.currentStep = Math.pow(10.0, this.currentPowerOfTenStep);
        }
        if ((double)this.numberOfChecks == UPPER_LIMIT) {
            this.currentStep = UPPER_LIMIT_STEP;
        }
    }

    private void showProgressDuringValidation() {
        String currentProgress = this.getCurrentValidationJobProgress();
        System.err.printf("%-" + this.lengthOfPrevProgressString + "s\r", currentProgress);
        this.lengthOfPrevProgressString = currentProgress.length();
    }
}

