/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.external;

import org.verapdf.external.JPEG2000;
import org.verapdf.gf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.gf.model.impl.external.GFExternal;
import org.verapdf.model.pdlayer.PDColorSpace;

public class GFJPEG2000
extends GFExternal
implements org.verapdf.model.external.JPEG2000 {
    public static final String JPEG_2000_TYPE = "JPEG2000";
    private final JPEG2000 jpeg2000;
    private final boolean hasColorSpace;

    public GFJPEG2000(JPEG2000 jpeg2000, boolean hasColorSpace) {
        super(JPEG_2000_TYPE);
        this.jpeg2000 = jpeg2000;
        this.hasColorSpace = hasColorSpace;
    }

    @Override
    public Long getnrColorChannels() {
        return this.jpeg2000.getNumberOfColorChannels();
    }

    @Override
    public Long getnrColorSpaceSpecs() {
        return this.jpeg2000.getNumberOfColorSpaceSpecs();
    }

    @Override
    public Long getnrColorSpacesWithApproxField() {
        return this.jpeg2000.getNumberOfColorSpacesWithApproxField();
    }

    @Override
    public Long getcolrMethod() {
        return this.jpeg2000.getColrMethod();
    }

    @Override
    public Long getcolrEnumCS() {
        return this.jpeg2000.getColrEnumCS();
    }

    @Override
    public Long getbitDepth() {
        return this.jpeg2000.getBitDepth();
    }

    @Override
    public Boolean getbpccBoxPresent() {
        return this.jpeg2000.getBPCCBoxPresent();
    }

    @Override
    public Boolean gethasColorSpace() {
        return this.hasColorSpace;
    }

    public PDColorSpace getImageColorSpace() {
        return ColorSpaceFactory.getColorSpace(this.jpeg2000.getImageColorSpace());
    }
}

