/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.eventbus.internal.Event;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NonNull;

public final class ClientTooltipComponentManager {
    private static Map<Class<? extends TooltipComponent>, Function<TooltipComponent, ClientTooltipComponent>> FACTORIES;

    public static @NonNull ClientTooltipComponent createClientTooltipComponent(@NonNull TooltipComponent component) {
        ClientTooltipComponent ret;
        Function<TooltipComponent, ClientTooltipComponent> factory = FACTORIES.get(component.getClass());
        ClientTooltipComponent clientTooltipComponent = ret = factory != null ? factory.apply(component) : null;
        if (ret == null) {
            throw new IllegalArgumentException("Unknown TooltipComponent");
        }
        return ret;
    }

    @ApiStatus.Internal
    public static void init() {
        HashMap<Class<? extends TooltipComponent>, Function<TooltipComponent, ClientTooltipComponent>> factories = new HashMap<Class<? extends TooltipComponent>, Function<TooltipComponent, ClientTooltipComponent>>();
        RegisterClientTooltipComponentFactoriesEvent event = new RegisterClientTooltipComponentFactoriesEvent(factories);
        RegisterClientTooltipComponentFactoriesEvent.BUS.post((Event)event);
        FACTORIES = Map.copyOf(factories);
    }

    private ClientTooltipComponentManager() {
    }
}

