// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV1

import (
	"fmt"

	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// LogsIndex Object describing a Datadog Log index.
type LogsIndex struct {
	// The number of log events you can send in this index per day before you are rate-limited.
	DailyLimit *int64 `json:"daily_limit,omitempty"`
	// Object containing options to override the default daily limit reset time.
	DailyLimitReset *LogsDailyLimitReset `json:"daily_limit_reset,omitempty"`
	// A percentage threshold of the daily quota at which a Datadog warning event is generated.
	DailyLimitWarningThresholdPercentage *float64 `json:"daily_limit_warning_threshold_percentage,omitempty"`
	// An array of exclusion objects. The logs are tested against the query of each filter,
	// following the order of the array. Only the first matching active exclusion matters,
	// others (if any) are ignored.
	ExclusionFilters []LogsExclusion `json:"exclusion_filters,omitempty"`
	// Filter for logs.
	Filter LogsFilter `json:"filter"`
	// A boolean stating if the index is rate limited, meaning more logs than the daily limit have been sent.
	// Rate limit is reset every-day at 2pm UTC.
	IsRateLimited *bool `json:"is_rate_limited,omitempty"`
	// The name of the index.
	Name string `json:"name"`
	// The total number of days logs are stored in Standard and Flex Tier before being deleted from the index.
	// If Standard Tier is enabled on this index, logs are first retained in Standard Tier for the number of days specified through `num_retention_days`,
	// and then stored in Flex Tier until the number of days specified in `num_flex_logs_retention_days` is reached.
	// The available values depend on retention plans specified in your organization's contract/subscriptions.
	NumFlexLogsRetentionDays *int64 `json:"num_flex_logs_retention_days,omitempty"`
	// The number of days logs are stored in Standard Tier before aging into the Flex Tier or being deleted from the index.
	// The available values depend on retention plans specified in your organization's contract/subscriptions.
	NumRetentionDays *int64 `json:"num_retention_days,omitempty"`
	// UnparsedObject contains the raw value of the object if there was an error when deserializing into the struct
	UnparsedObject       map[string]interface{} `json:"-"`
	AdditionalProperties map[string]interface{} `json:"-"`
}

// NewLogsIndex instantiates a new LogsIndex object.
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed.
func NewLogsIndex(filter LogsFilter, name string) *LogsIndex {
	this := LogsIndex{}
	this.Filter = filter
	this.Name = name
	return &this
}

// NewLogsIndexWithDefaults instantiates a new LogsIndex object.
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set.
func NewLogsIndexWithDefaults() *LogsIndex {
	this := LogsIndex{}
	return &this
}

// GetDailyLimit returns the DailyLimit field value if set, zero value otherwise.
func (o *LogsIndex) GetDailyLimit() int64 {
	if o == nil || o.DailyLimit == nil {
		var ret int64
		return ret
	}
	return *o.DailyLimit
}

// GetDailyLimitOk returns a tuple with the DailyLimit field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *LogsIndex) GetDailyLimitOk() (*int64, bool) {
	if o == nil || o.DailyLimit == nil {
		return nil, false
	}
	return o.DailyLimit, true
}

// HasDailyLimit returns a boolean if a field has been set.
func (o *LogsIndex) HasDailyLimit() bool {
	return o != nil && o.DailyLimit != nil
}

// SetDailyLimit gets a reference to the given int64 and assigns it to the DailyLimit field.
func (o *LogsIndex) SetDailyLimit(v int64) {
	o.DailyLimit = &v
}

// GetDailyLimitReset returns the DailyLimitReset field value if set, zero value otherwise.
func (o *LogsIndex) GetDailyLimitReset() LogsDailyLimitReset {
	if o == nil || o.DailyLimitReset == nil {
		var ret LogsDailyLimitReset
		return ret
	}
	return *o.DailyLimitReset
}

// GetDailyLimitResetOk returns a tuple with the DailyLimitReset field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *LogsIndex) GetDailyLimitResetOk() (*LogsDailyLimitReset, bool) {
	if o == nil || o.DailyLimitReset == nil {
		return nil, false
	}
	return o.DailyLimitReset, true
}

// HasDailyLimitReset returns a boolean if a field has been set.
func (o *LogsIndex) HasDailyLimitReset() bool {
	return o != nil && o.DailyLimitReset != nil
}

// SetDailyLimitReset gets a reference to the given LogsDailyLimitReset and assigns it to the DailyLimitReset field.
func (o *LogsIndex) SetDailyLimitReset(v LogsDailyLimitReset) {
	o.DailyLimitReset = &v
}

// GetDailyLimitWarningThresholdPercentage returns the DailyLimitWarningThresholdPercentage field value if set, zero value otherwise.
func (o *LogsIndex) GetDailyLimitWarningThresholdPercentage() float64 {
	if o == nil || o.DailyLimitWarningThresholdPercentage == nil {
		var ret float64
		return ret
	}
	return *o.DailyLimitWarningThresholdPercentage
}

// GetDailyLimitWarningThresholdPercentageOk returns a tuple with the DailyLimitWarningThresholdPercentage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *LogsIndex) GetDailyLimitWarningThresholdPercentageOk() (*float64, bool) {
	if o == nil || o.DailyLimitWarningThresholdPercentage == nil {
		return nil, false
	}
	return o.DailyLimitWarningThresholdPercentage, true
}

// HasDailyLimitWarningThresholdPercentage returns a boolean if a field has been set.
func (o *LogsIndex) HasDailyLimitWarningThresholdPercentage() bool {
	return o != nil && o.DailyLimitWarningThresholdPercentage != nil
}

// SetDailyLimitWarningThresholdPercentage gets a reference to the given float64 and assigns it to the DailyLimitWarningThresholdPercentage field.
func (o *LogsIndex) SetDailyLimitWarningThresholdPercentage(v float64) {
	o.DailyLimitWarningThresholdPercentage = &v
}

// GetExclusionFilters returns the ExclusionFilters field value if set, zero value otherwise.
func (o *LogsIndex) GetExclusionFilters() []LogsExclusion {
	if o == nil || o.ExclusionFilters == nil {
		var ret []LogsExclusion
		return ret
	}
	return o.ExclusionFilters
}

// GetExclusionFiltersOk returns a tuple with the ExclusionFilters field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *LogsIndex) GetExclusionFiltersOk() (*[]LogsExclusion, bool) {
	if o == nil || o.ExclusionFilters == nil {
		return nil, false
	}
	return &o.ExclusionFilters, true
}

// HasExclusionFilters returns a boolean if a field has been set.
func (o *LogsIndex) HasExclusionFilters() bool {
	return o != nil && o.ExclusionFilters != nil
}

// SetExclusionFilters gets a reference to the given []LogsExclusion and assigns it to the ExclusionFilters field.
func (o *LogsIndex) SetExclusionFilters(v []LogsExclusion) {
	o.ExclusionFilters = v
}

// GetFilter returns the Filter field value.
func (o *LogsIndex) GetFilter() LogsFilter {
	if o == nil {
		var ret LogsFilter
		return ret
	}
	return o.Filter
}

// GetFilterOk returns a tuple with the Filter field value
// and a boolean to check if the value has been set.
func (o *LogsIndex) GetFilterOk() (*LogsFilter, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Filter, true
}

// SetFilter sets field value.
func (o *LogsIndex) SetFilter(v LogsFilter) {
	o.Filter = v
}

// GetIsRateLimited returns the IsRateLimited field value if set, zero value otherwise.
func (o *LogsIndex) GetIsRateLimited() bool {
	if o == nil || o.IsRateLimited == nil {
		var ret bool
		return ret
	}
	return *o.IsRateLimited
}

// GetIsRateLimitedOk returns a tuple with the IsRateLimited field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *LogsIndex) GetIsRateLimitedOk() (*bool, bool) {
	if o == nil || o.IsRateLimited == nil {
		return nil, false
	}
	return o.IsRateLimited, true
}

// HasIsRateLimited returns a boolean if a field has been set.
func (o *LogsIndex) HasIsRateLimited() bool {
	return o != nil && o.IsRateLimited != nil
}

// SetIsRateLimited gets a reference to the given bool and assigns it to the IsRateLimited field.
func (o *LogsIndex) SetIsRateLimited(v bool) {
	o.IsRateLimited = &v
}

// GetName returns the Name field value.
func (o *LogsIndex) GetName() string {
	if o == nil {
		var ret string
		return ret
	}
	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *LogsIndex) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value.
func (o *LogsIndex) SetName(v string) {
	o.Name = v
}

// GetNumFlexLogsRetentionDays returns the NumFlexLogsRetentionDays field value if set, zero value otherwise.
func (o *LogsIndex) GetNumFlexLogsRetentionDays() int64 {
	if o == nil || o.NumFlexLogsRetentionDays == nil {
		var ret int64
		return ret
	}
	return *o.NumFlexLogsRetentionDays
}

// GetNumFlexLogsRetentionDaysOk returns a tuple with the NumFlexLogsRetentionDays field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *LogsIndex) GetNumFlexLogsRetentionDaysOk() (*int64, bool) {
	if o == nil || o.NumFlexLogsRetentionDays == nil {
		return nil, false
	}
	return o.NumFlexLogsRetentionDays, true
}

// HasNumFlexLogsRetentionDays returns a boolean if a field has been set.
func (o *LogsIndex) HasNumFlexLogsRetentionDays() bool {
	return o != nil && o.NumFlexLogsRetentionDays != nil
}

// SetNumFlexLogsRetentionDays gets a reference to the given int64 and assigns it to the NumFlexLogsRetentionDays field.
func (o *LogsIndex) SetNumFlexLogsRetentionDays(v int64) {
	o.NumFlexLogsRetentionDays = &v
}

// GetNumRetentionDays returns the NumRetentionDays field value if set, zero value otherwise.
func (o *LogsIndex) GetNumRetentionDays() int64 {
	if o == nil || o.NumRetentionDays == nil {
		var ret int64
		return ret
	}
	return *o.NumRetentionDays
}

// GetNumRetentionDaysOk returns a tuple with the NumRetentionDays field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *LogsIndex) GetNumRetentionDaysOk() (*int64, bool) {
	if o == nil || o.NumRetentionDays == nil {
		return nil, false
	}
	return o.NumRetentionDays, true
}

// HasNumRetentionDays returns a boolean if a field has been set.
func (o *LogsIndex) HasNumRetentionDays() bool {
	return o != nil && o.NumRetentionDays != nil
}

// SetNumRetentionDays gets a reference to the given int64 and assigns it to the NumRetentionDays field.
func (o *LogsIndex) SetNumRetentionDays(v int64) {
	o.NumRetentionDays = &v
}

// MarshalJSON serializes the struct using spec logic.
func (o LogsIndex) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.UnparsedObject != nil {
		return datadog.Marshal(o.UnparsedObject)
	}
	if o.DailyLimit != nil {
		toSerialize["daily_limit"] = o.DailyLimit
	}
	if o.DailyLimitReset != nil {
		toSerialize["daily_limit_reset"] = o.DailyLimitReset
	}
	if o.DailyLimitWarningThresholdPercentage != nil {
		toSerialize["daily_limit_warning_threshold_percentage"] = o.DailyLimitWarningThresholdPercentage
	}
	if o.ExclusionFilters != nil {
		toSerialize["exclusion_filters"] = o.ExclusionFilters
	}
	toSerialize["filter"] = o.Filter
	if o.IsRateLimited != nil {
		toSerialize["is_rate_limited"] = o.IsRateLimited
	}
	toSerialize["name"] = o.Name
	if o.NumFlexLogsRetentionDays != nil {
		toSerialize["num_flex_logs_retention_days"] = o.NumFlexLogsRetentionDays
	}
	if o.NumRetentionDays != nil {
		toSerialize["num_retention_days"] = o.NumRetentionDays
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}
	return datadog.Marshal(toSerialize)
}

// UnmarshalJSON deserializes the given payload.
func (o *LogsIndex) UnmarshalJSON(bytes []byte) (err error) {
	all := struct {
		DailyLimit                           *int64               `json:"daily_limit,omitempty"`
		DailyLimitReset                      *LogsDailyLimitReset `json:"daily_limit_reset,omitempty"`
		DailyLimitWarningThresholdPercentage *float64             `json:"daily_limit_warning_threshold_percentage,omitempty"`
		ExclusionFilters                     []LogsExclusion      `json:"exclusion_filters,omitempty"`
		Filter                               *LogsFilter          `json:"filter"`
		IsRateLimited                        *bool                `json:"is_rate_limited,omitempty"`
		Name                                 *string              `json:"name"`
		NumFlexLogsRetentionDays             *int64               `json:"num_flex_logs_retention_days,omitempty"`
		NumRetentionDays                     *int64               `json:"num_retention_days,omitempty"`
	}{}
	if err = datadog.Unmarshal(bytes, &all); err != nil {
		return datadog.Unmarshal(bytes, &o.UnparsedObject)
	}
	if all.Filter == nil {
		return fmt.Errorf("required field filter missing")
	}
	if all.Name == nil {
		return fmt.Errorf("required field name missing")
	}
	additionalProperties := make(map[string]interface{})
	if err = datadog.Unmarshal(bytes, &additionalProperties); err == nil {
		datadog.DeleteKeys(additionalProperties, &[]string{"daily_limit", "daily_limit_reset", "daily_limit_warning_threshold_percentage", "exclusion_filters", "filter", "is_rate_limited", "name", "num_flex_logs_retention_days", "num_retention_days"})
	} else {
		return err
	}

	hasInvalidField := false
	o.DailyLimit = all.DailyLimit
	if all.DailyLimitReset != nil && all.DailyLimitReset.UnparsedObject != nil && o.UnparsedObject == nil {
		hasInvalidField = true
	}
	o.DailyLimitReset = all.DailyLimitReset
	o.DailyLimitWarningThresholdPercentage = all.DailyLimitWarningThresholdPercentage
	o.ExclusionFilters = all.ExclusionFilters
	if all.Filter.UnparsedObject != nil && o.UnparsedObject == nil {
		hasInvalidField = true
	}
	o.Filter = *all.Filter
	o.IsRateLimited = all.IsRateLimited
	o.Name = *all.Name
	o.NumFlexLogsRetentionDays = all.NumFlexLogsRetentionDays
	o.NumRetentionDays = all.NumRetentionDays

	if len(additionalProperties) > 0 {
		o.AdditionalProperties = additionalProperties
	}

	if hasInvalidField {
		return datadog.Unmarshal(bytes, &o.UnparsedObject)
	}

	return nil
}
