// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV2

import (
	"fmt"

	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// AuthNMappingsType AuthN Mappings resource type.
type AuthNMappingsType string

// List of AuthNMappingsType.
const (
	AUTHNMAPPINGSTYPE_AUTHN_MAPPINGS AuthNMappingsType = "authn_mappings"
)

var allowedAuthNMappingsTypeEnumValues = []AuthNMappingsType{
	AUTHNMAPPINGSTYPE_AUTHN_MAPPINGS,
}

// GetAllowedValues reeturns the list of possible values.
func (v *AuthNMappingsType) GetAllowedValues() []AuthNMappingsType {
	return allowedAuthNMappingsTypeEnumValues
}

// UnmarshalJSON deserializes the given payload.
func (v *AuthNMappingsType) UnmarshalJSON(src []byte) error {
	var value string
	err := datadog.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	*v = AuthNMappingsType(value)
	return nil
}

// NewAuthNMappingsTypeFromValue returns a pointer to a valid AuthNMappingsType
// for the value passed as argument, or an error if the value passed is not allowed by the enum.
func NewAuthNMappingsTypeFromValue(v string) (*AuthNMappingsType, error) {
	ev := AuthNMappingsType(v)
	if ev.IsValid() {
		return &ev, nil
	}
	return nil, fmt.Errorf("invalid value '%v' for AuthNMappingsType: valid values are %v", v, allowedAuthNMappingsTypeEnumValues)
}

// IsValid return true if the value is valid for the enum, false otherwise.
func (v AuthNMappingsType) IsValid() bool {
	for _, existing := range allowedAuthNMappingsTypeEnumValues {
		if existing == v {
			return true
		}
	}
	return false
}

// Ptr returns reference to AuthNMappingsType value.
func (v AuthNMappingsType) Ptr() *AuthNMappingsType {
	return &v
}
