// Code generated by bpf2go; DO NOT EDIT.
//go:build 386 || amd64

package tpinjector

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"
	"structs"

	"github.com/cilium/ebpf"
)

type BpfDebugConnectionInfoPartT struct {
	_    structs.HostLayout
	Addr [16]uint8
	Pid  uint32
	Port uint16
	Type uint8
	Pad  uint8
}

type BpfDebugConnectionInfoT struct {
	_      structs.HostLayout
	S_addr [16]uint8
	D_addr [16]uint8
	S_port uint16
	D_port uint16
}

type BpfDebugCpSupportDataT struct {
	_          structs.HostLayout
	T_key      BpfDebugTraceKeyT
	RealClient uint8
	Pad        [7]uint8
}

type BpfDebugEgressKeyT struct {
	_      structs.HostLayout
	S_port uint16
	D_port uint16
}

type BpfDebugFdInfoT struct {
	_    structs.HostLayout
	Pid  BpfDebugPidKeyT
	Fd   int32
	Type uint32
}

type BpfDebugFdKey struct {
	_       structs.HostLayout
	PidTgid uint64
	Fd      int32
	Pad     [4]uint8
}

type BpfDebugMsgBufferT struct {
	_   structs.HostLayout
	Buf [256]uint8
	Pos uint16
}

type BpfDebugPidConnectionInfoT struct {
	_    structs.HostLayout
	Conn BpfDebugConnectionInfoT
	Pid  uint32
}

type BpfDebugPidKeyT struct {
	_   structs.HostLayout
	Tid uint32
	Pid uint32
	Ns  uint32
}

type BpfDebugSslArgsT struct {
	_      structs.HostLayout
	Ssl    uint64
	Buf    uint64
	LenPtr uint64
	Flags  uint64
}

type BpfDebugSslPidConnectionInfoT struct {
	_         structs.HostLayout
	P_conn    BpfDebugPidConnectionInfoT
	OrigDport uint16
	Pad       [6]uint8
}

type BpfDebugTpInfoPidT struct {
	_  structs.HostLayout
	Tp struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Pid     uint32
	Valid   uint8
	Written uint8
	ReqType uint8
	Pad     [1]uint8
}

type BpfDebugTraceKeyT struct {
	_       structs.HostLayout
	ExtraId uint64
	P_key   BpfDebugPidKeyT
	Pad     [4]uint8
}

type BpfDebugTraceMapKeyT struct {
	_    structs.HostLayout
	Conn BpfDebugConnectionInfoT
	Type uint32
}

// LoadBpfDebug returns the embedded CollectionSpec for BpfDebug.
func LoadBpfDebug() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_BpfDebugBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load BpfDebug: %w", err)
	}

	return spec, err
}

// LoadBpfDebugObjects loads BpfDebug and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*BpfDebugObjects
//	*BpfDebugPrograms
//	*BpfDebugMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func LoadBpfDebugObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := LoadBpfDebug()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// BpfDebugSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfDebugSpecs struct {
	BpfDebugProgramSpecs
	BpfDebugMapSpecs
	BpfDebugVariableSpecs
}

// BpfDebugProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfDebugProgramSpecs struct {
	ObiPacketExtender           *ebpf.ProgramSpec `ebpf:"obi_packet_extender"`
	ObiPacketExtenderWriteMsgTp *ebpf.ProgramSpec `ebpf:"obi_packet_extender_write_msg_tp"`
	ObiSockmapTracker           *ebpf.ProgramSpec `ebpf:"obi_sockmap_tracker"`
}

// BpfDebugMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfDebugMapSpecs struct {
	ActiveSslConnections *ebpf.MapSpec `ebpf:"active_ssl_connections"`
	ActiveSslReadArgs    *ebpf.MapSpec `ebpf:"active_ssl_read_args"`
	ActiveSslWriteArgs   *ebpf.MapSpec `ebpf:"active_ssl_write_args"`
	ActiveUnixSocks      *ebpf.MapSpec `ebpf:"active_unix_socks"`
	CloneMap             *ebpf.MapSpec `ebpf:"clone_map"`
	CpSupportConnectInfo *ebpf.MapSpec `ebpf:"cp_support_connect_info"`
	DebugEvents          *ebpf.MapSpec `ebpf:"debug_events"`
	EgressKeyMem         *ebpf.MapSpec `ebpf:"egress_key_mem"`
	Events               *ebpf.MapSpec `ebpf:"events"`
	ExtenderJumpTable    *ebpf.MapSpec `ebpf:"extender_jump_table"`
	FdMap                *ebpf.MapSpec `ebpf:"fd_map"`
	FdToConnection       *ebpf.MapSpec `ebpf:"fd_to_connection"`
	IncomingTraceMap     *ebpf.MapSpec `ebpf:"incoming_trace_map"`
	MsgBuffers           *ebpf.MapSpec `ebpf:"msg_buffers"`
	NginxUpstream        *ebpf.MapSpec `ebpf:"nginx_upstream"`
	NodejsFdMap          *ebpf.MapSpec `ebpf:"nodejs_fd_map"`
	OutgoingTraceMap     *ebpf.MapSpec `ebpf:"outgoing_trace_map"`
	PidCache             *ebpf.MapSpec `ebpf:"pid_cache"`
	PidConnectionInfoMem *ebpf.MapSpec `ebpf:"pid_connection_info_mem"`
	ServerTraces         *ebpf.MapSpec `ebpf:"server_traces"`
	ServerTracesAux      *ebpf.MapSpec `ebpf:"server_traces_aux"`
	SockDir              *ebpf.MapSpec `ebpf:"sock_dir"`
	SslToConn            *ebpf.MapSpec `ebpf:"ssl_to_conn"`
	TpCharBufMem         *ebpf.MapSpec `ebpf:"tp_char_buf_mem"`
	TpInfoMem            *ebpf.MapSpec `ebpf:"tp_info_mem"`
	TraceMap             *ebpf.MapSpec `ebpf:"trace_map"`
	ValidPids            *ebpf.MapSpec `ebpf:"valid_pids"`
}

// BpfDebugVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfDebugVariableSpecs struct {
	EXTEND_SIZE       *ebpf.VariableSpec `ebpf:"EXTEND_SIZE"`
	INVALID_POS       *ebpf.VariableSpec `ebpf:"INVALID_POS"`
	TP                *ebpf.VariableSpec `ebpf:"TP"`
	TP_PREFIX         *ebpf.VariableSpec `ebpf:"TP_PREFIX"`
	TP_PREFIX_SIZE    *ebpf.VariableSpec `ebpf:"TP_PREFIX_SIZE"`
	DisableBlackBoxCp *ebpf.VariableSpec `ebpf:"disable_black_box_cp"`
	FilterPids        *ebpf.VariableSpec `ebpf:"filter_pids"`
	Ip4ip6Prefix      *ebpf.VariableSpec `ebpf:"ip4ip6_prefix"`
	Unused            *ebpf.VariableSpec `ebpf:"unused"`
	UnusedHttp2       *ebpf.VariableSpec `ebpf:"unused_http2"`
	WakeupDataBytes   *ebpf.VariableSpec `ebpf:"wakeup_data_bytes"`
}

// BpfDebugObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to LoadBpfDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfDebugObjects struct {
	BpfDebugPrograms
	BpfDebugMaps
	BpfDebugVariables
}

func (o *BpfDebugObjects) Close() error {
	return _BpfDebugClose(
		&o.BpfDebugPrograms,
		&o.BpfDebugMaps,
	)
}

// BpfDebugMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to LoadBpfDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfDebugMaps struct {
	ActiveSslConnections *ebpf.Map `ebpf:"active_ssl_connections"`
	ActiveSslReadArgs    *ebpf.Map `ebpf:"active_ssl_read_args"`
	ActiveSslWriteArgs   *ebpf.Map `ebpf:"active_ssl_write_args"`
	ActiveUnixSocks      *ebpf.Map `ebpf:"active_unix_socks"`
	CloneMap             *ebpf.Map `ebpf:"clone_map"`
	CpSupportConnectInfo *ebpf.Map `ebpf:"cp_support_connect_info"`
	DebugEvents          *ebpf.Map `ebpf:"debug_events"`
	EgressKeyMem         *ebpf.Map `ebpf:"egress_key_mem"`
	Events               *ebpf.Map `ebpf:"events"`
	ExtenderJumpTable    *ebpf.Map `ebpf:"extender_jump_table"`
	FdMap                *ebpf.Map `ebpf:"fd_map"`
	FdToConnection       *ebpf.Map `ebpf:"fd_to_connection"`
	IncomingTraceMap     *ebpf.Map `ebpf:"incoming_trace_map"`
	MsgBuffers           *ebpf.Map `ebpf:"msg_buffers"`
	NginxUpstream        *ebpf.Map `ebpf:"nginx_upstream"`
	NodejsFdMap          *ebpf.Map `ebpf:"nodejs_fd_map"`
	OutgoingTraceMap     *ebpf.Map `ebpf:"outgoing_trace_map"`
	PidCache             *ebpf.Map `ebpf:"pid_cache"`
	PidConnectionInfoMem *ebpf.Map `ebpf:"pid_connection_info_mem"`
	ServerTraces         *ebpf.Map `ebpf:"server_traces"`
	ServerTracesAux      *ebpf.Map `ebpf:"server_traces_aux"`
	SockDir              *ebpf.Map `ebpf:"sock_dir"`
	SslToConn            *ebpf.Map `ebpf:"ssl_to_conn"`
	TpCharBufMem         *ebpf.Map `ebpf:"tp_char_buf_mem"`
	TpInfoMem            *ebpf.Map `ebpf:"tp_info_mem"`
	TraceMap             *ebpf.Map `ebpf:"trace_map"`
	ValidPids            *ebpf.Map `ebpf:"valid_pids"`
}

func (m *BpfDebugMaps) Close() error {
	return _BpfDebugClose(
		m.ActiveSslConnections,
		m.ActiveSslReadArgs,
		m.ActiveSslWriteArgs,
		m.ActiveUnixSocks,
		m.CloneMap,
		m.CpSupportConnectInfo,
		m.DebugEvents,
		m.EgressKeyMem,
		m.Events,
		m.ExtenderJumpTable,
		m.FdMap,
		m.FdToConnection,
		m.IncomingTraceMap,
		m.MsgBuffers,
		m.NginxUpstream,
		m.NodejsFdMap,
		m.OutgoingTraceMap,
		m.PidCache,
		m.PidConnectionInfoMem,
		m.ServerTraces,
		m.ServerTracesAux,
		m.SockDir,
		m.SslToConn,
		m.TpCharBufMem,
		m.TpInfoMem,
		m.TraceMap,
		m.ValidPids,
	)
}

// BpfDebugVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to LoadBpfDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfDebugVariables struct {
	EXTEND_SIZE       *ebpf.Variable `ebpf:"EXTEND_SIZE"`
	INVALID_POS       *ebpf.Variable `ebpf:"INVALID_POS"`
	TP                *ebpf.Variable `ebpf:"TP"`
	TP_PREFIX         *ebpf.Variable `ebpf:"TP_PREFIX"`
	TP_PREFIX_SIZE    *ebpf.Variable `ebpf:"TP_PREFIX_SIZE"`
	DisableBlackBoxCp *ebpf.Variable `ebpf:"disable_black_box_cp"`
	FilterPids        *ebpf.Variable `ebpf:"filter_pids"`
	Ip4ip6Prefix      *ebpf.Variable `ebpf:"ip4ip6_prefix"`
	Unused            *ebpf.Variable `ebpf:"unused"`
	UnusedHttp2       *ebpf.Variable `ebpf:"unused_http2"`
	WakeupDataBytes   *ebpf.Variable `ebpf:"wakeup_data_bytes"`
}

// BpfDebugPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to LoadBpfDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfDebugPrograms struct {
	ObiPacketExtender           *ebpf.Program `ebpf:"obi_packet_extender"`
	ObiPacketExtenderWriteMsgTp *ebpf.Program `ebpf:"obi_packet_extender_write_msg_tp"`
	ObiSockmapTracker           *ebpf.Program `ebpf:"obi_sockmap_tracker"`
}

func (p *BpfDebugPrograms) Close() error {
	return _BpfDebugClose(
		p.ObiPacketExtender,
		p.ObiPacketExtenderWriteMsgTp,
		p.ObiSockmapTracker,
	)
}

func _BpfDebugClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed bpfdebug_x86_bpfel.o
var _BpfDebugBytes []byte
