// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	monitoringv1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	appsv1 "k8s.io/api/apps/v1"
	corev1 "k8s.io/api/core/v1"
	metav1 "k8s.io/client-go/applyconfigurations/meta/v1"
)

// CommonPrometheusFieldsApplyConfiguration represents a declarative configuration of the CommonPrometheusFields type for use
// with apply.
type CommonPrometheusFieldsApplyConfiguration struct {
	PodMetadata                          *EmbeddedObjectMetadataApplyConfiguration               `json:"podMetadata,omitempty"`
	ServiceMonitorSelector               *metav1.LabelSelectorApplyConfiguration                 `json:"serviceMonitorSelector,omitempty"`
	ServiceMonitorNamespaceSelector      *metav1.LabelSelectorApplyConfiguration                 `json:"serviceMonitorNamespaceSelector,omitempty"`
	PodMonitorSelector                   *metav1.LabelSelectorApplyConfiguration                 `json:"podMonitorSelector,omitempty"`
	PodMonitorNamespaceSelector          *metav1.LabelSelectorApplyConfiguration                 `json:"podMonitorNamespaceSelector,omitempty"`
	ProbeSelector                        *metav1.LabelSelectorApplyConfiguration                 `json:"probeSelector,omitempty"`
	ProbeNamespaceSelector               *metav1.LabelSelectorApplyConfiguration                 `json:"probeNamespaceSelector,omitempty"`
	ScrapeConfigSelector                 *metav1.LabelSelectorApplyConfiguration                 `json:"scrapeConfigSelector,omitempty"`
	ScrapeConfigNamespaceSelector        *metav1.LabelSelectorApplyConfiguration                 `json:"scrapeConfigNamespaceSelector,omitempty"`
	Version                              *string                                                 `json:"version,omitempty"`
	Paused                               *bool                                                   `json:"paused,omitempty"`
	Image                                *string                                                 `json:"image,omitempty"`
	ImagePullPolicy                      *corev1.PullPolicy                                      `json:"imagePullPolicy,omitempty"`
	ImagePullSecrets                     []corev1.LocalObjectReference                           `json:"imagePullSecrets,omitempty"`
	Replicas                             *int32                                                  `json:"replicas,omitempty"`
	Shards                               *int32                                                  `json:"shards,omitempty"`
	ReplicaExternalLabelName             *string                                                 `json:"replicaExternalLabelName,omitempty"`
	PrometheusExternalLabelName          *string                                                 `json:"prometheusExternalLabelName,omitempty"`
	LogLevel                             *string                                                 `json:"logLevel,omitempty"`
	LogFormat                            *string                                                 `json:"logFormat,omitempty"`
	ScrapeInterval                       *monitoringv1.Duration                                  `json:"scrapeInterval,omitempty"`
	ScrapeTimeout                        *monitoringv1.Duration                                  `json:"scrapeTimeout,omitempty"`
	ScrapeProtocols                      []monitoringv1.ScrapeProtocol                           `json:"scrapeProtocols,omitempty"`
	ExternalLabels                       map[string]string                                       `json:"externalLabels,omitempty"`
	EnableRemoteWriteReceiver            *bool                                                   `json:"enableRemoteWriteReceiver,omitempty"`
	EnableOTLPReceiver                   *bool                                                   `json:"enableOTLPReceiver,omitempty"`
	RemoteWriteReceiverMessageVersions   []monitoringv1.RemoteWriteMessageVersion                `json:"remoteWriteReceiverMessageVersions,omitempty"`
	EnableFeatures                       []monitoringv1.EnableFeature                            `json:"enableFeatures,omitempty"`
	ExternalURL                          *string                                                 `json:"externalUrl,omitempty"`
	RoutePrefix                          *string                                                 `json:"routePrefix,omitempty"`
	Storage                              *StorageSpecApplyConfiguration                          `json:"storage,omitempty"`
	Volumes                              []corev1.Volume                                         `json:"volumes,omitempty"`
	VolumeMounts                         []corev1.VolumeMount                                    `json:"volumeMounts,omitempty"`
	PersistentVolumeClaimRetentionPolicy *appsv1.StatefulSetPersistentVolumeClaimRetentionPolicy `json:"persistentVolumeClaimRetentionPolicy,omitempty"`
	Web                                  *PrometheusWebSpecApplyConfiguration                    `json:"web,omitempty"`
	Resources                            *corev1.ResourceRequirements                            `json:"resources,omitempty"`
	NodeSelector                         map[string]string                                       `json:"nodeSelector,omitempty"`
	ServiceAccountName                   *string                                                 `json:"serviceAccountName,omitempty"`
	AutomountServiceAccountToken         *bool                                                   `json:"automountServiceAccountToken,omitempty"`
	Secrets                              []string                                                `json:"secrets,omitempty"`
	ConfigMaps                           []string                                                `json:"configMaps,omitempty"`
	Affinity                             *corev1.Affinity                                        `json:"affinity,omitempty"`
	Tolerations                          []corev1.Toleration                                     `json:"tolerations,omitempty"`
	TopologySpreadConstraints            []TopologySpreadConstraintApplyConfiguration            `json:"topologySpreadConstraints,omitempty"`
	RemoteWrite                          []RemoteWriteSpecApplyConfiguration                     `json:"remoteWrite,omitempty"`
	OTLP                                 *OTLPConfigApplyConfiguration                           `json:"otlp,omitempty"`
	SecurityContext                      *corev1.PodSecurityContext                              `json:"securityContext,omitempty"`
	DNSPolicy                            *monitoringv1.DNSPolicy                                 `json:"dnsPolicy,omitempty"`
	DNSConfig                            *PodDNSConfigApplyConfiguration                         `json:"dnsConfig,omitempty"`
	ListenLocal                          *bool                                                   `json:"listenLocal,omitempty"`
	EnableServiceLinks                   *bool                                                   `json:"enableServiceLinks,omitempty"`
	Containers                           []corev1.Container                                      `json:"containers,omitempty"`
	InitContainers                       []corev1.Container                                      `json:"initContainers,omitempty"`
	AdditionalScrapeConfigs              *corev1.SecretKeySelector                               `json:"additionalScrapeConfigs,omitempty"`
	APIServerConfig                      *APIServerConfigApplyConfiguration                      `json:"apiserverConfig,omitempty"`
	PriorityClassName                    *string                                                 `json:"priorityClassName,omitempty"`
	PortName                             *string                                                 `json:"portName,omitempty"`
	ArbitraryFSAccessThroughSMs          *ArbitraryFSAccessThroughSMsConfigApplyConfiguration    `json:"arbitraryFSAccessThroughSMs,omitempty"`
	OverrideHonorLabels                  *bool                                                   `json:"overrideHonorLabels,omitempty"`
	OverrideHonorTimestamps              *bool                                                   `json:"overrideHonorTimestamps,omitempty"`
	IgnoreNamespaceSelectors             *bool                                                   `json:"ignoreNamespaceSelectors,omitempty"`
	EnforcedNamespaceLabel               *string                                                 `json:"enforcedNamespaceLabel,omitempty"`
	EnforcedSampleLimit                  *uint64                                                 `json:"enforcedSampleLimit,omitempty"`
	EnforcedTargetLimit                  *uint64                                                 `json:"enforcedTargetLimit,omitempty"`
	EnforcedLabelLimit                   *uint64                                                 `json:"enforcedLabelLimit,omitempty"`
	EnforcedLabelNameLengthLimit         *uint64                                                 `json:"enforcedLabelNameLengthLimit,omitempty"`
	EnforcedLabelValueLengthLimit        *uint64                                                 `json:"enforcedLabelValueLengthLimit,omitempty"`
	EnforcedKeepDroppedTargets           *uint64                                                 `json:"enforcedKeepDroppedTargets,omitempty"`
	EnforcedBodySizeLimit                *monitoringv1.ByteSize                                  `json:"enforcedBodySizeLimit,omitempty"`
	NameValidationScheme                 *monitoringv1.NameValidationSchemeOptions               `json:"nameValidationScheme,omitempty"`
	MinReadySeconds                      *uint32                                                 `json:"minReadySeconds,omitempty"`
	HostAliases                          []HostAliasApplyConfiguration                           `json:"hostAliases,omitempty"`
	AdditionalArgs                       []ArgumentApplyConfiguration                            `json:"additionalArgs,omitempty"`
	WALCompression                       *bool                                                   `json:"walCompression,omitempty"`
	ExcludedFromEnforcement              []ObjectReferenceApplyConfiguration                     `json:"excludedFromEnforcement,omitempty"`
	HostNetwork                          *bool                                                   `json:"hostNetwork,omitempty"`
	PodTargetLabels                      []string                                                `json:"podTargetLabels,omitempty"`
	TracingConfig                        *PrometheusTracingConfigApplyConfiguration              `json:"tracingConfig,omitempty"`
	BodySizeLimit                        *monitoringv1.ByteSize                                  `json:"bodySizeLimit,omitempty"`
	SampleLimit                          *uint64                                                 `json:"sampleLimit,omitempty"`
	TargetLimit                          *uint64                                                 `json:"targetLimit,omitempty"`
	LabelLimit                           *uint64                                                 `json:"labelLimit,omitempty"`
	LabelNameLengthLimit                 *uint64                                                 `json:"labelNameLengthLimit,omitempty"`
	LabelValueLengthLimit                *uint64                                                 `json:"labelValueLengthLimit,omitempty"`
	KeepDroppedTargets                   *uint64                                                 `json:"keepDroppedTargets,omitempty"`
	ReloadStrategy                       *monitoringv1.ReloadStrategyType                        `json:"reloadStrategy,omitempty"`
	MaximumStartupDurationSeconds        *int32                                                  `json:"maximumStartupDurationSeconds,omitempty"`
	ScrapeClasses                        []ScrapeClassApplyConfiguration                         `json:"scrapeClasses,omitempty"`
	ServiceDiscoveryRole                 *monitoringv1.ServiceDiscoveryRole                      `json:"serviceDiscoveryRole,omitempty"`
	TSDB                                 *TSDBSpecApplyConfiguration                             `json:"tsdb,omitempty"`
	ScrapeFailureLogFile                 *string                                                 `json:"scrapeFailureLogFile,omitempty"`
	ServiceName                          *string                                                 `json:"serviceName,omitempty"`
	Runtime                              *RuntimeConfigApplyConfiguration                        `json:"runtime,omitempty"`
	TerminationGracePeriodSeconds        *int64                                                  `json:"terminationGracePeriodSeconds,omitempty"`
}

// CommonPrometheusFieldsApplyConfiguration constructs a declarative configuration of the CommonPrometheusFields type for use with
// apply.
func CommonPrometheusFields() *CommonPrometheusFieldsApplyConfiguration {
	return &CommonPrometheusFieldsApplyConfiguration{}
}

// WithPodMetadata sets the PodMetadata field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PodMetadata field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithPodMetadata(value *EmbeddedObjectMetadataApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	b.PodMetadata = value
	return b
}

// WithServiceMonitorSelector sets the ServiceMonitorSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServiceMonitorSelector field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithServiceMonitorSelector(value *metav1.LabelSelectorApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	b.ServiceMonitorSelector = value
	return b
}

// WithServiceMonitorNamespaceSelector sets the ServiceMonitorNamespaceSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServiceMonitorNamespaceSelector field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithServiceMonitorNamespaceSelector(value *metav1.LabelSelectorApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	b.ServiceMonitorNamespaceSelector = value
	return b
}

// WithPodMonitorSelector sets the PodMonitorSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PodMonitorSelector field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithPodMonitorSelector(value *metav1.LabelSelectorApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	b.PodMonitorSelector = value
	return b
}

// WithPodMonitorNamespaceSelector sets the PodMonitorNamespaceSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PodMonitorNamespaceSelector field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithPodMonitorNamespaceSelector(value *metav1.LabelSelectorApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	b.PodMonitorNamespaceSelector = value
	return b
}

// WithProbeSelector sets the ProbeSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ProbeSelector field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithProbeSelector(value *metav1.LabelSelectorApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	b.ProbeSelector = value
	return b
}

// WithProbeNamespaceSelector sets the ProbeNamespaceSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ProbeNamespaceSelector field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithProbeNamespaceSelector(value *metav1.LabelSelectorApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	b.ProbeNamespaceSelector = value
	return b
}

// WithScrapeConfigSelector sets the ScrapeConfigSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ScrapeConfigSelector field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithScrapeConfigSelector(value *metav1.LabelSelectorApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	b.ScrapeConfigSelector = value
	return b
}

// WithScrapeConfigNamespaceSelector sets the ScrapeConfigNamespaceSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ScrapeConfigNamespaceSelector field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithScrapeConfigNamespaceSelector(value *metav1.LabelSelectorApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	b.ScrapeConfigNamespaceSelector = value
	return b
}

// WithVersion sets the Version field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Version field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithVersion(value string) *CommonPrometheusFieldsApplyConfiguration {
	b.Version = &value
	return b
}

// WithPaused sets the Paused field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Paused field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithPaused(value bool) *CommonPrometheusFieldsApplyConfiguration {
	b.Paused = &value
	return b
}

// WithImage sets the Image field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Image field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithImage(value string) *CommonPrometheusFieldsApplyConfiguration {
	b.Image = &value
	return b
}

// WithImagePullPolicy sets the ImagePullPolicy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ImagePullPolicy field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithImagePullPolicy(value corev1.PullPolicy) *CommonPrometheusFieldsApplyConfiguration {
	b.ImagePullPolicy = &value
	return b
}

// WithImagePullSecrets adds the given value to the ImagePullSecrets field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ImagePullSecrets field.
func (b *CommonPrometheusFieldsApplyConfiguration) WithImagePullSecrets(values ...corev1.LocalObjectReference) *CommonPrometheusFieldsApplyConfiguration {
	for i := range values {
		b.ImagePullSecrets = append(b.ImagePullSecrets, values[i])
	}
	return b
}

// WithReplicas sets the Replicas field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Replicas field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithReplicas(value int32) *CommonPrometheusFieldsApplyConfiguration {
	b.Replicas = &value
	return b
}

// WithShards sets the Shards field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Shards field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithShards(value int32) *CommonPrometheusFieldsApplyConfiguration {
	b.Shards = &value
	return b
}

// WithReplicaExternalLabelName sets the ReplicaExternalLabelName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ReplicaExternalLabelName field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithReplicaExternalLabelName(value string) *CommonPrometheusFieldsApplyConfiguration {
	b.ReplicaExternalLabelName = &value
	return b
}

// WithPrometheusExternalLabelName sets the PrometheusExternalLabelName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PrometheusExternalLabelName field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithPrometheusExternalLabelName(value string) *CommonPrometheusFieldsApplyConfiguration {
	b.PrometheusExternalLabelName = &value
	return b
}

// WithLogLevel sets the LogLevel field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LogLevel field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithLogLevel(value string) *CommonPrometheusFieldsApplyConfiguration {
	b.LogLevel = &value
	return b
}

// WithLogFormat sets the LogFormat field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LogFormat field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithLogFormat(value string) *CommonPrometheusFieldsApplyConfiguration {
	b.LogFormat = &value
	return b
}

// WithScrapeInterval sets the ScrapeInterval field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ScrapeInterval field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithScrapeInterval(value monitoringv1.Duration) *CommonPrometheusFieldsApplyConfiguration {
	b.ScrapeInterval = &value
	return b
}

// WithScrapeTimeout sets the ScrapeTimeout field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ScrapeTimeout field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithScrapeTimeout(value monitoringv1.Duration) *CommonPrometheusFieldsApplyConfiguration {
	b.ScrapeTimeout = &value
	return b
}

// WithScrapeProtocols adds the given value to the ScrapeProtocols field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ScrapeProtocols field.
func (b *CommonPrometheusFieldsApplyConfiguration) WithScrapeProtocols(values ...monitoringv1.ScrapeProtocol) *CommonPrometheusFieldsApplyConfiguration {
	for i := range values {
		b.ScrapeProtocols = append(b.ScrapeProtocols, values[i])
	}
	return b
}

// WithExternalLabels puts the entries into the ExternalLabels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the ExternalLabels field,
// overwriting an existing map entries in ExternalLabels field with the same key.
func (b *CommonPrometheusFieldsApplyConfiguration) WithExternalLabels(entries map[string]string) *CommonPrometheusFieldsApplyConfiguration {
	if b.ExternalLabels == nil && len(entries) > 0 {
		b.ExternalLabels = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.ExternalLabels[k] = v
	}
	return b
}

// WithEnableRemoteWriteReceiver sets the EnableRemoteWriteReceiver field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnableRemoteWriteReceiver field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithEnableRemoteWriteReceiver(value bool) *CommonPrometheusFieldsApplyConfiguration {
	b.EnableRemoteWriteReceiver = &value
	return b
}

// WithEnableOTLPReceiver sets the EnableOTLPReceiver field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnableOTLPReceiver field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithEnableOTLPReceiver(value bool) *CommonPrometheusFieldsApplyConfiguration {
	b.EnableOTLPReceiver = &value
	return b
}

// WithRemoteWriteReceiverMessageVersions adds the given value to the RemoteWriteReceiverMessageVersions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the RemoteWriteReceiverMessageVersions field.
func (b *CommonPrometheusFieldsApplyConfiguration) WithRemoteWriteReceiverMessageVersions(values ...monitoringv1.RemoteWriteMessageVersion) *CommonPrometheusFieldsApplyConfiguration {
	for i := range values {
		b.RemoteWriteReceiverMessageVersions = append(b.RemoteWriteReceiverMessageVersions, values[i])
	}
	return b
}

// WithEnableFeatures adds the given value to the EnableFeatures field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the EnableFeatures field.
func (b *CommonPrometheusFieldsApplyConfiguration) WithEnableFeatures(values ...monitoringv1.EnableFeature) *CommonPrometheusFieldsApplyConfiguration {
	for i := range values {
		b.EnableFeatures = append(b.EnableFeatures, values[i])
	}
	return b
}

// WithExternalURL sets the ExternalURL field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ExternalURL field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithExternalURL(value string) *CommonPrometheusFieldsApplyConfiguration {
	b.ExternalURL = &value
	return b
}

// WithRoutePrefix sets the RoutePrefix field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RoutePrefix field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithRoutePrefix(value string) *CommonPrometheusFieldsApplyConfiguration {
	b.RoutePrefix = &value
	return b
}

// WithStorage sets the Storage field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Storage field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithStorage(value *StorageSpecApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	b.Storage = value
	return b
}

// WithVolumes adds the given value to the Volumes field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Volumes field.
func (b *CommonPrometheusFieldsApplyConfiguration) WithVolumes(values ...corev1.Volume) *CommonPrometheusFieldsApplyConfiguration {
	for i := range values {
		b.Volumes = append(b.Volumes, values[i])
	}
	return b
}

// WithVolumeMounts adds the given value to the VolumeMounts field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the VolumeMounts field.
func (b *CommonPrometheusFieldsApplyConfiguration) WithVolumeMounts(values ...corev1.VolumeMount) *CommonPrometheusFieldsApplyConfiguration {
	for i := range values {
		b.VolumeMounts = append(b.VolumeMounts, values[i])
	}
	return b
}

// WithPersistentVolumeClaimRetentionPolicy sets the PersistentVolumeClaimRetentionPolicy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PersistentVolumeClaimRetentionPolicy field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithPersistentVolumeClaimRetentionPolicy(value appsv1.StatefulSetPersistentVolumeClaimRetentionPolicy) *CommonPrometheusFieldsApplyConfiguration {
	b.PersistentVolumeClaimRetentionPolicy = &value
	return b
}

// WithWeb sets the Web field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Web field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithWeb(value *PrometheusWebSpecApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	b.Web = value
	return b
}

// WithResources sets the Resources field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Resources field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithResources(value corev1.ResourceRequirements) *CommonPrometheusFieldsApplyConfiguration {
	b.Resources = &value
	return b
}

// WithNodeSelector puts the entries into the NodeSelector field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the NodeSelector field,
// overwriting an existing map entries in NodeSelector field with the same key.
func (b *CommonPrometheusFieldsApplyConfiguration) WithNodeSelector(entries map[string]string) *CommonPrometheusFieldsApplyConfiguration {
	if b.NodeSelector == nil && len(entries) > 0 {
		b.NodeSelector = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.NodeSelector[k] = v
	}
	return b
}

// WithServiceAccountName sets the ServiceAccountName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServiceAccountName field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithServiceAccountName(value string) *CommonPrometheusFieldsApplyConfiguration {
	b.ServiceAccountName = &value
	return b
}

// WithAutomountServiceAccountToken sets the AutomountServiceAccountToken field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AutomountServiceAccountToken field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithAutomountServiceAccountToken(value bool) *CommonPrometheusFieldsApplyConfiguration {
	b.AutomountServiceAccountToken = &value
	return b
}

// WithSecrets adds the given value to the Secrets field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Secrets field.
func (b *CommonPrometheusFieldsApplyConfiguration) WithSecrets(values ...string) *CommonPrometheusFieldsApplyConfiguration {
	for i := range values {
		b.Secrets = append(b.Secrets, values[i])
	}
	return b
}

// WithConfigMaps adds the given value to the ConfigMaps field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ConfigMaps field.
func (b *CommonPrometheusFieldsApplyConfiguration) WithConfigMaps(values ...string) *CommonPrometheusFieldsApplyConfiguration {
	for i := range values {
		b.ConfigMaps = append(b.ConfigMaps, values[i])
	}
	return b
}

// WithAffinity sets the Affinity field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Affinity field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithAffinity(value corev1.Affinity) *CommonPrometheusFieldsApplyConfiguration {
	b.Affinity = &value
	return b
}

// WithTolerations adds the given value to the Tolerations field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Tolerations field.
func (b *CommonPrometheusFieldsApplyConfiguration) WithTolerations(values ...corev1.Toleration) *CommonPrometheusFieldsApplyConfiguration {
	for i := range values {
		b.Tolerations = append(b.Tolerations, values[i])
	}
	return b
}

// WithTopologySpreadConstraints adds the given value to the TopologySpreadConstraints field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the TopologySpreadConstraints field.
func (b *CommonPrometheusFieldsApplyConfiguration) WithTopologySpreadConstraints(values ...*TopologySpreadConstraintApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithTopologySpreadConstraints")
		}
		b.TopologySpreadConstraints = append(b.TopologySpreadConstraints, *values[i])
	}
	return b
}

// WithRemoteWrite adds the given value to the RemoteWrite field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the RemoteWrite field.
func (b *CommonPrometheusFieldsApplyConfiguration) WithRemoteWrite(values ...*RemoteWriteSpecApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithRemoteWrite")
		}
		b.RemoteWrite = append(b.RemoteWrite, *values[i])
	}
	return b
}

// WithOTLP sets the OTLP field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the OTLP field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithOTLP(value *OTLPConfigApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	b.OTLP = value
	return b
}

// WithSecurityContext sets the SecurityContext field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SecurityContext field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithSecurityContext(value corev1.PodSecurityContext) *CommonPrometheusFieldsApplyConfiguration {
	b.SecurityContext = &value
	return b
}

// WithDNSPolicy sets the DNSPolicy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DNSPolicy field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithDNSPolicy(value monitoringv1.DNSPolicy) *CommonPrometheusFieldsApplyConfiguration {
	b.DNSPolicy = &value
	return b
}

// WithDNSConfig sets the DNSConfig field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DNSConfig field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithDNSConfig(value *PodDNSConfigApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	b.DNSConfig = value
	return b
}

// WithListenLocal sets the ListenLocal field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ListenLocal field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithListenLocal(value bool) *CommonPrometheusFieldsApplyConfiguration {
	b.ListenLocal = &value
	return b
}

// WithEnableServiceLinks sets the EnableServiceLinks field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnableServiceLinks field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithEnableServiceLinks(value bool) *CommonPrometheusFieldsApplyConfiguration {
	b.EnableServiceLinks = &value
	return b
}

// WithContainers adds the given value to the Containers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Containers field.
func (b *CommonPrometheusFieldsApplyConfiguration) WithContainers(values ...corev1.Container) *CommonPrometheusFieldsApplyConfiguration {
	for i := range values {
		b.Containers = append(b.Containers, values[i])
	}
	return b
}

// WithInitContainers adds the given value to the InitContainers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the InitContainers field.
func (b *CommonPrometheusFieldsApplyConfiguration) WithInitContainers(values ...corev1.Container) *CommonPrometheusFieldsApplyConfiguration {
	for i := range values {
		b.InitContainers = append(b.InitContainers, values[i])
	}
	return b
}

// WithAdditionalScrapeConfigs sets the AdditionalScrapeConfigs field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AdditionalScrapeConfigs field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithAdditionalScrapeConfigs(value corev1.SecretKeySelector) *CommonPrometheusFieldsApplyConfiguration {
	b.AdditionalScrapeConfigs = &value
	return b
}

// WithAPIServerConfig sets the APIServerConfig field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the APIServerConfig field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithAPIServerConfig(value *APIServerConfigApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	b.APIServerConfig = value
	return b
}

// WithPriorityClassName sets the PriorityClassName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PriorityClassName field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithPriorityClassName(value string) *CommonPrometheusFieldsApplyConfiguration {
	b.PriorityClassName = &value
	return b
}

// WithPortName sets the PortName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PortName field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithPortName(value string) *CommonPrometheusFieldsApplyConfiguration {
	b.PortName = &value
	return b
}

// WithArbitraryFSAccessThroughSMs sets the ArbitraryFSAccessThroughSMs field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ArbitraryFSAccessThroughSMs field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithArbitraryFSAccessThroughSMs(value *ArbitraryFSAccessThroughSMsConfigApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	b.ArbitraryFSAccessThroughSMs = value
	return b
}

// WithOverrideHonorLabels sets the OverrideHonorLabels field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the OverrideHonorLabels field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithOverrideHonorLabels(value bool) *CommonPrometheusFieldsApplyConfiguration {
	b.OverrideHonorLabels = &value
	return b
}

// WithOverrideHonorTimestamps sets the OverrideHonorTimestamps field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the OverrideHonorTimestamps field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithOverrideHonorTimestamps(value bool) *CommonPrometheusFieldsApplyConfiguration {
	b.OverrideHonorTimestamps = &value
	return b
}

// WithIgnoreNamespaceSelectors sets the IgnoreNamespaceSelectors field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the IgnoreNamespaceSelectors field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithIgnoreNamespaceSelectors(value bool) *CommonPrometheusFieldsApplyConfiguration {
	b.IgnoreNamespaceSelectors = &value
	return b
}

// WithEnforcedNamespaceLabel sets the EnforcedNamespaceLabel field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnforcedNamespaceLabel field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithEnforcedNamespaceLabel(value string) *CommonPrometheusFieldsApplyConfiguration {
	b.EnforcedNamespaceLabel = &value
	return b
}

// WithEnforcedSampleLimit sets the EnforcedSampleLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnforcedSampleLimit field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithEnforcedSampleLimit(value uint64) *CommonPrometheusFieldsApplyConfiguration {
	b.EnforcedSampleLimit = &value
	return b
}

// WithEnforcedTargetLimit sets the EnforcedTargetLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnforcedTargetLimit field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithEnforcedTargetLimit(value uint64) *CommonPrometheusFieldsApplyConfiguration {
	b.EnforcedTargetLimit = &value
	return b
}

// WithEnforcedLabelLimit sets the EnforcedLabelLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnforcedLabelLimit field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithEnforcedLabelLimit(value uint64) *CommonPrometheusFieldsApplyConfiguration {
	b.EnforcedLabelLimit = &value
	return b
}

// WithEnforcedLabelNameLengthLimit sets the EnforcedLabelNameLengthLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnforcedLabelNameLengthLimit field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithEnforcedLabelNameLengthLimit(value uint64) *CommonPrometheusFieldsApplyConfiguration {
	b.EnforcedLabelNameLengthLimit = &value
	return b
}

// WithEnforcedLabelValueLengthLimit sets the EnforcedLabelValueLengthLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnforcedLabelValueLengthLimit field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithEnforcedLabelValueLengthLimit(value uint64) *CommonPrometheusFieldsApplyConfiguration {
	b.EnforcedLabelValueLengthLimit = &value
	return b
}

// WithEnforcedKeepDroppedTargets sets the EnforcedKeepDroppedTargets field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnforcedKeepDroppedTargets field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithEnforcedKeepDroppedTargets(value uint64) *CommonPrometheusFieldsApplyConfiguration {
	b.EnforcedKeepDroppedTargets = &value
	return b
}

// WithEnforcedBodySizeLimit sets the EnforcedBodySizeLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnforcedBodySizeLimit field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithEnforcedBodySizeLimit(value monitoringv1.ByteSize) *CommonPrometheusFieldsApplyConfiguration {
	b.EnforcedBodySizeLimit = &value
	return b
}

// WithNameValidationScheme sets the NameValidationScheme field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NameValidationScheme field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithNameValidationScheme(value monitoringv1.NameValidationSchemeOptions) *CommonPrometheusFieldsApplyConfiguration {
	b.NameValidationScheme = &value
	return b
}

// WithMinReadySeconds sets the MinReadySeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MinReadySeconds field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithMinReadySeconds(value uint32) *CommonPrometheusFieldsApplyConfiguration {
	b.MinReadySeconds = &value
	return b
}

// WithHostAliases adds the given value to the HostAliases field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the HostAliases field.
func (b *CommonPrometheusFieldsApplyConfiguration) WithHostAliases(values ...*HostAliasApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithHostAliases")
		}
		b.HostAliases = append(b.HostAliases, *values[i])
	}
	return b
}

// WithAdditionalArgs adds the given value to the AdditionalArgs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the AdditionalArgs field.
func (b *CommonPrometheusFieldsApplyConfiguration) WithAdditionalArgs(values ...*ArgumentApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithAdditionalArgs")
		}
		b.AdditionalArgs = append(b.AdditionalArgs, *values[i])
	}
	return b
}

// WithWALCompression sets the WALCompression field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the WALCompression field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithWALCompression(value bool) *CommonPrometheusFieldsApplyConfiguration {
	b.WALCompression = &value
	return b
}

// WithExcludedFromEnforcement adds the given value to the ExcludedFromEnforcement field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ExcludedFromEnforcement field.
func (b *CommonPrometheusFieldsApplyConfiguration) WithExcludedFromEnforcement(values ...*ObjectReferenceApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithExcludedFromEnforcement")
		}
		b.ExcludedFromEnforcement = append(b.ExcludedFromEnforcement, *values[i])
	}
	return b
}

// WithHostNetwork sets the HostNetwork field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the HostNetwork field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithHostNetwork(value bool) *CommonPrometheusFieldsApplyConfiguration {
	b.HostNetwork = &value
	return b
}

// WithPodTargetLabels adds the given value to the PodTargetLabels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the PodTargetLabels field.
func (b *CommonPrometheusFieldsApplyConfiguration) WithPodTargetLabels(values ...string) *CommonPrometheusFieldsApplyConfiguration {
	for i := range values {
		b.PodTargetLabels = append(b.PodTargetLabels, values[i])
	}
	return b
}

// WithTracingConfig sets the TracingConfig field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TracingConfig field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithTracingConfig(value *PrometheusTracingConfigApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	b.TracingConfig = value
	return b
}

// WithBodySizeLimit sets the BodySizeLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BodySizeLimit field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithBodySizeLimit(value monitoringv1.ByteSize) *CommonPrometheusFieldsApplyConfiguration {
	b.BodySizeLimit = &value
	return b
}

// WithSampleLimit sets the SampleLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SampleLimit field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithSampleLimit(value uint64) *CommonPrometheusFieldsApplyConfiguration {
	b.SampleLimit = &value
	return b
}

// WithTargetLimit sets the TargetLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TargetLimit field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithTargetLimit(value uint64) *CommonPrometheusFieldsApplyConfiguration {
	b.TargetLimit = &value
	return b
}

// WithLabelLimit sets the LabelLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LabelLimit field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithLabelLimit(value uint64) *CommonPrometheusFieldsApplyConfiguration {
	b.LabelLimit = &value
	return b
}

// WithLabelNameLengthLimit sets the LabelNameLengthLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LabelNameLengthLimit field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithLabelNameLengthLimit(value uint64) *CommonPrometheusFieldsApplyConfiguration {
	b.LabelNameLengthLimit = &value
	return b
}

// WithLabelValueLengthLimit sets the LabelValueLengthLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LabelValueLengthLimit field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithLabelValueLengthLimit(value uint64) *CommonPrometheusFieldsApplyConfiguration {
	b.LabelValueLengthLimit = &value
	return b
}

// WithKeepDroppedTargets sets the KeepDroppedTargets field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the KeepDroppedTargets field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithKeepDroppedTargets(value uint64) *CommonPrometheusFieldsApplyConfiguration {
	b.KeepDroppedTargets = &value
	return b
}

// WithReloadStrategy sets the ReloadStrategy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ReloadStrategy field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithReloadStrategy(value monitoringv1.ReloadStrategyType) *CommonPrometheusFieldsApplyConfiguration {
	b.ReloadStrategy = &value
	return b
}

// WithMaximumStartupDurationSeconds sets the MaximumStartupDurationSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaximumStartupDurationSeconds field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithMaximumStartupDurationSeconds(value int32) *CommonPrometheusFieldsApplyConfiguration {
	b.MaximumStartupDurationSeconds = &value
	return b
}

// WithScrapeClasses adds the given value to the ScrapeClasses field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ScrapeClasses field.
func (b *CommonPrometheusFieldsApplyConfiguration) WithScrapeClasses(values ...*ScrapeClassApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithScrapeClasses")
		}
		b.ScrapeClasses = append(b.ScrapeClasses, *values[i])
	}
	return b
}

// WithServiceDiscoveryRole sets the ServiceDiscoveryRole field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServiceDiscoveryRole field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithServiceDiscoveryRole(value monitoringv1.ServiceDiscoveryRole) *CommonPrometheusFieldsApplyConfiguration {
	b.ServiceDiscoveryRole = &value
	return b
}

// WithTSDB sets the TSDB field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TSDB field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithTSDB(value *TSDBSpecApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	b.TSDB = value
	return b
}

// WithScrapeFailureLogFile sets the ScrapeFailureLogFile field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ScrapeFailureLogFile field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithScrapeFailureLogFile(value string) *CommonPrometheusFieldsApplyConfiguration {
	b.ScrapeFailureLogFile = &value
	return b
}

// WithServiceName sets the ServiceName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServiceName field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithServiceName(value string) *CommonPrometheusFieldsApplyConfiguration {
	b.ServiceName = &value
	return b
}

// WithRuntime sets the Runtime field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Runtime field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithRuntime(value *RuntimeConfigApplyConfiguration) *CommonPrometheusFieldsApplyConfiguration {
	b.Runtime = value
	return b
}

// WithTerminationGracePeriodSeconds sets the TerminationGracePeriodSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TerminationGracePeriodSeconds field is set to the value of the last call.
func (b *CommonPrometheusFieldsApplyConfiguration) WithTerminationGracePeriodSeconds(value int64) *CommonPrometheusFieldsApplyConfiguration {
	b.TerminationGracePeriodSeconds = &value
	return b
}
