// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	v1 "k8s.io/api/core/v1"
)

// PagerDutyConfigApplyConfiguration represents a declarative configuration of the PagerDutyConfig type for use
// with apply.
type PagerDutyConfigApplyConfiguration struct {
	SendResolved          *bool                                    `json:"sendResolved,omitempty"`
	RoutingKey            *v1.SecretKeySelector                    `json:"routingKey,omitempty"`
	ServiceKey            *v1.SecretKeySelector                    `json:"serviceKey,omitempty"`
	URL                   *string                                  `json:"url,omitempty"`
	Client                *string                                  `json:"client,omitempty"`
	ClientURL             *string                                  `json:"clientURL,omitempty"`
	Description           *string                                  `json:"description,omitempty"`
	Severity              *string                                  `json:"severity,omitempty"`
	Class                 *string                                  `json:"class,omitempty"`
	Group                 *string                                  `json:"group,omitempty"`
	Component             *string                                  `json:"component,omitempty"`
	Details               []KeyValueApplyConfiguration             `json:"details,omitempty"`
	PagerDutyImageConfigs []PagerDutyImageConfigApplyConfiguration `json:"pagerDutyImageConfigs,omitempty"`
	PagerDutyLinkConfigs  []PagerDutyLinkConfigApplyConfiguration  `json:"pagerDutyLinkConfigs,omitempty"`
	HTTPConfig            *HTTPConfigApplyConfiguration            `json:"httpConfig,omitempty"`
	Source                *string                                  `json:"source,omitempty"`
}

// PagerDutyConfigApplyConfiguration constructs a declarative configuration of the PagerDutyConfig type for use with
// apply.
func PagerDutyConfig() *PagerDutyConfigApplyConfiguration {
	return &PagerDutyConfigApplyConfiguration{}
}

// WithSendResolved sets the SendResolved field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SendResolved field is set to the value of the last call.
func (b *PagerDutyConfigApplyConfiguration) WithSendResolved(value bool) *PagerDutyConfigApplyConfiguration {
	b.SendResolved = &value
	return b
}

// WithRoutingKey sets the RoutingKey field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RoutingKey field is set to the value of the last call.
func (b *PagerDutyConfigApplyConfiguration) WithRoutingKey(value v1.SecretKeySelector) *PagerDutyConfigApplyConfiguration {
	b.RoutingKey = &value
	return b
}

// WithServiceKey sets the ServiceKey field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServiceKey field is set to the value of the last call.
func (b *PagerDutyConfigApplyConfiguration) WithServiceKey(value v1.SecretKeySelector) *PagerDutyConfigApplyConfiguration {
	b.ServiceKey = &value
	return b
}

// WithURL sets the URL field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the URL field is set to the value of the last call.
func (b *PagerDutyConfigApplyConfiguration) WithURL(value string) *PagerDutyConfigApplyConfiguration {
	b.URL = &value
	return b
}

// WithClient sets the Client field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Client field is set to the value of the last call.
func (b *PagerDutyConfigApplyConfiguration) WithClient(value string) *PagerDutyConfigApplyConfiguration {
	b.Client = &value
	return b
}

// WithClientURL sets the ClientURL field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ClientURL field is set to the value of the last call.
func (b *PagerDutyConfigApplyConfiguration) WithClientURL(value string) *PagerDutyConfigApplyConfiguration {
	b.ClientURL = &value
	return b
}

// WithDescription sets the Description field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Description field is set to the value of the last call.
func (b *PagerDutyConfigApplyConfiguration) WithDescription(value string) *PagerDutyConfigApplyConfiguration {
	b.Description = &value
	return b
}

// WithSeverity sets the Severity field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Severity field is set to the value of the last call.
func (b *PagerDutyConfigApplyConfiguration) WithSeverity(value string) *PagerDutyConfigApplyConfiguration {
	b.Severity = &value
	return b
}

// WithClass sets the Class field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Class field is set to the value of the last call.
func (b *PagerDutyConfigApplyConfiguration) WithClass(value string) *PagerDutyConfigApplyConfiguration {
	b.Class = &value
	return b
}

// WithGroup sets the Group field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Group field is set to the value of the last call.
func (b *PagerDutyConfigApplyConfiguration) WithGroup(value string) *PagerDutyConfigApplyConfiguration {
	b.Group = &value
	return b
}

// WithComponent sets the Component field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Component field is set to the value of the last call.
func (b *PagerDutyConfigApplyConfiguration) WithComponent(value string) *PagerDutyConfigApplyConfiguration {
	b.Component = &value
	return b
}

// WithDetails adds the given value to the Details field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Details field.
func (b *PagerDutyConfigApplyConfiguration) WithDetails(values ...*KeyValueApplyConfiguration) *PagerDutyConfigApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithDetails")
		}
		b.Details = append(b.Details, *values[i])
	}
	return b
}

// WithPagerDutyImageConfigs adds the given value to the PagerDutyImageConfigs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the PagerDutyImageConfigs field.
func (b *PagerDutyConfigApplyConfiguration) WithPagerDutyImageConfigs(values ...*PagerDutyImageConfigApplyConfiguration) *PagerDutyConfigApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithPagerDutyImageConfigs")
		}
		b.PagerDutyImageConfigs = append(b.PagerDutyImageConfigs, *values[i])
	}
	return b
}

// WithPagerDutyLinkConfigs adds the given value to the PagerDutyLinkConfigs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the PagerDutyLinkConfigs field.
func (b *PagerDutyConfigApplyConfiguration) WithPagerDutyLinkConfigs(values ...*PagerDutyLinkConfigApplyConfiguration) *PagerDutyConfigApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithPagerDutyLinkConfigs")
		}
		b.PagerDutyLinkConfigs = append(b.PagerDutyLinkConfigs, *values[i])
	}
	return b
}

// WithHTTPConfig sets the HTTPConfig field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the HTTPConfig field is set to the value of the last call.
func (b *PagerDutyConfigApplyConfiguration) WithHTTPConfig(value *HTTPConfigApplyConfiguration) *PagerDutyConfigApplyConfiguration {
	b.HTTPConfig = value
	return b
}

// WithSource sets the Source field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Source field is set to the value of the last call.
func (b *PagerDutyConfigApplyConfiguration) WithSource(value string) *PagerDutyConfigApplyConfiguration {
	b.Source = &value
	return b
}
