/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.bridgeload;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.ConferenceStore;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.bridge.Bridge;
import org.jitsi.jicofo.bridge.BridgeConfig;
import org.jitsi.jicofo.bridge.BridgeSelector;
import org.jitsi.jicofo.bridge.ConferenceBridgeProperties;
import org.jitsi.jicofo.bridgeload.BridgeNotFoundException;
import org.jitsi.jicofo.bridgeload.ConferenceNotFoundException;
import org.jitsi.jicofo.bridgeload.InvalidParameterException;
import org.jitsi.jicofo.bridgeload.LoadRedistributorKt;
import org.jitsi.jicofo.bridgeload.MissingParameterException;
import org.jitsi.jicofo.bridgeload.MoveFailedException;
import org.jitsi.jicofo.bridgeload.MoveResult;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.metrics.JicofoMetricsContainer;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001bH\u0002J$\u0010\u001e\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001b2\b\u0010 \u001a\u0004\u0018\u00010\u001bJ\"\u0010!\u001a\u00020\u00142\b\u0010 \u001a\u0004\u0018\u00010\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\"\u001a\u00020\u0019J\u0018\u0010#\u001a\u00020\u00142\b\u0010 \u001a\u0004\u0018\u00010\u001b2\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020\u0012H\u0002J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\tH\u0002J\r\u0010(\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010)J\u001e\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190,0+*\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jitsi/jicofo/bridgeload/LoadRedistributor;", "", "conferenceStore", "Lorg/jitsi/jicofo/ConferenceStore;", "bridgeSelector", "Lorg/jitsi/jicofo/bridge/BridgeSelector;", "(Lorg/jitsi/jicofo/ConferenceStore;Lorg/jitsi/jicofo/bridge/BridgeSelector;)V", "bridgesInTimeout", "", "Lorg/jitsi/jicofo/bridge/Bridge;", "Ljava/time/Instant;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "task", "Ljava/util/concurrent/ScheduledFuture;", "cleanupTimeouts", "", "doMove", "Lorg/jitsi/jicofo/bridgeload/MoveResult;", "bridge", "endpointsToMove", "", "Lorg/jitsi/jicofo/conference/JitsiMeetConference;", "", "getBridge", "", "getConference", "conferenceId", "moveEndpoint", "endpointId", "bridgeId", "moveEndpoints", "numEndpoints", "moveFraction", "fraction", "", "run", "runSingleBridge", "shutdown", "()Lkotlin/Unit;", "getConferences", "", "Lkotlin/Pair;", "Companion", "jicofo"})
@SourceDebugExtension(value={"SMAP\nLoadRedistributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoadRedistributor.kt\norg/jitsi/jicofo/bridgeload/LoadRedistributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,274:1\n774#2:275\n865#2,2:276\n1863#2,2:278\n774#2:280\n865#2,2:281\n1611#2,9:284\n1863#2:293\n1864#2:295\n1620#2:296\n1062#2:297\n1#3:283\n1#3:294\n216#4,2:298\n*S KotlinDebug\n*F\n+ 1 LoadRedistributor.kt\norg/jitsi/jicofo/bridgeload/LoadRedistributor\n*L\n76#1:275\n76#1:276,2\n76#1:278,2\n155#1:280\n155#1:281,2\n213#1:284,9\n213#1:293\n213#1:295\n213#1:296\n215#1:297\n213#1:294\n221#1:298,2\n*E\n"})
public final class LoadRedistributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConferenceStore conferenceStore;
    @NotNull
    private final BridgeSelector bridgeSelector;
    @NotNull
    private final Logger logger;
    @Nullable
    private ScheduledFuture<?> task;
    @NotNull
    private final Map<Bridge, Instant> bridgesInTimeout;
    @NotNull
    private static final CounterMetric totalEndpointsMoved = MetricsContainer.registerCounter$default((MetricsContainer)((MetricsContainer)JicofoMetricsContainer.Companion.getInstance()), (String)"load_redistributor_endpoints_moved", (String)"Total number of endpoints moved away from any bridge for automatic load redistribution", (long)0L, null, (int)12, null);

    public LoadRedistributor(@NotNull ConferenceStore conferenceStore, @NotNull BridgeSelector bridgeSelector) {
        ScheduledFuture<?> scheduledFuture;
        Intrinsics.checkNotNullParameter((Object)conferenceStore, (String)"conferenceStore");
        Intrinsics.checkNotNullParameter((Object)bridgeSelector, (String)"bridgeSelector");
        this.conferenceStore = conferenceStore;
        this.bridgeSelector = bridgeSelector;
        this.logger = LoggerExtensionsKt.createLogger$default((Object)this, null, null, (int)3, null);
        if (BridgeConfig.config.getLoadRedistribution().getEnabled()) {
            this.logger.info((Object)("Enabling automatic load redistribution: " + BridgeConfig.config.getLoadRedistribution()));
            scheduledFuture = TaskPools.Companion.getScheduledPool().scheduleAtFixedRate(() -> LoadRedistributor.task$lambda$0(this), BridgeConfig.config.getLoadRedistribution().getInterval().toMillis(), BridgeConfig.config.getLoadRedistribution().getInterval().toMillis(), TimeUnit.MILLISECONDS);
        } else {
            scheduledFuture = null;
        }
        this.task = scheduledFuture;
        this.bridgesInTimeout = new LinkedHashMap();
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @Nullable
    public final Unit shutdown() {
        Unit unit;
        ScheduledFuture<?> scheduledFuture = this.task;
        if (scheduledFuture != null) {
            ScheduledFuture<?> it = scheduledFuture;
            boolean bl = false;
            this.logger.info((Object)"Stopping load redistribution");
            it.cancel(true);
            this.bridgesInTimeout.clear();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    /*
     * WARNING - void declaration
     */
    private final void run() {
        try {
            void $this$filterTo$iv$iv;
            this.logger.trace((Object)"Running load redistribution");
            if (!this.bridgeSelector.hasNonOverloadedBridge()) {
                this.logger.warn((Object)"No non-overloaded bridges, skipping load redistribution");
                return;
            }
            this.cleanupTimeouts();
            Iterable $this$filter$iv = this.bridgeSelector.getAll();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Bridge it = (Bridge)element$iv$iv;
                boolean bl = false;
                if (!(!this.bridgesInTimeout.containsKey(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Bridge p0 = (Bridge)element$iv;
                boolean bl = false;
                this.runSingleBridge(p0);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error running load redistribution", (Throwable)e);
        }
    }

    private final void runSingleBridge(Bridge bridge) {
        if (bridge.getCorrectedStress() >= BridgeConfig.config.getLoadRedistribution().getStressThreshold()) {
            Map<Bridge, Instant> map = this.bridgesInTimeout;
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            Instant instant2 = instant;
            map.put(bridge, instant2);
            MoveResult result = this.moveEndpoints(bridge.getJid().toString(), null, BridgeConfig.config.getLoadRedistribution().getEndpoints());
            this.logger.info((Object)("Moved " + result + " away from " + bridge.getJid().getResourceOrEmpty()));
            bridge.endpointsMoved((long)result.getMovedEndpoints());
            CounterMetric.add$default((CounterMetric)totalEndpointsMoved, (long)result.getMovedEndpoints(), null, (int)2, null);
        }
    }

    private final void cleanupTimeouts() {
        Instant limit = Instant.now().minus(BridgeConfig.config.getLoadRedistribution().getTimeout());
        this.bridgesInTimeout.entrySet().removeIf(arg_0 -> LoadRedistributor.cleanupTimeouts$lambda$3((Function1)new Function1<Map.Entry<Bridge, Instant>, Boolean>(limit){
            final /* synthetic */ Instant $limit;
            {
                this.$limit = $limit;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<Bridge, Instant> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.getValue().isBefore(this.$limit);
            }
        }, arg_0));
    }

    @NotNull
    public final MoveResult moveEndpoint(@Nullable String conferenceId, @Nullable String endpointId, @Nullable String bridgeId) throws MoveFailedException {
        MoveResult moveResult;
        CharSequence charSequence = conferenceId;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new MissingParameterException("conference");
        }
        charSequence = endpointId;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new MissingParameterException("endpoint");
        }
        CharSequence charSequence2 = bridgeId;
        Bridge bridge = charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2) ? null : this.getBridge(bridgeId);
        JitsiMeetConference conference = this.getConference(conferenceId);
        this.logger.info((Object)("Moving conference=" + conferenceId + " endpoint=" + endpointId + " bridge=" + bridgeId));
        if (conference.moveEndpoint(endpointId, bridge)) {
            this.logger.info((Object)"Moved successfully");
            moveResult = new MoveResult(1, 1);
        } else {
            this.logger.info((Object)"Failed to move");
            moveResult = new MoveResult(0, 0);
        }
        return moveResult;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MoveResult moveEndpoints(@Nullable String bridgeId, @Nullable String conferenceId, int numEndpoints) throws MoveFailedException {
        List list;
        JitsiMeetConference conference;
        CharSequence charSequence = bridgeId;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new MissingParameterException("bridge");
        }
        Bridge bridge = this.getBridge(bridgeId);
        CharSequence charSequence2 = conferenceId;
        JitsiMeetConference jitsiMeetConference = conference = charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2) ? null : this.getConference(conferenceId);
        if (conference == null) {
            list = this.getConferences(bridge);
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.getConferences(bridge);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Pair it = (Pair)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)conference)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List bridgeConferences = list;
        this.logger.info((Object)("Moving " + numEndpoints + " endpoints from bridge=" + bridge.getJid() + " (conference=" + conference + ")"));
        Map endpointsToMove = LoadRedistributorKt.access$select(bridgeConferences, numEndpoints);
        return this.doMove(bridge, endpointsToMove);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MoveResult moveFraction(@Nullable String bridgeId, double fraction) throws MoveFailedException {
        CharSequence charSequence = bridgeId;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new MissingParameterException("bridge");
        }
        Bridge bridge = this.getBridge(bridgeId);
        List<Pair<JitsiMeetConference, Integer>> bridgeConferences = this.getConferences(bridge);
        Iterable iterable = bridgeConferences;
        int n = 0;
        for (Object t : iterable) {
            void it;
            Pair pair = (Pair)t;
            int n2 = n;
            boolean bl = false;
            int n3 = ((Number)it.getSecond()).intValue();
            n = n2 + n3;
        }
        int totalEndpoints = n;
        int numEndpoints = MathKt.roundToInt((double)(fraction * (double)totalEndpoints));
        this.logger.info((Object)("Moving " + fraction + " of endpoints from bridge=" + bridge + " (" + numEndpoints + " out of " + totalEndpoints + ")"));
        Map endpointsToMove = LoadRedistributorKt.access$select(bridgeConferences, numEndpoints);
        return this.doMove(bridge, endpointsToMove);
    }

    private final JitsiMeetConference getConference(String conferenceId) {
        EntityBareJid entityBareJid;
        try {
            entityBareJid = JidCreate.entityBareFrom((String)conferenceId);
        }
        catch (Exception e) {
            throw new InvalidParameterException("conference ID");
        }
        EntityBareJid conferenceJid = entityBareJid;
        Intrinsics.checkNotNull((Object)conferenceJid);
        JitsiMeetConference jitsiMeetConference = this.conferenceStore.getConference(conferenceJid);
        if (jitsiMeetConference == null) {
            throw new ConferenceNotFoundException(conferenceId);
        }
        return jitsiMeetConference;
    }

    private final Bridge getBridge(String bridge) {
        Jid jid;
        Jid jid2;
        try {
            jid2 = JidCreate.from((String)bridge);
        }
        catch (Exception e) {
            throw new InvalidParameterException("bridge ID");
        }
        Jid bridgeJid = jid2;
        Intrinsics.checkNotNull((Object)bridgeJid);
        Bridge bridge2 = this.bridgeSelector.get(bridgeJid);
        if (bridge2 != null) {
            Bridge it = bridge2;
            boolean bl = false;
            return it;
        }
        try {
            jid = JidCreate.from((String)(BridgeConfig.config.getBreweryJid() + "/" + bridge));
        }
        catch (Exception e) {
            throw new InvalidParameterException("bridge ID");
        }
        Jid bridgeFullJid = jid;
        Intrinsics.checkNotNull((Object)bridgeFullJid);
        Bridge bridge3 = this.bridgeSelector.get(bridgeFullJid);
        if (bridge3 == null) {
            throw new BridgeNotFoundException(bridge);
        }
        return bridge3;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<JitsiMeetConference, Integer>> getConferences(Bridge $this$getConferences) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.conferenceStore.getAllConferences();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JitsiMeetConference conference = (JitsiMeetConference)element$iv$iv;
            boolean bl2 = false;
            ConferenceBridgeProperties conferenceBridgeProperties = conference.getBridges().get($this$getConferences);
            if (conferenceBridgeProperties != null) {
                int it = conferenceBridgeProperties.getParticipantCount();
                boolean bl3 = false;
                pair = new Pair((Object)conference, (Object)it);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getSecond()));
            }
        });
    }

    private final MoveResult doMove(Bridge bridge, Map<JitsiMeetConference, Integer> endpointsToMove) {
        this.logger.info((Object)("Moving endpoints from bridge " + bridge.getJid() + ": " + endpointsToMove));
        int movedEndpoints = 0;
        int conferences = 0;
        Map<JitsiMeetConference, Integer> $this$forEach$iv = endpointsToMove;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<JitsiMeetConference, Integer>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<JitsiMeetConference, Integer> element$iv;
            Map.Entry<JitsiMeetConference, Integer> entry = element$iv = iterator.next();
            boolean bl = false;
            JitsiMeetConference conference = entry.getKey();
            int numEps = ((Number)entry.getValue()).intValue();
            int moved = conference.moveEndpoints(bridge, numEps);
            movedEndpoints += moved;
            if (moved <= 0) continue;
            ++conferences;
        }
        this.logger.info((Object)("Moved " + movedEndpoints + " endpoints from " + conferences + " conferences."));
        return new MoveResult(movedEndpoints, conferences);
    }

    private static final void task$lambda$0(LoadRedistributor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.run();
    }

    private static final boolean cleanupTimeouts$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/jicofo/bridgeload/LoadRedistributor$Companion;", "", "()V", "totalEndpointsMoved", "Lorg/jitsi/metrics/CounterMetric;", "getTotalEndpointsMoved", "()Lorg/jitsi/metrics/CounterMetric;", "jicofo"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CounterMetric getTotalEndpointsMoved() {
            return totalEndpointsMoved;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

