#### room._data fields
- allModerators - If is set to true, all authenticated participants are moderators. You need a custom module to set participants as moderators based on the field.
- allowUnauthenticatedAccess - Option that works only with tenants. When it is false only jwt authenticated participants(visitors) are allowed in the meeting and their token(or sub claim for jaas) should match the one in the room. Default value when missing is true.
- av_can_unmute - Default value is missing/true. If set to false, when the first moderator joining the room we enable AV moderation and disable the ability for participants to unmute themselves.
- av_first_moderator_joined - When av_can_unmute is set to false, this flag is used to indicate that the first moderator has joined the room and AV moderation is enabled.
- breakout_rooms - A table containing breakout rooms created in the main room. The keys are the JIDs of the breakout rooms, and the values are their subjects.
- breakout_rooms_active - Whether there was a breakout room created in the main room.
- breakout_rooms_counter - A counter for breakout rooms created in the main room.
- flip_participant_nick - Used in mod_muc_flip, when flipping a participant we store the nick of the second device/participant. Same processing as kicked_participant_nick.
- hideDisplayNameForGuests - When set to true, the display name of participants is hidden for guests.
- jicofo_lock - A boolean value, when set to true the room is locked waiting for Jicofo to join. All attempts to join will be queued until Jicofo joins.
- kicked_participant_nick - Used in mod_muc_flip, when flipping a participant we store the nick of the initial device/participant so we can kick it after the second on joins, everything happens in the same pass when the second join presence is processed, so concurrency and overwriting are not a concern.
- lobby_extra_reason - Used in mod_muc_lobby_rooms to store the reason for creating a lobby room. This is set by the global event 'create-lobby-room' and can be used to provide additional context or information about the lobby room creation. Used by mod_muc_wait_for_host with value 'waiting-for-host'. Value is sent as the error reply 'registration-required'.
- lobby_skip_display_name_check - Used in mod_muc_lobby_rooms to skip the display name check for the lobby room. This is used when the lobby room is created with a specific reason that does not require a display name check via the global event 'create-lobby-room'.
- lobbyroom - Holds the JID of the lobby room if it exists. It is set by mod_muc_lobby_rooms.lua when a lobby room is created. Value is available in the room config form for all clients to use it.
- max_occupants - The maximum number of occupants allowed in the room used by mod_muc_max_occupants.
- meetingId - A unique identifier for the meeting, generated by mod_muc_meeting_id. Set in the room config form for all clients to use it. It is also sent to all visitor nodes if any.
- moderator_id - The id (from the token) for the moderator of the room. The value can be userId or a groupId where all participants from the same group will be moderators. You need a custom module to set participants as moderators based on the field.
- moderators - A list of moderator ids (from the token) that are allowed to join the room. The list is sent to jicofo to take decisions about forwarding to main room or visitor node in case of large meetings. Those participants will be moderators. You need a custom module to set participants as moderators based on the field.
- participants - A list of participants ids (from the token) that are allowed to join the room. The list is sent to jicofo to take decisions about forwarding to main room or visitor node in case of large meetings. Those participants will not be moderators.
- participants_details - Used in mod_muc_flip to store details about authenticated participants in the room. A table where the keys are participant id from the token and the values are their room jid.
- persist_lobby - A boolean value, when set to true the lobby room will be persistent and not destroyed after the main room is destroyed. Used by mod_persistent_lobby.
- subject - The subject of the room. Set by subject.lib.lua in prosody.

# room fields added by jitsi
- _connected_vnodes - A cache object that holds connected vnodes for the room. It is used by mod_visitors_component.lua to manage connected vnodes.
- _jid_nick - Prosody's internal table that maps connection JIDs to room jids in the room. It is used by mod_muc_max_occupants.lua.
- _jitsi_go_live_sent - A boolean value indicating whether the go live request has been sent for the room. It is used by mod_visitors_component.lua to manage the go live state of the room.
- _main_room_lobby_enabled - A boolean value indicating whether the main room lobby is enabled. It is set by mod_fmuc.lua when the main room lobby is enabled or disabled.
- _muc_messages_count - A counter for the number of messages sent in the room. It is used by mod_measure_message_count.lua to track message counts for analytics.
- _muc_messages_limit - A boolean value indicating whether the message limit is enabled for the room. It is used by mod_muc_limit_messages.lua to control the message limit in the room.
- _muc_messages_limit_count - A counter for the number of messages sent in the room when the message limit is enabled. It is used by mod_muc_limit_messages.lua to track message counts for the limit.
- _muc_polls_count - A counter for the number of polls created in the room. It is used by mod_measure_message_count.lua to track poll counts for analytics.
- _occupants - Prosody's internal table that holds room occupants.
- _transcription_languages - A table containing transcription languages for each occupant in the room. The keys are occupant JIDs and the values are language codes. Used by mod_fmuc.lua to manage transcription languages for occupants.
- av_moderation - A table containing media types as keys ('audio', 'video', 'desktop') and arrays of occupant nicknames that are allowed to unmute themselves. Used by mod_av_moderation_component.lua.
- av_moderation_actors - A table containing media types as keys ('audio', 'video', 'desktop') and occupant nicknames of the moderators that performed the last AV moderation action. Used by mod_av_moderation_component.lua.
- av_moderation_startMuted_restore - Keeps the startMuted metadata state of the room before AV moderation was applied. Used by mod_av_moderation_component.lua.
- broadcast_timer - A timer used to broadcast the list of breakout rooms in the main room. It is set by mod_muc_breakout_rooms.lua to periodically update the list of breakout rooms.
- close_timer - A timer used to close the main room when all occupants have left. It is set by mod_muc_breakout_rooms.lua to clean up the main room after all participants left from breakout room.
- created_timestamp - A timestamp in milliseconds when the room was created. It is set by mod_conference_duration_component.lua and used by mod_conference_duration.lua to calculate the conference duration. It is also used by mod_measure_message_count.lua to calculate the room duration for analytics.
- has_host - Whether the host (an authenticated user) has arrived in the room.
- is_vpaas - A boolean value indicating whether the room is a VPAAS room, optimization for the is_vpaas function in util.internal.lib.lua.
- jibri_throttle - A throttle object used to limit the number of Jibri requests per room. It is created in mod_filter_iq_jibri.lua to prevent abuse of Jibri resources.
- jitsi_meet_tenant_mismatch - A boolean value indicating whether there is a tenant mismatch comparing room tenant and jwt tenant value.
- jitsi_shared_files - A table containing shared files in the room. The keys are file IDs and the values are file objects with properties like fileId, name, size, type, and url. Used by mod_filesharing_component.lua to manage file sharing in the room.
- jitsiMetadata - The metadata for the room. Example values:
```json
    {
      "allownersEnabled": true,
      "asyncTranscription": true,
      "conferencePresetsServiceEnabled": true,
      "participantsSoftLimit": 200,
      "permissions": {
        "groupChatRestricted": true,
        "pollCreationRestricted": true
      },
      "recording": {
        "autoAudioRecording": true,
        "autoVideoRecording": true,
        "autoTranscriptions": true,
        "isTranscribingEnabled": true
      },
      "startMuted": {
        "audio": true,
        "video": true
      },
      "transcriberType": "GOOGLE | ORACLE_CLOUD_AI_SPEECH | EGHT_WHISPER",
      "visitors": {
        "autoPromote": true,
        "live": true
      },
      "visitorsEnabled": true
    }
```
- join_rate_presence_queue - A queue used to hold join presence requests when the join rate throttle is exceeded. It is set by mod_muc_rate_limit.lua to manage join requests in the room.
- join_rate_queue_timer - A timer used to process the join rate presence queue. It is set by mod_muc_rate_limit.lua to periodically check and process join requests in the queue.
- join_rate_throttle - A throttle object used to limit the rate of join requests in the room. It is set by mod_muc_rate_limit.lua to prevent high join rate in case of large conferences.
- leave_rate_presence_queue - A queue used to hold leave presence requests when the leave rate throttle is exceeded. It is set by mod_muc_rate_limit.lua to manage leave requests in the room.
- leave_rate_queue_timer - A timer used to process the leave rate presence queue. It is set by mod_muc_rate_limit.lua to periodically check and process leave requests in the queue.
- leave_rate_throttle - A throttle object used to limit the rate of leave requests in the room. It is set by mod_muc_rate_limit.lua to prevent high leave rate in case of large conferences.
- main_room - For lobby or breakout rooms it is the main room object.
- moderators_list - A set containing the JIDs of moderators in the room. It is used by mod_fmuc.lua to manage moderators in the room.
- polls - A table containing polls created in the room. The keys are poll IDs and the values are poll objects with properties like id, question, options, votes, and creator. Used by mod_polls.lua to manage polls in the room.
- pre_join_queue - A queue used to hold join requests when the room is locked waiting for Jicofo to join. It is set by mod_muc_meeting_id.lua when the room is locked. The queue is processed once Jicofo joins the room.
- send_default_permissions_to - A table containing the default permissions to be sent to occupants in the room. The keys are bare JIDs and the values are boolean values indicating whether the permissions should be sent. Used by mod_jitsi_permissions.lua to manage permissions in the room.
- sent_initial_metadata - A table containing the initial metadata sent to occupants in the room. The keys are bare JIDs and the values are boolean values indicating whether the metadata has been sent. Used by mod_room_metadata_component.lua to manage metadata in the room.
- speakerStats - A table containing speaker statistics for occupants in the room. The keys are occupant JIDs and the values are objects with properties like dominantSpeakerId, faceLandmarks, and sessionId. Used by mod_speakerstats_component.lua to manage speaker statistics in the room.
- visitors_destroy_timer - A timer used to destroy the room when there are no main occupants or visitors left. It is set by mod_fmuc.lua to clean up the room after a certain period of inactivity.

#### Notes:
When modules need to store data they should do it in the room object in _data or directly. The data needs to be a simple as strings or table of strings, they should not add objects like room, sessions or occupants that cannot be serialized. Attaching data to the room object makes reloading modules safe and guarantees data will be wiped once the room is destroyed.
