/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.vp9;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.codec.vpx.VpxUtils;
import org.jitsi.nlj.rtp.codec.vp9.Vp9Packet;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.cc.vp9.PacketInsertionResult;
import org.jitsi.videobridge.cc.vp9.PictureHistory;
import org.jitsi.videobridge.cc.vp9.Vp9Frame;
import org.jitsi.videobridge.cc.vp9.Vp9Picture;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0014J$\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00100\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0014J$\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00100\u0018J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jitsi/videobridge/cc/vp9/Vp9PictureMap;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/utils/logging2/Logger;)V", "pictureHistory", "Lorg/jitsi/videobridge/cc/vp9/PictureHistory;", "logger", "findPicture", "Lorg/jitsi/videobridge/cc/vp9/Vp9Picture;", "packet", "Lorg/jitsi/nlj/rtp/codec/vp9/Vp9Packet;", "size", "", "isLargeJump", "", "insertPacket", "Lorg/jitsi/videobridge/cc/vp9/PacketInsertionResult;", "nextFrame", "Lorg/jitsi/videobridge/cc/vp9/Vp9Frame;", "frame", "nextFrameWith", "pred", "Lkotlin/Function1;", "prevFrame", "prevFrameWith", "findPrevAcceptedFrame", "findNextAcceptedFrame", "findNextBaseTl0", "Companion", "jitsi-videobridge"})
public final class Vp9PictureMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PictureHistory pictureHistory;
    @NotNull
    private final Logger logger;
    public static final int PICTURE_MAP_SIZE = 500;

    public Vp9PictureMap(@NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        this.pictureHistory = new PictureHistory(500);
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
    }

    @Nullable
    public final synchronized Vp9Picture findPicture(@NotNull Vp9Packet packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        return this.pictureHistory.get(packet.getPictureId());
    }

    public final int size() {
        return this.pictureHistory.getNumCached();
    }

    private final boolean isLargeJump(Vp9Packet packet) {
        Vp9Picture vp9Picture = this.pictureHistory.getLatestPicture();
        if (vp9Picture == null) {
            return false;
        }
        Vp9Picture latestPicture = vp9Picture;
        int picDelta = VpxUtils.Companion.getExtendedPictureIdDelta(packet.getPictureId(), latestPicture.getPictureId());
        if (picDelta > 500) {
            return true;
        }
        long tsDelta = RtpUtils.Companion.getTimestampDiff(packet.getTimestamp(), latestPicture.getTimestamp());
        if (picDelta < 0) {
            if (tsDelta > 0L) {
                return true;
            }
            if (RtpUtils.Companion.getSequenceNumberDelta(packet.getSequenceNumber(), latestPicture.getLatestKnownSequenceNumber()) > 0) {
                return true;
            }
        }
        return tsDelta > 90000000L;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final synchronized PacketInsertionResult insertPacket(@NotNull Vp9Packet packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        int pictureId = packet.getPictureId();
        if (pictureId == -1) {
            return null;
        }
        if (this.isLargeJump(packet)) {
            this.pictureHistory.getIndexTracker().resetAt((Object)pictureId);
            Vp9Picture vp9Picture = this.pictureHistory.insert(packet);
            if (vp9Picture == null) {
                return null;
            }
            Vp9Picture picture = vp9Picture;
            Vp9Frame vp9Frame = picture.frame(packet);
            Intrinsics.checkNotNull((Object)vp9Frame);
            return new PacketInsertionResult(vp9Frame, picture, true, true);
        }
        Vp9Picture picture = this.pictureHistory.get(pictureId);
        if (picture != null) {
            if (!picture.matchesPicture(packet)) {
                void $this$insertPacket_u24lambda_u242;
                void $this$insertPacket_u24lambda_u241;
                if (!(picture.getPictureId() == pictureId)) {
                    boolean $i$a$-check-Vp9PictureMap$insertPacket$22 = false;
                    String cfr_ignored_0 = "Picture map returned picture with picture ID " + picture.getPictureId() + " ";
                    String $i$a$-check-Vp9PictureMap$insertPacket$22 = "when asked for picture with picture ID " + pictureId;
                    throw new IllegalStateException($i$a$-check-Vp9PictureMap$insertPacket$22.toString());
                }
                Vp9Picture $i$a$-check-Vp9PictureMap$insertPacket$22 = picture;
                Logger logger = this.logger;
                boolean bl = false;
                Vp9Packet vp9Packet = packet;
                String string = "picture with ssrc " + $this$insertPacket_u24lambda_u241.getSsrc() + ", timestamp " + $this$insertPacket_u24lambda_u241.getTimestamp() + ", and sequence number range " + $this$insertPacket_u24lambda_u241.getEarliestKnownSequenceNumber() + "-" + $this$insertPacket_u24lambda_u241.getLatestKnownSequenceNumber() + ", ";
                boolean bl2 = false;
                String string2 = "and packet " + $this$insertPacket_u24lambda_u242.getSequenceNumber() + " with ssrc " + $this$insertPacket_u24lambda_u242.getSsrc() + ", timestamp " + $this$insertPacket_u24lambda_u242.getTimestamp() + ", and sequence number " + $this$insertPacket_u24lambda_u242.getSequenceNumber();
                logger.warn((Object)("Cannot insert packet in picture map: " + string + string2 + " both have picture ID " + pictureId));
                return null;
            }
            try {
                picture.validateConsistency(packet);
            }
            catch (Exception e) {
                this.logger.warn((Object)e);
            }
            return picture.addPacket(packet);
        }
        Vp9Picture vp9Picture = this.pictureHistory.insert(packet);
        if (vp9Picture == null) {
            return null;
        }
        Vp9Picture newPicture = vp9Picture;
        Vp9Frame vp9Frame = newPicture.frame(packet);
        Intrinsics.checkNotNull((Object)vp9Frame);
        return new PacketInsertionResult(vp9Frame, newPicture, true, false, 8, null);
    }

    @Nullable
    public final synchronized Vp9Frame nextFrame(@NotNull Vp9Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        return this.pictureHistory.findAfter(frame, (Function1<? super Vp9Frame, Boolean>)((Function1)Vp9PictureMap::nextFrame$lambda$0));
    }

    @Nullable
    public final synchronized Vp9Frame nextFrameWith(@NotNull Vp9Frame frame, @NotNull Function1<? super Vp9Frame, Boolean> pred) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter(pred, (String)"pred");
        return this.pictureHistory.findAfter(frame, pred);
    }

    @Nullable
    public final synchronized Vp9Frame prevFrame(@NotNull Vp9Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        return this.pictureHistory.findBefore(frame, (Function1<? super Vp9Frame, Boolean>)((Function1)Vp9PictureMap::prevFrame$lambda$0));
    }

    @Nullable
    public final synchronized Vp9Frame prevFrameWith(@NotNull Vp9Frame frame, @NotNull Function1<? super Vp9Frame, Boolean> pred) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter(pred, (String)"pred");
        return this.pictureHistory.findBefore(frame, pred);
    }

    @Nullable
    public final Vp9Frame findPrevAcceptedFrame(@NotNull Vp9Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        return this.prevFrameWith(frame, (Function1<? super Vp9Frame, Boolean>)((Function1)Vp9PictureMap::findPrevAcceptedFrame$lambda$0));
    }

    @Nullable
    public final Vp9Frame findNextAcceptedFrame(@NotNull Vp9Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        return this.nextFrameWith(frame, (Function1<? super Vp9Frame, Boolean>)((Function1)Vp9PictureMap::findNextAcceptedFrame$lambda$0));
    }

    @Nullable
    public final Vp9Frame findNextBaseTl0(@NotNull Vp9Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        return this.nextFrameWith(frame, (Function1<? super Vp9Frame, Boolean>)((Function1)Vp9PictureMap::findNextBaseTl0$lambda$0));
    }

    private static final boolean nextFrame$lambda$0(Vp9Frame it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean prevFrame$lambda$0(Vp9Frame it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean findPrevAcceptedFrame$lambda$0(Vp9Frame it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isAccepted();
    }

    private static final boolean findNextAcceptedFrame$lambda$0(Vp9Frame it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isAccepted();
    }

    private static final boolean findNextBaseTl0$lambda$0(Vp9Frame it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSpatialLayer() <= 0 && it.getTemporalLayer() <= 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/videobridge/cc/vp9/Vp9PictureMap$Companion;", "", "<init>", "()V", "PICTURE_MAP_SIZE", "", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

