/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest.prometheus;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jitsi.metrics.MetricsContainer;

@Path(value="/metrics")
public class Prometheus {
    private static final Comparator<MediaType> comparator = Comparator.comparing(Prometheus::getQValue).reversed();
    @NotNull
    private final MetricsContainer metricsContainer;

    private static double getQValue(MediaType m) {
        return m.getParameters().get("q") == null ? 1.0 : Double.parseDouble((String)m.getParameters().get("q"));
    }

    public Prometheus(@NotNull MetricsContainer metricsContainer) {
        this.metricsContainer = metricsContainer;
    }

    @GET
    public Response x(@HeaderParam(value="Accept") String accept) {
        List acceptMediaTypes = Arrays.stream(accept.split(",")).map(MediaType::valueOf).sorted(comparator).map(m -> m.getType() + "/" + m.getSubtype()).collect(Collectors.toList());
        Pair m2 = this.metricsContainer.getMetrics(acceptMediaTypes);
        return Response.ok((Object)m2.getFirst(), (String)((String)m2.getSecond())).build();
    }
}

