/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.sctp;

import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.transform.node.ConsumerNode;
import org.jitsi.rtp.Packet;
import org.jitsi.videobridge.datachannel.DataChannelStack;
import org.jitsi.videobridge.datachannel.protocol.DataChannelPacket;
import org.jitsi.videobridge.util.TaskPools;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jitsi/videobridge/sctp/DataChannelHandler;", "Lorg/jitsi/nlj/transform/node/ConsumerNode;", "<init>", "()V", "dataChannelStackLock", "", "dataChannelStack", "Lorg/jitsi/videobridge/datachannel/DataChannelStack;", "cachedDataChannelPackets", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lorg/jitsi/nlj/PacketInfo;", "consume", "", "packetInfo", "setDataChannelStack", "trace", "f", "Lkotlin/Function0;", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nDataChannelHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataChannelHandler.kt\norg/jitsi/videobridge/sctp/DataChannelHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1869#2,2:81\n*S KotlinDebug\n*F\n+ 1 DataChannelHandler.kt\norg/jitsi/videobridge/sctp/DataChannelHandler\n*L\n66#1:81,2\n*E\n"})
public final class DataChannelHandler
extends ConsumerNode {
    @NotNull
    private final Object dataChannelStackLock = new Object();
    @Nullable
    private DataChannelStack dataChannelStack;
    @NotNull
    private final LinkedBlockingQueue<PacketInfo> cachedDataChannelPackets = new LinkedBlockingQueue();

    public DataChannelHandler() {
        super("Data channel handler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        Object object = this.dataChannelStackLock;
        synchronized (object) {
            Object object2;
            boolean bl = false;
            Packet packet = packetInfo.getPacket();
            if (packet instanceof DataChannelPacket) {
                DataChannelStack dataChannelStack = this.dataChannelStack;
                if (dataChannelStack != null) {
                    dataChannelStack.onIncomingDataChannelPacket(ByteBuffer.wrap(packet.buffer), ((DataChannelPacket)packet).sid, ((DataChannelPacket)packet).ppid);
                    object2 = Unit.INSTANCE;
                } else {
                    DataChannelHandler $this$consume_u24lambda_u240_u240 = this;
                    boolean bl2 = false;
                    object2 = $this$consume_u24lambda_u240_u240.cachedDataChannelPackets.add(packetInfo);
                }
            } else {
                object2 = Unit.INSTANCE;
            }
            Unit unit = object2;
        }
    }

    public final void setDataChannelStack(@NotNull DataChannelStack dataChannelStack) {
        Intrinsics.checkNotNullParameter((Object)dataChannelStack, (String)"dataChannelStack");
        TaskPools.IO_POOL.execute(() -> DataChannelHandler.setDataChannelStack$lambda$0(this, dataChannelStack));
    }

    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        f.invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void setDataChannelStack$lambda$0(DataChannelHandler this$0, DataChannelStack $dataChannelStack) {
        Object object = this$0.dataChannelStackLock;
        synchronized (object) {
            boolean bl = false;
            this$0.dataChannelStack = $dataChannelStack;
            Iterable $this$forEach$iv = this$0.cachedDataChannelPackets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PacketInfo it = (PacketInfo)element$iv;
                boolean bl2 = false;
                Packet packet = it.getPacket();
                Intrinsics.checkNotNull((Object)packet, (String)"null cannot be cast to non-null type org.jitsi.videobridge.datachannel.protocol.DataChannelPacket");
                DataChannelPacket dcp = (DataChannelPacket)packet;
                $dataChannelStack.onIncomingDataChannelPacket(ByteBuffer.wrap(dcp.buffer), dcp.sid, dcp.ppid);
            }
            Unit unit = Unit.INSTANCE;
        }
    }
}

