/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.stats;

import java.time.Clock;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.stats.RateTracker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B%\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0015\u001a\u00020\f2\b\b\u0002\u0010\u0016\u001a\u00020\fH\u0007J\u0012\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u0016\u001a\u00020\fH\u0016J\u001c\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u00032\b\b\u0002\u0010\u0016\u001a\u00020\fH\u0007R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lorg/jitsi/utils/stats/RateStatistics;", "", "windowSizeMs", "", "scale", "", "clock", "Ljava/time/Clock;", "(IFLjava/time/Clock;)V", "getClock", "()Ljava/time/Clock;", "rate", "", "getRate", "()J", "getScale", "()F", "tracker", "Lorg/jitsi/utils/stats/RateTracker;", "getTracker", "()Lorg/jitsi/utils/stats/RateTracker;", "getAccumulatedCount", "nowMs", "update", "", "count", "jitsi-utils"})
public class RateStatistics {
    @NotNull
    private final Clock clock;
    @NotNull
    private final RateTracker tracker;
    private final float scale;

    @JvmOverloads
    public RateStatistics(int windowSizeMs, float scale, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
        this.tracker = new RateTracker(windowSizeMs, DurationKt.getMs(1), this.clock);
        this.scale = scale / (float)windowSizeMs;
    }

    public /* synthetic */ RateStatistics(int n, float f, Clock clock, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1000;
        }
        if ((n2 & 2) != 0) {
            f = 8000.0f;
        }
        if ((n2 & 4) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        this(n, f, clock);
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    @NotNull
    public final RateTracker getTracker() {
        return this.tracker;
    }

    public final float getScale() {
        return this.scale;
    }

    public final long getRate() {
        return this.getRate(this.clock.millis());
    }

    public long getRate(long nowMs) {
        return MathKt.roundToLong((float)((float)this.tracker.getRate(nowMs) * this.scale));
    }

    public static /* synthetic */ long getRate$default(RateStatistics rateStatistics, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getRate");
        }
        if ((n & 1) != 0) {
            l = rateStatistics.clock.millis();
        }
        return rateStatistics.getRate(l);
    }

    @JvmOverloads
    public final long getAccumulatedCount(long nowMs) {
        return this.tracker.getAccumulatedCount(nowMs);
    }

    public static /* synthetic */ long getAccumulatedCount$default(RateStatistics rateStatistics, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAccumulatedCount");
        }
        if ((n & 1) != 0) {
            l = rateStatistics.clock.millis();
        }
        return rateStatistics.getAccumulatedCount(l);
    }

    @JvmOverloads
    public final void update(int count, long nowMs) {
        this.tracker.update(count, nowMs);
    }

    public static /* synthetic */ void update$default(RateStatistics rateStatistics, int n, long l, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n2 & 1) != 0) {
            n = 1;
        }
        if ((n2 & 2) != 0) {
            l = rateStatistics.clock.millis();
        }
        rateStatistics.update(n, l);
    }

    @JvmOverloads
    public RateStatistics(int windowSizeMs, float scale) {
        this(windowSizeMs, scale, null, 4, null);
    }

    @JvmOverloads
    public RateStatistics(int windowSizeMs) {
        this(windowSizeMs, 0.0f, null, 6, null);
    }

    @JvmOverloads
    public RateStatistics() {
        this(0, 0.0f, null, 7, null);
    }

    @JvmOverloads
    public final long getAccumulatedCount() {
        return RateStatistics.getAccumulatedCount$default(this, 0L, 1, null);
    }

    @JvmOverloads
    public final void update(int count) {
        RateStatistics.update$default(this, count, 0L, 2, null);
    }

    @JvmOverloads
    public final void update() {
        RateStatistics.update$default(this, 0, 0L, 3, null);
    }
}

