/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.dtls;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.time.Duration;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDefaultDigestProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.dtls.CertificateInfo;
import org.jitsi.nlj.dtls.DtlsConfig;
import org.jitsi.nlj.dtls.DtlsUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00042\u00020\u0001:\u0002\u0004\u0005B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/nlj/dtls/DtlsUtils;", "", "<init>", "()V", "Companion", "DtlsException", "jitsi-media-transform"})
public final class DtlsUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final char[] HEX_CHARS;

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        char[] cArray = "0123456789ABCDEF".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        HEX_CHARS = cArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\"\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\tJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u001c0\u001bJ*\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\f2\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u001c0\u001bH\u0002J\u0014\u0010\u001e\u001a\u00020\u0014*\u00020\f2\u0006\u0010\u001f\u001a\u00020\u0014H\u0002J\f\u0010\"\u001a\u00020\u0014*\u00020#H\u0002J0\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00142\b\u0010(\u001a\u0004\u0018\u00010#2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020+R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jitsi/nlj/dtls/DtlsUtils$Companion;", "", "<init>", "()V", "generateCertificateInfo", "Lorg/jitsi/nlj/dtls/CertificateInfo;", "chooseSrtpProtectionProfile", "", "ours", "", "theirs", "generateCertificate", "Lorg/bouncycastle/asn1/x509/Certificate;", "subject", "Lorg/bouncycastle/asn1/x500/X500Name;", "keyPair", "Ljava/security/KeyPair;", "generateEcKeyPair", "generateCN", "appName", "", "appVersion", "verifyAndValidateCertificate", "", "certificateInfo", "Lorg/bouncycastle/tls/Certificate;", "remoteFingerprints", "", "", "certificate", "getFingerprint", "hashFunction", "HEX_CHARS", "", "toFingerprint", "", "exportKeyingMaterial", "context", "Lorg/bouncycastle/tls/TlsContext;", "asciiLabel", "context_value", "length", "masterSecret", "Lorg/bouncycastle/tls/crypto/TlsSecret;", "jitsi-media-transform"})
    @SourceDebugExtension(value={"SMAP\nDtlsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtlsUtils.kt\norg/jitsi/nlj/dtls/DtlsUtils$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,324:1\n230#2,2:325\n1869#2:327\n2746#2,3:328\n1870#2:331\n*S KotlinDebug\n*F\n+ 1 DtlsUtils.kt\norg/jitsi/nlj/dtls/DtlsUtils$Companion\n*L\n87#1:325,2\n189#1:327\n194#1:328,3\n189#1:331\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CertificateInfo generateCertificateInfo() {
            X500Name cn = this.generateCN("TODO-APP-NAME", "TODO-APP-VERSION");
            KeyPair keyPair = this.generateEcKeyPair();
            org.bouncycastle.asn1.x509.Certificate x509certificate = this.generateCertificate(cn, keyPair);
            String localFingerprintHashFunction = DtlsConfig.Companion.getConfig().getLocalFingerprintHashFunction();
            String localFingerprint = this.getFingerprint(x509certificate, localFingerprintHashFunction);
            BcTlsCertificate[] bcTlsCertificateArray = new BcTlsCertificate[]{new BcTlsCertificate(DtlsUtilsKt.getBC_TLS_CRYPTO(), x509certificate)};
            Certificate certificate = new Certificate((TlsCertificate[])bcTlsCertificateArray);
            return new CertificateInfo(keyPair, certificate, localFingerprintHashFunction, localFingerprint, System.currentTimeMillis());
        }

        public final int chooseSrtpProtectionProfile(@NotNull Iterable<Integer> ours, @NotNull Iterable<Integer> theirs) {
            int n;
            Intrinsics.checkNotNullParameter(ours, (String)"ours");
            Intrinsics.checkNotNullParameter(theirs, (String)"theirs");
            try {
                Integer element$iv2;
                block3: {
                    Iterable<Integer> $this$first$iv = ours;
                    boolean $i$f$first = false;
                    for (Integer element$iv2 : $this$first$iv) {
                        int p0 = ((Number)element$iv2).intValue();
                        boolean bl = false;
                        if (!CollectionsKt.contains(theirs, (Object)p0)) continue;
                        break block3;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                n = ((Number)element$iv2).intValue();
            }
            catch (NoSuchElementException e) {
                throw new DtlsException("No common SRTP protection profile found.  Ours: " + CollectionsKt.joinToString$default(ours, null, null, null, (int)0, null, null, (int)63, null) + " Theirs: " + CollectionsKt.joinToString$default(theirs, null, null, null, (int)0, null, null, (int)63, null));
            }
            return n;
        }

        private final org.bouncycastle.asn1.x509.Certificate generateCertificate(X500Name subject, KeyPair keyPair) {
            long now = System.currentTimeMillis();
            Date startDate = new Date(now - Duration.ofDays(1L).toMillis());
            Date expiryDate = new Date(now + Duration.ofDays(7L).toMillis());
            BigInteger serialNumber = BigInteger.valueOf(now);
            JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(subject, serialNumber, startDate, expiryDate, subject, keyPair.getPublic());
            ContentSigner signer = new JcaContentSignerBuilder("SHA256withECDSA").build(keyPair.getPrivate());
            org.bouncycastle.asn1.x509.Certificate certificate = certBuilder.build(signer).toASN1Structure();
            Intrinsics.checkNotNullExpressionValue((Object)certificate, (String)"toASN1Structure(...)");
            return certificate;
        }

        private final KeyPair generateEcKeyPair() {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC", "BC");
            ECNamedCurveParameterSpec ecCurveSpec = ECNamedCurveTable.getParameterSpec((String)"secp256r1");
            keyGen.initialize((AlgorithmParameterSpec)ecCurveSpec);
            KeyPair keyPair = keyGen.generateKeyPair();
            Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"generateKeyPair(...)");
            return keyPair;
        }

        private final X500Name generateCN(String appName, String appVersion) {
            X500NameBuilder builder2 = new X500NameBuilder(BCStyle.INSTANCE);
            String rdn = appName + " " + appVersion;
            builder2.addRDN(BCStyle.CN, rdn);
            X500Name x500Name = builder2.build();
            Intrinsics.checkNotNullExpressionValue((Object)x500Name, (String)"build(...)");
            return x500Name;
        }

        public final void verifyAndValidateCertificate(@NotNull Certificate certificateInfo, @NotNull Map<String, ? extends List<String>> remoteFingerprints) {
            Intrinsics.checkNotNullParameter((Object)certificateInfo, (String)"certificateInfo");
            Intrinsics.checkNotNullParameter(remoteFingerprints, (String)"remoteFingerprints");
            TlsCertificate[] tlsCertificateArray = certificateInfo.getCertificateList();
            Intrinsics.checkNotNullExpressionValue((Object)tlsCertificateArray, (String)"getCertificateList(...)");
            if (((Object[])tlsCertificateArray).length == 0) {
                throw new DtlsException("No remote fingerprints.");
            }
            TlsCertificate[] tlsCertificateArray2 = certificateInfo.getCertificateList();
            Intrinsics.checkNotNullExpressionValue((Object)tlsCertificateArray2, (String)"getCertificateList(...)");
            for (TlsCertificate currCertificate : tlsCertificateArray2) {
                org.bouncycastle.asn1.x509.Certificate x509Cert = org.bouncycastle.asn1.x509.Certificate.getInstance((Object)currCertificate.getEncoded());
                Intrinsics.checkNotNull((Object)x509Cert);
                this.verifyAndValidateCertificate(x509Cert, remoteFingerprints);
            }
        }

        private final void verifyAndValidateCertificate(org.bouncycastle.asn1.x509.Certificate certificate, Map<String, ? extends List<String>> remoteFingerprints) {
            Iterable $this$forEach$iv = DtlsConfig.Companion.getConfig().getAcceptedFingerprintHashFunctions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                String certificateFingerprint;
                List<String> fingerprints;
                String hashFunction;
                block5: {
                    hashFunction = (String)element$iv;
                    boolean bl2 = false;
                    List<String> list = remoteFingerprints.get(hashFunction);
                    if (list == null) continue;
                    fingerprints = list;
                    certificateFingerprint = Companion.getFingerprint(certificate, hashFunction);
                    Iterable $this$none$iv = fingerprints;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $this$none$iv) {
                            String it = (String)element$iv2;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)certificateFingerprint)) continue;
                            bl = false;
                            break block5;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    throw new DtlsException("None of the fingerprints " + CollectionsKt.joinToString$default((Iterable)fingerprints, null, null, null, (int)0, null, null, (int)63, null) + " match the " + hashFunction + "-hashed certificate " + certificateFingerprint);
                }
                return;
            }
            throw new DtlsException("No fingerprint declared over the signaling path with any of the accepted hash functions: " + CollectionsKt.joinToString$default((Iterable)DtlsConfig.Companion.getConfig().getAcceptedFingerprintHashFunctions(), null, null, null, (int)0, null, null, (int)63, null));
        }

        private final String getFingerprint(org.bouncycastle.asn1.x509.Certificate $this$getFingerprint, String hashFunction) {
            DefaultDigestAlgorithmIdentifierFinder defaultDigestAlgorithmIdentifierFinder = new DefaultDigestAlgorithmIdentifierFinder();
            String string = hashFunction.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            AlgorithmIdentifier digAlgId = defaultDigestAlgorithmIdentifierFinder.find(string);
            ExtendedDigest digest = BcDefaultDigestProvider.INSTANCE.get(digAlgId);
            byte[] byArray = $this$getFingerprint.getEncoded("DER");
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
            byte[] input = byArray;
            byte[] output = new byte[digest.getDigestSize()];
            digest.update(input, 0, input.length);
            digest.doFinal(output, 0);
            return this.toFingerprint(output);
        }

        private final String toFingerprint(byte[] $this$toFingerprint) {
            StringBuffer buf = new StringBuffer();
            int n = $this$toFingerprint.length;
            for (int i = 0; i < n; ++i) {
                byte octet = $this$toFingerprint[i];
                int firstIndex = (octet & 0xF0) >>> 4;
                int secondIndex = octet & 0xF;
                buf.append(HEX_CHARS[firstIndex]);
                buf.append(HEX_CHARS[secondIndex]);
                if (i >= $this$toFingerprint.length - 1) continue;
                buf.append(":");
            }
            String string = buf.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @NotNull
        public final byte[] exportKeyingMaterial(@NotNull TlsContext context, @NotNull String asciiLabel, @Nullable byte[] context_value, int length, @NotNull TlsSecret masterSecret) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)asciiLabel, (String)"asciiLabel");
            Intrinsics.checkNotNullParameter((Object)masterSecret, (String)"masterSecret");
            if (context_value != null && !TlsUtils.isValidUint16((int)context_value.length)) {
                throw new IllegalArgumentException("'context_value' must have a length less than 2^16 (or be null)");
            }
            SecurityParameters sp = context.getSecurityParameters();
            byte[] cr = sp.getClientRandom();
            byte[] sr = sp.getServerRandom();
            int seedLength = cr.length + sr.length;
            if (context_value != null) {
                seedLength += 2 + context_value.length;
            }
            byte[] seed = new byte[seedLength];
            int seedPos = 0;
            System.arraycopy(cr, 0, seed, seedPos, cr.length);
            System.arraycopy(sr, 0, seed, seedPos += cr.length, sr.length);
            seedPos += sr.length;
            if (context_value != null) {
                TlsUtils.writeUint16((int)context_value.length, (byte[])seed, (int)seedPos);
                System.arraycopy(context_value, 0, seed, seedPos += 2, context_value.length);
                seedPos += context_value.length;
            }
            if (seedPos != seedLength) {
                throw new IllegalStateException("error in calculation of seed for export");
            }
            byte[] byArray = TlsUtils.PRF((SecurityParameters)sp, (TlsSecret)masterSecret, (String)asciiLabel, (byte[])seed, (int)length).extract();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"extract(...)");
            return byArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/nlj/dtls/DtlsUtils$DtlsException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "msg", "", "<init>", "(Ljava/lang/String;)V", "jitsi-media-transform"})
    public static final class DtlsException
    extends Exception {
        public DtlsException(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            super(msg);
        }
    }
}

