/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.bandwidthestimation2.PacketResult;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0002\u0019\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\b\u0012J\r\u0010\u0013\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/ProbeBitrateEstimator;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "<init>", "(Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/utils/logging/DiagnosticContext;)V", "logger", "clusters", "Ljava/util/TreeMap;", "", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/ProbeBitrateEstimator$AggregatedCluster;", "estimatedDataRate", "Lorg/jitsi/nlj/util/Bandwidth;", "handleProbeAndEstimateBitrate", "packetFeedback", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/PacketResult;", "handleProbeAndEstimateBitrate-VeXOdVA", "fetchAndResetLastEstimatedBitrate", "fetchAndResetLastEstimatedBitrate-4yB3KFE", "eraseOldClusters", "", "timestamp", "Ljava/time/Instant;", "AggregatedCluster", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nProbeBitrateEstimator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProbeBitrateEstimator.kt\norg/jitsi/nlj/rtp/bandwidthestimation2/ProbeBitrateEstimator\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,205:1\n382#2,7:206\n*S KotlinDebug\n*F\n+ 1 ProbeBitrateEstimator.kt\norg/jitsi/nlj/rtp/bandwidthestimation2/ProbeBitrateEstimator\n*L\n58#1:206,7\n*E\n"})
public final class ProbeBitrateEstimator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiagnosticContext diagnosticContext;
    @NotNull
    private final Logger logger;
    @NotNull
    private final TreeMap<Integer, AggregatedCluster> clusters;
    @Nullable
    private Bandwidth estimatedDataRate;
    public static final double kMinReceivedProbesRatio = 0.8;
    public static final double kMinReceivedBytesRatio = 0.8;
    public static final float kMaxValidRatio = 2.0f;
    public static final double kMinRatioForUnsaturatedLink = 0.9;
    public static final double kTargetUtilizationFraction = 0.95;
    @NotNull
    private static final Duration kMaxClusterHistory = DurationKt.getSecs((int)1);
    @NotNull
    private static final Duration kMaxProbeInterval = DurationKt.getSecs((int)1);
    private static final TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(ProbeBitrateEstimator.class);

    public ProbeBitrateEstimator(@NotNull Logger parentLogger, @NotNull DiagnosticContext diagnosticContext) {
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter((Object)diagnosticContext, (String)"diagnosticContext");
        this.diagnosticContext = diagnosticContext;
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        this.clusters = new TreeMap();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bandwidth handleProbeAndEstimateBitrate-VeXOdVA(@NotNull PacketResult packetFeedback) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)packetFeedback, (String)"packetFeedback");
        int clusterId = packetFeedback.getSentPacket().getPacingInfo().getProbeClusterId();
        if (!(clusterId != -1)) {
            throw new IllegalStateException("Check failed.");
        }
        this.eraseOldClusters(packetFeedback.getReceiveTime());
        Map map = this.clusters;
        Integer key$iv = clusterId;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            AggregatedCluster answer$iv = new AggregatedCluster(0, null, null, null, null, null, null, null, 255, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        AggregatedCluster cluster = (AggregatedCluster)object;
        if (packetFeedback.getSentPacket().getSendTime().compareTo(cluster.getFirstSend()) < 0) {
            cluster.setFirstSend(packetFeedback.getSentPacket().getSendTime());
        }
        if (packetFeedback.getSentPacket().getSendTime().compareTo(cluster.getLastSend()) > 0) {
            cluster.setLastSend(packetFeedback.getSentPacket().getSendTime());
            cluster.setSizeLastSend(packetFeedback.getSentPacket().getSize());
        }
        if (packetFeedback.getReceiveTime().compareTo(cluster.getFirstReceive()) < 0) {
            cluster.setFirstReceive(packetFeedback.getReceiveTime());
            cluster.setSizeFirstReceive(packetFeedback.getSentPacket().getSize());
        }
        if (packetFeedback.getReceiveTime().compareTo(cluster.getLastReceive()) > 0) {
            cluster.setLastReceive(packetFeedback.getReceiveTime());
        }
        cluster.setSizeTotal(cluster.getSizeTotal().plus(packetFeedback.getSentPacket().getSize()));
        cluster.setNumProbes(cluster.getNumProbes() + 1);
        if (!(packetFeedback.getSentPacket().getPacingInfo().getProbeClusterMinProbes() > 0)) {
            throw new IllegalStateException("Check failed.");
        }
        if (!(packetFeedback.getSentPacket().getPacingInfo().getProbeClusterMinBytes() > 0)) {
            throw new IllegalStateException("Check failed.");
        }
        double minProbes = (double)packetFeedback.getSentPacket().getPacingInfo().getProbeClusterMinProbes() * 0.8;
        DataSize minSize = DataSizeKt.getBytes(packetFeedback.getSentPacket().getPacingInfo().getProbeClusterMinBytes()).times(0.8);
        if ((double)cluster.getNumProbes() < minProbes || cluster.getSizeTotal().compareTo(minSize) < 0) {
            return null;
        }
        Duration sendInterval = Duration.between(cluster.getFirstSend(), cluster.getLastSend());
        Duration receiveInterval = Duration.between(cluster.getFirstReceive(), cluster.getLastReceive());
        if (sendInterval.compareTo(Duration.ZERO) <= 0 || sendInterval.compareTo(kMaxProbeInterval) > 0 || receiveInterval.compareTo(Duration.ZERO) <= 0 || receiveInterval.compareTo(kMaxProbeInterval) > 0) {
            this.logger.info((Object)("Probing unsuccessful, invalid send/receive interval [cluster id: " + clusterId + "] [sendInterval: " + sendInterval + "] [receive interval: " + receiveInterval + "]"));
            return null;
        }
        if (!(cluster.getSizeTotal().compareTo(cluster.getSizeLastSend()) >= 0)) {
            throw new IllegalStateException("Check failed.");
        }
        DataSize sendSize = cluster.getSizeTotal().minus(cluster.getSizeLastSend());
        Intrinsics.checkNotNull((Object)sendInterval);
        long sendRate = BandwidthKt.per(sendSize, sendInterval);
        if (!(cluster.getSizeTotal().compareTo(cluster.getSizeFirstReceive()) >= 0)) {
            throw new IllegalStateException("Check failed.");
        }
        DataSize receiveSize = cluster.getSizeTotal().minus(cluster.getSizeFirstReceive());
        Intrinsics.checkNotNull((Object)receiveInterval);
        long receiveRate = BandwidthKt.per(receiveSize, receiveInterval);
        double ratio = Bandwidth.div-_2icLw0(receiveRate, sendRate);
        if (ratio > 2.0) {
            this.logger.info((Object)("Probing unsuccessful, receive/send ratio too high [cluster id: " + clusterId + "] [send: " + sendSize + "/" + sendInterval + " = " + Bandwidth.toString-impl(sendRate) + "] [receive: " + receiveSize + "/" + receiveInterval + " = " + Bandwidth.toString-impl(receiveRate) + "] [ratio: " + Bandwidth.toString-impl(receiveRate) + " / " + Bandwidth.toString-impl(sendRate) + " = " + ratio + " > kMaxValidRatio (2.0)]"));
            return null;
        }
        this.logger.info((Object)("Probing successful [cluster id: " + clusterId + "] [send: " + sendSize + " / " + sendInterval + " = " + Bandwidth.toString-impl(sendRate) + "][receive: " + receiveSize + " / " + receiveInterval + " = " + Bandwidth.toString-impl(receiveRate) + "]"));
        Ref.LongRef res = new Ref.LongRef();
        res.element = BandwidthKt.min-YUm52VA(sendRate, receiveRate);
        if (Bandwidth.compareTo-_2icLw0(receiveRate, BandwidthKt.times-ERFH51c(0.9, sendRate)) < 0) {
            if (!(Bandwidth.compareTo-_2icLw0(sendRate, receiveRate) > 0)) {
                throw new IllegalStateException("Check failed.");
            }
            res.element = BandwidthKt.times-ERFH51c(0.95, receiveRate);
        }
        timeSeriesLogger.trace(() -> ProbeBitrateEstimator.handleProbeAndEstimateBitrate_VeXOdVA$lambda$1(this, clusterId, res));
        this.estimatedDataRate = Bandwidth.box-impl(res.element);
        return this.estimatedDataRate;
    }

    @Nullable
    public final Bandwidth fetchAndResetLastEstimatedBitrate-4yB3KFE() {
        Bandwidth estimatedDataRate = this.estimatedDataRate;
        this.estimatedDataRate = null;
        return estimatedDataRate;
    }

    private final void eraseOldClusters(Instant timestamp) {
        this.clusters.entrySet().removeIf(arg_0 -> ProbeBitrateEstimator.eraseOldClusters$lambda$1(arg_0 -> ProbeBitrateEstimator.eraseOldClusters$lambda$0(timestamp, arg_0), arg_0));
    }

    private static final Map handleProbeAndEstimateBitrate_VeXOdVA$lambda$1(ProbeBitrateEstimator this$0, int $clusterId, Ref.LongRef $res) {
        return (Map)this$0.diagnosticContext.makeTimeSeriesPoint("probe_result_success").addField("id", (Object)$clusterId).addField("bitrate_bps", (Object)$res.element);
    }

    private static final boolean eraseOldClusters$lambda$0(Instant $timestamp, Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((AggregatedCluster)it.getValue()).getLastReceive().plus(kMaxClusterHistory).compareTo($timestamp) < 0;
    }

    private static final boolean eraseOldClusters$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b$\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001BW\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\u0005H\u00c6\u0003J\t\u0010(\u001a\u00020\u0005H\u00c6\u0003J\t\u0010)\u001a\u00020\u0005H\u00c6\u0003J\t\u0010*\u001a\u00020\nH\u00c6\u0003J\t\u0010+\u001a\u00020\nH\u00c6\u0003J\t\u0010,\u001a\u00020\nH\u00c6\u0003JY\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\nH\u00c6\u0001J\u0013\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00101\u001a\u00020\u0003H\u00d6\u0001J\t\u00102\u001a\u000203H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0014\"\u0004\b\u001a\u0010\u0016R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\u000b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001e\"\u0004\b\"\u0010 R\u001a\u0010\f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001e\"\u0004\b$\u0010 \u00a8\u00064"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/ProbeBitrateEstimator$AggregatedCluster;", "", "numProbes", "", "firstSend", "Ljava/time/Instant;", "lastSend", "firstReceive", "lastReceive", "sizeLastSend", "Lorg/jitsi/nlj/util/DataSize;", "sizeFirstReceive", "sizeTotal", "<init>", "(ILjava/time/Instant;Ljava/time/Instant;Ljava/time/Instant;Ljava/time/Instant;Lorg/jitsi/nlj/util/DataSize;Lorg/jitsi/nlj/util/DataSize;Lorg/jitsi/nlj/util/DataSize;)V", "getNumProbes", "()I", "setNumProbes", "(I)V", "getFirstSend", "()Ljava/time/Instant;", "setFirstSend", "(Ljava/time/Instant;)V", "getLastSend", "setLastSend", "getFirstReceive", "setFirstReceive", "getLastReceive", "setLastReceive", "getSizeLastSend", "()Lorg/jitsi/nlj/util/DataSize;", "setSizeLastSend", "(Lorg/jitsi/nlj/util/DataSize;)V", "getSizeFirstReceive", "setSizeFirstReceive", "getSizeTotal", "setSizeTotal", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "toString", "", "jitsi-media-transform"})
    private static final class AggregatedCluster {
        private int numProbes;
        @NotNull
        private Instant firstSend;
        @NotNull
        private Instant lastSend;
        @NotNull
        private Instant firstReceive;
        @NotNull
        private Instant lastReceive;
        @NotNull
        private DataSize sizeLastSend;
        @NotNull
        private DataSize sizeFirstReceive;
        @NotNull
        private DataSize sizeTotal;

        public AggregatedCluster(int numProbes, @NotNull Instant firstSend, @NotNull Instant lastSend, @NotNull Instant firstReceive, @NotNull Instant lastReceive, @NotNull DataSize sizeLastSend, @NotNull DataSize sizeFirstReceive, @NotNull DataSize sizeTotal) {
            Intrinsics.checkNotNullParameter((Object)firstSend, (String)"firstSend");
            Intrinsics.checkNotNullParameter((Object)lastSend, (String)"lastSend");
            Intrinsics.checkNotNullParameter((Object)firstReceive, (String)"firstReceive");
            Intrinsics.checkNotNullParameter((Object)lastReceive, (String)"lastReceive");
            Intrinsics.checkNotNullParameter((Object)sizeLastSend, (String)"sizeLastSend");
            Intrinsics.checkNotNullParameter((Object)sizeFirstReceive, (String)"sizeFirstReceive");
            Intrinsics.checkNotNullParameter((Object)sizeTotal, (String)"sizeTotal");
            this.numProbes = numProbes;
            this.firstSend = firstSend;
            this.lastSend = lastSend;
            this.firstReceive = firstReceive;
            this.lastReceive = lastReceive;
            this.sizeLastSend = sizeLastSend;
            this.sizeFirstReceive = sizeFirstReceive;
            this.sizeTotal = sizeTotal;
        }

        public /* synthetic */ AggregatedCluster(int n, Instant instant, Instant instant2, Instant instant3, Instant instant4, DataSize dataSize, DataSize dataSize2, DataSize dataSize3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            if ((n2 & 2) != 0) {
                Instant instant5 = Instant.MAX;
                Intrinsics.checkNotNullExpressionValue((Object)instant5, (String)"MAX");
                instant = instant5;
            }
            if ((n2 & 4) != 0) {
                Instant instant6 = Instant.MIN;
                Intrinsics.checkNotNullExpressionValue((Object)instant6, (String)"MIN");
                instant2 = instant6;
            }
            if ((n2 & 8) != 0) {
                Instant instant7 = Instant.MAX;
                Intrinsics.checkNotNullExpressionValue((Object)instant7, (String)"MAX");
                instant3 = instant7;
            }
            if ((n2 & 0x10) != 0) {
                Instant instant8 = Instant.MIN;
                Intrinsics.checkNotNullExpressionValue((Object)instant8, (String)"MIN");
                instant4 = instant8;
            }
            if ((n2 & 0x20) != 0) {
                dataSize = DataSize.Companion.getZERO();
            }
            if ((n2 & 0x40) != 0) {
                dataSize2 = DataSize.Companion.getZERO();
            }
            if ((n2 & 0x80) != 0) {
                dataSize3 = DataSize.Companion.getZERO();
            }
            this(n, instant, instant2, instant3, instant4, dataSize, dataSize2, dataSize3);
        }

        public final int getNumProbes() {
            return this.numProbes;
        }

        public final void setNumProbes(int n) {
            this.numProbes = n;
        }

        @NotNull
        public final Instant getFirstSend() {
            return this.firstSend;
        }

        public final void setFirstSend(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
            this.firstSend = instant;
        }

        @NotNull
        public final Instant getLastSend() {
            return this.lastSend;
        }

        public final void setLastSend(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
            this.lastSend = instant;
        }

        @NotNull
        public final Instant getFirstReceive() {
            return this.firstReceive;
        }

        public final void setFirstReceive(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
            this.firstReceive = instant;
        }

        @NotNull
        public final Instant getLastReceive() {
            return this.lastReceive;
        }

        public final void setLastReceive(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
            this.lastReceive = instant;
        }

        @NotNull
        public final DataSize getSizeLastSend() {
            return this.sizeLastSend;
        }

        public final void setSizeLastSend(@NotNull DataSize dataSize) {
            Intrinsics.checkNotNullParameter((Object)dataSize, (String)"<set-?>");
            this.sizeLastSend = dataSize;
        }

        @NotNull
        public final DataSize getSizeFirstReceive() {
            return this.sizeFirstReceive;
        }

        public final void setSizeFirstReceive(@NotNull DataSize dataSize) {
            Intrinsics.checkNotNullParameter((Object)dataSize, (String)"<set-?>");
            this.sizeFirstReceive = dataSize;
        }

        @NotNull
        public final DataSize getSizeTotal() {
            return this.sizeTotal;
        }

        public final void setSizeTotal(@NotNull DataSize dataSize) {
            Intrinsics.checkNotNullParameter((Object)dataSize, (String)"<set-?>");
            this.sizeTotal = dataSize;
        }

        public final int component1() {
            return this.numProbes;
        }

        @NotNull
        public final Instant component2() {
            return this.firstSend;
        }

        @NotNull
        public final Instant component3() {
            return this.lastSend;
        }

        @NotNull
        public final Instant component4() {
            return this.firstReceive;
        }

        @NotNull
        public final Instant component5() {
            return this.lastReceive;
        }

        @NotNull
        public final DataSize component6() {
            return this.sizeLastSend;
        }

        @NotNull
        public final DataSize component7() {
            return this.sizeFirstReceive;
        }

        @NotNull
        public final DataSize component8() {
            return this.sizeTotal;
        }

        @NotNull
        public final AggregatedCluster copy(int numProbes, @NotNull Instant firstSend, @NotNull Instant lastSend, @NotNull Instant firstReceive, @NotNull Instant lastReceive, @NotNull DataSize sizeLastSend, @NotNull DataSize sizeFirstReceive, @NotNull DataSize sizeTotal) {
            Intrinsics.checkNotNullParameter((Object)firstSend, (String)"firstSend");
            Intrinsics.checkNotNullParameter((Object)lastSend, (String)"lastSend");
            Intrinsics.checkNotNullParameter((Object)firstReceive, (String)"firstReceive");
            Intrinsics.checkNotNullParameter((Object)lastReceive, (String)"lastReceive");
            Intrinsics.checkNotNullParameter((Object)sizeLastSend, (String)"sizeLastSend");
            Intrinsics.checkNotNullParameter((Object)sizeFirstReceive, (String)"sizeFirstReceive");
            Intrinsics.checkNotNullParameter((Object)sizeTotal, (String)"sizeTotal");
            return new AggregatedCluster(numProbes, firstSend, lastSend, firstReceive, lastReceive, sizeLastSend, sizeFirstReceive, sizeTotal);
        }

        public static /* synthetic */ AggregatedCluster copy$default(AggregatedCluster aggregatedCluster, int n, Instant instant, Instant instant2, Instant instant3, Instant instant4, DataSize dataSize, DataSize dataSize2, DataSize dataSize3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = aggregatedCluster.numProbes;
            }
            if ((n2 & 2) != 0) {
                instant = aggregatedCluster.firstSend;
            }
            if ((n2 & 4) != 0) {
                instant2 = aggregatedCluster.lastSend;
            }
            if ((n2 & 8) != 0) {
                instant3 = aggregatedCluster.firstReceive;
            }
            if ((n2 & 0x10) != 0) {
                instant4 = aggregatedCluster.lastReceive;
            }
            if ((n2 & 0x20) != 0) {
                dataSize = aggregatedCluster.sizeLastSend;
            }
            if ((n2 & 0x40) != 0) {
                dataSize2 = aggregatedCluster.sizeFirstReceive;
            }
            if ((n2 & 0x80) != 0) {
                dataSize3 = aggregatedCluster.sizeTotal;
            }
            return aggregatedCluster.copy(n, instant, instant2, instant3, instant4, dataSize, dataSize2, dataSize3);
        }

        @NotNull
        public String toString() {
            return "AggregatedCluster(numProbes=" + this.numProbes + ", firstSend=" + this.firstSend + ", lastSend=" + this.lastSend + ", firstReceive=" + this.firstReceive + ", lastReceive=" + this.lastReceive + ", sizeLastSend=" + this.sizeLastSend + ", sizeFirstReceive=" + this.sizeFirstReceive + ", sizeTotal=" + this.sizeTotal + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.numProbes);
            result = result * 31 + this.firstSend.hashCode();
            result = result * 31 + this.lastSend.hashCode();
            result = result * 31 + this.firstReceive.hashCode();
            result = result * 31 + this.lastReceive.hashCode();
            result = result * 31 + this.sizeLastSend.hashCode();
            result = result * 31 + this.sizeFirstReceive.hashCode();
            result = result * 31 + this.sizeTotal.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AggregatedCluster)) {
                return false;
            }
            AggregatedCluster aggregatedCluster = (AggregatedCluster)other;
            if (this.numProbes != aggregatedCluster.numProbes) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.firstSend, (Object)aggregatedCluster.firstSend)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastSend, (Object)aggregatedCluster.lastSend)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.firstReceive, (Object)aggregatedCluster.firstReceive)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastReceive, (Object)aggregatedCluster.lastReceive)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sizeLastSend, (Object)aggregatedCluster.sizeLastSend)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sizeFirstReceive, (Object)aggregatedCluster.sizeFirstReceive)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.sizeTotal, (Object)aggregatedCluster.sizeTotal);
        }

        public AggregatedCluster() {
            this(0, null, null, null, null, null, null, null, 255, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/ProbeBitrateEstimator$Companion;", "", "<init>", "()V", "kMinReceivedProbesRatio", "", "kMinReceivedBytesRatio", "kMaxValidRatio", "", "kMinRatioForUnsaturatedLink", "kTargetUtilizationFraction", "kMaxClusterHistory", "Ljava/time/Duration;", "getKMaxClusterHistory", "()Ljava/time/Duration;", "kMaxProbeInterval", "getKMaxProbeInterval", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getKMaxClusterHistory() {
            return kMaxClusterHistory;
        }

        @NotNull
        public final Duration getKMaxProbeInterval() {
            return kMaxProbeInterval;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

