/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Random;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.ConfigDelegate;
import org.jitsi.metaconfig.ConfigSource;
import org.jitsi.metaconfig.Deprecation;
import org.jitsi.metaconfig.DeprecationKt;
import org.jitsi.metaconfig.supplier.ConfigSourceSupplier;
import org.jitsi.metaconfig.supplier.ConfigValueSupplier;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.pcap4j.core.PcapDumper;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV4Rfc1349Tos;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UdpPacket;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.DataLinkType;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.packet.namednumber.UdpPort;
import org.pcap4j.util.MacAddress;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0001&B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\tJ\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ&\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010%\u001a\u00020\u001bR\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\r0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013*\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00150\u00150\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0016\u001a\n \u000e*\u0004\u0018\u00010\u00150\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019*\u0004\b\u0017\u0010\u0011\u00a8\u0006'"}, d2={"Lorg/jitsi/nlj/transform/node/PcapWriter;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "filePath", "Ljava/nio/file/Path;", "<init>", "(Lorg/jitsi/utils/logging2/Logger;Ljava/nio/file/Path;)V", "", "(Lorg/jitsi/utils/logging2/Logger;Ljava/lang/String;)V", "logger", "lazyHandle", "Lkotlin/Lazy;", "Lorg/pcap4j/core/PcapHandle;", "kotlin.jvm.PlatformType", "handle", "getHandle$delegate", "(Lorg/jitsi/nlj/transform/node/PcapWriter;)Ljava/lang/Object;", "getHandle", "()Lorg/pcap4j/core/PcapHandle;", "lazyWriter", "Lorg/pcap4j/core/PcapDumper;", "writer", "getWriter$delegate", "getWriter", "()Lorg/pcap4j/core/PcapDumper;", "observe", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "outbound", "", "buffer", "", "offset", "", "length", "close", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nPcapWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PcapWriter.kt\norg/jitsi/nlj/transform/node/PcapWriter\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 3 SupplierBuilder.kt\norg/jitsi/metaconfig/SupplierBuilderKt\n+ 4 Delegates.kt\norg/jitsi/metaconfig/DelegatesKt\n*L\n1#1,136:1\n57#2,4:137\n127#3:141\n59#4:142\n*S KotlinDebug\n*F\n+ 1 PcapWriter.kt\norg/jitsi/nlj/transform/node/PcapWriter\n*L\n55#1:137,4\n68#1:141\n68#1:142\n*E\n"})
public final class PcapWriter {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy<PcapHandle> lazyHandle;
    @NotNull
    private final Lazy<PcapDumper> lazyWriter;
    @NotNull
    private static final Inet4Address localhost;
    @NotNull
    private static final Inet4Address remotehost;
    @NotNull
    private static final UdpPort localport;
    @NotNull
    private static final UdpPort remoteport;
    @NotNull
    private static final ConfigDelegate<String> directory$delegate;

    public PcapWriter(@NotNull Logger parentLogger, @NotNull Path filePath) {
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        this.lazyHandle = LazyKt.lazy(PcapWriter::lazyHandle$lambda$0);
        this.lazyWriter = LazyKt.lazy(() -> PcapWriter.lazyWriter$lambda$0(this, filePath));
    }

    public /* synthetic */ PcapWriter(Logger logger, Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            String string = Companion.getDirectory();
            String[] stringArray = new String[]{new Random().nextLong() + ".pcap"};
            Path path2 = Paths.get(string, Arrays.copyOf(stringArray, stringArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            path = path2;
        }
        this(logger, path);
    }

    public PcapWriter(@NotNull Logger parentLogger, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Path path = Paths.get(filePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        this(parentLogger, path);
    }

    private final PcapHandle getHandle() {
        Lazy<PcapHandle> lazy = this.lazyHandle;
        return (PcapHandle)lazy.getValue();
    }

    private static Object getHandle$delegate(PcapWriter pcapWriter) {
        return pcapWriter.lazyHandle;
    }

    private final PcapDumper getWriter() {
        Lazy<PcapDumper> lazy = this.lazyWriter;
        return (PcapDumper)lazy.getValue();
    }

    private static Object getWriter$delegate(PcapWriter pcapWriter) {
        return pcapWriter.lazyWriter;
    }

    public final void observe(@NotNull PacketInfo packetInfo, boolean outbound) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        Intrinsics.checkNotNullExpressionValue((Object)packetInfo.getPacket().buffer, (String)"buffer");
        this.observe(packetInfo.getPacket().buffer, packetInfo.getPacket().offset, packetInfo.getPacket().length, outbound);
    }

    public final void observe(@NotNull byte[] buffer, int offset, int length, boolean outbound) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        UnknownPacket.Builder udpPayload = new UnknownPacket.Builder();
        byte[] subBuf = new byte[length];
        System.arraycopy(buffer, offset, subBuf, 0, length);
        udpPayload.rawData(subBuf);
        Inet4Address srchost = null;
        Inet4Address dsthost = null;
        UdpPort srcport = null;
        UdpPort dstport = null;
        if (outbound) {
            srchost = localhost;
            srcport = localport;
            dsthost = remotehost;
            dstport = remoteport;
        } else {
            srchost = remotehost;
            srcport = remoteport;
            dsthost = localhost;
            dstport = localport;
        }
        UdpPacket.Builder udp = new UdpPacket.Builder().srcPort(srcport).dstPort(dstport).srcAddr((InetAddress)srchost).dstAddr((InetAddress)dsthost).correctChecksumAtBuild(true).correctLengthAtBuild(true).payloadBuilder((Packet.Builder)udpPayload);
        IpV4Packet.Builder ipPacket = new IpV4Packet.Builder().srcAddr(srchost).dstAddr(dsthost).protocol(IpNumber.UDP).version(IpVersion.IPV4).tos((IpV4Packet.IpV4Tos)IpV4Rfc1349Tos.newInstance((byte)0)).correctLengthAtBuild(true).payloadBuilder((Packet.Builder)udp);
        EthernetPacket eth = new EthernetPacket.Builder().srcAddr(MacAddress.ETHER_BROADCAST_ADDRESS).dstAddr(MacAddress.ETHER_BROADCAST_ADDRESS).type(EtherType.IPV4).paddingAtBuild(true).payloadBuilder((Packet.Builder)ipPacket).build();
        this.getWriter().dump((Packet)eth);
    }

    public final void close() {
        if (this.lazyWriter.isInitialized() && this.getWriter().isOpen()) {
            this.getWriter().close();
        }
        if (this.lazyHandle.isInitialized() && this.getHandle().isOpen()) {
            this.getHandle().close();
        }
    }

    private static final PcapHandle lazyHandle$lambda$0() {
        return Pcaps.openDead((DataLinkType)DataLinkType.EN10MB, (int)65536);
    }

    private static final PcapDumper lazyWriter$lambda$0(PcapWriter this$0, Path $filePath) {
        Logger $this$cinfo$iv = this$0.logger;
        boolean $i$f$cinfo = false;
        if ($this$cinfo$iv.isInfoEnabled()) {
            Logger logger = $this$cinfo$iv;
            boolean bl = false;
            logger.info((Object)("Pcap writer writing to file " + $filePath));
        }
        return this$0.getHandle().dumpOpen(((Object)$filePath).toString());
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$from$iv;
        Companion = new Companion(null);
        InetAddress inetAddress = Inet4Address.getByName("127.0.0.1");
        Intrinsics.checkNotNull((Object)inetAddress, (String)"null cannot be cast to non-null type java.net.Inet4Address");
        localhost = (Inet4Address)inetAddress;
        InetAddress inetAddress2 = Inet4Address.getByName("192.0.2.0");
        Intrinsics.checkNotNull((Object)inetAddress2, (String)"null cannot be cast to non-null type java.net.Inet4Address");
        remotehost = (Inet4Address)inetAddress2;
        localport = new UdpPort(Short.valueOf((short)123), "blah");
        remoteport = new UdpPort(Short.valueOf((short)456), "blah");
        String string = "jmt.debug.pcap.directory";
        ConfigSource configSource$iv = JitsiConfig.Companion.getNewConfig();
        boolean $i$f$from = false;
        ConfigSourceSupplier supplier$iv = new ConfigSourceSupplier((String)$this$from$iv, configSource$iv, Reflection.typeOf(String.class), (Deprecation)DeprecationKt.noDeprecation());
        boolean $i$f$config = false;
        directory$delegate = new ConfigDelegate((ConfigValueSupplier)supplier$iv);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jitsi/nlj/transform/node/PcapWriter$Companion;", "", "<init>", "()V", "localhost", "Ljava/net/Inet4Address;", "remotehost", "localport", "Lorg/pcap4j/packet/namednumber/UdpPort;", "remoteport", "directory", "", "getDirectory", "()Ljava/lang/String;", "directory$delegate", "Lorg/jitsi/metaconfig/ConfigDelegate;", "jitsi-media-transform"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final String getDirectory() {
            return (String)directory$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "directory", "getDirectory()Ljava/lang/String;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

