/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.NodeStatsProducer;
import org.jitsi.nlj.util.ArrayCache;
import org.jitsi.nlj.util.RtpPacketCache;
import org.jitsi.rtp.rtp.RtpPacket;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B'\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0004J\"\u0010\u001c\u001a\u000e\u0018\u00010\u001dR\b\u0012\u0004\u0012\u00020\u00040\u001e2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0007J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040!2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0007J\u001e\u0010#\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0010J\u0006\u0010%\u001a\u00020\u0018J\b\u0010&\u001a\u00020'H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rRN\u0010\u000e\u001aB\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00120\u0012 \u0011* \u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u00130\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jitsi/nlj/util/PacketCache;", "Lorg/jitsi/nlj/transform/NodeStatsProducer;", "packetPredicate", "Lkotlin/Function1;", "Lorg/jitsi/rtp/rtp/RtpPacket;", "", "size", "", "<init>", "(Lkotlin/jvm/functions/Function1;I)V", "getPacketPredicate", "()Lkotlin/jvm/functions/Function1;", "getSize", "()I", "packetCaches", "", "", "kotlin.jvm.PlatformType", "Lorg/jitsi/nlj/util/RtpPacketCache;", "", "stopped", "getCache", "ssrc", "expireCaches", "", "now", "insert", "packet", "get", "Lorg/jitsi/nlj/util/ArrayCache$Container;", "Lorg/jitsi/nlj/util/ArrayCache;", "seqNum", "getMany", "", "numBytes", "updateTimestamp", "timeAdded", "stop", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nPacketCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PacketCache.kt\norg/jitsi/nlj/util/PacketCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n1#2:211\n216#3,2:212\n1869#4,2:214\n*S KotlinDebug\n*F\n+ 1 PacketCache.kt\norg/jitsi/nlj/util/PacketCache\n*L\n99#1:212,2\n105#1:214,2\n*E\n"})
public final class PacketCache
implements NodeStatsProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<RtpPacket, Boolean> packetPredicate;
    private final int size;
    private final Map<Long, RtpPacketCache> packetCaches;
    private boolean stopped;
    private static final int MAX_CACHE_LIFETIME_MILLIS = 15000;

    public PacketCache(@NotNull Function1<? super RtpPacket, Boolean> packetPredicate, int size) {
        Intrinsics.checkNotNullParameter(packetPredicate, (String)"packetPredicate");
        this.packetPredicate = packetPredicate;
        this.size = size;
        this.packetCaches = Collections.synchronizedMap(new LinkedHashMap(16, 0.75f, true));
    }

    public /* synthetic */ PacketCache(Function1 function1, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            function1 = PacketCache::_init_$lambda$0;
        }
        if ((n2 & 2) != 0) {
            n = 500;
        }
        this((Function1<? super RtpPacket, Boolean>)function1, n);
    }

    @NotNull
    public final Function1<RtpPacket, Boolean> getPacketPredicate() {
        return this.packetPredicate;
    }

    public final int getSize() {
        return this.size;
    }

    private final RtpPacketCache getCache(long ssrc) {
        RtpPacketCache rtpPacketCache;
        RtpPacketCache it = rtpPacketCache = this.packetCaches.computeIfAbsent(ssrc, arg_0 -> PacketCache.getCache$lambda$1(arg_0 -> PacketCache.getCache$lambda$0(this, arg_0), arg_0));
        boolean bl = false;
        it.setLastAccess();
        it = rtpPacketCache;
        boolean bl2 = false;
        this.expireCaches(it.getLastAccessMillis());
        RtpPacketCache rtpPacketCache2 = rtpPacketCache;
        Intrinsics.checkNotNullExpressionValue((Object)rtpPacketCache2, (String)"also(...)");
        return rtpPacketCache2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void expireCaches(long now) {
        Map<Long, RtpPacketCache> map = this.packetCaches;
        Intrinsics.checkNotNullExpressionValue(map, (String)"packetCaches");
        Map<Long, RtpPacketCache> map2 = map;
        synchronized (map2) {
            RtpPacketCache cache;
            boolean bl = false;
            Map<Long, RtpPacketCache> map3 = this.packetCaches;
            Intrinsics.checkNotNullExpressionValue(map3, (String)"packetCaches");
            Iterator<Map.Entry<Long, RtpPacketCache>> i = map3.entrySet().iterator();
            while (i.hasNext() && now - (cache = i.next().getValue()).getLastAccessMillis() >= (long)MAX_CACHE_LIFETIME_MILLIS) {
                cache.flush();
                i.remove();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean insert(@NotNull RtpPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        return !this.stopped && (Boolean)this.packetPredicate.invoke((Object)packet) != false && this.getCache(packet.getSsrc()).insert(packet);
    }

    @Nullable
    public final ArrayCache.Container get(long ssrc, int seqNum) {
        return this.getCache(ssrc).get(seqNum);
    }

    @NotNull
    public final Set<RtpPacket> getMany(long ssrc, int numBytes) {
        return this.getCache(ssrc).getMany(numBytes);
    }

    public final void updateTimestamp(long ssrc, int seqNum, long timeAdded) {
        this.getCache(ssrc).updateTimestamp(seqNum, timeAdded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        this.stopped = true;
        Map<Long, RtpPacketCache> map = this.packetCaches;
        Intrinsics.checkNotNullExpressionValue(map, (String)"packetCaches");
        Map<Long, RtpPacketCache> map2 = map;
        synchronized (map2) {
            boolean bl = false;
            Map<Long, RtpPacketCache> map3 = this.packetCaches;
            Intrinsics.checkNotNullExpressionValue(map3, (String)"packetCaches");
            Map<Long, RtpPacketCache> $this$forEach$iv = map3;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Long, RtpPacketCache>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, RtpPacketCache> element$iv;
                Map.Entry<Long, RtpPacketCache> entry = element$iv = iterator.next();
                boolean bl2 = false;
                RtpPacketCache cache = entry.getValue();
                cache.flush();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u240 = nodeStatsBlock = new NodeStatsBlock("PacketCache");
        boolean bl = false;
        Map<Long, RtpPacketCache> map = this.packetCaches;
        Intrinsics.checkNotNullExpressionValue(map, (String)"packetCaches");
        Map<Long, RtpPacketCache> map2 = map;
        synchronized (map2) {
            boolean bl2 = false;
            Iterable $this$forEach$iv = this.packetCaches.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RtpPacketCache it = (RtpPacketCache)element$iv;
                boolean bl3 = false;
                $this$getNodeStats_u24lambda_u240.aggregate(it.getNodeStats());
            }
            Unit unit = Unit.INSTANCE;
        }
        return nodeStatsBlock;
    }

    private static final boolean _init_$lambda$0(RtpPacket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof VideoRtpPacket;
    }

    private static final RtpPacketCache getCache$lambda$0(PacketCache this$0, Long it) {
        return new RtpPacketCache(this$0.size, false, 2, null);
    }

    private static final RtpPacketCache getCache$lambda$1(Function1 $tmp0, Object p0) {
        return (RtpPacketCache)$tmp0.invoke(p0);
    }

    public PacketCache() {
        this(null, 0, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jitsi/nlj/util/PacketCache$Companion;", "", "<init>", "()V", "MAX_CACHE_LIFETIME_MILLIS", "", "getMAX_CACHE_LIFETIME_MILLIS", "()I", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMAX_CACHE_LIFETIME_MILLIS() {
            return MAX_CACHE_LIFETIME_MILLIS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

